/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.dom;

import com.intellij.lang.ant.dom.AntCallParamsFinder;
import com.intellij.lang.ant.dom.AntDomAntCallParam;
import com.intellij.lang.ant.dom.AntDomElement;
import com.intellij.lang.ant.dom.AntDomProject;
import com.intellij.lang.ant.dom.AntDomProperty;
import com.intellij.lang.ant.dom.PropertiesProvider;
import com.intellij.lang.ant.dom.PropertyResolver;
import com.intellij.openapi.util.Trinity;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomTarget;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntRenameProcessor
extends RenamePsiElementProcessor {
    public void prepareRenaming(PsiElement element, String newName, Map<PsiElement, String> allRenames) {
        AntDomElement antElement = AntRenameProcessor.convertToAntDomElement(element);
        String propName = null;
        if (antElement instanceof AntDomProperty) {
            propName = ((AntDomProperty)antElement).getName().getStringValue();
        } else if (antElement instanceof AntDomAntCallParam) {
            propName = ((AntDomAntCallParam)antElement).getName().getStringValue();
        }
        if (propName != null) {
            Trinity<PsiElement, Collection<String>, PropertiesProvider> result;
            AntDomProject contextProject = antElement.getContextAntProject();
            List<PsiElement> additional = AntCallParamsFinder.resolve(contextProject, propName);
            for (PsiElement psiElement : additional) {
                allRenames.put(psiElement, newName);
            }
            if (antElement instanceof AntDomAntCallParam && (result = PropertyResolver.resolve(contextProject, propName, null)).getFirst() != null) {
                allRenames.put((PsiElement)result.getFirst(), newName);
            }
        }
    }

    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ant/dom/AntRenameProcessor", "canProcessElement"));
        }
        AntDomElement antElement = AntRenameProcessor.convertToAntDomElement(element);
        return antElement instanceof AntDomProperty || antElement instanceof AntDomAntCallParam;
    }

    @Nullable
    private static AntDomElement convertToAntDomElement(PsiElement element) {
        DomElement domElement;
        PomTarget target;
        if (element instanceof PomTargetPsiElement && (target = ((PomTargetPsiElement)element).getTarget()) instanceof DomTarget && (domElement = ((DomTarget)target).getDomElement()) instanceof AntDomElement) {
            return (AntDomElement)domElement;
        }
        return null;
    }
}

