/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.impl;

import com.intellij.codeInsight.completion.CompletionContributorEP;
import com.intellij.codeInspection.dataFlow.StringExpressionHelper;
import com.intellij.icons.AllIcons;
import com.intellij.lang.DependentLanguage;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomJavaUtil;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;

class LanguageResolvingUtil {
    private static final String ANY_LANGUAGE_DEFAULT_ID = Language.ANY.getID();

    LanguageResolvingUtil() {
    }

    static Collection<LanguageDefinition> getAllLanguageDefinitions(ConvertContext context) {
        List<LanguageDefinition> languageDefinitions = LanguageResolvingUtil.collectLanguageDefinitions(context);
        ContainerUtil.addIfNotNull(languageDefinitions, (Object)LanguageResolvingUtil.createAnyLanguageDefinition(context));
        return languageDefinitions;
    }

    private static List<LanguageDefinition> collectLanguageDefinitions(ConvertContext context) {
        final PsiClass languageClass = DomJavaUtil.findClass((String)Language.class.getName(), (DomElement)context.getInvocationElement());
        if (languageClass == null) {
            return Collections.emptyList();
        }
        final Project project = context.getProject();
        final GlobalSearchScope projectProductionScope = GlobalSearchScopesCore.projectProductionScope((Project)project);
        Collection allLanguages = (Collection)CachedValuesManager.getCachedValue((PsiElement)languageClass, (CachedValueProvider)new CachedValueProvider<Collection<PsiClass>>(){

            @Nullable
            public CachedValueProvider.Result<Collection<PsiClass>> compute() {
                GlobalSearchScope allScope = projectProductionScope.union((SearchScope)ProjectScope.getLibrariesScope((Project)project));
                return CachedValueProvider.Result.create((Object)ClassInheritorsSearch.search((PsiClass)languageClass, (SearchScope)allScope, (boolean)true).findAll(), (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }
        });
        List<LanguageDefinition> libraryDefinitions = LanguageResolvingUtil.collectLibraryLanguages(context, allLanguages);
        List projectLanguages = ContainerUtil.filter((Collection)allLanguages, (Condition)new Condition<PsiClass>(){

            public boolean value(PsiClass aClass) {
                return PsiSearchScopeUtil.isInScope((GlobalSearchScope)projectProductionScope, (PsiElement)aClass);
            }
        });
        List<LanguageDefinition> projectDefinitions = LanguageResolvingUtil.collectProjectLanguages(projectLanguages, libraryDefinitions);
        ArrayList<LanguageDefinition> all = new ArrayList<LanguageDefinition>(libraryDefinitions);
        all.addAll(projectDefinitions);
        return all;
    }

    private static List<LanguageDefinition> collectLibraryLanguages(final ConvertContext context, final Collection<PsiClass> allLanguages) {
        return ContainerUtil.mapNotNull((Collection)Language.getRegisteredLanguages(), (Function)new NullableFunction<Language, LanguageDefinition>(){

            public LanguageDefinition fun(Language language) {
                if (language.getID().isEmpty() || language instanceof DependentLanguage) {
                    return null;
                }
                PsiClass psiClass = DomJavaUtil.findClass((String)language.getClass().getName(), (DomElement)context.getInvocationElement());
                if (psiClass == null) {
                    return null;
                }
                if (!allLanguages.contains(psiClass)) {
                    return null;
                }
                LanguageFileType type = language.getAssociatedFileType();
                Icon icon = type != null ? type.getIcon() : null;
                return new LanguageDefinition(language.getID(), psiClass, icon, language.getDisplayName());
            }
        });
    }

    private static List<LanguageDefinition> collectProjectLanguages(Collection<PsiClass> projectLanguages, final List<LanguageDefinition> libraryLanguages) {
        return ContainerUtil.mapNotNull(projectLanguages, (Function)new NullableFunction<PsiClass, LanguageDefinition>(){

            @Nullable
            public LanguageDefinition fun(final PsiClass language) {
                if (language.hasModifierProperty("abstract")) {
                    return null;
                }
                if (ContainerUtil.exists((Iterable)libraryLanguages, (Condition)new Condition<LanguageDefinition>(){

                    public boolean value(LanguageDefinition definition) {
                        return definition.clazz.equals(language);
                    }
                })) {
                    return null;
                }
                String id = LanguageResolvingUtil.computeConstantSuperCtorCallParameter(language, 0);
                if (id == null) {
                    id = LanguageResolvingUtil.computeConstantSuperCtorCallParameter(language, 1);
                }
                if (id == null) {
                    id = LanguageResolvingUtil.computeConstantReturnValue(language, "getID");
                }
                if (id == null) {
                    return null;
                }
                return new LanguageDefinition(id, language, null, LanguageResolvingUtil.computeConstantReturnValue(language, "getDisplayName"));
            }
        });
    }

    @Nullable
    private static String computeConstantReturnValue(PsiClass languagePsiClass, String methodName) {
        PsiMethod[] methods = languagePsiClass.findMethodsByName(methodName, false);
        if (methods.length != 1) {
            return null;
        }
        return LanguageResolvingUtil.getStringConstantExpression((PsiElement)methods[0]);
    }

    private static String computeConstantSuperCtorCallParameter(PsiClass languagePsiClass, int index) {
        PsiMethod defaultConstructor = null;
        for (PsiMethod constructor : languagePsiClass.getConstructors()) {
            if (constructor.getParameterList().getParametersCount() != 0) continue;
            defaultConstructor = constructor;
            break;
        }
        if (defaultConstructor == null) {
            return null;
        }
        PsiCodeBlock body = defaultConstructor.getBody();
        if (body == null) {
            return null;
        }
        PsiStatement[] statements = body.getStatements();
        if (statements.length < 1) {
            return null;
        }
        PsiStatement statement = statements[0];
        if (!(statement instanceof PsiExpressionStatement)) {
            return null;
        }
        PsiExpression expression = ((PsiExpressionStatement)statement).getExpression();
        if (!(expression instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
        PsiExpression[] argumentExpressions = methodCallExpression.getArgumentList().getExpressions();
        if (argumentExpressions.length < index + 1) {
            return null;
        }
        return LanguageResolvingUtil.getStringConstantExpression((PsiElement)argumentExpressions[index]);
    }

    @Nullable
    private static String getStringConstantExpression(PsiElement psiElement) {
        Pair pair = StringExpressionHelper.evaluateConstantExpression((PsiElement)psiElement);
        return pair != null ? (String)pair.second : null;
    }

    @Nullable
    private static LanguageDefinition createAnyLanguageDefinition(ConvertContext context) {
        PsiClass languageClass = DomJavaUtil.findClass((String)Language.class.getName(), (DomElement)context.getInvocationElement());
        if (languageClass == null) {
            return null;
        }
        String anyLanguageId = LanguageResolvingUtil.calculateAnyLanguageId(context);
        return new LanguageDefinition(anyLanguageId, languageClass, AllIcons.FileTypes.Any_type, "<any language>");
    }

    private static String calculateAnyLanguageId(ConvertContext context) {
        Extension extension = (Extension)context.getInvocationElement().getParentOfType(Extension.class, true);
        if (extension == null) {
            return ANY_LANGUAGE_DEFAULT_ID;
        }
        ExtensionPoint extensionPoint = extension.getExtensionPoint();
        if (extensionPoint == null) {
            return ANY_LANGUAGE_DEFAULT_ID;
        }
        GenericAttributeValue<PsiClass> epBeanClass = extensionPoint.getBeanClass();
        if (CompletionContributorEP.class.getName().equals(epBeanClass.getStringValue())) {
            return "any";
        }
        return ANY_LANGUAGE_DEFAULT_ID;
    }

    static class LanguageDefinition {
        final String id;
        final PsiClass clazz;
        final Icon icon;
        final String displayName;

        LanguageDefinition(String id, PsiClass clazz, Icon icon, String displayName) {
            this.id = id;
            this.clazz = clazz;
            this.icon = icon;
            this.displayName = displayName;
        }
    }
}

