/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.incremental;

import java.io.File;
import java.util.ArrayList;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.kotlin.jps.incremental.CacheVersion;
import org.jetbrains.kotlin.jps.incremental.CacheVersionKt;
import org.jetbrains.kotlin.jps.incremental.CacheVersionProvider;
import org.jetbrains.kotlin.jps.incremental.KotlinDataContainerTarget;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"1\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001\u0005\u000f\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0003\u0003\u0019\u0001I\u0012\u0001'\u0001\"\u000e%\u0019\u0001\"A\u0007\u00021\u0007\t6!\u0001\u0005\u0003K5AQ!\u0004\u0003\n\u0005%\t\u0001D\u0002M\u00063\u0019Ai!\u0004\u0003\n\u0005%\t\u0001d\u0002M\u0006K\rAy!D\u0001\u0019\r\u0015:\u0001\u0002C\u0007\u00021\u0019I2\u0001#\u0005\u000e\u0003a9Qe\u0002\u0005\n\u001b\u0005Ab!G\u0002\t\u00125\t\u0001dB\u0015\b\t\u0005C\u0001\"A\u0007\u00021\u0007\t6!A\u0003\u0001S9!\u0011\t\u0003E\u0003\u001b\u0005A2!F\u0002\n\u0003\u0011\r\u0001t\u0001\u000f\"#\u000e\u0019QB\u0001\u0003\u0005\u0011\u0013\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/CacheVersionProvider;", "", "paths", "Lorg/jetbrains/jps/builders/storage/BuildDataPaths;", "(Lorg/jetbrains/jps/builders/storage/BuildDataPaths;)V", "dataRoot", "Ljava/io/File;", "Lorg/jetbrains/jps/builders/BuildTarget;", "getDataRoot", "(Lorg/jetbrains/jps/builders/BuildTarget;)Ljava/io/File;", "allVersions", "", "Lorg/jetbrains/kotlin/jps/incremental/CacheVersion;", "targets", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "dataContainerVersion", "experimentalVersion", "target", "normalVersion"}, moduleName="jps-plugin")
public final class CacheVersionProvider {
    private final BuildDataPaths paths;

    private final File getDataRoot(BuildTarget<?> $receiver) {
        File file = this.paths.getTargetDataRoot($receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"paths.getTargetDataRoot(this)");
        return file;
    }

    @NotNull
    public final CacheVersion normalVersion(@NotNull ModuleBuildTarget target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        return new CacheVersion(CacheVersionKt.access$getNORMAL_VERSION$p(), new File(this.getDataRoot((BuildTarget)target), CacheVersionKt.access$getNORMAL_VERSION_FILE_NAME$p()), CacheVersion.Action.REBUILD_CHUNK, CacheVersion.Action.REBUILD_CHUNK, CacheVersion.Action.CLEAN_NORMAL_CACHES, (Function0<Boolean>)((Function0)normalVersion.1.INSTANCE));
    }

    @NotNull
    public final CacheVersion experimentalVersion(@NotNull ModuleBuildTarget target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        return new CacheVersion(CacheVersionKt.access$getEXPERIMENTAL_VERSION$p(), new File(this.getDataRoot((BuildTarget)target), CacheVersionKt.access$getEXPERIMENTAL_VERSION_FILE_NAME$p()), CacheVersion.Action.REBUILD_CHUNK, CacheVersion.Action.REBUILD_CHUNK, CacheVersion.Action.CLEAN_EXPERIMENTAL_CACHES, (Function0<Boolean>)((Function0)experimentalVersion.1.INSTANCE));
    }

    @NotNull
    public final CacheVersion dataContainerVersion() {
        return new CacheVersion(CacheVersionKt.access$getDATA_CONTAINER_VERSION$p(), new File(this.getDataRoot(KotlinDataContainerTarget.INSTANCE), CacheVersionKt.access$getDATA_CONTAINER_VERSION_FILE_NAME$p()), CacheVersion.Action.REBUILD_ALL_KOTLIN, CacheVersion.Action.REBUILD_ALL_KOTLIN, CacheVersion.Action.CLEAN_DATA_CONTAINER, (Function0<Boolean>)((Function0)dataContainerVersion.1.INSTANCE));
    }

    @NotNull
    public final Iterable<CacheVersion> allVersions(@NotNull Iterable<ModuleBuildTarget> targets) {
        Intrinsics.checkParameterIsNotNull(targets, (String)"targets");
        ArrayList versions = CollectionsKt.arrayListOf((Object[])new CacheVersion[0]);
        versions.add(this.dataContainerVersion());
        for (ModuleBuildTarget target : targets) {
            versions.add(this.normalVersion(target));
            versions.add(this.experimentalVersion(target));
        }
        return versions;
    }

    public CacheVersionProvider(@NotNull BuildDataPaths paths) {
        Intrinsics.checkParameterIsNotNull((Object)paths, (String)"paths");
        this.paths = paths;
    }
}

