/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.incremental;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.BooleanDataDescriptor;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.THashSet;
import java.io.DataOutput;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.NoWhenBranchMatchedException;
import kotlin.PreconditionsKt;
import kotlin.Sequence;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.FunctionReference;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.storage.PathStringDescriptor;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.inline.InlineUtilKt;
import org.jetbrains.kotlin.jps.build.GeneratedJvmClass;
import org.jetbrains.kotlin.jps.build.KotlinBuilder;
import org.jetbrains.kotlin.jps.incremental.CacheVersionProvider;
import org.jetbrains.kotlin.jps.incremental.ChangeInfo;
import org.jetbrains.kotlin.jps.incremental.CompilationResult;
import org.jetbrains.kotlin.jps.incremental.DifferenceKind;
import org.jetbrains.kotlin.jps.incremental.IncrementalCacheImpl;
import org.jetbrains.kotlin.jps.incremental.IncrementalCacheImplKt;
import org.jetbrains.kotlin.jps.incremental.LocalFileKotlinClass;
import org.jetbrains.kotlin.jps.incremental.ProtoDifferenceUtilsKt;
import org.jetbrains.kotlin.jps.incremental.storage.BasicMap;
import org.jetbrains.kotlin.jps.incremental.storage.BasicMapsOwner;
import org.jetbrains.kotlin.jps.incremental.storage.BasicStringMap;
import org.jetbrains.kotlin.jps.incremental.storage.ConstantsMapExternalizer;
import org.jetbrains.kotlin.jps.incremental.storage.LazyStorage;
import org.jetbrains.kotlin.jps.incremental.storage.PathCollectionExternalizer;
import org.jetbrains.kotlin.jps.incremental.storage.PathFunctionPair;
import org.jetbrains.kotlin.jps.incremental.storage.PathFunctionPairKeyDescriptor;
import org.jetbrains.kotlin.jps.incremental.storage.ProtoMapValue;
import org.jetbrains.kotlin.jps.incremental.storage.ProtoMapValueExternalizer;
import org.jetbrains.kotlin.jps.incremental.storage.StringCollectionExternalizer;
import org.jetbrains.kotlin.jps.incremental.storage.StringToLongMapExternalizer;
import org.jetbrains.kotlin.jps.incremental.storage.SubtypesMap;
import org.jetbrains.kotlin.jps.incremental.storage.SupertypesMap;
import org.jetbrains.kotlin.load.kotlin.ModuleMapping;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeaderKt;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCache;
import org.jetbrains.kotlin.load.kotlin.incremental.components.JvmPackagePartProto;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.serialization.ClassData;
import org.jetbrains.kotlin.serialization.PackageData;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.ProtoTypeTableUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.TypeTable;
import org.jetbrains.kotlin.serialization.jvm.BitEncoding;
import org.jetbrains.kotlin.serialization.jvm.JvmProtoBufUtil;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"Y\u0004)\u0011\u0001D\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u00119)\u0011\u0001b\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005Aq!B\u0001\u0005\u0004\u0015\t\u0001\"A\u0003\u0002\t\u0007)\u0011\u0001D\u0001\u0006\u0003\u0011\u0011Q!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\t\u001f\u0015\u0001Q!\u0001\u0005\n\u000b\u0005!)!B\u0001\r\u0003\u0015\tAQA\u0003\u0002\u0011A)\u0011\u0001\u0002\u0004\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\u0005\u00111\u0001\u0001CM\r\u00021\u0003I\u0012\u0001G\u0001\u001e\fI\u00164w\r[5kW2lgNQ\u000b\u0013\rA\u0019!D\u0001\u0019\u0005%\u0019\u0001RA\u0007\u00021\r\t6!\u0001E\u0004K\u001dA\u0011$D\u0001\u00194e\u0019\u0001BG\u0007\u00021\u0001)\u0003\u0002B\u0001\t65\t\u00014G\r\u0004\u0011mi\u0011\u0001g\u000e&\t\u0011Y\u0001\u0002H\u0007\u00021g)3\u0001#\u000f\u000e\u0003aMRe\u0001\u0005\u001e\u001b\u0005A\u001a$J\u0002\t<5\t\u0001DH\u0013\t\t-Ai$D\u0001\u00190e\u0019\u0001bH\u0007\u00021_)c\u0001c\u0010\u000e\t%\u0011\u0011\"\u0001M\u00051\u0001*S\u0001B\u0006\tB5\u0011A\u0012\u0001\r\"K%!1\u0002c\u0011\u000e\u00051\u0005\u0001tF\r\u0004\u0011\tj\u0011\u0001g\f&\u000f\u0011Y\u0001RI\u0007\u0005\u0013\tI\u0011\u0001g\f\u0019A\u0015:Aa\u0003\u0005$\u001b\u0011I!!C\u0001\u00190a\u0001S%\u0003\u0003\f\u0011\u000fj!\u0001$\u0001\u0019Ie\u0019\u0001\u0012J\u0007\u00021_)C\u0002B\u0006\tK5)\u0011BA\u0005\u00021_a\t\u0001\u0007\u0011\u001a\u0007!-S\"\u0001M\u0018K)Aa%D\u0001\u00194e1\u0001RJ\u0007\u0005\u0013\tI\u0011\u0001'\u0003\u0019O\u0015^B!\u0001E(\u001b\u0005!\u0003&\u0005\u0002\u0005\u0001!E\u0013C\u0001C\u0001\u0011%\n\"\u0002B\u0001\tQU9\u0011BA\u0005\u0002I#J!!C\u0001%Sae\u0011d\u0001E*\u001b\u0005!\u0003&U\u0002\u0002\u0011)*\u0003\u0003B\u0006\tV5\t\u00014G\r\u0004\u0011-j\u0011\u0001g\f\u001a\u0007!]S\"\u0001M\u00183\rAA&D\u0001\u00190\u0015ZA!\u0001E-\u001b\u0005A\u001a$\u0007\u0004\t[5!\u0011BA\u0005\u000217B\u0002%J\u0004\t]5\t\u0001DH\r\u0004\u0011;j\u0011\u0001G\u0018&\u001d!}S\"\u0001\r\u001f3\u0019A\u0001'\u0004\u0003\n\u0005%\t\u0001\u0014\u0002\r!3\rA\t'D\u0001\u0019\n\u0015^A!\u0001\u00052\u001b\u0005A\u001a$F\u0001\u0019=e%\u00012M\u0007\u000217\u00026\u0011A\u0015\b\t\u0005C\u0001\u0002B\u0007\u00021\u0013\t6!A\u0003\u0001S\u001d!\u0011\t\u0003\u0005\u0006\u001b\u0005AZ!U\u0002\u0002\u000b\u0001I\u0013\u0002B!\t\u0011\u0019i1\u0001'\u0004*\u0003a\u0001\u0011kA\u0001\u0006\u0001%RA!\u0011\u0005\t\u000f5!\u0011BA\u0005\u00021\u0001Az!U\u0002\u0002\u000b\u0001IS\u0002B!\t\u0011!iA!\u0003\u0002\n\u0003a\u0001\u0001\u0014\u0003\u000f\"#\u000e\u0019QB\u0001\u0003\n\u0011'I\u0013\u0002B!\t\u0011)i1\u0001'\u0006*\u0003a\u0001\u0011kA\u0001\u0006\u0001%JA!\u0011\u0005\t\u00175\u0019\u0001tC\u0015\u00021\u0001\t6!A\u0003\u0001S9!\u0011\t\u0003\u0005\r\u001b!Ia!C\u0003\n\u0003\u0011\r\u0011\"\u0001C\u000213Az!U\u0002\u0002\u000b\u0001I\u0013\u0002B!\t\u00115i1\u0001g\u0007*\u0003a\u0001\u0011kA\u0001\u0006\u0001%JA!\u0011\u0005\t\u001d5\u0019\u0001TD\u0015\u00021\u0001\t6!A\u0003\u0001S%!\u0011\t\u0003\u0005\u0010\u001b\rAz\"K\u0001\u0019\u0001E\u001b\u0011!\u0002\u0001*\u0013\u0011\t\u0005\u0002\u0003\t\u000e\u0007a\u0005\u0012&\u0001\r\u0001#\u000e\tQ\u0001AU\n\t\u0005C\u0001\"EG\u00041\u0013\t6!\u0001C\u0012#\u000e\tQ\u0001A\u0015\n\t\u0005C\u0001BE\u0007\u00041KI\u0013\u0001\u0007\u0001R\u0007\u0005)\u0001!K\u0005\u0005\u0003\"A1#D\u0002\u0019(%\n\u0001\u0004A)\u0004\u0003\u0015\u0001\u0011&\u0003\u0003B\u0011!!Rb\u0001M\u0015S\u0005A\u0002!U\u0002\u0002\u000b\u0001Is\u0001B!\t\u0011Ui\u0011\u0001g\u000bR\u0007\u0005)\u0001!K\u0004\u0005\u0003\"Aa#D\u0001\u0019.E\u001b\u0011!\u0002\u0001*\u000f\u0011\t\u0005\u0002c\u0001\u000e\u0003a\u0011\u0011kA\u0001\u0006\u0001%bA!\u0011\u0005\t/5\t\u0001\u0014B\u000b\u00021_a\u0012%U\u0002\u0004\u001b\t!\u0001\u0004#\r"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl;", "Lorg/jetbrains/kotlin/jps/incremental/storage/BasicMapsOwner;", "Lorg/jetbrains/kotlin/load/kotlin/incremental/components/IncrementalCache;", "target", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "paths", "Lorg/jetbrains/jps/builders/storage/BuildDataPaths;", "(Lorg/jetbrains/jps/incremental/ModuleBuildTarget;Lorg/jetbrains/jps/builders/storage/BuildDataPaths;)V", "baseDir", "Ljava/io/File;", "cacheVersionProvider", "Lorg/jetbrains/kotlin/jps/incremental/CacheVersionProvider;", "constantsMap", "Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$ConstantsMap;", "dependents", "Ljava/util/ArrayList;", "dependentsWithThis", "", "getDependentsWithThis", "()Ljava/lang/Iterable;", "dirtyInlineFunctionsMap", "Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$DirtyInlineFunctionsMap;", "dirtyOutputClassesMap", "Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$DirtyOutputClassesMap;", "experimentalMaps", "Lorg/jetbrains/kotlin/jps/incremental/storage/BasicMap;", "inlineFunctionsMap", "Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$InlineFunctionsMap;", "inlinedTo", "Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$InlineFunctionsFilesMap;", "multifileClassFacadeMap", "Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$MultifileClassFacadeMap;", "multifileClassPartMap", "Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$MultifileClassPartMap;", "outputDir", "Lorg/jetbrains/annotations/Nullable;", "packagePartMap", "Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$PackagePartMap;", "protoMap", "Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$ProtoMap;", "sourceToClassesMap", "Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$SourceToClassesMap;", "subtypesMap", "Lorg/jetbrains/kotlin/jps/incremental/storage/SubtypesMap;", "supertypesMap", "Lorg/jetbrains/kotlin/jps/incremental/storage/SupertypesMap;", "storageFile", "", "getStorageFile", "(Ljava/lang/String;)Ljava/io/File;", "addDependentCache", "", "cache", "addToClassStorage", "kotlinClass", "Lorg/jetbrains/kotlin/jps/incremental/LocalFileKotlinClass;", "clean", "cleanDirtyInlineFunctions", "cleanExperimental", "clearCacheForRemovedClasses", "Lorg/jetbrains/kotlin/jps/incremental/CompilationResult;", "getClassFilePath", "internalClassName", "getFilesToReinline", "", "getModuleMappingData", "", "getMultifileFacade", "partInternalName", "getObsoleteMultifileClasses", "getObsoletePackageParts", "getPackagePartData", "Lorg/jetbrains/kotlin/load/kotlin/incremental/components/JvmPackagePartProto;", "fqName", "getStableMultifileFacadeParts", "facadeInternalName", "markOutputClassesDirty", "removedAndCompiledSources", "", "registerExperimentalMap", "M", "K", "V", "map", "(Lorg/jetbrains/kotlin/jps/incremental/storage/BasicMap;)Lorg/jetbrains/kotlin/jps/incremental/storage/BasicMap;", "registerInline", "fromPath", "jvmSignature", "toPath", "removeAllFromClassStorage", "removedClasses", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "saveFileToCache", "generatedClass", "Lorg/jetbrains/kotlin/jps/build/GeneratedJvmClass;", "saveModuleMappingToCache", "sourceFiles", "file", "logIfSomethingChanged", "className", "Companion", "ConstantsMap", "DirtyInlineFunctionsMap", "DirtyOutputClassesMap", "InlineFunctionsFilesMap", "InlineFunctionsMap", "MultifileClassFacadeMap", "MultifileClassPartMap", "PackagePartMap", "ProtoMap", "SourceToClassesMap"}, moduleName="jps-plugin")
public final class IncrementalCacheImpl
extends BasicMapsOwner
implements IncrementalCache {
    private final File baseDir;
    private final CacheVersionProvider cacheVersionProvider;
    private final ArrayList<BasicMap<?, ?>> experimentalMaps;
    private final ProtoMap protoMap;
    private final ConstantsMap constantsMap;
    private final InlineFunctionsMap inlineFunctionsMap;
    private final PackagePartMap packagePartMap;
    private final MultifileClassFacadeMap multifileClassFacadeMap;
    private final MultifileClassPartMap multifileClassPartMap;
    private final SourceToClassesMap sourceToClassesMap;
    private final DirtyOutputClassesMap dirtyOutputClassesMap;
    private final DirtyInlineFunctionsMap dirtyInlineFunctionsMap;
    private final InlineFunctionsFilesMap inlinedTo;
    private final SubtypesMap subtypesMap;
    private final SupertypesMap supertypesMap;
    private final ArrayList<IncrementalCacheImpl> dependents;
    private final File outputDir;
    private final ModuleBuildTarget target;
    @NotNull
    public static final String PROTO_MAP = "proto";
    @NotNull
    public static final String CONSTANTS_MAP = "constants";
    @NotNull
    public static final String INLINE_FUNCTIONS = "inline-functions";
    @NotNull
    public static final String PACKAGE_PARTS = "package-parts";
    @NotNull
    public static final String MULTIFILE_CLASS_FACADES = "multifile-class-facades";
    @NotNull
    public static final String MULTIFILE_CLASS_PARTS = "multifile-class-parts";
    @NotNull
    public static final String SOURCE_TO_CLASSES = "source-to-classes";
    @NotNull
    public static final String DIRTY_OUTPUT_CLASSES = "dirty-output-classes";
    @NotNull
    public static final String DIRTY_INLINE_FUNCTIONS = "dirty-inline-functions";
    @NotNull
    public static final String INLINED_TO = "inlined-to";
    @NotNull
    public static final String SUBTYPES = "subtypes";
    @NotNull
    public static final String SUPERTYPES = "supertypes";
    private static final String MODULE_MAPPING_FILE_NAME = ".kotlin_module";
    public static final Companion Companion = org.jetbrains.kotlin.jps.incremental.IncrementalCacheImpl$Companion.INSTANCE;

    private final <K, V, M extends BasicMap<K, V>> M registerExperimentalMap(M map) {
        this.experimentalMaps.add(map);
        return this.registerMap(map);
    }

    private final File getStorageFile(String $receiver) {
        return new File(this.baseDir, $receiver + "." + BasicMapsOwner.Companion.getCACHE_EXTENSION());
    }

    private final Iterable<IncrementalCacheImpl> getDependentsWithThis() {
        return CollectionsKt.plus((Collection)this.dependents, (Object)this);
    }

    public void registerInline(@NotNull String fromPath, @NotNull String jvmSignature, @NotNull String toPath) {
        Intrinsics.checkParameterIsNotNull((Object)fromPath, (String)"fromPath");
        Intrinsics.checkParameterIsNotNull((Object)jvmSignature, (String)"jvmSignature");
        Intrinsics.checkParameterIsNotNull((Object)toPath, (String)"toPath");
        this.inlinedTo.add(fromPath, jvmSignature, toPath);
    }

    public final void addDependentCache(@NotNull IncrementalCacheImpl cache) {
        Intrinsics.checkParameterIsNotNull((Object)cache, (String)"cache");
        this.dependents.add(cache);
    }

    /*
     * WARNING - void declaration
     */
    public final void markOutputClassesDirty(@NotNull List<? extends File> removedAndCompiledSources) {
        Intrinsics.checkParameterIsNotNull(removedAndCompiledSources, (String)"removedAndCompiledSources");
        for (File file : removedAndCompiledSources) {
            void $receiver$iv;
            Collection<JvmClassName> classes2 = this.sourceToClassesMap.get(file);
            Iterable iterable = classes2;
            for (Object element$iv : $receiver$iv) {
                JvmClassName it = (JvmClassName)element$iv;
                String string = it.getInternalName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.internalName");
                this.dirtyOutputClassesMap.markDirty(string);
            }
            this.sourceToClassesMap.clearOutputsForSource(file);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<File> getFilesToReinline() {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Object className2;
        THashSet result = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
        Object object = MapsKt.iterator(this.dirtyInlineFunctionsMap.getEntries());
        while (object.hasNext()) {
            void $receiver$iv;
            void $receiver$iv2;
            Map.Entry entry = (Map.Entry)object.next();
            Map.Entry entry2 = entry;
            className2 = (JvmClassName)$receiver$iv2.getKey();
            Map.Entry $i$f$component1 = entry;
            Collection functions2 = (Collection)$receiver$iv.getValue();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            String classFilePath = this.getClassFilePath(string);
            for (IncrementalCacheImpl incrementalCacheImpl : this.getDependentsWithThis()) {
                void destination$iv$iv2;
                void $receiver$iv$iv2;
                void $receiver$iv3;
                Iterable iterable = functions2;
                void var11_13 = $receiver$iv3;
                Collection collection = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv2) {
                    String it = (String)element$iv$iv;
                    Iterable list$iv$iv = incrementalCacheImpl.inlinedTo.get(classFilePath, it);
                    CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                }
                List targetFiles = (List)destination$iv$iv2;
                result.addAll((Collection)targetFiles);
            }
        }
        Iterable $receiver$iv = (Iterable)result;
        object = $receiver$iv;
        className2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            String string = (String)item$iv$iv;
            void var20_19 = destination$iv$iv;
            File file = new File(string);
            var20_19.add(file);
        }
        return (List)destination$iv$iv;
    }

    public final void cleanDirtyInlineFunctions() {
        this.dirtyInlineFunctionsMap.clean();
    }

    @NotNull
    public String getClassFilePath(@NotNull String internalClassName) {
        Intrinsics.checkParameterIsNotNull((Object)internalClassName, (String)"internalClassName");
        String string = FileUtil.toSystemIndependentName((String)new File(this.outputDir, internalClassName + ".class").getCanonicalPath());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"toSystemIndependentName(\u2026me.class\").canonicalPath)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CompilationResult saveModuleMappingToCache(@NotNull Collection<? extends File> sourceFiles, @NotNull File file) {
        void $receiver$iv;
        JvmClassName jvmClassName;
        Intrinsics.checkParameterIsNotNull(sourceFiles, (String)"sourceFiles");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        JvmClassName jvmClassName2 = jvmClassName = JvmClassName.byInternalName((String)IncrementalCacheImpl.Companion.getMODULE_MAPPING_FILE_NAME());
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName2, (String)"jvmClassName");
        byte[] byArray = FilesKt.readBytes((File)file);
        JvmClassName jvmClassName3 = jvmClassName2;
        ProtoMap protoMap = this.protoMap;
        Object[] objectArray = new String[0];
        protoMap.process(jvmClassName3, byArray, (String[])objectArray, false, false);
        this.dirtyOutputClassesMap.notDirty(IncrementalCacheImpl.Companion.getMODULE_MAPPING_FILE_NAME());
        Iterable $i$f$emptyArray = sourceFiles;
        for (Object element$iv : $receiver$iv) {
            File it = (File)element$iv;
            JvmClassName jvmClassName4 = jvmClassName;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName4, (String)"jvmClassName");
            this.sourceToClassesMap.add(it, jvmClassName4);
        }
        return CompilationResult.Companion.getNO_CHANGES();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CompilationResult saveFileToCache(@NotNull GeneratedJvmClass generatedClass) {
        Object partNames;
        CompilationResult compilationResult;
        void $receiver$iv22;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)generatedClass, (String)"generatedClass");
        Object sourceFiles = generatedClass.getSourceFiles();
        LocalFileKotlinClass kotlinClass = generatedClass.getOutputClass();
        JvmClassName className2 = kotlinClass.getClassName();
        String string = className2.getInternalName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
        this.dirtyOutputClassesMap.notDirty(string);
        Iterable iterable = (Iterable)sourceFiles;
        for (Object element$iv : $receiver$iv) {
            File it = (File)element$iv;
            this.sourceToClassesMap.add(it, className2);
        }
        KotlinClassHeader header = kotlinClass.getClassHeader();
        if (KotlinClassHeaderKt.isCompatibleFileFacadeKind((KotlinClassHeader)header)) {
            Unit unit;
            Object element$iv;
            element$iv = sourceFiles;
            boolean $receiver$iv22 = $receiver$iv22.size() == 1;
            if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                void value$iv;
                if (value$iv == false) {
                    String message$iv = "Package part from several source files: " + sourceFiles;
                    throw (Throwable)((Object)new AssertionError((Object)message$iv));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            this.packagePartMap.addPackagePart(className2);
            compilationResult = this.protoMap.process(kotlinClass, true).plus(this.constantsMap.process(kotlinClass)).plus(this.inlineFunctionsMap.process(kotlinClass, true));
        } else if (KotlinClassHeaderKt.isCompatibleMultifileClassKind((KotlinClassHeader)header)) {
            Object object = kotlinClass.getClassHeader().getFilePartClassNames();
            if (object == null || (object = ArraysKt.toList((Object[])object)) == null) {
                throw (Throwable)((Object)new AssertionError((Object)("Multifile class has no parts: " + kotlinClass.getClassName())));
            }
            partNames = object;
            this.multifileClassFacadeMap.add(className2, (Collection)partNames);
            compilationResult = this.constantsMap.process(kotlinClass).plus(this.inlineFunctionsMap.process(kotlinClass, true));
        } else if (KotlinClassHeaderKt.isCompatibleMultifileClassPartKind((KotlinClassHeader)header)) {
            Unit unit;
            partNames = sourceFiles;
            boolean $receiver$iv3 = $receiver$iv22.size() == 1;
            if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                void value$iv;
                if (value$iv == false) {
                    String message$iv = "Multifile class part from several source files: " + sourceFiles;
                    throw (Throwable)((Object)new AssertionError((Object)message$iv));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            this.packagePartMap.addPackagePart(className2);
            String string2 = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"className.internalName");
            String string3 = header.getMultifileClassName();
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            this.multifileClassPartMap.add(string2, string3);
            compilationResult = this.protoMap.process(kotlinClass, true).plus(this.constantsMap.process(kotlinClass)).plus(this.inlineFunctionsMap.process(kotlinClass, true));
        } else if (KotlinClassHeaderKt.isCompatibleClassKind((KotlinClassHeader)header) && !header.isLocalClass()) {
            this.addToClassStorage(kotlinClass);
            compilationResult = this.protoMap.process(kotlinClass, false).plus(this.constantsMap.process(kotlinClass)).plus(this.inlineFunctionsMap.process(kotlinClass, false));
        } else {
            compilationResult = CompilationResult.Companion.getNO_CHANGES();
        }
        CompilationResult changesInfo = compilationResult;
        this.logIfSomethingChanged(changesInfo, className2);
        return changesInfo;
    }

    private final void logIfSomethingChanged(CompilationResult $receiver, JvmClassName className2) {
        if (Intrinsics.areEqual((Object)$receiver, (Object)CompilationResult.Companion.getNO_CHANGES())) {
            return;
        }
        KotlinBuilder.Companion.getLOG().debug(className2 + " is changed: " + $receiver);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CompilationResult clearCacheForRemovedClasses() {
        Iterable $receiver$iv;
        void initial$iv;
        Sequence sequence;
        CompilationResult destination$iv$iv;
        Object element$iv$iv;
        Iterable $receiver$iv$iv;
        Iterator p1;
        void destination$iv$iv2;
        Iterable $receiver$iv$iv2;
        void $receiver$iv2;
        clearCacheForRemovedClasses.1 getNonPrivateNames$ = clearCacheForRemovedClasses.1.INSTANCE;
        Function1<JvmClassName, ChangeInfo> createChangeInfo$ = new Function1<JvmClassName, ChangeInfo>(this){
            final /* synthetic */ IncrementalCacheImpl this$0;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final ChangeInfo invoke(@NotNull JvmClassName className2) {
                ChangeInfo.Removed removed;
                Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
                if (Intrinsics.areEqual((Object)className2.getInternalName(), (Object)org.jetbrains.kotlin.jps.incremental.IncrementalCacheImpl$Companion.access$getMODULE_MAPPING_FILE_NAME$p(IncrementalCacheImpl.Companion))) {
                    return null;
                }
                ProtoMapValue protoMapValue = IncrementalCacheImpl.access$getProtoMap$p(this.this$0).get(className2);
                if (protoMapValue == null) {
                    return null;
                }
                ProtoMapValue mapValue = protoMapValue;
                if (mapValue.isPackageFacade()) {
                    PackageData packageData = JvmProtoBufUtil.readPackageDataFrom((byte[])mapValue.getBytes(), (String[])mapValue.getStrings());
                    Set<String> memberNames2 = clearCacheForRemovedClasses.1.INSTANCE.invoke(packageData.getPackageProto(), packageData.getNameResolver(), (Function1)Reflection.function((FunctionReference)clearCacheForRemovedClasses.memberNames.1.INSTANCE), (Function1)Reflection.function((FunctionReference)clearCacheForRemovedClasses.memberNames.2.INSTANCE));
                    FqName fqName = className2.getPackageFqName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)fqName, (String)"className.packageFqName");
                    removed = new ChangeInfo.Removed(fqName, (Collection<String>)memberNames2);
                } else {
                    List list;
                    void destination$iv$iv;
                    void $receiver$iv$iv;
                    void $receiver$iv;
                    ClassData classData = JvmProtoBufUtil.readClassDataFrom((byte[])mapValue.getBytes(), (String[])mapValue.getStrings());
                    Iterable iterable = classData.getClassProto().getEnumEntryNameList();
                    Set<String> set = clearCacheForRemovedClasses.1.INSTANCE.invoke(classData.getClassProto(), classData.getNameResolver(), (Function1)Reflection.function((FunctionReference)clearCacheForRemovedClasses.memberNames.3.INSTANCE), (Function1)Reflection.function((FunctionReference)clearCacheForRemovedClasses.memberNames.4.INSTANCE), (Function1)Reflection.function((FunctionReference)clearCacheForRemovedClasses.memberNames.5.INSTANCE));
                    void var6_9 = $receiver$iv;
                    Collection collection = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    for (T item$iv$iv : $receiver$iv$iv) {
                        void it;
                        Integer n = (Integer)item$iv$iv;
                        list = destination$iv$iv;
                        String string = classData.getNameResolver().getString(((Number)it).intValue());
                        list.add(string);
                    }
                    list = (List)destination$iv$iv;
                    Set memberNames3 = SetsKt.plus(set, (Iterable)CollectionsKt.toSet((Iterable)list));
                    FqName fqName = className2.getFqNameForClassNameWithoutDollars();
                    Intrinsics.checkExpressionValueIsNotNull((Object)fqName, (String)"className.fqNameForClassNameWithoutDollars");
                    removed = new ChangeInfo.Removed(fqName, memberNames3);
                }
                return removed;
            }
            {
                this.this$0 = incrementalCacheImpl;
                super(1);
            }
        };
        Iterable iterable = this.dirtyOutputClassesMap.getDirtyOutputClasses();
        void var5_4 = $receiver$iv2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            String string = (String)item$iv$iv;
            void var22_7 = destination$iv$iv2;
            JvmClassName jvmClassName = JvmClassName.byInternalName((String)((Object)p1));
            var22_7.add(jvmClassName);
        }
        List dirtyClasses = CollectionsKt.toList((Iterable)((List)destination$iv$iv2));
        if (IncrementalCompilation.isExperimental()) {
            void $receiver$iv$iv$iv;
            void $receiver$iv3;
            Object item$iv$iv;
            $receiver$iv$iv2 = dirtyClasses;
            destination$iv$iv2 = $receiver$iv3;
            Iterator iterator2 = new ArrayList();
            item$iv$iv = $receiver$iv$iv;
            p1 = $receiver$iv$iv$iv.iterator();
            while (p1.hasNext()) {
                Boolean bl;
                JvmClassName it;
                Object element$iv$iv$iv;
                element$iv$iv = element$iv$iv$iv = p1.next();
                JvmClassName jvmClassName = it = (JvmClassName)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"it");
                if (createChangeInfo$.invoke(jvmClassName) != null) {
                    void $receiver$iv$iv$iv2;
                    void it$iv$iv = $receiver$iv$iv$iv2;
                    bl = destination$iv$iv.add(it$iv$iv);
                    continue;
                }
                bl = null;
            }
            sequence = CollectionsKt.asSequence((Iterable)((List)((Object)destination$iv$iv)));
        } else {
            sequence = SequencesKt.emptySequence();
        }
        Sequence changes2 = sequence;
        $receiver$iv$iv = dirtyClasses;
        destination$iv$iv = new CompilationResult(false, false, false, false, changes2, 15, null);
        CompilationResult accumulator$iv = initial$iv;
        for (Object element$iv : $receiver$iv) {
            void className2;
            element$iv$iv = (JvmClassName)element$iv;
            CompilationResult info = accumulator$iv;
            void v3 = className2;
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"className");
            boolean bl = this.protoMap.contains((JvmClassName)v3);
            void v5 = className2;
            Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"className");
            CompilationResult newInfo = new CompilationResult(bl, this.constantsMap.contains((JvmClassName)v5), false, false, null, 28, null);
            void v6 = className2;
            Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"className");
            this.logIfSomethingChanged(newInfo, (JvmClassName)v6);
            accumulator$iv = info.plus(newInfo);
        }
        CompilationResult changesInfo = accumulator$iv;
        $receiver$iv = dirtyClasses;
        for (Object element$iv : $receiver$iv) {
            JvmClassName it;
            JvmClassName jvmClassName = it = (JvmClassName)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"it");
            this.protoMap.remove(jvmClassName);
            JvmClassName jvmClassName2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName2, (String)"it");
            this.packagePartMap.remove(jvmClassName2);
            JvmClassName jvmClassName3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName3, (String)"it");
            this.multifileClassFacadeMap.remove(jvmClassName3);
            JvmClassName jvmClassName4 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName4, (String)"it");
            this.multifileClassPartMap.remove(jvmClassName4);
            JvmClassName jvmClassName5 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName5, (String)"it");
            this.constantsMap.remove(jvmClassName5);
            JvmClassName jvmClassName6 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName6, (String)"it");
            this.inlineFunctionsMap.remove(jvmClassName6);
        }
        this.removeAllFromClassStorage(dirtyClasses);
        this.dirtyOutputClassesMap.clean();
        return changesInfo;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<String> getObsoletePackageParts() {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Iterable $receiver$iv = this.dirtyOutputClassesMap.getDirtyOutputClasses();
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            String it = (String)element$iv$iv;
            JvmClassName jvmClassName = JvmClassName.byInternalName((String)it);
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"JvmClassName.byInternalName(it)");
            if (!this.packagePartMap.isPackagePart(jvmClassName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List obsoletePackageParts = (List)destination$iv$iv;
        KotlinBuilder.Companion.getLOG().debug("Obsolete package parts: " + obsoletePackageParts);
        return obsoletePackageParts;
    }

    @Nullable
    public JvmPackagePartProto getPackagePartData(@NotNull String fqName) {
        JvmPackagePartProto jvmPackagePartProto;
        Intrinsics.checkParameterIsNotNull((Object)fqName, (String)"fqName");
        JvmClassName jvmClassName = JvmClassName.byInternalName((String)fqName);
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"JvmClassName.byInternalName(fqName)");
        ProtoMapValue protoMapValue = this.protoMap.get(jvmClassName);
        if (protoMapValue != null) {
            ProtoMapValue $receiver$iv = protoMapValue;
            ProtoMapValue value = $receiver$iv;
            jvmPackagePartProto = new JvmPackagePartProto(value.getBytes(), value.getStrings());
        } else {
            jvmPackagePartProto = null;
        }
        return jvmPackagePartProto;
    }

    @NotNull
    public Collection<String> getObsoleteMultifileClasses() {
        LinkedHashSet obsoleteMultifileClasses = SetsKt.linkedSetOf((Object[])new String[0]);
        for (String dirtyClass : this.dirtyOutputClassesMap.getDirtyOutputClasses()) {
            String dirtyFacade;
            if (this.multifileClassPartMap.getFacadeName(dirtyClass) == null) {
                continue;
            }
            obsoleteMultifileClasses.add(dirtyFacade);
        }
        KotlinBuilder.Companion.getLOG().debug("Obsolete multifile class facades: " + obsoleteMultifileClasses);
        return obsoleteMultifileClasses;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Collection<String> getStableMultifileFacadeParts(@NotNull String facadeInternalName) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)facadeInternalName, (String)"facadeInternalName");
        Collection<String> collection = this.multifileClassFacadeMap.getMultifileClassParts(facadeInternalName);
        if (collection == null) {
            return null;
        }
        Collection<String> partNames = collection;
        Iterable $receiver$iv = partNames;
        Iterable iterable = $receiver$iv;
        Collection collection2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            String it = (String)element$iv$iv;
            if (!(!this.dirtyOutputClassesMap.isDirty(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public String getMultifileFacade(@NotNull String partInternalName) {
        Intrinsics.checkParameterIsNotNull((Object)partInternalName, (String)"partInternalName");
        return this.multifileClassPartMap.getFacadeName(partInternalName);
    }

    @Nullable
    public byte[] getModuleMappingData() {
        JvmClassName jvmClassName = JvmClassName.byInternalName((String)IncrementalCacheImpl.Companion.getMODULE_MAPPING_FILE_NAME());
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"JvmClassName.byInternalN\u2026MODULE_MAPPING_FILE_NAME)");
        ProtoMapValue protoMapValue = this.protoMap.get(jvmClassName);
        return (byte[])(protoMapValue != null ? protoMapValue.getBytes() : null);
    }

    @Override
    public void clean() {
        super.clean();
        this.cacheVersionProvider.normalVersion(this.target).clean();
        this.cacheVersionProvider.experimentalVersion(this.target).clean();
    }

    public final void cleanExperimental() {
        this.cacheVersionProvider.experimentalVersion(this.target).clean();
        Iterable $receiver$iv = this.experimentalMaps;
        for (Object element$iv : $receiver$iv) {
            BasicMap it = (BasicMap)element$iv;
            it.clean();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addToClassStorage(LocalFileKotlinClass kotlinClass) {
        void $receiver$iv;
        FqName it;
        Collection destination$iv$iv;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv2;
        if (!IncrementalCompilation.isExperimental()) {
            return;
        }
        String[] stringArray = kotlinClass.getClassHeader().getAnnotationData();
        if (stringArray == null) {
            Intrinsics.throwNpe();
        }
        String[] stringArray2 = kotlinClass.getClassHeader().getStrings();
        if (stringArray2 == null) {
            Intrinsics.throwNpe();
        }
        ClassData classData = JvmProtoBufUtil.readClassDataFrom((String[])stringArray, (String[])stringArray2);
        ProtoBuf.Class clazz = classData.getClassProto();
        ProtoBuf.TypeTable typeTable = classData.getClassProto().getTypeTable();
        Intrinsics.checkExpressionValueIsNotNull((Object)typeTable, (String)"classData.classProto.typeTable");
        List<ProtoBuf.Type> supertypes2 = ProtoTypeTableUtilKt.supertypes(clazz, new TypeTable(typeTable));
        Iterable iterable = supertypes2;
        void var6_5 = $receiver$iv2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            ProtoBuf.Type type = (ProtoBuf.Type)item$iv$iv;
            void var14_10 = destination$iv$iv;
            FqName fqName = classData.getNameResolver().getClassId(it.getClassName()).asSingleFqName();
            var14_10.add(fqName);
        }
        $receiver$iv2 = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv2;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (FqName)element$iv$iv;
            if (!(Intrinsics.areEqual((Object)it.asString(), (Object)"kotlin.Any") ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List parents = (List)destination$iv$iv;
        FqName child = kotlinClass.getClassId().asSingleFqName();
        $receiver$iv$iv = parents;
        for (Object element$iv : $receiver$iv) {
            FqName it2;
            FqName fqName = it2 = (FqName)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName, (String)"it");
            FqName fqName2 = child;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"child");
            this.subtypesMap.add(fqName, fqName2);
        }
        FqName fqName = child;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName, (String)"child");
        this.supertypesMap.set(fqName, parents);
    }

    /*
     * WARNING - void declaration
     */
    private final void removeAllFromClassStorage(Collection<? extends JvmClassName> removedClasses) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        if (!IncrementalCompilation.isExperimental() || removedClasses.isEmpty()) {
            return;
        }
        Iterable $receiver$iv = removedClasses;
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            JvmClassName jvmClassName = (JvmClassName)item$iv$iv;
            void var12_8 = destination$iv$iv;
            FqName fqName = it.getFqNameForClassNameWithoutDollars();
            var12_8.add(fqName);
        }
        Set removedFqNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        for (IncrementalCacheImpl cache : this.getDependentsWithThis()) {
            HashSet parentsFqNames = SetsKt.hashSetOf((Object[])new FqName[0]);
            HashSet childrenFqNames = SetsKt.hashSetOf((Object[])new FqName[0]);
            for (FqName removedFqName : removedFqNames) {
                SupertypesMap supertypesMap = cache.supertypesMap;
                FqName fqName = removedFqName;
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName, (String)"removedFqName");
                parentsFqNames.addAll(supertypesMap.get(fqName));
                SubtypesMap subtypesMap = cache.subtypesMap;
                FqName fqName2 = removedFqName;
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"removedFqName");
                childrenFqNames.addAll(subtypesMap.get(fqName2));
                SupertypesMap supertypesMap2 = cache.supertypesMap;
                FqName fqName3 = removedFqName;
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"removedFqName");
                supertypesMap2.remove(fqName3);
                SubtypesMap subtypesMap2 = cache.subtypesMap;
                FqName fqName4 = removedFqName;
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName4, (String)"removedFqName");
                subtypesMap2.remove(fqName4);
            }
            for (FqName child : childrenFqNames) {
                SupertypesMap supertypesMap = cache.supertypesMap;
                FqName fqName = child;
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName, (String)"child");
                supertypesMap.removeValues(fqName, removedFqNames);
            }
            for (FqName parent : parentsFqNames) {
                SubtypesMap subtypesMap = cache.subtypesMap;
                FqName fqName = parent;
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName, (String)"parent");
                subtypesMap.removeValues(fqName, removedFqNames);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public IncrementalCacheImpl(@NotNull ModuleBuildTarget target, @NotNull BuildDataPaths paths) {
        File file;
        void value$iv;
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)paths, (String)"paths");
        this.target = target;
        this.baseDir = new File(paths.getTargetDataRoot((BuildTarget)this.target), IncrementalCacheImplKt.getKOTLIN_CACHE_DIRECTORY_NAME());
        this.cacheVersionProvider = new CacheVersionProvider(paths);
        this.experimentalMaps = CollectionsKt.arrayListOf((Object[])new BasicMap[0]);
        this.protoMap = (ProtoMap)this.registerMap((BasicMap)new ProtoMap(this.getStorageFile(Companion.getPROTO_MAP())));
        this.constantsMap = (ConstantsMap)this.registerMap((BasicMap)new ConstantsMap(this.getStorageFile(Companion.getCONSTANTS_MAP())));
        this.inlineFunctionsMap = (InlineFunctionsMap)this.registerMap((BasicMap)new InlineFunctionsMap(this.getStorageFile(Companion.getINLINE_FUNCTIONS())));
        this.packagePartMap = (PackagePartMap)this.registerMap((BasicMap)new PackagePartMap(this.getStorageFile(Companion.getPACKAGE_PARTS())));
        this.multifileClassFacadeMap = (MultifileClassFacadeMap)this.registerMap((BasicMap)new MultifileClassFacadeMap(this.getStorageFile(Companion.getMULTIFILE_CLASS_FACADES())));
        this.multifileClassPartMap = (MultifileClassPartMap)this.registerMap((BasicMap)new MultifileClassPartMap(this.getStorageFile(Companion.getMULTIFILE_CLASS_PARTS())));
        this.sourceToClassesMap = (SourceToClassesMap)this.registerMap((BasicMap)new SourceToClassesMap(this.getStorageFile(Companion.getSOURCE_TO_CLASSES())));
        this.dirtyOutputClassesMap = (DirtyOutputClassesMap)this.registerMap((BasicMap)new DirtyOutputClassesMap(this.getStorageFile(Companion.getDIRTY_OUTPUT_CLASSES())));
        this.dirtyInlineFunctionsMap = (DirtyInlineFunctionsMap)this.registerMap((BasicMap)new DirtyInlineFunctionsMap(this.getStorageFile(Companion.getDIRTY_INLINE_FUNCTIONS())));
        this.inlinedTo = (InlineFunctionsFilesMap)this.registerMap((BasicMap)new InlineFunctionsFilesMap(this.getStorageFile(Companion.getINLINED_TO())));
        this.subtypesMap = (SubtypesMap)this.registerExperimentalMap((BasicMap)new SubtypesMap(this.getStorageFile(Companion.getSUBTYPES())));
        this.supertypesMap = (SupertypesMap)this.registerExperimentalMap((BasicMap)new SupertypesMap(this.getStorageFile(Companion.getSUPERTYPES())));
        this.dependents = CollectionsKt.arrayListOf((Object[])new IncrementalCacheImpl[0]);
        File file2 = this.target.getOutputDir();
        IncrementalCacheImpl incrementalCacheImpl = this;
        if (value$iv == null) {
            String message$iv = "Target is expected to have output directory: " + this.target;
            throw (Throwable)new IllegalArgumentException(message$iv.toString());
        }
        incrementalCacheImpl.outputDir = file = file2;
    }

    static {
        PROTO_MAP = PROTO_MAP;
        CONSTANTS_MAP = CONSTANTS_MAP;
        INLINE_FUNCTIONS = INLINE_FUNCTIONS;
        PACKAGE_PARTS = PACKAGE_PARTS;
        MULTIFILE_CLASS_FACADES = MULTIFILE_CLASS_FACADES;
        MULTIFILE_CLASS_PARTS = MULTIFILE_CLASS_PARTS;
        SOURCE_TO_CLASSES = SOURCE_TO_CLASSES;
        DIRTY_OUTPUT_CLASSES = DIRTY_OUTPUT_CLASSES;
        DIRTY_INLINE_FUNCTIONS = DIRTY_INLINE_FUNCTIONS;
        INLINED_TO = INLINED_TO;
        SUBTYPES = SUBTYPES;
        SUPERTYPES = SUPERTYPES;
        MODULE_MAPPING_FILE_NAME = "." + ModuleMapping.Companion.getMAPPING_FILE_EXT();
    }

    @NotNull
    public static final /* synthetic */ ProtoMap access$getProtoMap$p(IncrementalCacheImpl $this) {
        return $this.protoMap;
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"K\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001c\u0003\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005Aq!B\u0001\u0005\u0004\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\t\u0001\"C\u0003\u0001\u000b\u0005A\t\"B\u0001\u0005\u0006\u0015\t\u0001\"\u0001\u0003B\u00051\u0001\u0011\u0004B\u0005\u0003\u0013\u0005A\u0012\u0001'\u0001\"\u0011%%\u00012A\u0007\u00021\t\u00016\u0011A)\u0004\u0003!\u0015Q\u0015\u0003\u0003D\t!\u0019Q\"\u0001M\u00043\rAA!D\u0001\u0019\n\u0015BAA\u0003\u0005\u0006\u001b\u0005AZ!G\u0002\t\r5\t\u0001$AS\n\t\r#\u0001RB\u0007\u0003\u0019\u0003A\u0012!G\u0002\t\t5\t\u0001\u0014B\u0013\f\u0011\u001di\u0011\u0001g\u0004\u001a\u0007!AQ\"\u0001M\t3\rA\u0011\"D\u0001\u0019\b\u0015f\u0002bB\u0007\u00021\u001fI2\u0001\u0003\u0003\u000e\u0003a%\u0011d\u0001E\n\u001b\u0005A\"\"\u0007\u0004\t\u00165!\u0011BA\u0005\u00021\u0017A2\"G\u0002\t\u00135\t\u0001tA\r\u0004\u0011/i\u0011\u0001g\u0002R\u0007\u0005AA\"j\u000f\u0005\u0003!eQ\"\u0001M\b3\rAA!D\u0001\u0019\ne\u0019\u0001\"D\u0007\u00021)Ib\u0001#\u0006\u000e\t%\u0011\u0011\"\u0001M\u00061-I2\u0001C\u0005\u000e\u0003a\u001d\u0011d\u0001E\f\u001b\u0005A:!U\u0002\u0002\u00111)s\u0001c\u0007\u000e\u0003aq\u0011d\u0001\u0005\u0005\u001b\u0005AJ\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$ProtoMap;", "Lorg/jetbrains/kotlin/jps/incremental/storage/BasicStringMap;", "Lorg/jetbrains/kotlin/jps/incremental/storage/ProtoMapValue;", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl;Ljava/io/File;)V", "contains", "", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "dumpValue", "", "value", "get", "process", "Lorg/jetbrains/kotlin/jps/incremental/CompilationResult;", "kotlinClass", "Lorg/jetbrains/kotlin/jps/incremental/LocalFileKotlinClass;", "isPackage", "data", "", "strings", "", "checkChangesIsOpenPart", "(Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;[B[Ljava/lang/String;ZZ)Lorg/jetbrains/kotlin/jps/incremental/CompilationResult;", "put", "bytes", "remove", ""}, moduleName="jps-plugin")
    private final class ProtoMap
    extends BasicStringMap<ProtoMapValue> {
        @NotNull
        public final CompilationResult process(@NotNull LocalFileKotlinClass kotlinClass, boolean isPackage) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)kotlinClass), (String)"kotlinClass");
            KotlinClassHeader header = kotlinClass.getClassHeader();
            String[] stringArray = header.getAnnotationData();
            if (stringArray == null) {
                Intrinsics.throwNpe();
            }
            byte[] bytes = BitEncoding.decodeBytes((String[])stringArray);
            JvmClassName jvmClassName = kotlinClass.getClassName();
            Intrinsics.checkExpressionValueIsNotNull((Object)bytes, (String)"bytes");
            String[] stringArray2 = header.getStrings();
            if (stringArray2 == null) {
                Intrinsics.throwNpe();
            }
            return this.put(jvmClassName, bytes, stringArray2, isPackage, true);
        }

        @NotNull
        public final CompilationResult process(@NotNull JvmClassName className2, @NotNull byte[] data, @NotNull String[] strings, boolean isPackage, boolean checkChangesIsOpenPart) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            Intrinsics.checkParameterIsNotNull((Object)strings, (String)"strings");
            return this.put(className2, data, strings, isPackage, checkChangesIsOpenPart);
        }

        private final CompilationResult put(JvmClassName className2, byte[] bytes, String[] strings, boolean isPackage, boolean checkChangesIsOpenPart) {
            Sequence sequence;
            String key = className2.getInternalName();
            LazyStorage lazyStorage = this.getStorage();
            String string = key;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"key");
            ProtoMapValue oldData = (ProtoMapValue)lazyStorage.get(string);
            ProtoMapValue data = new ProtoMapValue(isPackage, bytes, strings);
            if (oldData == null || !Arrays.equals(bytes, oldData.getBytes()) || !Arrays.equals(strings, oldData.getStrings()) || isPackage != oldData.isPackageFacade()) {
                LazyStorage<String, ProtoMapValue> lazyStorage2 = this.getStorage();
                String string2 = key;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"key");
                lazyStorage2.set(string2, data);
            }
            if (oldData == null || !checkChangesIsOpenPart) {
                return new CompilationResult(true, false, false, false, null, 30, null);
            }
            DifferenceKind diff = ProtoDifferenceUtilsKt.difference(oldData, data);
            if (!IncrementalCompilation.isExperimental()) {
                return new CompilationResult(Intrinsics.areEqual((Object)diff, (Object)DifferenceKind.NONE.INSTANCE) ^ true, false, false, false, null, 30, null);
            }
            FqName fqName = isPackage ? className2.getPackageFqName() : className2.getFqNameForClassNameWithoutDollars();
            DifferenceKind differenceKind = diff;
            if (differenceKind instanceof DifferenceKind.NONE) {
                sequence = SequencesKt.emptySequence();
            } else if (differenceKind instanceof DifferenceKind.CLASS_SIGNATURE) {
                Object[] objectArray = new ChangeInfo.SignatureChanged[1];
                FqName fqName2 = fqName;
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"fqName");
                objectArray[0] = new ChangeInfo.SignatureChanged(fqName2);
                sequence = SequencesKt.sequenceOf((Object[])objectArray);
            } else if (differenceKind instanceof DifferenceKind.MEMBERS) {
                Object[] objectArray = new ChangeInfo.MembersChanged[1];
                FqName fqName3 = fqName;
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"fqName");
                objectArray[0] = new ChangeInfo.MembersChanged(fqName3, ((DifferenceKind.MEMBERS)diff).getNames());
                sequence = SequencesKt.sequenceOf((Object[])objectArray);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Sequence changes2 = sequence;
            return new CompilationResult(Intrinsics.areEqual((Object)diff, (Object)DifferenceKind.NONE.INSTANCE) ^ true, false, false, false, changes2, 14, null);
        }

        public final boolean contains(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            return lazyStorage.contains(string);
        }

        @Nullable
        public final ProtoMapValue get(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            return (ProtoMapValue)lazyStorage.get(string);
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            lazyStorage.remove(string);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull ProtoMapValue value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            return (value.isPackageFacade() ? "1" : "0") + Long.toHexString(IncrementalCacheImplKt.access$md5(value.getBytes()));
        }

        public ProtoMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            super(storageFile, ProtoMapValueExternalizer.INSTANCE);
        }
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"E\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001\u0003\n\u0006\u0003!9Q!\u0001\u0005\u0001\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001E\u0006\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\u0011Q!\u0001\u0005\n\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001C\u0001\u0005\u0003\na\u0001!\u0007\u0006\n\u0011%9\u0011BA\u0005\u00021\u0007I!!C\u0001\u0019\u0005a\t\u0001\u0014A\u0011\t\u0013\u0013A)!D\u0001\u0019\u0007A\u001b\t!U\u0002\u0002\u0011\u000f)\u000b\u0002B\"\u0005\u0011\u0011i\u0011\u0001'\u0003\u001a\u0007!)Q\"\u0001M\u0006K9!!\u0002\u0003\u0004\u000e\u0003a\r\u0011$\u0003E\u0007\u001b\u001dI!!C\u0001\u0019\u0004%\u0011\u0011\"\u0001\r\u00031\u0005)s\u0002B\u0001\t\u000f5A\u0011BA\u0005\u00021\u0007I!!C\u0001\u0019\u00051\u0005\u0001$A\r\u0004\u0011\u001fi\u0011\u0001\u0007\u0005&\u000f!EQ\"\u0001\r\n3\rA\u0019\"D\u0001\u0019\u0015\u0015\u001aB!\u0001E\u000b\u001b\u0005A\u0012\"G\u0002\t\u000b5\t\u00014B\r\u000b\u0011-i\u0001\"\u0003\u0002\n\u0003a\r\u0011BA\u0005\u00021\ta\t\u0001G\u0001&\u000f!]Q\"\u0001\r\r3\rAQ!D\u0001\u0019\f\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$ConstantsMap;", "Lorg/jetbrains/kotlin/jps/incremental/storage/BasicStringMap;", "", "", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl;Ljava/io/File;)V", "contains", "", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "dumpValue", "value", "getConstantsMap", "bytes", "", "process", "Lorg/jetbrains/kotlin/jps/incremental/CompilationResult;", "kotlinClass", "Lorg/jetbrains/kotlin/jps/incremental/LocalFileKotlinClass;", "put", "constantsMap", "remove", ""}, moduleName="jps-plugin")
    private final class ConstantsMap
    extends BasicStringMap<Map<String, ? extends Object>> {
        private final Map<String, Object> getConstantsMap(byte[] bytes) {
            HashMap result = new HashMap();
            new ClassReader(bytes).accept(new ClassVisitor(result, 327680){
                final /* synthetic */ HashMap $result;

                @Nullable
                public FieldVisitor visitField(int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable Object value) {
                    Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                    Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
                    int staticFinal = 8 | 0x10 | 2;
                    if (value != null && (access & staticFinal) == (8 | 0x10)) {
                        MapsKt.set((Map)this.$result, (Object)name, (Object)value);
                    }
                    return null;
                }
                {
                    this.$result = $captured_local_variable$0;
                    super($super_call_param$1);
                }
            }, 1 | 2 | 4);
            return result.isEmpty() ? (HashMap)null : result;
        }

        public final boolean contains(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            return lazyStorage.contains(string);
        }

        @NotNull
        public final CompilationResult process(@NotNull LocalFileKotlinClass kotlinClass) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)kotlinClass), (String)"kotlinClass");
            return this.put(kotlinClass.getClassName(), this.getConstantsMap(kotlinClass.getFileContents()));
        }

        private final CompilationResult put(JvmClassName className2, Map<String, ? extends Object> constantsMap) {
            String key = className2.getInternalName();
            LazyStorage lazyStorage = this.getStorage();
            String string = key;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"key");
            Map oldMap = (Map)lazyStorage.get(string);
            if (Intrinsics.areEqual((Object)oldMap, constantsMap)) {
                return CompilationResult.Companion.getNO_CHANGES();
            }
            if (constantsMap != null) {
                LazyStorage<String, Map<String, ? extends Object>> lazyStorage2 = this.getStorage();
                String string2 = key;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"key");
                lazyStorage2.set(string2, constantsMap);
            } else {
                LazyStorage lazyStorage3 = this.getStorage();
                String string3 = key;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"key");
                lazyStorage3.remove(string3);
            }
            return new CompilationResult(false, true, false, false, null, 29, null);
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            this.put(className2, null);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull Map<String, ? extends Object> value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return IncrementalCacheImplKt.access$dumpMap(value, (Function1)Reflection.function((FunctionReference)dumpValue.1.INSTANCE));
        }

        public ConstantsMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            super(storageFile, ConstantsMapExternalizer.INSTANCE);
        }
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"E\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001\u0003\n\u0006\u0003!9Q!\u0001E\u0005\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\u0015Q!\u0001\u0005\n\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005AY!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001C\u0001\u0005\u0003\na\u0001!\u0007\u0006\n\u0011%9\u0011BA\u0005\u00021\u0007I!!C\u0001\u0019\u0005a\t\u0001\u0014A\u0011\t\u0013\u0013A)!D\u0001\u0019\u0007A\u001b\t!U\u0002\u0002\u0011\u000f)c\u0002\u0002\u0006\t\t5\t\u00014A\r\n\u0011\u0013iq!\u0003\u0002\n\u0003a\r\u0011BA\u0005\u00021\tA\u0012!\n\b\u0005\u0003!)QbB\u0005\u0003\u0013\u0005A\u001a!\u0003\u0002\n\u0003a\u0011\u0001$A\r\u0004\u0011\u0017i\u0011\u0001\u0007\u0004&\u0017!5Q\"\u0001\r\b3\rAy!D\u0001\u0019\u0011e\u0019\u0001\u0012C\u0007\u00021%)c\u0003B\u0001\t\u00145\t\u0001dB\r\u0004\u0011)i\u0011\u0001'\u0006\u001a\u0013!YQbB\u0005\u0003\u0013\u0005A\u001a!\u0003\u0002\n\u0003a\u0011\u0001$A\r\u0004\u0011#i\u0011\u0001G\u0005&\u000f!]Q\"\u0001\r\r3\rA!\"D\u0001\u0019\u0016\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$InlineFunctionsMap;", "Lorg/jetbrains/kotlin/jps/incremental/storage/BasicStringMap;", "", "", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl;Ljava/io/File;)V", "dumpValue", "value", "getInlineFunctionsMap", "bytes", "", "process", "Lorg/jetbrains/kotlin/jps/incremental/CompilationResult;", "kotlinClass", "Lorg/jetbrains/kotlin/jps/incremental/LocalFileKotlinClass;", "isPackage", "", "put", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "newMap", "remove", ""}, moduleName="jps-plugin")
    private final class InlineFunctionsMap
    extends BasicStringMap<Map<String, ? extends Long>> {
        private final Map<String, Long> getInlineFunctionsMap(byte[] bytes) {
            HashMap result = new HashMap();
            Set inlineFunctions = InlineUtilKt.inlineFunctionsJvmNames((byte[])bytes);
            if (inlineFunctions.isEmpty()) {
                return MapsKt.emptyMap();
            }
            new ClassReader(bytes).accept(new ClassVisitor(inlineFunctions, result, 327680){
                final /* synthetic */ Set $inlineFunctions;
                final /* synthetic */ HashMap $result;

                @Nullable
                public MethodVisitor visitMethod(int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions) {
                    Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                    Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
                    ClassWriter dummyClassWriter = new ClassWriter(327680);
                    return new MethodVisitor(this, name, desc, dummyClassWriter, 327680, dummyClassWriter.visitMethod(0, name, desc, (String)null, exceptions)){
                        final /* synthetic */ getInlineFunctionsMap.1 this$0;
                        final /* synthetic */ String $name;
                        final /* synthetic */ String $desc;
                        final /* synthetic */ ClassWriter $dummyClassWriter;

                        public void visitEnd() {
                            String jvmName = this.$name + this.$desc;
                            if (this.this$0.$inlineFunctions.contains(jvmName) ^ true) {
                                return;
                            }
                            byte[] byArray = this.$dummyClassWriter.toByteArray();
                            if (byArray == null) {
                                Intrinsics.throwNpe();
                            }
                            byte[] dummyBytes = byArray;
                            long hash = IncrementalCacheImplKt.access$md5(dummyBytes);
                            MapsKt.set((Map)this.this$0.$result, (Object)jvmName, (Object)hash);
                        }
                        {
                            this.this$0 = $outer;
                            this.$name = $captured_local_variable$1;
                            this.$desc = $captured_local_variable$2;
                            this.$dummyClassWriter = $captured_local_variable$3;
                            super($super_call_param$4, $super_call_param$5);
                        }
                    };
                }
                {
                    this.$inlineFunctions = $captured_local_variable$0;
                    this.$result = $captured_local_variable$1;
                    super($super_call_param$2);
                }
            }, 0);
            return result;
        }

        @NotNull
        public final CompilationResult process(@NotNull LocalFileKotlinClass kotlinClass, boolean isPackage) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)kotlinClass), (String)"kotlinClass");
            return this.put(kotlinClass.getClassName(), this.getInlineFunctionsMap(kotlinClass.getFileContents()), isPackage);
        }

        private final CompilationResult put(JvmClassName className2, Map<String, Long> newMap, boolean isPackage) {
            Sequence sequence;
            Map<String, Long> $receiver$iv;
            String internalName = className2.getInternalName();
            LazyStorage lazyStorage = this.getStorage();
            String string = internalName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"internalName");
            Map map = (Map)lazyStorage.get(string);
            if (map == null) {
                map = MapsKt.emptyMap();
            }
            Map oldMap = map;
            HashSet added = SetsKt.hashSetOf((Object[])new String[0]);
            HashSet changed = SetsKt.hashSetOf((Object[])new String[0]);
            Map map2 = oldMap;
            Set set = $receiver$iv.keySet();
            $receiver$iv = newMap;
            Set set2 = set;
            Set<String> set3 = $receiver$iv.keySet();
            Set allFunctions = SetsKt.plus(set2, (Iterable)set3);
            for (String fn : allFunctions) {
                Long oldHash = (Long)oldMap.get(fn);
                Long newHash = newMap.get(fn);
                if (oldHash == null) {
                    added.add(fn);
                    continue;
                }
                if (!(Intrinsics.areEqual((Object)oldHash, (Object)newHash) ^ true)) continue;
                changed.add(fn);
            }
            if (MapsKt.isNotEmpty(newMap)) {
                LazyStorage<String, Map<String, Long>> lazyStorage2 = this.getStorage();
                String string2 = internalName;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"internalName");
                lazyStorage2.set(string2, newMap);
            } else {
                LazyStorage lazyStorage3 = this.getStorage();
                String string3 = internalName;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"internalName");
                lazyStorage3.remove(string3);
            }
            if (CollectionsKt.isNotEmpty((Collection)changed)) {
                IncrementalCacheImpl.this.dirtyInlineFunctionsMap.put(className2, CollectionsKt.toList((Iterable)changed));
            }
            if (IncrementalCompilation.isExperimental()) {
                FqName fqName = isPackage ? className2.getPackageFqName() : className2.getFqNameForClassNameWithoutDollars();
                sequence = SequencesKt.map((Sequence)SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)added), (Sequence)CollectionsKt.asSequence((Iterable)changed)), (Function1)((Function1)new Function1<String, ChangeInfo.MembersChanged>(fqName){
                    final /* synthetic */ FqName $fqName;

                    @NotNull
                    public final ChangeInfo.MembersChanged invoke(@NotNull String it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        FqName fqName = this.$fqName;
                        Intrinsics.checkExpressionValueIsNotNull((Object)fqName, (String)"fqName");
                        return new ChangeInfo.MembersChanged(fqName, CollectionsKt.listOf((Object)StringsKt.substringBefore$default((String)it, (String)"(", null, (int)2)));
                    }
                    {
                        this.$fqName = fqName;
                        super(1);
                    }
                }));
            } else {
                sequence = SequencesKt.emptySequence();
            }
            Sequence changes2 = sequence;
            return new CompilationResult(false, false, CollectionsKt.isNotEmpty((Collection)changed), CollectionsKt.isNotEmpty((Collection)added), changes2, 3, null);
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            lazyStorage.remove(string);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull Map<String, Long> value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return IncrementalCacheImplKt.access$dumpMap(value, dumpValue.1.INSTANCE);
        }

        public InlineFunctionsMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            super(storageFile, StringToLongMapExternalizer.INSTANCE);
        }
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"+\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001c\u0003\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001C\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005Aq!B\u0001\u0005\u0004\u0011\t%\u0001\u0004\u0001\u001a\t%\u0011\u0011\"\u0001\r\u00021\u0003\t\u0003\"#\u0003\t\u00045\t\u0001D\u0001)\u0004\u0002E\u001b\u0011\u0001#\u0002&\u000f!\u0019Q\"\u0001M\u00043\rAA!D\u0001\u0019\n\u0015BAA\u0003\u0005\u0006\u001b\u0005AZ!G\u0002\t\r5\t\u0001$A\u0013\b\u0011\u001bi\u0011\u0001G\u0001\u001a\u0007!!Q\"\u0001M\u0005K\u001dAq!D\u0001\u0019\be\u0019\u0001\u0002B\u0007\u00021\u0013\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$PackagePartMap;", "Lorg/jetbrains/kotlin/jps/incremental/storage/BasicStringMap;", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl;Ljava/io/File;)V", "addPackagePart", "", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "dumpValue", "", "value", "isPackagePart", "remove"}, moduleName="jps-plugin")
    private final class PackagePartMap
    extends BasicStringMap<Boolean> {
        public final void addPackagePart(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage<String, Boolean> lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            lazyStorage.set(string, true);
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            lazyStorage.remove(string);
        }

        public final boolean isPackagePart(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            return lazyStorage.contains(string);
        }

        @Override
        @NotNull
        protected String dumpValue(boolean value) {
            return "";
        }

        public PackagePartMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            DataExternalizer dataExternalizer = (DataExternalizer)BooleanDataDescriptor.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataExternalizer, (String)"BooleanDataDescriptor.INSTANCE");
            super(storageFile, dataExternalizer);
        }
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={")\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001C\b\u0006\u0003!9Q\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0002\u0005\u0003\na\u0001!G\u0004\n\u000b%!\u0011BA\u0005\u00021\u0007A\u0012\u0001'\u0001\"\u0011%%\u0001BA\u0007\u00021\u000b\u00016\u0011A)\u0004\u0003!\u0019QE\u0004E\u0004\u001b\u0005AB!G\u0002\t\n5\t\u0001$B\r\u0007\u0011\u0017iA!\u0003\u0002\n\u0003a\r\u0001$A\u0013\f\t)Aa!D\u0001\u0019\u0004e1\u0001RB\u0007\u0005\u0013\tI\u0011\u0001g\u0001\u0019\u0003\u0015Z\u0001bB\u0007\u0006\u0013\tI\u0011\u0001g\u0001\r\u0002a\t\u0011d\u0001E\u0005\u001b\u0005A\u001a!J\u0004\t\u00105\t\u0001\u0004B\r\u0004\u0011!i\u0011\u0001G\u0003"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$MultifileClassFacadeMap;", "Lorg/jetbrains/kotlin/jps/incremental/storage/BasicStringMap;", "", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl;Ljava/io/File;)V", "add", "", "facadeName", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "partNames", "dumpValue", "value", "getMultifileClassParts", "remove", "className"}, moduleName="jps-plugin")
    private final class MultifileClassFacadeMap
    extends BasicStringMap<Collection<? extends String>> {
        public final void add(@NotNull JvmClassName facadeName, @NotNull Collection<String> partNames) {
            Intrinsics.checkParameterIsNotNull((Object)facadeName, (String)"facadeName");
            Intrinsics.checkParameterIsNotNull(partNames, (String)"partNames");
            LazyStorage<String, Collection<String>> lazyStorage = this.getStorage();
            String string = facadeName.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"facadeName.internalName");
            lazyStorage.set(string, partNames);
        }

        @Nullable
        public final Collection<String> getMultifileClassParts(@NotNull String facadeName) {
            Intrinsics.checkParameterIsNotNull((Object)facadeName, (String)"facadeName");
            return (Collection)this.getStorage().get(facadeName);
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            lazyStorage.remove(string);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull Collection<String> value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return IncrementalCacheImplKt.dumpCollection(value);
        }

        public MultifileClassFacadeMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            super(storageFile, StringCollectionExternalizer.INSTANCE);
        }
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"#\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001C\u0004\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001C\u0001\u0006\u0003\u0011\u001dQ!\u0001\u0007\u0002\t\u0005\u0013A\u0002A\r\u0005\u0013\tI\u0011\u0001G\u0001\u0019\u0002\u0005B\u0011\u0012\u0002E\u0002\u001b\u0005A\"\u0001UB\u0001#\u000e\t\u0001RA\u0013\f\u0011\ri\u0011\u0001g\u0002\u001a\u0007!!Q\"\u0001\r\u00023\rAI!D\u0001\u0019\u0003\u0015BAA\u0003\u0005\u0006\u001b\u0005A\u0012!G\u0002\t\f5\t\u0001$A\u0013\t\u0011\u0019i!\u0001$\u0001\u0019\u0003e\u0019\u0001\u0002B\u0007\u00021\u0005)s\u0001#\u0004\u000e\u0003a\u001d\u0011d\u0001\u0005\b\u001b\u0005Az\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$MultifileClassPartMap;", "Lorg/jetbrains/kotlin/jps/incremental/storage/BasicStringMap;", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl;Ljava/io/File;)V", "add", "", "partName", "facadeName", "dumpValue", "value", "getFacadeName", "remove", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;"}, moduleName="jps-plugin")
    private final class MultifileClassPartMap
    extends BasicStringMap<String> {
        public final void add(@NotNull String partName, @NotNull String facadeName) {
            Intrinsics.checkParameterIsNotNull((Object)partName, (String)"partName");
            Intrinsics.checkParameterIsNotNull((Object)facadeName, (String)"facadeName");
            this.getStorage().set(partName, facadeName);
        }

        @Nullable
        public final String getFacadeName(@NotNull String partName) {
            Intrinsics.checkParameterIsNotNull((Object)partName, (String)"partName");
            return (String)this.getStorage().get(partName);
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            lazyStorage.remove(string);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            return value;
        }

        public MultifileClassPartMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            DataExternalizer dataExternalizer = (DataExternalizer)EnumeratorStringDescriptor.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataExternalizer, (String)"EnumeratorStringDescriptor.INSTANCE");
            super(storageFile, dataExternalizer);
        }
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"+\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001C\b\u0006\u0003!9Q\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\u0005\b\u0011\t%\u0001\u0004\u0001\u001a\u000f%)\u0011\u0002B\u0005\u0003\u0013\u0005A\u001a\u0001G\u0001\u0019\u0002\u0005B\u0011\u0012\u0002\u0005\u0003\u001b\u0005A*\u0001UB\u0001#\u000e\t\u0001bA\u0013\f\u0011\u000fi\u0011\u0001\u0007\u0003\u001a\u0007!%Q\"\u0001M\u00033\rAQ!D\u0001\u0019\f\u0015\"Aa\u0003\u0005\u0007\u001b\u0005AB!J\u0004\t\u000e5\t\u0001\u0004B\r\u0004\u0011\u0013i\u0011\u0001'\u0002&\u0017\u0011Q\u0001bB\u0007\u00021\u0007Ib\u0001c\u0004\u000e\t%\u0011\u0011\"\u0001M\u00021\u0005);\u0002B\"\u0005\u0011!iA!\u0003\u0002\n\u0003a-\u0001$A\r\u0004\u0011\u0013i\u0011\u0001'\u0002&\u0011\u0011\t\u0001\u0012C\u0007\u00021\u0011I2\u0001C\u0005\u000e\u0003a\r\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$SourceToClassesMap;", "Lorg/jetbrains/kotlin/jps/incremental/storage/BasicStringMap;", "", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl;Ljava/io/File;)V", "add", "", "sourceFile", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "clean", "clearOutputsForSource", "dumpValue", "value", "get", "remove", "path"}, moduleName="jps-plugin")
    private final class SourceToClassesMap
    extends BasicStringMap<Collection<? extends String>> {
        public final void clearOutputsForSource(@NotNull File sourceFile) {
            Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
            String string = sourceFile.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sourceFile.absolutePath");
            this.remove(string);
        }

        public final void add(@NotNull File sourceFile, @NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = sourceFile.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sourceFile.absolutePath");
            lazyStorage.append(string, (Function1<DataOutput, Unit>)((Function1)new Function1<DataOutput, Unit>(className2){
                final /* synthetic */ JvmClassName $className;

                public final void invoke(@NotNull DataOutput out) {
                    Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
                    IOUtil.writeUTF((DataOutput)out, (String)this.$className.getInternalName());
                }
                {
                    this.$className = jvmClassName;
                    super(1);
                }
            }));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Collection<JvmClassName> get(@NotNull File sourceFile) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
            LazyStorage lazyStorage = this.getStorage();
            String string = sourceFile.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sourceFile.absolutePath");
            Iterable $receiver$iv = CollectionsKt.orEmpty((Collection)((Collection)lazyStorage.get(string)));
            Iterable iterable = $receiver$iv;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                void var11_8 = destination$iv$iv;
                JvmClassName jvmClassName = JvmClassName.byInternalName((String)it);
                var11_8.add(jvmClassName);
            }
            return (List)destination$iv$iv;
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull Collection<String> value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return IncrementalCacheImplKt.dumpCollection(value);
        }

        @Override
        public void clean() {
            Iterable $receiver$iv = this.getStorage().getKeys();
            for (Object element$iv : $receiver$iv) {
                String it = (String)element$iv;
                this.remove(it);
            }
        }

        private final void remove(String path) {
            this.getStorage().remove(path);
        }

        public SourceToClassesMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            KeyDescriptor keyDescriptor = (KeyDescriptor)PathStringDescriptor.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)keyDescriptor, (String)"PathStringDescriptor.INSTANCE");
            super(storageFile, (KeyDescriptor<String>)keyDescriptor, (DataExternalizer)StringCollectionExternalizer.INSTANCE);
        }
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"-\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001c\u0003\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001C\u0004\u0006\u0003\u0011\tQ!\u0001\u0005\u0010\u000b\u0005!\u0019!B\u0001\t\u0003\u0015\u0001A!\u0011\u0002\r\u0001e!\u0011BA\u0005\u00021\u0005A\n!\t\u0005\n\n!\rQ\"\u0001\r\u0003!\u000e\u0005\u0011kA\u0001\t\u0006\u0015BAA\u0003\u0005\u0004\u001b\u0005A:!G\u0002\t\t5\t\u0001$A\u0013\u0007\u0011\u0013iA!\u0003\u0002\n\u0003a\u001d\u0001$B\u0013\b\u0011\u0017i\u0011\u0001G\u0001\u001a\u0007!1Q\"\u0001M\u0004K\u001dAi!D\u0001\u0019\u000fe\u0019\u0001BB\u0007\u00021\u000f)s\u0001c\u0004\u000e\u0003a9\u0011d\u0001\u0005\u0007\u001b\u0005A:\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$DirtyOutputClassesMap;", "Lorg/jetbrains/kotlin/jps/incremental/storage/BasicStringMap;", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl;Ljava/io/File;)V", "dumpValue", "", "value", "getDirtyOutputClasses", "", "isDirty", "className", "markDirty", "", "notDirty"}, moduleName="jps-plugin")
    private final class DirtyOutputClassesMap
    extends BasicStringMap<Boolean> {
        public final void markDirty(@NotNull String className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            this.getStorage().set(className2, true);
        }

        public final void notDirty(@NotNull String className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            this.getStorage().remove(className2);
        }

        @NotNull
        public final Collection<String> getDirtyOutputClasses() {
            return this.getStorage().getKeys();
        }

        public final boolean isDirty(@NotNull String className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            return this.getStorage().contains(className2);
        }

        @Override
        @NotNull
        protected String dumpValue(boolean value) {
            return "";
        }

        public DirtyOutputClassesMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            DataExternalizer dataExternalizer = (DataExternalizer)BooleanDataDescriptor.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataExternalizer, (String)"BooleanDataDescriptor.INSTANCE");
            super(storageFile, dataExternalizer);
        }
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"1\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001C\b\u0006\u0003!9Q\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001\u0002\u0002\u0006\u0003!\u0011R!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001C\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\u0011\t\u0005\u0013A\u0002A\r\b\u0013\u0015IA!\u0003\u0002\n\u0003a\r\u0001$\u0001M\u0001C!II\u0001\u0003\u0002\u000e\u0003a\u0015\u0001k!\u0001R\u0007\u0005A1!J\u0006\u0005\u0015!\u001dQ\"\u0001M\u00023\u0019AA!\u0004\u0003\n\u0005%\t\u00014\u0001\r\u0002K1AI!\u0004\u0006\n\u0005%\t\u00014B\u0005\u0006\u0013\u0011I!!C\u0001\u0019\u0004a\t\u0001$B\u0013\u000f\u0011\u0019i\u0011\u0001'\u0004\u001a\u0007!9Q\"\u0001M\u00063\u0019Ay!\u0004\u0003\n\u0005%\t\u00014\u0001\r\t"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$DirtyInlineFunctionsMap;", "Lorg/jetbrains/kotlin/jps/incremental/storage/BasicStringMap;", "", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl;Ljava/io/File;)V", "dumpValue", "value", "getEntries", "", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "put", "", "className", "changedFunctions", ""}, moduleName="jps-plugin")
    private final class DirtyInlineFunctionsMap
    extends BasicStringMap<Collection<? extends String>> {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<JvmClassName, Collection<String>> getEntries() {
            Iterable $receiver$iv = this.getStorage().getKeys();
            Iterable $receiver$iv$iv = $receiver$iv;
            float capacity$iv$iv = (float)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv$iv, (int)10) / 0.75f + 1.0f;
            LinkedHashMap<JvmClassName, Collection> result$iv$iv = new LinkedHashMap<JvmClassName, Collection>(Math.max((int)capacity$iv$iv, 16));
            for (Object element$iv$iv : $receiver$iv$iv) {
                void it;
                String p1;
                String string = (String)element$iv$iv;
                LinkedHashMap<JvmClassName, Collection> linkedHashMap = result$iv$iv;
                JvmClassName jvmClassName = JvmClassName.byInternalName((String)p1);
                p1 = (String)element$iv$iv;
                Object v = this.getStorage().get(it);
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                Collection collection = (Collection)v;
                linkedHashMap.put(jvmClassName, collection);
            }
            return result$iv$iv;
        }

        public final void put(@NotNull JvmClassName className2, @NotNull List<String> changedFunctions) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            Intrinsics.checkParameterIsNotNull(changedFunctions, (String)"changedFunctions");
            LazyStorage<String, List<String>> lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            lazyStorage.set(string, changedFunctions);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull Collection<String> value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return IncrementalCacheImplKt.dumpCollection(value);
        }

        public DirtyInlineFunctionsMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            super(storageFile, StringCollectionExternalizer.INSTANCE);
        }
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"'\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003!yQ!\u0001\u0005\b\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\u0002\u000b\u0005!A\u0001B!\u0003\u0019\u0001I\"\"\u0003\u0002\n\u0003a\t\u0011\"B\u0005\u0005\u0013\tI\u0011\u0001\u0007\u0002\u0019\u0004a\u0005\u0011\u0005CE\u0005\u0011\u000bi\u0011\u0001G\u0002Q\u0007\u0003\t6!\u0001E\u0004K=AA!D\u0001\u0019\ne\u0019\u0001\"B\u0007\u00021\tI2\u0001c\u0003\u000e\u0003a\u0011\u0011d\u0001\u0005\u0007\u001b\u0005A\"!\n\u0005\u0005\u0015!5Q\"\u0001\r\u00033\rAq!D\u0001\u0019\u0003\u0015ZAA\u0003E\b\u001b\u0005A\"!\u0007\u0004\t\u00115!\u0011BA\u0005\u00021\tA\u001a!j\b\u0005\u0007\u0012A\t\"\u0004\u0003\n\u0005%\t\u0001D\u0001M\u00023\rAQ!D\u0001\u0019\u0005e\u0019\u00012B\u0007\u00021\t\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$InlineFunctionsFilesMap;", "Lorg/jetbrains/kotlin/jps/incremental/storage/BasicMap;", "Lorg/jetbrains/kotlin/jps/incremental/storage/PathFunctionPair;", "", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl;Ljava/io/File;)V", "add", "", "sourcePath", "jvmSignature", "targetPath", "dumpKey", "key", "dumpValue", "value", "get"}, moduleName="jps-plugin")
    private final class InlineFunctionsFilesMap
    extends BasicMap<PathFunctionPair, Collection<? extends String>> {
        public final void add(@NotNull String sourcePath, @NotNull String jvmSignature, @NotNull String targetPath) {
            Intrinsics.checkParameterIsNotNull((Object)sourcePath, (String)"sourcePath");
            Intrinsics.checkParameterIsNotNull((Object)jvmSignature, (String)"jvmSignature");
            Intrinsics.checkParameterIsNotNull((Object)targetPath, (String)"targetPath");
            PathFunctionPair key = new PathFunctionPair(sourcePath, jvmSignature);
            this.getStorage().append(key, (Function1<DataOutput, Unit>)((Function1)new Function1<DataOutput, Unit>(targetPath){
                final /* synthetic */ String $targetPath;

                public final void invoke(@NotNull DataOutput out) {
                    Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
                    IOUtil.writeUTF((DataOutput)out, (String)this.$targetPath);
                }
                {
                    this.$targetPath = string;
                    super(1);
                }
            }));
        }

        @NotNull
        public final Collection<String> get(@NotNull String sourcePath, @NotNull String jvmSignature) {
            Intrinsics.checkParameterIsNotNull((Object)sourcePath, (String)"sourcePath");
            Intrinsics.checkParameterIsNotNull((Object)jvmSignature, (String)"jvmSignature");
            PathFunctionPair key = new PathFunctionPair(sourcePath, jvmSignature);
            Collection collection = (Collection)this.getStorage().get(key);
            if (collection == null) {
                collection = SetsKt.emptySet();
            }
            return collection;
        }

        @Override
        @NotNull
        protected String dumpKey(@NotNull PathFunctionPair key) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            return "(" + key.getPath() + ", " + key.getFunction() + ")";
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull Collection<String> value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return IncrementalCacheImplKt.dumpCollection(value);
        }

        public InlineFunctionsFilesMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            super(storageFile, PathFunctionPairKeyDescriptor.INSTANCE, PathCollectionExternalizer.INSTANCE);
        }
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u0015\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!9Q!\u0001\u0003\u000e\t\r\u000fA\u0002A\r\u00021\u0003\t;\u0001B\u0001R\u0007\u0005A\u0011!k\u0006\u0005\u0007\"\u000b\u00012A\u0007\u00021\t\t6!B\u0003\u0002\u0019\u0003i!\u0001\"\u0002\t\u0007%^Aa\u0011%\u0002\u0011\u000fi\u0011\u0001\u0007\u0002R\u0007\u0015)\u0011\u0001$\u0001\u000e\u0005\u0011!\u0001bAU\f\t\rC\u0015\u0001#\u0003\u000e\u0003a\u0011\u0011kA\u0003\u0006\u00031\u0005QB\u0001\u0003\u0006\u0011\rI;\u0002B\"I\u0003!-Q\"\u0001\r\u0003#\u000e)Q!\u0001G\u0001\u001b\t!a\u0001C\u0002*\u0018\u0011\u0019\u0005*\u0001E\u0007\u001b\u0005A\"!U\u0002\u0006\u000b\u0005a\t!\u0004\u0002\u0005\u000f!\u0019\u0011v\u0003\u0003B\u0011\u0006Ay!D\u0001\u0019\u0005E\u001bQ!B\u0001\r\u00025\u0011A\u0001\u0003\u0005\u0004S/!1\tS\u0001\t\u00125\t\u0001DA)\u0004\u000b\u0015\tA\u0012A\u0007\u0003\t%A1!k\u0006\u0005\u0007\"\u000b\u00012C\u0007\u00021\t\t6!B\u0003\u0002\u0019\u0003i!\u0001\u0002\u0006\t\u0007%^Aa\u0011%\u0002\u0011+i\u0011\u0001\u0007\u0002R\u0007\u0015)\u0011\u0001$\u0001\u000e\u0005\u0011Y\u0001bAU\f\t\rC\u0015\u0001c\u0006\u000e\u0003a\u0011\u0011kA\u0003\u0006\u00031\u0005QB\u0001\u0003\r\u0011\rI;\u0002B\"I\u0003!eQ\"\u0001\r\u0003#\u000e)Q!\u0001G\u0001\u001b\t!Q\u0002C\u0002*\u0018\u0011\u0019\u0005*\u0001E\u000e\u001b\u0005A\"!U\u0002\u0006\u000b\u0005a\t!\u0004\u0002\u0005\u001d!\u0019\u0011v\u0003\u0003D\u0011\u0006Ai\"D\u0001\u0019\u0005E\u001bQ!B\u0001\r\u00025\u0011Aa\u0004\u0005\u0004"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$Companion;", "", "()V", "CONSTANTS_MAP", "", "getCONSTANTS_MAP", "()Ljava/lang/String;", "DIRTY_INLINE_FUNCTIONS", "getDIRTY_INLINE_FUNCTIONS", "DIRTY_OUTPUT_CLASSES", "getDIRTY_OUTPUT_CLASSES", "INLINED_TO", "getINLINED_TO", "INLINE_FUNCTIONS", "getINLINE_FUNCTIONS", "MODULE_MAPPING_FILE_NAME", "getMODULE_MAPPING_FILE_NAME", "MULTIFILE_CLASS_FACADES", "getMULTIFILE_CLASS_FACADES", "MULTIFILE_CLASS_PARTS", "getMULTIFILE_CLASS_PARTS", "PACKAGE_PARTS", "getPACKAGE_PARTS", "PROTO_MAP", "getPROTO_MAP", "SOURCE_TO_CLASSES", "getSOURCE_TO_CLASSES", "SUBTYPES", "getSUBTYPES", "SUPERTYPES", "getSUPERTYPES"}, moduleName="jps-plugin")
    public static final class Companion {
        public static final Companion INSTANCE;

        @NotNull
        public final String getPROTO_MAP() {
            return PROTO_MAP;
        }

        @NotNull
        public final String getCONSTANTS_MAP() {
            return CONSTANTS_MAP;
        }

        @NotNull
        public final String getINLINE_FUNCTIONS() {
            return INLINE_FUNCTIONS;
        }

        @NotNull
        public final String getPACKAGE_PARTS() {
            return PACKAGE_PARTS;
        }

        @NotNull
        public final String getMULTIFILE_CLASS_FACADES() {
            return MULTIFILE_CLASS_FACADES;
        }

        @NotNull
        public final String getMULTIFILE_CLASS_PARTS() {
            return MULTIFILE_CLASS_PARTS;
        }

        @NotNull
        public final String getSOURCE_TO_CLASSES() {
            return SOURCE_TO_CLASSES;
        }

        @NotNull
        public final String getDIRTY_OUTPUT_CLASSES() {
            return DIRTY_OUTPUT_CLASSES;
        }

        @NotNull
        public final String getDIRTY_INLINE_FUNCTIONS() {
            return DIRTY_INLINE_FUNCTIONS;
        }

        @NotNull
        public final String getINLINED_TO() {
            return INLINED_TO;
        }

        @NotNull
        public final String getSUBTYPES() {
            return SUBTYPES;
        }

        @NotNull
        public final String getSUPERTYPES() {
            return SUPERTYPES;
        }

        private final String getMODULE_MAPPING_FILE_NAME() {
            return MODULE_MAPPING_FILE_NAME;
        }

        private Companion() {
            INSTANCE = this;
        }

        static {
            new Companion();
        }
    }
}

