/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.incremental;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.jps.incremental.LookupSymbol;
import org.jetbrains.kotlin.jps.incremental.storage.BasicMap;
import org.jetbrains.kotlin.jps.incremental.storage.BasicMapsOwner;
import org.jetbrains.kotlin.jps.incremental.storage.FileToIdMap;
import org.jetbrains.kotlin.jps.incremental.storage.IdToFileMap;
import org.jetbrains.kotlin.jps.incremental.storage.LookupMap;
import org.jetbrains.kotlin.jps.incremental.storage.LookupSymbolKey;
import org.jetbrains.kotlin.utils.Printer;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"Y\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA1A\u0003\u0002\u0011\u0011)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\b\u000b\u0005!\u0019!B\u0001\t\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001C\b\u0006\u0003\u0011\u0015Q!\u0001\u0005\u0012\u000b\u0005!\u0011!B\u0001\t\f\u0015\tAa\u0001\u0007\u0001!OI\u0012\u0001'\u0001\u001e\u0002O\tk!C\u0002\t\u00035\t\u00014A)\u0004\u0003!\u0011QE\u0004E\n\u001b\u0005A\"\"G\u0002\t\u00165\t\u0001dC\r\u0007\u0011/iA!\u0003\u0002\n\u0003aA\u0001\u0004D\u0013\t\t\u0005AI\"D\u0001\u0019\be\u0019\u0001\"D\u0007\u00021\u0007)C\u0001B\u0006\t\u001c5\t\u0001DC\u0013\f\t\u000fAa\"D\u0001\u0019\u0011e1\u0001RD\u0007\u0005\u0013\tI\u0011\u0001G\u0006\u0019\u001f\u0015BAa\u0003E\u0010\u001b\u0005A\"\"G\u0002\t!5\t\u0001\u0014E\u0013\u0005\t\u000fA\u0011#D\u0001\u0019\u0015\u0015R\u00012E\u0007\u0005\u0013\tI\u0011\u0001\u0007\u0005\u0019\u0019e\u0019\u0001RC\u0007\u00021-)\u0013\u0002B\u0001\t%5\t\u0001DC\r\u0005\t\u0005A)#D\u0001\u0019\"\u0015:\u0001bE\u0007\u00021)I2\u0001C\u0007\u000e\u0003a\r\u0011f\u0002\u0003B\u0011!\u0015Q\"\u0001M\u0002#\u000e\tQ\u0001A\u0015\b\t\u0005c\u0002bA\u0007\u00021\u000f\t6!A\u0003\u0001S\u001d!\u0011\t\u0003\u0005\u0005\u001b\u0005AJ!U\u0002\u0002\u000b\u0001Is\u0001B!\t\u0011\u0015i\u0011\u0001g\u0003R\u0007\u0005)\u0001!K\u0004\u0005\u0003\"Aa!D\u0001\u0019\u000eE\u001b\u0011!\u0002\u0001*\u000f\u0011\tE\u0004C\u0004\u000e\u0003a\u001d\u0011kA\u0001\u0006\u0001%:A!\u0011\u0005\t\u00035\t\u00014A)\u0004\u0003\u0015\u0001\u0011\u0006\u0004\u0003B\u0011!=Q\"\u0001M\u0002+\u0005A\u0002\u0002H\u0011R\u0007\ri!\u0001\"\u0005\t\u0013\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/LookupStorage;", "Lorg/jetbrains/kotlin/jps/incremental/storage/BasicMapsOwner;", "targetDataDir", "Ljava/io/File;", "(Ljava/io/File;)V", "countersFile", "deletedCount", "", "fileToId", "Lorg/jetbrains/kotlin/jps/incremental/storage/FileToIdMap;", "idToFile", "Lorg/jetbrains/kotlin/jps/incremental/storage/IdToFileMap;", "lookupMap", "Lorg/jetbrains/kotlin/jps/incremental/storage/LookupMap;", "size", "storageFile", "", "getStorageFile", "(Ljava/lang/String;)Ljava/io/File;", "add", "", "lookupSymbol", "Lorg/jetbrains/kotlin/jps/incremental/LookupSymbol;", "containingPaths", "", "addFileIfNeeded", "file", "clean", "dump", "lookupSymbols", "", "flush", "memoryCachesOnly", "", "forceGC", "get", "removeGarbageIfNeeded", "force", "removeLookupsFrom", "Companion"}, moduleName="jps-plugin")
public final class LookupStorage
extends BasicMapsOwner {
    private final File countersFile;
    private final IdToFileMap idToFile;
    private final FileToIdMap fileToId;
    private final LookupMap lookupMap;
    private int size;
    private int deletedCount;
    private final File targetDataDir;
    private static final double DELETED_TO_SIZE_TRESHOLD = 0.5;
    private static final int MINIMUM_GARBAGE_COLLECTIBLE_SIZE = 10000;
    public static final Companion Companion = org.jetbrains.kotlin.jps.incremental.LookupStorage$Companion.INSTANCE;

    private final File getStorageFile(String $receiver) {
        return new File(this.targetDataDir, $receiver + "." + BasicMapsOwner.Companion.getCACHE_EXTENSION());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<String> get(@NotNull LookupSymbol lookupSymbol) {
        void destination$iv$iv;
        void $receiver$iv$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)lookupSymbol, (String)"lookupSymbol");
        LookupSymbolKey key = new LookupSymbolKey(lookupSymbol.getName(), lookupSymbol.getScope());
        Collection<Integer> collection = this.lookupMap.get(key);
        if (collection == null) {
            return SetsKt.emptySet();
        }
        Collection<Integer> fileIds = collection;
        Iterable iterable = fileIds;
        void var5_5 = $receiver$iv;
        Collection collection2 = new ArrayList();
        void var7_7 = $receiver$iv$iv;
        Iterator iterator2 = $receiver$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Boolean bl;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            int it = ((Number)element$iv$iv).intValue();
            File file = this.idToFile.get(it);
            if ((file != null ? file.getPath() : null) != null) {
                void $receiver$iv$iv$iv2;
                String string;
                string = string;
                void it$iv$iv = $receiver$iv$iv$iv2;
                bl = destination$iv$iv.add(it$iv$iv);
                continue;
            }
            bl = null;
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public final void add(@NotNull LookupSymbol lookupSymbol, @NotNull Collection<String> containingPaths) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)lookupSymbol, (String)"lookupSymbol");
        Intrinsics.checkParameterIsNotNull(containingPaths, (String)"containingPaths");
        LookupSymbolKey key = new LookupSymbolKey(lookupSymbol.getName(), lookupSymbol.getScope());
        Iterable iterable = containingPaths;
        void var6_5 = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            void var14_10 = destination$iv$iv;
            Integer n = this.addFileIfNeeded(new File((String)it));
            var14_10.add(n);
        }
        HashSet fileIds = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
        Collection collection2 = this.lookupMap.get(key);
        if (collection2 == null) {
            collection2 = SetsKt.emptySet();
        }
        fileIds.addAll(collection2);
        this.lookupMap.set(key, fileIds);
    }

    public final void removeLookupsFrom(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Integer n = this.fileToId.get(file);
        if (n == null) {
            return;
        }
        int id = ((Number)n).intValue();
        this.idToFile.remove(id);
        this.fileToId.remove(file);
        int n2 = this.deletedCount++;
    }

    @Override
    public void clean() {
        if (this.countersFile.exists()) {
            this.countersFile.delete();
        }
        this.size = 0;
        this.deletedCount = 0;
        super.clean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(boolean memoryCachesOnly) {
        try {
            LookupStorage.removeGarbageIfNeeded$default(this, false, 1);
            if (this.size > 0) {
                if (!this.countersFile.exists()) {
                    this.countersFile.getParentFile().mkdirs();
                    this.countersFile.createNewFile();
                }
                FilesKt.writeText$default((File)this.countersFile, (String)(this.size + "\n" + this.deletedCount), null, (int)2);
            }
        }
        finally {
            super.flush(memoryCachesOnly);
        }
    }

    private final int addFileIfNeeded(File file) {
        Integer existing = this.fileToId.get(file);
        if (existing != null) {
            return ((Number)existing).intValue();
        }
        int id = this.size++;
        this.fileToId.set(file, id);
        this.idToFile.set(id, file);
        return id;
    }

    /*
     * WARNING - void declaration
     */
    private final void removeGarbageIfNeeded(boolean force) {
        Iterator<Object> iterator2;
        Map.Entry<File, Integer> $receiver$iv;
        if (!force && this.size <= LookupStorage.Companion.getMINIMUM_GARBAGE_COLLECTIBLE_SIZE() && (double)this.deletedCount / (double)this.size <= LookupStorage.Companion.getDELETED_TO_SIZE_TRESHOLD()) {
            return;
        }
        for (LookupSymbolKey hash : this.lookupMap.getKeys()) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            Collection<Integer> collection = this.lookupMap.get(hash);
            if (collection == null) {
                Intrinsics.throwNpe();
            }
            Iterable iterable = collection;
            LookupSymbolKey lookupSymbolKey = hash;
            LookupMap lookupMap = this.lookupMap;
            iterator2 = $receiver$iv;
            Collection collection2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                int it = ((Number)element$iv$iv).intValue();
                if (!this.idToFile.contains(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            lookupMap.set(lookupSymbolKey, CollectionsKt.toSet((Iterable)list));
        }
        Map<File, Integer> oldFileToId = this.fileToId.toMap();
        HashMap oldIdToNewId = new HashMap(oldFileToId.size());
        this.idToFile.clean();
        this.fileToId.clean();
        this.size = 0;
        this.deletedCount = 0;
        iterator2 = oldFileToId.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $receiver$iv2;
            void $receiver$iv3;
            Map.Entry<File, Integer> entry = $receiver$iv = iterator2.next();
            File file = (File)$receiver$iv3.getKey();
            Map.Entry<File, Integer> $i$f$component1 = $receiver$iv;
            int oldId = ((Number)$receiver$iv2.getValue()).intValue();
            int newId = this.addFileIfNeeded(file);
            MapsKt.set((Map)oldIdToNewId, (Object)oldId, (Object)newId);
        }
        for (LookupSymbolKey lookup : this.lookupMap.getKeys()) {
            void destination$iv$iv;
            void $receiver$iv$iv$iv;
            void $receiver$iv$iv;
            void $receiver$iv4;
            Collection<Integer> collection = this.lookupMap.get(lookup);
            if (collection == null) {
                Intrinsics.throwNpe();
            }
            Iterable oldId = collection;
            void newId = $receiver$iv4;
            Collection $i$f$component2 = new ArrayList();
            void $i$a$1 = $receiver$iv$iv;
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                Boolean bl;
                Object element$iv$iv = element$iv$iv$iv;
                int it = ((Number)element$iv$iv).intValue();
                if ((Integer)oldIdToNewId.get(it) != null) {
                    void $receiver$iv$iv$iv2;
                    void it$iv$iv = $receiver$iv$iv$iv2;
                    bl = destination$iv$iv.add(it$iv$iv);
                    continue;
                }
                bl = null;
            }
            Set fileIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            if (fileIds.isEmpty()) {
                this.lookupMap.remove(lookup);
                continue;
            }
            this.lookupMap.set(lookup, fileIds);
        }
    }

    static /* bridge */ /* synthetic */ void removeGarbageIfNeeded$default(LookupStorage lookupStorage, boolean bl, int n) {
        if ((n & 1) != 0) {
            bl = false;
        }
        lookupStorage.removeGarbageIfNeeded(bl);
    }

    public final void forceGC() {
        this.removeGarbageIfNeeded(true);
        this.flush(false);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String dump(@NotNull Set<LookupSymbol> lookupSymbols) {
        Object value$iv$iv$iv;
        void map$iv$iv;
        Iterator key$iv$iv;
        LookupSymbol it;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(lookupSymbols, (String)"lookupSymbols");
        this.flush(false);
        StringBuilder sb = new StringBuilder();
        Printer p = new Printer(sb);
        Iterable iterable = lookupSymbols;
        Iterator iterator2 = $receiver$iv;
        Map map = new LinkedHashMap();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Object object;
            void $receiver$iv$iv$iv;
            it = (LookupSymbol)element$iv$iv;
            key$iv$iv = new LookupSymbolKey(it.getName(), it.getScope());
            Iterator iterator3 = map$iv$iv;
            value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        void lookupsStrings = map$iv$iv;
        for (LookupSymbolKey lookup : CollectionsKt.sorted((Iterable)this.lookupMap.getKeys())) {
            void destination$iv$iv;
            void $receiver$iv$iv2;
            void $receiver$iv2;
            Collection<Integer> fileIds;
            String string;
            Object object;
            void var20_18;
            void destination$iv$iv2;
            Iterable $receiver$iv$iv3;
            if (this.lookupMap.get(lookup) == null) {
                Intrinsics.throwNpe();
            }
            if (MapsKt.contains((Map)lookupsStrings, (Object)lookup)) {
                void $receiver$iv3;
                Object element$iv$iv;
                Object v = lookupsStrings.get(lookup);
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                element$iv$iv = (Iterable)v;
                it = $receiver$iv3;
                Collection $i$a$1 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv3) {
                    void it2;
                    value$iv$iv$iv = (LookupSymbol)item$iv$iv;
                    var20_18 = destination$iv$iv2;
                    object = it2.getScope() + "#" + it2.getName();
                    var20_18.add(object);
                }
                string = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv2)), (CharSequence)", ", null, null, (int)0, null, null, (int)62);
            } else {
                string = lookup.toString();
            }
            String key = string;
            $receiver$iv$iv3 = fileIds;
            destination$iv$iv2 = $receiver$iv2;
            key$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                void it3;
                int $i$a$1 = ((Number)item$iv$iv).intValue();
                var20_18 = destination$iv$iv;
                Object object2 = this.idToFile.get((int)it3);
                if (object2 == null || (object2 = ((File)object2).getAbsolutePath()) == null) {
                    object2 = String.valueOf((int)it3);
                }
                object = object2;
                var20_18.add(object);
            }
            String value = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)), (CharSequence)", ", null, null, (int)0, null, null, (int)62);
            p.println(key + " -> " + value);
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    public LookupStorage(@NotNull File targetDataDir) {
        Intrinsics.checkParameterIsNotNull((Object)targetDataDir, (String)"targetDataDir");
        this.targetDataDir = targetDataDir;
        this.countersFile = this.getStorageFile("counters");
        this.idToFile = (IdToFileMap)this.registerMap((BasicMap)new IdToFileMap(this.getStorageFile("id-to-file")));
        this.fileToId = (FileToIdMap)this.registerMap((BasicMap)new FileToIdMap(this.getStorageFile("file-to-id")));
        this.lookupMap = (LookupMap)this.registerMap((BasicMap)new LookupMap(this.getStorageFile("lookups")));
        if (this.countersFile.exists()) {
            List lines = FilesKt.readLines$default((File)this.countersFile, null, (int)1);
            this.size = StringsKt.toInt((String)((String)lines.get(0)));
            this.deletedCount = StringsKt.toInt((String)((String)lines.get(1)));
        }
    }

    static {
        DELETED_TO_SIZE_TRESHOLD = 0.5;
        MINIMUM_GARBAGE_COLLECTIBLE_SIZE = 10000;
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u001d\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!\u0019Q!\u0001C\u0002\u000b\u0005AA!B\u0001\u0005\u0003\u0011\u0019\u001d\u0001\u0004\u0001\u001a\u0003a\u0005\u0011u\u0001\u0003\u0002#\u000e\t\u0001\"AU\f\t\u0005C\u0015\u0001c\u0001\u000e\u0003a\u0011\u0011kA\u0003\u0006\u00031\u0005QB\u0001C\u0003\u0011\rI;\u0002B!I\u0003!\u001dQ\"\u0001\r\u0005#\u000e)Q!\u0001G\u0001\u001b\t!I\u0001C\u0003"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/LookupStorage$Companion;", "", "()V", "DELETED_TO_SIZE_TRESHOLD", "", "getDELETED_TO_SIZE_TRESHOLD", "()D", "MINIMUM_GARBAGE_COLLECTIBLE_SIZE", "", "getMINIMUM_GARBAGE_COLLECTIBLE_SIZE", "()I"}, moduleName="jps-plugin")
    public static final class Companion {
        public static final Companion INSTANCE;

        private final double getDELETED_TO_SIZE_TRESHOLD() {
            return DELETED_TO_SIZE_TRESHOLD;
        }

        private final int getMINIMUM_GARBAGE_COLLECTIBLE_SIZE() {
            return MINIMUM_GARBAGE_COLLECTIBLE_SIZE;
        }

        private Companion() {
            INSTANCE = this;
        }

        static {
            new Companion();
        }
    }
}

