/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.incremental.storage;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"1\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\u0005\u000b\u0005!\u0011!B\u0001\t\f\u0015\tAAA\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\u0003\u0015\u0001Q!\u0001\u0007\u0002\t\r\fA\u0002A\r\u0005\u0013\tI\u0011\u0001G\u0001\u0019\u0002\u0005\u001eA!A)\u0004\u0003!\rQ%\u0003\u0003\f\u0011\ti\u0011\u0001'\u0002\u001a\t!\u0019QB\u0001G\u00011\u0005)c\u0002B\u0006\t\b5\t\u0001\u0004B\r\u0005\u0011\u0013i!\u0001$\u0001\u0019\u0003e!\u0001\"B\u0007\u0003\u0019\u0003A\u0012!\n\u0005\u0005\u0017!-Q\"\u0001\r\u00023\rAa!D\u0001\u0019\u000e\u0015bAa\u0003\u0005\b\u001b\u0005Az!G\u0002\t\u00115\t\u0001\u0014C\r\u0004\u0011\ri\u0011\u0001G\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/storage/FileKeyDescriptor;", "Lcom/intellij/util/io/KeyDescriptor;", "Ljava/io/File;", "()V", "getHashCode", "", "value", "isEqual", "", "val1", "val2", "read", "input", "Ljava/io/DataInput;", "save", "", "output", "Ljava/io/DataOutput;"}, moduleName="jps-plugin")
public final class FileKeyDescriptor
implements KeyDescriptor<File> {
    public static final FileKeyDescriptor INSTANCE;
    public static final FileKeyDescriptor INSTANCE$;

    @NotNull
    public File read(@NotNull DataInput input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return new File(input.readUTF());
    }

    public void save(@NotNull DataOutput output, @NotNull File value) {
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        output.writeUTF(value.getCanonicalPath());
    }

    public int getHashCode(@Nullable File value) {
        return FileUtil.FILE_HASHING_STRATEGY.computeHashCode((Object)value);
    }

    public boolean isEqual(@Nullable File val1, @Nullable File val2) {
        return FileUtil.FILE_HASHING_STRATEGY.equals((Object)val1, (Object)val2);
    }

    private FileKeyDescriptor() {
        INSTANCE = this;
        INSTANCE$ = this;
    }

    static {
        new FileKeyDescriptor();
    }
}

