/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils.strings;

import com.intellij.openapi.util.text.StringUtil;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;

@KotlinFileFacade(version={1, 0, 1}, abiVersion=32, data={"\u0019\u0015\u0001Q!\u0001\u0005\b\u000b\u0005!)!B\u0001\t\u000e\u0015\u0001Q!\u0001\u0005\u0005\u000b\u0005!!!d\u0007\u0005\u0003!\u0015Q\"\u0001M\u00013\rA1!D\u0001\u0019\be\u0019\u0001\u0002B\u0007\u00021\u0013!6!A\u0007\u0018\u0011\u0015i\u0011\u0001'\u0001\u0016\u0003a\u001d\u0011\u0014\u0002E\u0006\u001b\u0005AJ\u0001UB\u00013\u0013Aa!D\u0001\u0019\nA\u001b\u0011!'\u0003\t\u000e5\t\u0001\u0014\u0002)\u0004\u0004Q\u001b\u0011!E\u0005\u0005\u0003\"\u000b\u0001\u0002A\u0007\u00021\u0003\t6!A\u0003\u0001)\u000e\t\u0011#\u0003\u0003B\u0011\u0006A\u0019!D\u0001\u0019\u0002E\u001b\u0011!\u0002\u0001U\u0007\u0005\t\u0012\u0002B!I\u0003!\u0011Q\"\u0001M\u0001#\u000e\tQ\u0001\u0001+\u0004\u0003\u0001"}, strings={"BEGIN_MARKER", "", "StringsKt", "CARET_MARKER", "END_MARKER", "position", "str", "", "offset", "", "substringWithContext", "beginIndex", "endIndex", "range"}, moduleName="util")
public final class StringsKt {
    private static final String CARET_MARKER = "<~!!~>";
    private static final String BEGIN_MARKER = "<~BEGIN~>";
    private static final String END_MARKER = "<~END~>";

    @NotNull
    public static final String substringWithContext(CharSequence $receiver, int beginIndex, int endIndex, int range) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        int start = Math.max(0, beginIndex - range);
        int end = Math.min(CollectionsKt.length((CharSequence)$receiver), endIndex + range);
        boolean notFromBegin = start != 0;
        boolean notToEnd = end != CollectionsKt.length((CharSequence)$receiver);
        int updatedStart = beginIndex - start;
        int updatedEnd = endIndex - start;
        String string = new StringBuilder(kotlin.text.StringsKt.substring((String)((Object)$receiver).toString(), (int)start, (int)end)).insert(updatedEnd, updatedEnd == updatedStart ? CARET_MARKER : END_MARKER).insert(updatedStart, updatedEnd == updatedStart ? "" : BEGIN_MARKER).insert(0, notFromBegin ? "<~..." + StringsKt.position($receiver, start) + "~>" : "").append(notToEnd ? "<~" + StringsKt.position($receiver, end) + "...~>" : "").toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder(this.toStr\u2026..~>\" else \"\").toString()");
        return string;
    }

    private static final String position(CharSequence str, int offset) {
        int line = StringUtil.offsetToLineNumber((CharSequence)str, (int)offset) + 1;
        return "(line: " + line + ")";
    }

    static {
        CARET_MARKER = CARET_MARKER;
        BEGIN_MARKER = BEGIN_MARKER;
        END_MARKER = END_MARKER;
    }
}

