/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.git4idea.ssh;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.ArrayUtilRt;
import com.trilead.ssh2.Connection;
import com.trilead.ssh2.HTTPProxyData;
import com.trilead.ssh2.InteractiveCallback;
import com.trilead.ssh2.KnownHosts;
import com.trilead.ssh2.ProxyData;
import com.trilead.ssh2.ServerHostKeyVerifier;
import com.trilead.ssh2.Session;
import com.trilead.ssh2.crypto.PEMDecoder;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Semaphore;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.git4idea.GitExternalApp;
import org.jetbrains.git4idea.ssh.GitSSHXmlRpcClient;
import org.jetbrains.git4idea.ssh.SSHConfig;
import org.jetbrains.git4idea.ssh.SSHMainBundle;

public class SSHMain
implements GitExternalApp {
    private final Semaphore myForwardCompleted = new Semaphore(0);
    private final SSHConfig.Host myHost;
    private final int myHandlerNo;
    private final GitSSHXmlRpcClient myXmlRpcClient;
    private final String myCommand;
    private int myExitCode = 0;
    private String myLastError = "";
    private Exception myErrorCause;
    @NonNls
    private static final String knownHostPath = SSHConfig.USER_HOME + "/.ssh/known_hosts";
    @NonNls
    private static final String idDSAPath = SSHConfig.USER_HOME + "/.ssh/id_dsa";
    @NonNls
    private static final String idRSAPath = SSHConfig.USER_HOME + "/.ssh/id_rsa";
    private final KnownHosts database = new KnownHosts();
    private static final int BUFFER_SIZE = 16384;
    @NonNls
    public static final String PUBLIC_KEY_METHOD = "publickey";
    @NonNls
    public static final String KEYBOARD_INTERACTIVE_METHOD = "keyboard-interactive";
    @NonNls
    public static final String PASSWORD_METHOD = "password";
    @NonNls
    public static final String SSH_RSA_ALGORITHM = "ssh-rsa";
    @NonNls
    public static final String SSH_DSS_ALGORITHM = "ssh-dss";

    private SSHMain(String host, String username, Integer port, String command) throws IOException {
        SSHConfig config = SSHConfig.load();
        this.myHost = config.lookup(username, host, port);
        this.myHandlerNo = Integer.parseInt(System.getenv("GIT4IDEA_SSH_HANDLER"));
        int xmlRpcPort = Integer.parseInt(System.getenv("GIT4IDEA_SSH_PORT"));
        this.myXmlRpcClient = new GitSSHXmlRpcClient(xmlRpcPort, this.myHost.isBatchMode());
        this.myCommand = command;
    }

    public static void main(String[] args) {
        try {
            SSHMain app = SSHMain.parseArguments(args);
            app.start();
            System.exit(app.myExitCode);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() throws IOException, InterruptedException {
        Connection c = new Connection(this.myHost.getHostName(), this.myHost.getPort());
        try {
            this.configureKnownHosts(c);
            boolean useHttpProxy = Boolean.valueOf(System.getenv("GIT4IDEA_SSH_USE_PROXY"));
            if (useHttpProxy) {
                String proxyHost = System.getenv("GIT4IDEA_SSH_PROXY_HOST");
                Integer proxyPort = Integer.valueOf(System.getenv("GIT4IDEA_SSH_PROXY_PORT"));
                boolean proxyAuthentication = Boolean.valueOf(System.getenv("GIT4IDEA_SSH_PROXY_AUTHENTICATION"));
                String proxyUser = null;
                String proxyPassword = null;
                if (proxyAuthentication) {
                    proxyUser = System.getenv("GIT4IDEA_SSH_PROXY_USER");
                    proxyPassword = System.getenv("GIT4IDEA_SSH_PROXY_PASSWORD");
                }
                c.setProxyData((ProxyData)new HTTPProxyData(proxyHost, proxyPort.intValue(), proxyUser, proxyPassword));
            }
            c.connect((ServerHostKeyVerifier)new HostKeyVerifier());
            this.authenticate(c);
            Session s = c.openSession();
            try {
                s.execCommand(this.myCommand);
                this.forward("stdin", s.getStdin(), System.in, false);
                this.forward("stdout", System.out, s.getStdout(), true);
                this.forward("stderr", System.err, s.getStderr(), true);
                this.myForwardCompleted.acquire(2);
                s.waitForCondition(32, Long.MAX_VALUE);
                Integer exitStatus = s.getExitStatus();
                if (exitStatus == null) {
                    exitStatus = 1;
                }
                System.exit(exitStatus == 0 ? this.myExitCode : exitStatus);
            }
            finally {
                s.close();
            }
        }
        finally {
            c.close();
        }
    }

    private void authenticate(Connection c) throws IOException {
        LinkedList<String> methods = new LinkedList<String>(this.myHost.getPreferredMethods());
        String lastSuccessfulMethod = this.myXmlRpcClient.getLastSuccessful(this.myHandlerNo, this.getUserHostString());
        if (lastSuccessfulMethod != null && lastSuccessfulMethod.length() > 0 && methods.remove(lastSuccessfulMethod)) {
            methods.addFirst(lastSuccessfulMethod);
        }
        block0: for (String method : methods) {
            String password;
            if (c.isAuthenticationComplete()) {
                return;
            }
            if (PUBLIC_KEY_METHOD.equals(method)) {
                if (!this.myHost.supportsPubkeyAuthentication() || !c.isAuthMethodAvailable(this.myHost.getUser(), PUBLIC_KEY_METHOD)) continue;
                File key = this.myHost.getIdentityFile();
                if (key == null) {
                    for (String a : this.myHost.getHostKeyAlgorithms()) {
                        if (!(SSH_RSA_ALGORITHM.equals(a) ? this.tryPublicKey(c, idRSAPath) : SSH_DSS_ALGORITHM.equals(a) && this.tryPublicKey(c, idDSAPath))) continue;
                        return;
                    }
                    continue;
                }
                if (!this.tryPublicKey(c, key.getPath())) continue;
                return;
            }
            if (KEYBOARD_INTERACTIVE_METHOD.equals(method)) {
                if (!c.isAuthMethodAvailable(this.myHost.getUser(), KEYBOARD_INTERACTIVE_METHOD)) continue;
                InteractiveSupport interactiveSupport = new InteractiveSupport();
                for (int i = this.myHost.getNumberOfPasswordPrompts(); i > 0; --i) {
                    if (c.isAuthenticationComplete()) {
                        return;
                    }
                    if (c.authenticateWithKeyboardInteractive(this.myHost.getUser(), (InteractiveCallback)interactiveSupport)) {
                        this.myLastError = "";
                        this.myXmlRpcClient.setLastSuccessful(this.myHandlerNo, this.getUserHostString(), KEYBOARD_INTERACTIVE_METHOD, "");
                        return;
                    }
                    this.myLastError = SSHMainBundle.getString("sshmain.keyboard.interactive.failed");
                    if (interactiveSupport.myPromptCount != 0 && !interactiveSupport.myCancelled) continue;
                    this.myLastError = "";
                    continue block0;
                }
                continue;
            }
            if (!PASSWORD_METHOD.equals(method) || !this.myHost.supportsPasswordAuthentication() || !c.isAuthMethodAvailable(this.myHost.getUser(), PASSWORD_METHOD)) continue;
            for (int i = 0; i < this.myHost.getNumberOfPasswordPrompts() && (password = this.myXmlRpcClient.askPassword(this.myHandlerNo, this.getUserHostString(), i != 0, this.myLastError)) != null; ++i) {
                if (c.authenticateWithPassword(this.myHost.getUser(), password)) {
                    this.myLastError = "";
                    this.myXmlRpcClient.setLastSuccessful(this.myHandlerNo, this.getUserHostString(), PASSWORD_METHOD, "");
                    return;
                }
                this.myLastError = SSHMainBundle.getString("sshmain.password.failed");
            }
        }
        this.myXmlRpcClient.setLastSuccessful(this.myHandlerNo, this.getUserHostString(), "", this.myLastError);
        throw new IOException("Authentication failed: " + this.myLastError, this.myErrorCause);
    }

    private String getUserHostString() {
        int port = this.myHost.getPort();
        return this.myHost.getUser() + "@" + this.myHost.getHostName() + (port == 22 ? "" : ":" + port);
    }

    private boolean tryPublicKey(Connection c, String keyPath) {
        try {
            File file = new File(keyPath);
            if (file.exists()) {
                String passphrase = null;
                char[] text = FileUtilRt.loadFileText((File)file);
                if (SSHMain.isEncryptedKey(text)) {
                    int i;
                    for (i = 0; i < this.myHost.getNumberOfPasswordPrompts(); ++i) {
                        passphrase = this.myXmlRpcClient.askPassphrase(this.myHandlerNo, this.getUserHostString(), keyPath, i != 0, this.myLastError);
                        if (passphrase == null) {
                            return false;
                        }
                        try {
                            PEMDecoder.decode((char[])text, (String)passphrase);
                            this.myLastError = "";
                            break;
                        }
                        catch (IOException e) {
                            this.myLastError = SSHMainBundle.message("sshmain.invalidpassphrase", keyPath);
                            this.myErrorCause = e;
                            continue;
                        }
                    }
                    if (i == this.myHost.getNumberOfPasswordPrompts()) {
                        this.myLastError = SSHMainBundle.message("sshmain.too.mush.passphrase.guesses", keyPath, this.myHost.getNumberOfPasswordPrompts());
                        return false;
                    }
                }
                if (c.authenticateWithPublicKey(this.myHost.getUser(), text, passphrase)) {
                    this.myLastError = "";
                    this.myXmlRpcClient.setLastSuccessful(this.myHandlerNo, this.getUserHostString(), PUBLIC_KEY_METHOD, "");
                    return true;
                }
                this.myLastError = passphrase != null ? SSHMainBundle.message("sshmain.pk.authenitication.failed", keyPath) : "";
            }
            return false;
        }
        catch (Exception e) {
            this.myErrorCause = e;
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isEncryptedKey(char[] text) throws IOException {
        BufferedReader in = new BufferedReader(new CharArrayReader(text));
        try {
            String line;
            while ((line = in.readLine()) != null) {
                if (line.startsWith("Proc-Type: ") && line.contains("ENCRYPTED")) {
                    boolean bl = true;
                    return bl;
                }
                if (line.length() != 0) continue;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            in.close();
        }
    }

    private void forward(final @NonNls String name, final OutputStream out, final InputStream in, final boolean releaseSemaphore) {
        Runnable action = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                byte[] buffer = new byte[16384];
                try {
                    try {
                        try {
                            int rc;
                            while ((rc = in.read(buffer)) != -1) {
                                out.write(buffer, 0, rc);
                            }
                        }
                        finally {
                            out.close();
                        }
                    }
                    finally {
                        in.close();
                    }
                }
                catch (IOException e) {
                    System.err.println(SSHMainBundle.message("sshmain.forwarding.failed", name, e.getMessage()));
                    e.printStackTrace();
                    SSHMain.this.myExitCode = 1;
                    if (releaseSemaphore) {
                        SSHMain.this.myForwardCompleted.release(1);
                    }
                }
                finally {
                    if (releaseSemaphore) {
                        SSHMain.this.myForwardCompleted.release(1);
                    }
                }
            }
        };
        Thread t = new Thread(action, "Forwarding " + name);
        t.setDaemon(true);
        t.start();
    }

    private void configureKnownHosts(Connection c) throws IOException {
        File knownHostFile = new File(knownHostPath);
        if (knownHostFile.exists()) {
            this.database.addHostkeys(knownHostFile);
        }
        List<String> algorithms = this.myHost.getHostKeyAlgorithms();
        c.setServerHostKeyAlgorithms(ArrayUtilRt.toStringArray(algorithms));
    }

    private static SSHMain parseArguments(String[] args) throws IOException {
        String user;
        if (args.length != 2 && args.length != 4) {
            System.err.println(SSHMainBundle.message("sshmain.invalid.amount.of.arguments", Arrays.asList(args)));
            System.exit(1);
        }
        int i = 0;
        Integer port = null;
        if ("-p".equals(args[i])) {
            int n = ++i;
            port = Integer.parseInt(args[n]);
        }
        int n = ++i;
        ++i;
        String host = args[n];
        int atIndex = host.lastIndexOf(64);
        if (atIndex == -1) {
            user = null;
        } else {
            user = host.substring(0, atIndex);
            host = host.substring(atIndex + 1);
        }
        String command = args[i];
        return new SSHMain(host, user, port, command);
    }

    public String toString() {
        return String.format("SSHMain{myHost=%s, myHandlerNo=%d, myCommand='%s', myExitCode=%d, myLastError='%s'}", this.myHost, this.myHandlerNo, this.myCommand, this.myExitCode, this.myLastError);
    }

    private static void log(String s) {
        System.err.println(s);
    }

    private class HostKeyVerifier
    implements ServerHostKeyVerifier {
        private HostKeyVerifier() {
        }

        public boolean verifyServerHostKey(String hostname, int port, String serverHostKeyAlgorithm, byte[] serverHostKey) throws Exception {
            try {
                String s = System.getenv("GIT4IDEA_SSH_IGNORE_KNOWN_HOSTS");
                if (s != null && Boolean.parseBoolean(s)) {
                    return true;
                }
            }
            catch (Exception s) {
                // empty catch block
            }
            try {
                boolean isNew;
                int result = SSHMain.this.database.verifyHostkey(hostname, serverHostKeyAlgorithm, serverHostKey);
                switch (result) {
                    case 0: {
                        return true;
                    }
                    case 1: {
                        isNew = true;
                        break;
                    }
                    case 2: {
                        isNew = false;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown verification result: " + result);
                    }
                }
                String fingerprint = KnownHosts.createHexFingerprint((String)serverHostKeyAlgorithm, (byte[])serverHostKey);
                boolean keyCheck = SSHMain.this.myXmlRpcClient.verifyServerHostKey(SSHMain.this.myHandlerNo, hostname, port, serverHostKeyAlgorithm, fingerprint, isNew);
                if (keyCheck) {
                    String hashedHostname = KnownHosts.createHashedHostname((String)hostname);
                    SSHMain.this.database.addHostkey(new String[]{hashedHostname}, serverHostKeyAlgorithm, serverHostKey);
                    try {
                        KnownHosts.addHostkeyToFile((File)new File(knownHostPath), (String[])new String[]{hashedHostname}, (String)serverHostKeyAlgorithm, (byte[])serverHostKey);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return true;
                }
                System.err.println(SSHMainBundle.message("sshmain.invald.host.key", serverHostKeyAlgorithm, fingerprint));
                return false;
            }
            catch (Throwable t) {
                System.err.println(SSHMainBundle.message("sshmain.failed.to.verify.key", t.getMessage()));
                t.printStackTrace();
                return false;
            }
        }
    }

    class InteractiveSupport
    implements InteractiveCallback {
        int myPromptCount = 0;
        boolean myCancelled;

        InteractiveSupport() {
        }

        @Nullable
        public String[] replyToChallenge(String name, String instruction, int numPrompts, String[] prompt, boolean[] echo) throws Exception {
            if (numPrompts == 0) {
                return ArrayUtilRt.EMPTY_STRING_ARRAY;
            }
            ++this.myPromptCount;
            Vector<String> vPrompts = new Vector<String>(prompt.length);
            Collections.addAll(vPrompts, prompt);
            Vector<Boolean> vEcho = new Vector<Boolean>(prompt.length);
            for (boolean e : echo) {
                vEcho.add(e);
            }
            Vector<String> result = SSHMain.this.myXmlRpcClient.replyToChallenge(SSHMain.this.myHandlerNo, SSHMain.this.getUserHostString(), name, instruction, numPrompts, vPrompts, vEcho, SSHMain.this.myLastError);
            if (result == null) {
                this.myCancelled = true;
                Object[] rc = new String[numPrompts];
                Arrays.fill(rc, "");
                return rc;
            }
            return ArrayUtilRt.toStringArray(result);
        }
    }
}

