/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.devices;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;

public enum Abi {
    ARMEABI("armeabi", "ARM", "arm"),
    ARMEABI_V7A("armeabi-v7a", "ARM", "arm", "cortex-a8"),
    ARM64_V8A("arm64-v8a", "ARM", "arm64"),
    X86("x86", "Intel Atom", "x86"),
    X86_64("x86_64", "Intel Atom", "x86_64"),
    MIPS("mips", "MIPS", "mips"),
    MIPS64("mips64", "MIPS", "mips64");

    @NonNull
    private final String mAbi;
    @NonNull
    private final String mCpuArch;
    @Nullable
    private final String mCpuModel;
    @NonNull
    private final String mDisplayName;

    private Abi(@NonNull String abi, String displayName, String cpuArch) {
        this(abi, displayName, cpuArch, null);
    }

    private Abi(@NonNull String abi, @Nullable String displayName, String cpuArch, String cpuModel) {
        this.mAbi = abi;
        this.mDisplayName = displayName;
        this.mCpuArch = cpuArch;
        this.mCpuModel = cpuModel;
    }

    @Nullable
    public static Abi getEnum(@NonNull String abi) {
        for (Abi a : Abi.values()) {
            if (!a.mAbi.equals(abi)) continue;
            return a;
        }
        return null;
    }

    @NonNull
    public String toString() {
        return this.mAbi;
    }

    @NonNull
    public String getCpuArch() {
        return this.mCpuArch;
    }

    @Nullable
    public String getCpuModel() {
        return this.mCpuModel;
    }

    @NonNull
    public String getDisplayName() {
        return this.mDisplayName;
    }
}

