/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.devices;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;

public class Storage {
    private long mNoBytes;

    public Storage(long amount, Unit unit) {
        this.mNoBytes = amount * unit.getNumberOfBytes();
    }

    public Storage(long amount) {
        this(amount, Unit.B);
    }

    public long getSize() {
        return this.getSizeAsUnit(Unit.B);
    }

    @NonNull
    public Storage deepCopy() {
        return new Storage(this.mNoBytes);
    }

    public long getSizeAsUnit(@NonNull Unit unit) {
        return this.mNoBytes / unit.getNumberOfBytes();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Storage)) {
            return false;
        }
        Storage s = (Storage)o;
        return s.getSize() == this.getSize();
    }

    public int hashCode() {
        int result = 17;
        return 31 * result + (int)(this.mNoBytes ^ this.mNoBytes >>> 32);
    }

    @NonNull
    public Unit getAppropriateUnits() {
        Unit optimalUnit = Unit.B;
        for (Unit unit : Unit.values()) {
            if (this.mNoBytes % unit.getNumberOfBytes() != 0L) break;
            optimalUnit = unit;
        }
        return optimalUnit;
    }

    public String toString() {
        Unit u = this.getAppropriateUnits();
        return String.format("%d %s", new Object[]{this.getSizeAsUnit(u), u});
    }

    public static enum Unit {
        B("B", "B", 1L),
        KiB("KiB", "KB", 1024L),
        MiB("MiB", "MB", 0x100000L),
        GiB("GiB", "GB", 0x40000000L),
        TiB("TiB", "TB", 0x10000000000L);

        @NonNull
        private String mValue;
        @NonNull
        private String mDisplayValue;
        private long mNoBytes;

        private Unit(String val, String displayVal, long noBytes) {
            this.mValue = val;
            this.mDisplayValue = displayVal;
            this.mNoBytes = noBytes;
        }

        @Nullable
        public static Unit getEnum(@NonNull String val) {
            for (Unit v : Unit.values()) {
                if (!v.mValue.equals(val)) continue;
                return v;
            }
            return null;
        }

        public long getNumberOfBytes() {
            return this.mNoBytes;
        }

        public String toString() {
            return this.mValue;
        }

        public String getDisplayValue() {
            return this.mDisplayValue;
        }
    }
}

