/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.keychain;

import com.intellij.openapi.util.PasswordUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.keychain.Credentials;
import org.jetbrains.keychain.CredentialsStore;
import org.jetbrains.keychain.CredentialsStoreKt;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"/\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\f\u0015\u0001Q!\u0001\u0005\u0002\u000b\u0005!\u0011!B\u0001\t\u000f\u0015\tA1\u0001\u0007\u00013\u0005A\n!)\u0004\n\u0007!\tQ\"\u0001M\u0002#\u000e\t\u0001BA\u0013\u0005\t\u0005AI!D\u0001\u0019\u000b\u0015zAa\u0003E\u0006\u001b\ta\t\u0001G\u0002\u001a\t!1QB\u0001G\u00011\u001bIB\u0001C\u0004\u000e\u00051\u0005\u0001TB\u0013\t\t-Ay!D\u0001\u0019\u000be\u0019\u0001BB\u0007\u00021\u001b)#\u0003B\u0006\t\u00115\t\u0001$B\r\u0005\u0011\u0019i!\u0001$\u0001\u0019\u000ee\u0019\u0001RA\u0007\u00021\rIB\u0001C\u0004\u000e\u00051\u0005\u0001TB\u0015\t\t\u0005c\u0002RA\u0007\u0003\u0019\u0003A2!U\u0002\u0002\u000b\u0001Is\u0001B!\u001d\u0011\u000fi\u0011\u0001\u0007\u0003R\u0007\u0005)\u0001!K\u0004\u0005\u0003\"A\u0011!D\u0001\u0019\u0004E\u001b\u0011!\u0002\u0001"}, strings={"Lorg/jetbrains/keychain/FileCredentialsStore;", "Lorg/jetbrains/keychain/CredentialsStore;", "storeFile", "Ljava/io/File;", "(Ljava/io/File;)V", "credentials", "Lorg/jetbrains/keychain/Credentials;", "dataLoaded", "", "ensureLoaded", "", "get", "host", "", "sshKeyFile", "reset", "save"}, moduleName="settings-repository")
public final class FileCredentialsStore
implements CredentialsStore {
    private Credentials credentials;
    private boolean dataLoaded;
    private final File storeFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void ensureLoaded() {
        if (this.dataLoaded) {
            return;
        }
        this.dataLoaded = true;
        if (this.storeFile.exists()) {
            try {
                boolean hasErrors = true;
                DataInputStream in = new DataInputStream(ByteStreamsKt.buffered$default((InputStream)new FileInputStream(this.storeFile), (int)0, (int)1));
                try {
                    this.credentials = new Credentials(PasswordUtil.decodePassword((String)IOUtil.readString((DataInput)in)), PasswordUtil.decodePassword((String)IOUtil.readString((DataInput)in)));
                    hasErrors = false;
                }
                finally {
                    if (hasErrors) {
                        this.storeFile.delete();
                    }
                    in.close();
                }
            }
            catch (IOException e) {
                CredentialsStoreKt.getLOG().error((Throwable)e);
            }
        }
    }

    @Override
    @Nullable
    public Credentials get(@Nullable String host, @Nullable String sshKeyFile) {
        this.ensureLoaded();
        return this.credentials;
    }

    @Override
    public void reset(@NotNull String host) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        if (this.credentials != null) {
            this.dataLoaded = true;
            this.storeFile.delete();
            Credentials credentials = this.credentials;
            if (credentials == null) {
                Intrinsics.throwNpe();
            }
            this.credentials = new Credentials(credentials.getId(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(@Nullable String host, @NotNull Credentials credentials, @Nullable String sshKeyFile) {
        Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
        if (credentials.equals(this.credentials)) {
            return;
        }
        this.credentials = credentials;
        try {
            FileUtil.createParentDirs((File)this.storeFile);
            DataOutputStream out = new DataOutputStream(ByteStreamsKt.buffered$default((OutputStream)new FileOutputStream(this.storeFile), (int)0, (int)1));
            try {
                IOUtil.writeString((String)PasswordUtil.encodePassword((String)credentials.getId()), (DataOutput)out);
                IOUtil.writeString((String)PasswordUtil.encodePassword((String)credentials.getToken()), (DataOutput)out);
            }
            finally {
                out.close();
            }
        }
        catch (IOException e) {
            CredentialsStoreKt.getLOG().error((Throwable)e);
        }
    }

    public FileCredentialsStore(@NotNull File storeFile) {
        Intrinsics.checkParameterIsNotNull((Object)storeFile, (String)"storeFile");
        this.storeFile = storeFile;
        this.dataLoaded = !this.storeFile.exists();
    }
}

