/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.util.Arrays;

public class VariableGridLayout
implements LayoutManager2,
Serializable {
    public static final int FIXED_NUM_ROWS = 1;
    public static final int FIXED_NUM_COLUMNS = 2;
    private int mode;
    private int size;
    private int hgap;
    private int vgap;
    private boolean takeSizesIntoAccount;
    private Insets distanceToBorders;
    private transient int nrows = -1;
    private transient int ncols = -1;
    private transient int[] minimum_row_heights = null;
    private transient int[] minimum_col_widths = null;
    private transient int[] row_heights = null;
    private transient int[] col_widths = null;
    private transient int[] maximum_row_heights = null;
    private transient int[] maximum_col_widths = null;

    public VariableGridLayout(int n, int n2, int n3, int n4, boolean bl, Insets insets) {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("illegal mode; value is " + n);
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("size cannot be zero or less; value is " + n2);
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("hgap cannot be negative; value is " + n3);
        }
        if (n4 < 0) {
            throw new IllegalArgumentException("vgap cannot be negative; value is " + n4);
        }
        this.mode = n;
        this.size = n2;
        this.hgap = n3;
        this.vgap = n4;
        this.takeSizesIntoAccount = bl;
        this.distanceToBorders = (Insets)insets.clone();
    }

    public VariableGridLayout(int n, int n2, int n3, int n4, boolean bl) {
        this(n, n2, n3, n4, bl, new Insets(0, 0, 0, 0));
    }

    public VariableGridLayout(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, false, new Insets(0, 0, 0, 0));
    }

    public VariableGridLayout(int n, int n2) {
        this(n, n2, 0, 0, false, new Insets(0, 0, 0, 0));
    }

    public VariableGridLayout() {
        this(1, 1, 0, 0, false, new Insets(0, 0, 0, 0));
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        return this.getLayoutSize(container, LayoutSize.PREFERRED);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.getLayoutSize(container, LayoutSize.MINIMUM);
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return this.getLayoutSize(container, LayoutSize.MAXIMUM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n;
            this.update(container);
            int n2 = container.getComponentCount();
            if (n2 == 0) {
                return;
            }
            int n3 = 0;
            Arrays.fill(this.row_heights, 0);
            Arrays.fill(this.col_widths, 0);
            if (this.takeSizesIntoAccount) {
                Arrays.fill(this.minimum_row_heights, 0);
                Arrays.fill(this.minimum_col_widths, 0);
                Arrays.fill(this.maximum_row_heights, Integer.MAX_VALUE);
                Arrays.fill(this.maximum_col_widths, Integer.MAX_VALUE);
            }
            int n4 = 0;
            for (n = 0; n < this.nrows; ++n) {
                for (int i = 0; i < this.ncols && n4 < n2; ++i, ++n4) {
                    Component component = container.getComponent(n4);
                    Dimension dimension = component.getPreferredSize();
                    this.row_heights[n] = Math.max(this.row_heights[n], dimension.height);
                    this.col_widths[i] = Math.max(this.col_widths[i], dimension.width);
                    if (!this.takeSizesIntoAccount) continue;
                    dimension = component.getMinimumSize();
                    this.minimum_row_heights[n] = Math.max(this.minimum_row_heights[n], dimension.height);
                    this.minimum_col_widths[i] = Math.max(this.minimum_col_widths[i], dimension.width);
                    dimension = component.getMaximumSize();
                    this.maximum_row_heights[n] = Math.min(this.maximum_row_heights[n], dimension.height);
                    this.maximum_col_widths[i] = Math.min(this.maximum_col_widths[i], dimension.width);
                }
                if (this.takeSizesIntoAccount) {
                    if (this.minimum_row_heights[n] >= this.maximum_row_heights[n]) {
                        this.maximum_row_heights[n] = this.minimum_row_heights[n];
                        this.row_heights[n] = this.minimum_row_heights[n];
                    } else if (this.row_heights[n] < this.minimum_row_heights[n]) {
                        this.row_heights[n] = this.minimum_row_heights[n];
                    } else if (this.row_heights[n] > this.maximum_row_heights[n]) {
                        this.row_heights[n] = this.maximum_row_heights[n];
                    }
                }
                n3 += this.row_heights[n];
            }
            n = 0;
            for (n4 = 0; n4 < this.ncols; ++n4) {
                if (this.takeSizesIntoAccount) {
                    if (this.minimum_col_widths[n4] >= this.maximum_col_widths[n4]) {
                        this.maximum_col_widths[n4] = this.minimum_col_widths[n4];
                        this.col_widths[n4] = this.minimum_col_widths[n4];
                    } else if (this.col_widths[n4] < this.minimum_col_widths[n4]) {
                        this.col_widths[n4] = this.minimum_col_widths[n4];
                    } else if (this.col_widths[n4] > this.maximum_col_widths[n4]) {
                        this.col_widths[n4] = this.maximum_col_widths[n4];
                    }
                }
                n += this.col_widths[n4];
            }
            Dimension dimension = container.getSize();
            Insets insets = container.getInsets();
            int n5 = dimension.height - insets.top - insets.bottom - (this.nrows - 1) * this.vgap - this.distanceToBorders.top - this.distanceToBorders.bottom;
            int n6 = dimension.width - insets.left - insets.right - (this.ncols - 1) * this.hgap - this.distanceToBorders.left - this.distanceToBorders.right;
            this.redistributeSpace(n3, n5, this.takeSizesIntoAccount, this.nrows, this.row_heights, this.minimum_row_heights, this.maximum_row_heights);
            this.redistributeSpace(n, n6, this.takeSizesIntoAccount, this.ncols, this.col_widths, this.minimum_col_widths, this.maximum_col_widths);
            int n7 = insets.top + this.distanceToBorders.top;
            int n8 = 0;
            for (int i = 0; i < this.nrows; ++i) {
                int n9 = 0;
                int n10 = insets.left + this.distanceToBorders.left;
                while (n9 < this.ncols) {
                    if (n8 < n2) {
                        Component component = container.getComponent(n8);
                        Dimension dimension2 = component.getMaximumSize();
                        int n11 = this.col_widths[n9];
                        int n12 = this.row_heights[i];
                        int n13 = 0;
                        int n14 = 0;
                        if (n11 > dimension2.width) {
                            n13 = (int)((float)(n11 - dimension2.width) * component.getAlignmentX());
                            n11 = dimension2.width;
                        }
                        if (n12 > dimension2.height) {
                            n14 = (int)((float)(n12 - dimension2.height) * component.getAlignmentY());
                            n12 = dimension2.height;
                        }
                        component.setBounds(n10 + n13, n7 + n14, n11, n12);
                    }
                    n10 += this.col_widths[n9] + this.hgap;
                    ++n9;
                    ++n8;
                }
                n7 += this.row_heights[i] + this.vgap;
            }
        }
    }

    @Override
    public void invalidateLayout(Container container) {
    }

    public String toString() {
        return this.getClass().getName() + "[mode=" + (1 == this.mode ? "FIXED_NUM_ROWS" : (2 == this.mode ? "FIXED_NUM_COLUMNS" : "UNKNOWN(" + this.mode + ")")) + ",size=" + this.size + ",hgap=" + this.hgap + ",vgap=" + this.vgap + ",takeSizesIntoAccount=" + this.takeSizesIntoAccount + ",distanceToBorders=" + this.distanceToBorders + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension getLayoutSize(Container container, LayoutSize layoutSize) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n;
            int n2;
            int n3;
            this.update(container);
            int n4 = container.getComponentCount();
            long l = 0L;
            long l2 = 0L;
            int n5 = 0;
            for (n3 = 0; n3 < this.nrows; ++n3) {
                n2 = 0;
                n = 0;
                while (n < this.ncols) {
                    if (n5 < n4) {
                        switch (layoutSize) {
                            case MINIMUM: {
                                n2 = Math.max(n2, container.getComponent((int)n5).getMinimumSize().height);
                                break;
                            }
                            case MAXIMUM: {
                                n2 = Math.max(n2, container.getComponent((int)n5).getMaximumSize().height);
                                break;
                            }
                            case PREFERRED: {
                                n2 = Math.max(n2, container.getComponent((int)n5).getPreferredSize().height);
                                break;
                            }
                            default: {
                                throw new InternalError("Missing case branch for LayoutSize: " + (Object)((Object)layoutSize));
                            }
                        }
                    }
                    ++n;
                    ++n5;
                }
                l += (long)n2;
            }
            for (n3 = 0; n3 < this.ncols; ++n3) {
                n5 = 0;
                block16: for (n2 = 0; n2 < this.nrows; ++n2) {
                    n = n2 * this.ncols + n3;
                    if (n >= n4) continue;
                    switch (layoutSize) {
                        case MINIMUM: {
                            n5 = Math.max(n5, container.getComponent((int)n).getMinimumSize().width);
                            continue block16;
                        }
                        case MAXIMUM: {
                            n5 = Math.max(n5, container.getComponent((int)n).getMaximumSize().width);
                            continue block16;
                        }
                        case PREFERRED: {
                            n5 = Math.max(n5, container.getComponent((int)n).getPreferredSize().width);
                            continue block16;
                        }
                        default: {
                            throw new InternalError("Missing case branch for LayoutSize: " + (Object)((Object)layoutSize));
                        }
                    }
                }
                l2 += (long)n5;
            }
            Insets insets = container.getInsets();
            l += (long)(insets.top + insets.bottom + (this.nrows - 1) * this.vgap + this.distanceToBorders.top + this.distanceToBorders.bottom);
            if ((l2 += (long)(insets.left + insets.right + (this.ncols - 1) * this.hgap + this.distanceToBorders.left + this.distanceToBorders.right)) > Integer.MAX_VALUE) {
                l2 = Integer.MAX_VALUE;
            }
            if (l > Integer.MAX_VALUE) {
                l = Integer.MAX_VALUE;
            }
            return new Dimension((int)l2, (int)l);
        }
    }

    private void update(Container container) {
        int n = container.getComponentCount();
        int n2 = this.nrows;
        int n3 = this.ncols;
        if (this.mode == 1) {
            this.nrows = this.size;
            this.ncols = (n + this.nrows - 1) / this.nrows;
        } else {
            this.ncols = this.size;
            this.nrows = (n + this.ncols - 1) / this.ncols;
        }
        if (n2 != this.nrows) {
            this.row_heights = new int[this.nrows];
            if (this.takeSizesIntoAccount) {
                this.minimum_row_heights = new int[this.nrows];
                this.maximum_row_heights = new int[this.nrows];
            }
        }
        if (n3 != this.ncols) {
            this.col_widths = new int[this.ncols];
            if (this.takeSizesIntoAccount) {
                this.minimum_col_widths = new int[this.ncols];
                this.maximum_col_widths = new int[this.ncols];
            }
        }
    }

    private void redistributeSpace(int n, int n2, boolean bl, int n3, int[] nArray, int[] nArray2, int[] nArray3) {
        block13: {
            if (n == n2) break block13;
            if (bl) {
                boolean bl2 = n < n2;
                n2 = (n2 - n) * (bl2 ? 1 : -1);
                while (n2 != 0) {
                    int n4;
                    int n5;
                    int n6 = 0;
                    int n7 = 0;
                    for (n5 = 0; n5 < n3; ++n5) {
                        if ((!bl2 || nArray[n5] >= nArray3[n5]) && (bl2 || nArray[n5] <= nArray2[n5])) continue;
                        ++n6;
                        n7 += nArray[n5];
                    }
                    n5 = 1;
                    if (0 == n6) {
                        for (n4 = 0; n4 < n3; ++n4) {
                            n7 += nArray[n4];
                        }
                        n5 = 0;
                        n6 = n3;
                    }
                    if (n7 == 0) break;
                    if (n2 < n6) {
                        for (n4 = 0; n4 < n3; ++n4) {
                            if (n2 == 0 || n5 != 0 && (n5 == 0 || !bl2 || nArray[n4] >= nArray3[n4]) && (bl2 || nArray[n4] <= nArray2[n4])) continue;
                            int n8 = n4;
                            nArray[n8] = nArray[n8] + (bl2 ? 1 : -1);
                            if (0 > nArray[n4]) {
                                nArray[n4] = 0;
                            }
                            --n2;
                        }
                        continue;
                    }
                    n4 = 0;
                    for (int i = 0; i < n3; ++i) {
                        int n9 = n5 != 0 ? (bl2 ? nArray3[i] - nArray[i] : nArray[i] - nArray2[i]) : Integer.MAX_VALUE - nArray[i];
                        int n10 = (int)((double)n2 / (double)n7 * (double)nArray[i]);
                        if (n10 <= n9) {
                            int n11 = i;
                            nArray[n11] = nArray[n11] + (bl2 ? n10 : -n10);
                            n4 += bl2 ? n10 : -n10;
                            n2 -= n10;
                        } else {
                            int n12 = i;
                            nArray[n12] = nArray[n12] + (bl2 ? n9 : -n9);
                            n4 += bl2 ? n9 : -n9;
                            n2 -= n9;
                        }
                        if (0 <= nArray[i]) continue;
                        nArray[i] = 0;
                    }
                    n7 += n4;
                }
            } else {
                double d = (double)n2 / (double)n;
                for (int i = 0; i < n3; ++i) {
                    nArray[i] = (int)((double)nArray[i] * d);
                }
            }
        }
    }

    private static enum LayoutSize {
        MINIMUM,
        MAXIMUM,
        PREFERRED;

    }
}

