/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import org.openstreetmap.josm.actions.AbstractMergeAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.MergeSourceBuildingVisitor;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class MergeSelectionAction
extends AbstractMergeAction {
    public MergeSelectionAction() {
        super(I18n.tr("Merge selection", new Object[0]), "dialogs/mergedown", I18n.tr("Merge the currently selected objects into another layer", new Object[0]), Shortcut.registerShortcut("system:mergeselection", I18n.tr("Edit: {0}", I18n.tr("Merge selection", new Object[0])), 77, 5009), true);
        this.putValue("help", HelpUtil.ht("/Action/MergeSelection"));
    }

    public void mergeSelected() {
        List<Layer> list = LayerListDialog.getInstance().getModel().getPossibleMergeTargets(MergeSelectionAction.getEditLayer());
        if (list.isEmpty()) {
            this.warnNoTargetLayersForSourceLayer(MergeSelectionAction.getEditLayer());
            return;
        }
        Layer layer = this.askTargetLayer(list);
        if (layer == null) {
            return;
        }
        if (MergeSelectionAction.getEditLayer().isUploadDiscouraged() && layer instanceof OsmDataLayer && !((OsmDataLayer)layer).isUploadDiscouraged() && MergeSelectionAction.getEditLayer().data.getAllSelected().size() > 1 && MergeSelectionAction.warnMergingUploadDiscouragedObjects(layer)) {
            return;
        }
        MergeSourceBuildingVisitor mergeSourceBuildingVisitor = new MergeSourceBuildingVisitor(MergeSelectionAction.getEditLayer().data);
        ((OsmDataLayer)layer).mergeFrom(mergeSourceBuildingVisitor.build());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (MergeSelectionAction.getEditLayer() == null || MergeSelectionAction.getEditLayer().data.getAllSelected().isEmpty()) {
            return;
        }
        this.mergeSelected();
    }

    @Override
    protected void updateEnabledState() {
        if (MergeSelectionAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(MergeSelectionAction.getCurrentDataSet().getAllSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty());
    }

    public static final boolean warnMergingUploadDiscouragedObjects(Layer layer) {
        return GuiHelper.warnUser(I18n.tr("Merging too many objects with different upload policies", new Object[0]), "<html>" + I18n.tr("You are about to merge more than 1 object between layers ''{0}'' and ''{1}''.<br /><br /><b>This is not the recommended way of merging such data</b>.<br />You should instead check and merge each object, <b>one by one</b>.<br /><br />Are you sure you want to continue?", MergeSelectionAction.getEditLayer().getName(), layer.getName(), layer.getName()) + "</html>", ImageProvider.get("dialogs", "mergedown"), I18n.tr("Ignore this hint and merge anyway", new Object[0]));
    }
}

