/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.proj;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.proj.Proj;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.tools.I18n;

public class LonLat
implements Proj {
    private double a;

    @Override
    public String getName() {
        return I18n.tr("Lat/lon (Geodetic)", new Object[0]);
    }

    @Override
    public String getProj4Id() {
        return "lonlat";
    }

    @Override
    public void initialize(ProjParameters projParameters) throws ProjectionConfigurationException {
        this.a = projParameters.ellps.a;
    }

    @Override
    public double[] project(double d, double d2) {
        return new double[]{Math.toDegrees(d2) / this.a, Math.toDegrees(d) / this.a};
    }

    @Override
    public double[] invproject(double d, double d2) {
        return new double[]{Math.toRadians(d2 * this.a), Math.toRadians(d * this.a)};
    }

    @Override
    public Bounds getAlgorithmBounds() {
        return new Bounds(-90.0, -180.0, 90.0, 180.0, false);
    }
}

