/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.jruby.Ruby;
import org.jruby.ext.ffi.Factory;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.Platform;
import org.jruby.ext.ffi.Util;

public final class ArrayMemoryIO
extends MemoryIO {
    protected static final ArrayIO IO = ArrayMemoryIO.getArrayIO();
    protected static final int LONG_SIZE = Platform.getPlatform().longSize();
    protected static final int ADDRESS_SIZE = Platform.getPlatform().addressSize();
    protected final Ruby runtime;
    protected final byte[] buffer;
    protected final int offset;
    protected final int length;

    public ArrayMemoryIO(Ruby runtime, byte[] buffer, int offset2, int length2) {
        super(false, 0L);
        this.runtime = runtime;
        this.buffer = buffer;
        this.offset = offset2;
        this.length = length2;
    }

    public ArrayMemoryIO(Ruby runtime, int size2) {
        this(runtime, new byte[size2], 0, size2);
    }

    private final void checkBounds(long off, long len) {
        Util.checkBounds(this.runtime, this.arrayLength(), off, len);
    }

    public final byte[] array() {
        return this.buffer;
    }

    @Override
    public final int arrayOffset() {
        return this.offset;
    }

    @Override
    public final int arrayLength() {
        return this.length;
    }

    private static final ArrayIO getArrayIO() {
        if (ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN)) {
            return Platform.getPlatform().addressSize() == 64 ? ArrayMemoryIO.newBE64ArrayIO() : ArrayMemoryIO.newBE32ArrayIO();
        }
        return Platform.getPlatform().addressSize() == 64 ? ArrayMemoryIO.newLE64ArrayIO() : ArrayMemoryIO.newLE32ArrayIO();
    }

    private static final ArrayIO newBE64ArrayIO() {
        return new BE64ArrayIO();
    }

    private static final ArrayIO newBE32ArrayIO() {
        return new BE32ArrayIO();
    }

    private static final ArrayIO newLE64ArrayIO() {
        return new LE64ArrayIO();
    }

    private static final ArrayIO newLE32ArrayIO() {
        return new LE32ArrayIO();
    }

    protected final int index(long off) {
        return this.offset + (int)off;
    }

    @Override
    public final ByteOrder order() {
        return ByteOrder.nativeOrder();
    }

    @Override
    public ArrayMemoryIO slice(long offset2) {
        this.checkBounds(offset2, 0L);
        return offset2 == 0L ? this : new ArrayMemoryIO(this.runtime, this.array(), this.arrayOffset() + (int)offset2, this.arrayLength() - (int)offset2);
    }

    @Override
    public ArrayMemoryIO slice(long offset2, long size2) {
        this.checkBounds(offset2, size2);
        return offset2 == 0L && size2 == (long)this.length ? this : new ArrayMemoryIO(this.runtime, this.array(), this.arrayOffset() + (int)offset2, (int)size2);
    }

    @Override
    public ArrayMemoryIO dup() {
        ArrayMemoryIO tmp = new ArrayMemoryIO(this.runtime, this.length);
        System.arraycopy(this.array(), this.arrayOffset(), tmp.array(), tmp.arrayOffset(), this.length);
        return tmp;
    }

    @Override
    public ByteBuffer asByteBuffer() {
        return ByteBuffer.wrap(this.buffer, this.offset, this.length).duplicate();
    }

    @Override
    public final MemoryIO getMemoryIO(long offset2) {
        this.checkBounds(offset2, ADDRESS_SIZE >> 3);
        return Factory.getInstance().wrapDirectMemory(this.runtime, this.getAddress(offset2));
    }

    @Override
    public final void putMemoryIO(long offset2, MemoryIO value2) {
        this.checkBounds(offset2, ADDRESS_SIZE >> 3);
        this.putAddress(offset2, value2.address());
    }

    @Override
    public final byte getByte(long offset2) {
        this.checkBounds(offset2, 1L);
        return (byte)(this.buffer[this.index(offset2)] & 0xFF);
    }

    @Override
    public final short getShort(long offset2) {
        this.checkBounds(offset2, 2L);
        return IO.getInt16(this.buffer, this.index(offset2));
    }

    @Override
    public final int getInt(long offset2) {
        this.checkBounds(offset2, 4L);
        return IO.getInt32(this.buffer, this.index(offset2));
    }

    @Override
    public final long getLong(long offset2) {
        this.checkBounds(offset2, 8L);
        return IO.getInt64(this.buffer, this.index(offset2));
    }

    @Override
    public final long getNativeLong(long offset2) {
        return LONG_SIZE == 32 ? (long)this.getInt(offset2) : this.getLong(offset2);
    }

    @Override
    public final float getFloat(long offset2) {
        this.checkBounds(offset2, 4L);
        return IO.getFloat32(this.buffer, this.index(offset2));
    }

    @Override
    public final double getDouble(long offset2) {
        this.checkBounds(offset2, 8L);
        return IO.getFloat64(this.buffer, this.index(offset2));
    }

    @Override
    public final long getAddress(long offset2) {
        this.checkBounds(offset2, ADDRESS_SIZE >> 3);
        return IO.getAddress(this.buffer, this.index(offset2));
    }

    @Override
    public final void putByte(long offset2, byte value2) {
        this.checkBounds(offset2, 1L);
        this.buffer[this.index((long)offset2)] = value2;
    }

    @Override
    public final void putShort(long offset2, short value2) {
        this.checkBounds(offset2, 2L);
        IO.putInt16(this.buffer, this.index(offset2), value2);
    }

    @Override
    public final void putInt(long offset2, int value2) {
        this.checkBounds(offset2, 4L);
        IO.putInt32(this.buffer, this.index(offset2), value2);
    }

    @Override
    public final void putLong(long offset2, long value2) {
        this.checkBounds(offset2, 8L);
        IO.putInt64(this.buffer, this.index(offset2), value2);
    }

    @Override
    public final void putNativeLong(long offset2, long value2) {
        if (LONG_SIZE == 32) {
            this.putInt(offset2, (int)value2);
        } else {
            this.putLong(offset2, value2);
        }
    }

    @Override
    public final void putFloat(long offset2, float value2) {
        this.checkBounds(offset2, 4L);
        IO.putFloat32(this.buffer, this.index(offset2), value2);
    }

    @Override
    public final void putDouble(long offset2, double value2) {
        this.checkBounds(offset2, 8L);
        IO.putFloat64(this.buffer, this.index(offset2), value2);
    }

    @Override
    public final void putAddress(long offset2, long value2) {
        this.checkBounds(offset2, ADDRESS_SIZE >> 3);
        IO.putAddress(this.buffer, this.index(offset2), value2);
    }

    @Override
    public final void get(long offset2, byte[] dst, int off, int len) {
        this.checkBounds(offset2, len);
        System.arraycopy(this.buffer, this.index(offset2), dst, off, len);
    }

    @Override
    public final void put(long offset2, byte[] src, int off, int len) {
        this.checkBounds(offset2, len);
        System.arraycopy(src, off, this.buffer, this.index(offset2), len);
    }

    @Override
    public final void get(long offset2, short[] dst, int off, int len) {
        this.checkBounds(offset2, len << 1);
        int begin2 = this.index(offset2);
        for (int i2 = 0; i2 < len; ++i2) {
            dst[off + i2] = IO.getInt16(this.buffer, begin2 + (i2 << 1));
        }
    }

    @Override
    public final void put(long offset2, short[] src, int off, int len) {
        this.checkBounds(offset2, len << 1);
        int begin2 = this.index(offset2);
        for (int i2 = 0; i2 < len; ++i2) {
            IO.putInt16(this.buffer, begin2 + (i2 << 1), src[off + i2]);
        }
    }

    @Override
    public final void get(long offset2, int[] dst, int off, int len) {
        this.checkBounds(offset2, len << 2);
        int begin2 = this.index(offset2);
        for (int i2 = 0; i2 < len; ++i2) {
            dst[off + i2] = IO.getInt32(this.buffer, begin2 + (i2 << 2));
        }
    }

    @Override
    public final void put(long offset2, int[] src, int off, int len) {
        this.checkBounds(offset2, len << 2);
        int begin2 = this.index(offset2);
        for (int i2 = 0; i2 < len; ++i2) {
            IO.putInt32(this.buffer, begin2 + (i2 << 2), src[off + i2]);
        }
    }

    @Override
    public final void get(long offset2, long[] dst, int off, int len) {
        this.checkBounds(offset2, len << 3);
        int begin2 = this.index(offset2);
        for (int i2 = 0; i2 < len; ++i2) {
            dst[off + i2] = IO.getInt64(this.buffer, begin2 + (i2 << 3));
        }
    }

    @Override
    public final void put(long offset2, long[] src, int off, int len) {
        this.checkBounds(offset2, len << 3);
        int begin2 = this.index(offset2);
        for (int i2 = 0; i2 < len; ++i2) {
            IO.putInt64(this.buffer, begin2 + (i2 << 3), src[off + i2]);
        }
    }

    @Override
    public final void get(long offset2, float[] dst, int off, int len) {
        this.checkBounds(offset2, len << 2);
        int begin2 = this.index(offset2);
        for (int i2 = 0; i2 < len; ++i2) {
            dst[off + i2] = IO.getFloat32(this.buffer, begin2 + (i2 << 2));
        }
    }

    @Override
    public final void put(long offset2, float[] src, int off, int len) {
        this.checkBounds(offset2, len << 2);
        int begin2 = this.index(offset2);
        for (int i2 = 0; i2 < len; ++i2) {
            IO.putFloat32(this.buffer, begin2 + (i2 << 2), src[off + i2]);
        }
    }

    @Override
    public final void get(long offset2, double[] dst, int off, int len) {
        this.checkBounds(offset2, len << 3);
        int begin2 = this.index(offset2);
        for (int i2 = 0; i2 < len; ++i2) {
            dst[off + i2] = IO.getFloat64(this.buffer, begin2 + (i2 << 3));
        }
    }

    @Override
    public final void put(long offset2, double[] src, int off, int len) {
        this.checkBounds(offset2, len << 3);
        int begin2 = this.index(offset2);
        for (int i2 = 0; i2 < len; ++i2) {
            IO.putFloat64(this.buffer, begin2 + (i2 << 3), src[off + i2]);
        }
    }

    @Override
    public final int indexOf(long offset2, byte value2) {
        int off = this.index(offset2);
        for (int i2 = 0; i2 < this.length; ++i2) {
            if (this.buffer[off + i2] != value2) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public final int indexOf(long offset2, byte value2, int maxlen) {
        int off = this.index(offset2);
        for (int i2 = 0; i2 < Math.min(this.length, maxlen); ++i2) {
            if (this.buffer[off + i2] != value2) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public final void setMemory(long offset2, long size2, byte value2) {
        this.checkBounds(offset2, size2);
        Arrays.fill(this.buffer, this.index(offset2), (int)size2, value2);
    }

    @Override
    public final byte[] getZeroTerminatedByteArray(long offset2) {
        this.checkBounds(offset2, 1L);
        int len = this.indexOf(offset2, (byte)0);
        byte[] bytes2 = new byte[len != -1 ? len : this.length - (int)offset2];
        System.arraycopy(this.buffer, this.index(offset2), bytes2, 0, bytes2.length);
        return bytes2;
    }

    @Override
    public final byte[] getZeroTerminatedByteArray(long offset2, int maxlen) {
        this.checkBounds(offset2, 1L);
        int len = this.indexOf(offset2, (byte)0, maxlen);
        byte[] bytes2 = new byte[len != -1 ? len : Math.min(this.length - (int)offset2, maxlen)];
        System.arraycopy(this.buffer, this.index(offset2), bytes2, 0, bytes2.length);
        return bytes2;
    }

    @Override
    public void putZeroTerminatedByteArray(long offset2, byte[] bytes2, int off, int len) {
        this.checkBounds(offset2, len + 1);
        System.arraycopy(bytes2, off, this.buffer, this.index(offset2), len);
        this.buffer[len] = 0;
    }

    public final void clear() {
        Arrays.fill(this.buffer, this.offset, this.length, (byte)0);
    }

    private static final class BE64ArrayIO
    extends BigEndianArrayIO {
        private BE64ArrayIO() {
        }

        @Override
        public final long getAddress(byte[] buffer, int offset2) {
            return this.getInt64(buffer, offset2);
        }

        @Override
        public final void putAddress(byte[] buffer, int offset2, long value2) {
            this.putInt64(buffer, offset2, value2);
        }
    }

    private static final class BE32ArrayIO
    extends BigEndianArrayIO {
        private BE32ArrayIO() {
        }

        @Override
        public final long getAddress(byte[] buffer, int offset2) {
            return (long)this.getInt32(buffer, offset2) & 0xFFFFFFFFL;
        }

        @Override
        public final void putAddress(byte[] buffer, int offset2, long value2) {
            this.putInt32(buffer, offset2, (int)value2);
        }
    }

    private static final class LE64ArrayIO
    extends LittleEndianArrayIO {
        private LE64ArrayIO() {
        }

        @Override
        public final long getAddress(byte[] buffer, int offset2) {
            return this.getInt64(buffer, offset2);
        }

        @Override
        public final void putAddress(byte[] buffer, int offset2, long value2) {
            this.putInt64(buffer, offset2, value2);
        }
    }

    private static final class LE32ArrayIO
    extends LittleEndianArrayIO {
        private LE32ArrayIO() {
        }

        @Override
        public final long getAddress(byte[] buffer, int offset2) {
            return (long)this.getInt32(buffer, offset2) & 0xFFFFFFFFL;
        }

        @Override
        public final void putAddress(byte[] buffer, int offset2, long value2) {
            this.putInt32(buffer, offset2, (int)value2);
        }
    }

    private static abstract class BigEndianArrayIO
    extends ArrayIO {
        private BigEndianArrayIO() {
        }

        @Override
        public short getInt16(byte[] array, int offset2) {
            return (short)((array[offset2 + 0] & 0xFF) << 8 | array[offset2 + 1] & 0xFF);
        }

        @Override
        public int getInt32(byte[] array, int offset2) {
            return (array[offset2 + 0] & 0xFF) << 24 | (array[offset2 + 1] & 0xFF) << 16 | (array[offset2 + 2] & 0xFF) << 8 | (array[offset2 + 3] & 0xFF) << 0;
        }

        @Override
        public long getInt64(byte[] array, int offset2) {
            return ((long)array[offset2 + 0] & 0xFFL) << 56 | ((long)array[offset2 + 1] & 0xFFL) << 48 | ((long)array[offset2 + 2] & 0xFFL) << 40 | ((long)array[offset2 + 3] & 0xFFL) << 32 | ((long)array[offset2 + 4] & 0xFFL) << 24 | ((long)array[offset2 + 5] & 0xFFL) << 16 | ((long)array[offset2 + 6] & 0xFFL) << 8 | ((long)array[offset2 + 7] & 0xFFL) << 0;
        }

        @Override
        public final void putInt16(byte[] buffer, int offset2, int value2) {
            buffer[offset2 + 0] = (byte)(value2 >> 8);
            buffer[offset2 + 1] = (byte)(value2 >> 0);
        }

        @Override
        public final void putInt32(byte[] buffer, int offset2, int value2) {
            buffer[offset2 + 0] = (byte)(value2 >> 24);
            buffer[offset2 + 1] = (byte)(value2 >> 16);
            buffer[offset2 + 2] = (byte)(value2 >> 8);
            buffer[offset2 + 3] = (byte)(value2 >> 0);
        }

        @Override
        public final void putInt64(byte[] buffer, int offset2, long value2) {
            buffer[offset2 + 0] = (byte)(value2 >> 56);
            buffer[offset2 + 1] = (byte)(value2 >> 48);
            buffer[offset2 + 2] = (byte)(value2 >> 40);
            buffer[offset2 + 3] = (byte)(value2 >> 32);
            buffer[offset2 + 4] = (byte)(value2 >> 24);
            buffer[offset2 + 5] = (byte)(value2 >> 16);
            buffer[offset2 + 6] = (byte)(value2 >> 8);
            buffer[offset2 + 7] = (byte)(value2 >> 0);
        }
    }

    private static abstract class LittleEndianArrayIO
    extends ArrayIO {
        private LittleEndianArrayIO() {
        }

        @Override
        public final short getInt16(byte[] array, int offset2) {
            return (short)(array[offset2] & 0xFF | (array[offset2 + 1] & 0xFF) << 8);
        }

        @Override
        public final int getInt32(byte[] array, int offset2) {
            return (array[offset2 + 0] & 0xFF) << 0 | (array[offset2 + 1] & 0xFF) << 8 | (array[offset2 + 2] & 0xFF) << 16 | (array[offset2 + 3] & 0xFF) << 24;
        }

        @Override
        public final long getInt64(byte[] array, int offset2) {
            return ((long)array[offset2 + 0] & 0xFFL) << 0 | ((long)array[offset2 + 1] & 0xFFL) << 8 | ((long)array[offset2 + 2] & 0xFFL) << 16 | ((long)array[offset2 + 3] & 0xFFL) << 24 | ((long)array[offset2 + 4] & 0xFFL) << 32 | ((long)array[offset2 + 5] & 0xFFL) << 40 | ((long)array[offset2 + 6] & 0xFFL) << 48 | ((long)array[offset2 + 7] & 0xFFL) << 56;
        }

        @Override
        public final void putInt16(byte[] buffer, int offset2, int value2) {
            buffer[offset2 + 0] = (byte)(value2 >> 0);
            buffer[offset2 + 1] = (byte)(value2 >> 8);
        }

        @Override
        public final void putInt32(byte[] buffer, int offset2, int value2) {
            buffer[offset2 + 0] = (byte)(value2 >> 0);
            buffer[offset2 + 1] = (byte)(value2 >> 8);
            buffer[offset2 + 2] = (byte)(value2 >> 16);
            buffer[offset2 + 3] = (byte)(value2 >> 24);
        }

        @Override
        public final void putInt64(byte[] buffer, int offset2, long value2) {
            buffer[offset2 + 0] = (byte)(value2 >> 0);
            buffer[offset2 + 1] = (byte)(value2 >> 8);
            buffer[offset2 + 2] = (byte)(value2 >> 16);
            buffer[offset2 + 3] = (byte)(value2 >> 24);
            buffer[offset2 + 4] = (byte)(value2 >> 32);
            buffer[offset2 + 5] = (byte)(value2 >> 40);
            buffer[offset2 + 6] = (byte)(value2 >> 48);
            buffer[offset2 + 7] = (byte)(value2 >> 56);
        }
    }

    protected static abstract class ArrayIO {
        protected ArrayIO() {
        }

        public abstract short getInt16(byte[] var1, int var2);

        public abstract int getInt32(byte[] var1, int var2);

        public abstract long getInt64(byte[] var1, int var2);

        public abstract long getAddress(byte[] var1, int var2);

        public abstract void putInt16(byte[] var1, int var2, int var3);

        public abstract void putInt32(byte[] var1, int var2, int var3);

        public abstract void putInt64(byte[] var1, int var2, long var3);

        public abstract void putAddress(byte[] var1, int var2, long var3);

        public final float getFloat32(byte[] buffer, int offset2) {
            return Float.intBitsToFloat(this.getInt32(buffer, offset2));
        }

        public final void putFloat32(byte[] buffer, int offset2, float value2) {
            this.putInt32(buffer, offset2, Float.floatToRawIntBits(value2));
        }

        public final double getFloat64(byte[] buffer, int offset2) {
            return Double.longBitsToDouble(this.getInt64(buffer, offset2));
        }

        public final void putFloat64(byte[] buffer, int offset2, double value2) {
            this.putInt64(buffer, offset2, Double.doubleToRawLongBits(value2));
        }
    }
}

