/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.proxies;

import java.util.Map;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.java.proxies.ConcreteJavaProxy;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class MapJavaProxy
extends ConcreteJavaProxy {
    private RubyHashMap wrappedMap;
    private static final ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        @Override
        public MapJavaProxy allocate(Ruby runtime, RubyClass klazz) {
            return new MapJavaProxy(runtime, klazz);
        }
    };

    public MapJavaProxy(Ruby runtime, RubyClass klazz) {
        super(runtime, klazz);
    }

    public MapJavaProxy(Ruby runtime, RubyClass klazz, Map map) {
        super(runtime, klazz, map);
    }

    public static RubyClass createMapJavaProxy(Ruby runtime) {
        RubyClass MapJavaProxy2 = runtime.defineClass("MapJavaProxy", runtime.getJavaSupport().getConcreteProxyClass(), ALLOCATOR);
        ConcreteJavaProxy.initialize(MapJavaProxy2);
        return MapJavaProxy2;
    }

    private RubyHashMap getOrCreateRubyHashMap() {
        if (this.wrappedMap == null) {
            this.wrappedMap = new RubyHashMap(this.getRuntime(), this);
        }
        IRubyObject oldExc = this.getRuntime().getGlobalVariables().get("$!");
        try {
            this.wrappedMap.setSize(this.getMapObject().size());
        }
        catch (RaiseException e) {
            this.wrappedMap.setSize(0);
            this.getRuntime().getGlobalVariables().set("$!", oldExc);
        }
        return this.wrappedMap;
    }

    @JRubyMethod(name={"default"})
    public IRubyObject default_value_get(ThreadContext context) {
        return this.getOrCreateRubyHashMap().default_value_get(context);
    }

    @JRubyMethod(name={"default"})
    public IRubyObject default_value_get(ThreadContext context, IRubyObject arg2) {
        return this.getOrCreateRubyHashMap().default_value_get(context, arg2);
    }

    @JRubyMethod(name={"default="}, required=1)
    public IRubyObject default_value_set(IRubyObject defaultValue) {
        return this.getOrCreateRubyHashMap().default_value_set(defaultValue);
    }

    @JRubyMethod(name={"default_proc"})
    public IRubyObject default_proc() {
        return this.getOrCreateRubyHashMap().default_proc();
    }

    @JRubyMethod(name={"default_proc="})
    public IRubyObject set_default_proc(IRubyObject proc) {
        return this.getOrCreateRubyHashMap().set_default_proc(proc);
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext context) {
        return this.getOrCreateRubyHashMap().inspect19(context);
    }

    @JRubyMethod(name={"size", "length"})
    public RubyFixnum rb_size() {
        return this.getOrCreateRubyHashMap().rb_size();
    }

    @JRubyMethod(name={"empty?"})
    public RubyBoolean empty_p() {
        return this.getOrCreateRubyHashMap().empty_p();
    }

    @Override
    @JRubyMethod(name={"to_a"})
    public RubyArray to_a() {
        return this.getOrCreateRubyHashMap().to_a();
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s(ThreadContext context) {
        return this.getOrCreateRubyHashMap().to_s19(context);
    }

    @JRubyMethod(name={"rehash"}, notImplemented=true)
    public RubyHash rehash() {
        return this.getOrCreateRubyHashMap().rehash();
    }

    @JRubyMethod(name={"to_hash", "to_h"})
    public RubyHash to_hash() {
        return this.getOrCreateRubyHashMap().to_hash();
    }

    @JRubyMethod(name={"[]=", "store"}, required=2)
    public IRubyObject op_aset(ThreadContext context, IRubyObject key2, IRubyObject value2) {
        return this.getOrCreateRubyHashMap().op_aset(context, key2, value2);
    }

    @Override
    @JRubyMethod(name={"=="})
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        return this.getOrCreateRubyHashMap().op_equal(context, other);
    }

    @JRubyMethod(name={"eql?"})
    public IRubyObject op_eql19(ThreadContext context, IRubyObject other) {
        return this.getOrCreateRubyHashMap().op_eql19(context, other);
    }

    @JRubyMethod(name={"[]"}, required=1)
    public IRubyObject op_aref(ThreadContext context, IRubyObject key2) {
        return this.getOrCreateRubyHashMap().op_aref(context, key2);
    }

    @Override
    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        return this.getOrCreateRubyHashMap().hash19();
    }

    @JRubyMethod
    public IRubyObject fetch(ThreadContext context, IRubyObject key2, Block block) {
        return this.getOrCreateRubyHashMap().fetch(context, key2, block);
    }

    @JRubyMethod
    public IRubyObject fetch(ThreadContext context, IRubyObject key2, IRubyObject _default, Block block) {
        return this.getOrCreateRubyHashMap().fetch(context, key2, _default, block);
    }

    @JRubyMethod(name={"has_key?", "key?", "include?", "member?"}, required=1)
    public RubyBoolean has_key_p(IRubyObject key2) {
        return this.getOrCreateRubyHashMap().has_key_p(key2);
    }

    @JRubyMethod(name={"has_value?", "value?"}, required=1)
    public RubyBoolean has_value_p(ThreadContext context, IRubyObject expected) {
        return this.getOrCreateRubyHashMap().has_value_p(context, expected);
    }

    @JRubyMethod
    public IRubyObject each(ThreadContext context, Block block) {
        return this.getOrCreateRubyHashMap().each19(context, block);
    }

    @JRubyMethod(name={"each_pair"})
    public IRubyObject each_pair(ThreadContext context, Block block) {
        return this.getOrCreateRubyHashMap().each_pair(context, block);
    }

    @JRubyMethod(name={"each_value"})
    public IRubyObject each_value(ThreadContext context, Block block) {
        return this.getOrCreateRubyHashMap().each_value(context, block);
    }

    @JRubyMethod(name={"each_key"})
    public IRubyObject each_key(ThreadContext context, Block block) {
        return this.getOrCreateRubyHashMap().each_key(context, block);
    }

    @JRubyMethod(name={"select!"})
    public IRubyObject select_bang(ThreadContext context, Block block) {
        return this.getOrCreateRubyHashMap().select_bang(context, block);
    }

    @JRubyMethod(name={"keep_if"})
    public IRubyObject keep_if(ThreadContext context, Block block) {
        return this.getOrCreateRubyHashMap().keep_if(context, block);
    }

    @JRubyMethod(name={"sort"})
    public IRubyObject sort(ThreadContext context, Block block) {
        return this.getOrCreateRubyHashMap().sort(context, block);
    }

    @JRubyMethod(name={"index"})
    public IRubyObject index(ThreadContext context, IRubyObject expected) {
        return this.getOrCreateRubyHashMap().index19(context, expected);
    }

    @JRubyMethod(name={"key"})
    public IRubyObject key(ThreadContext context, IRubyObject expected) {
        return this.getOrCreateRubyHashMap().key(context, expected);
    }

    @JRubyMethod(name={"keys"})
    public RubyArray keys() {
        return this.getOrCreateRubyHashMap().keys();
    }

    @JRubyMethod(name={"values"})
    public RubyArray rb_values() {
        return this.getOrCreateRubyHashMap().rb_values();
    }

    @JRubyMethod(name={"shift"}, notImplemented=true)
    public IRubyObject shift(ThreadContext context) {
        return this.getOrCreateRubyHashMap().shift(context);
    }

    @JRubyMethod(name={"delete"})
    public IRubyObject delete(ThreadContext context, IRubyObject key2, Block block) {
        return this.getOrCreateRubyHashMap().delete(context, key2, block);
    }

    @JRubyMethod(name={"select"})
    public IRubyObject select(ThreadContext context, Block block) {
        return this.getOrCreateRubyHashMap().select19(context, block);
    }

    @JRubyMethod(name={"delete_if"})
    public IRubyObject delete_if(ThreadContext context, Block block) {
        return this.getOrCreateRubyHashMap().delete_if(context, block);
    }

    @JRubyMethod(name={"reject"})
    public IRubyObject reject(ThreadContext context, Block block) {
        return this.getOrCreateRubyHashMap().reject(context, block);
    }

    @JRubyMethod(name={"reject!"})
    public IRubyObject reject_bang(ThreadContext context, Block block) {
        return this.getOrCreateRubyHashMap().reject_bang(context, block);
    }

    @JRubyMethod(name={"clear"})
    public RubyHash rb_clear() {
        return this.getOrCreateRubyHashMap().rb_clear();
    }

    @JRubyMethod(name={"invert"})
    public RubyHash invert(ThreadContext context) {
        return this.getOrCreateRubyHashMap().invert(context);
    }

    @JRubyMethod(name={"merge!", "update"}, required=1)
    public RubyHash merge_bang(ThreadContext context, IRubyObject other, Block block) {
        return this.getOrCreateRubyHashMap().merge_bang19(context, other, block);
    }

    @JRubyMethod(name={"merge"})
    public RubyHash merge(ThreadContext context, IRubyObject other, Block block) {
        return this.getOrCreateRubyHashMap().merge(context, other, block);
    }

    @JRubyMethod(name={"initialize_copy"}, visibility=Visibility.PRIVATE)
    public RubyHash initialize_copy(ThreadContext context, IRubyObject other) {
        return this.getOrCreateRubyHashMap().initialize_copy19(context, other);
    }

    @JRubyMethod(name={"replace"}, required=1)
    public RubyHash replace(ThreadContext context, IRubyObject other) {
        return this.getOrCreateRubyHashMap().replace19(context, other);
    }

    @JRubyMethod(name={"values_at"}, rest=true)
    public RubyArray values_at(ThreadContext context, IRubyObject[] args2) {
        return this.getOrCreateRubyHashMap().values_at(context, args2);
    }

    @JRubyMethod(name={"assoc"})
    public IRubyObject assoc(ThreadContext context, IRubyObject obj) {
        return this.getOrCreateRubyHashMap().assoc(context, obj);
    }

    @JRubyMethod(name={"rassoc"})
    public IRubyObject rassoc(ThreadContext context, IRubyObject obj) {
        return this.getOrCreateRubyHashMap().rassoc(context, obj);
    }

    @JRubyMethod(name={"flatten"})
    public IRubyObject flatten(ThreadContext context) {
        return this.getOrCreateRubyHashMap().flatten(context);
    }

    @JRubyMethod(name={"flatten"})
    public IRubyObject flatten(ThreadContext context, IRubyObject level2) {
        return this.getOrCreateRubyHashMap().flatten(context, level2);
    }

    @JRubyMethod(name={"compare_by_identity"})
    public IRubyObject getCompareByIdentity(ThreadContext context) {
        return this.getOrCreateRubyHashMap().getCompareByIdentity(context);
    }

    @JRubyMethod(name={"compare_by_identity?"})
    public IRubyObject getCompareByIdentity_p(ThreadContext context) {
        return this.getOrCreateRubyHashMap().getCompareByIdentity_p(context);
    }

    @Override
    public IRubyObject dup() {
        return this.dupImpl("dup");
    }

    @Override
    public IRubyObject rbClone() {
        return this.dupImpl("clone");
    }

    private MapJavaProxy dupImpl(String method) {
        Map map = this.getMapObject();
        try {
            Map newMap = (Map)map.getClass().newInstance();
            newMap.putAll(map);
            MapJavaProxy proxy2 = new MapJavaProxy(this.getRuntime(), this.metaClass);
            proxy2.setObject(newMap);
            return proxy2;
        }
        catch (InstantiationException ex) {
            throw MapJavaProxy.initCause(this.getRuntime().newNotImplementedError("can't " + method + " Map of type " + this.getObject().getClass().getName()), ex);
        }
        catch (IllegalAccessException ex) {
            throw MapJavaProxy.initCause(this.getRuntime().newNotImplementedError("can't " + method + " Map of type " + this.getObject().getClass().getName()), ex);
        }
    }

    private static RaiseException initCause(RaiseException re, Exception e) {
        re.initCause(e);
        return re;
    }

    final Map getMapObject() {
        return (Map)this.getObject();
    }

    @Deprecated
    public IRubyObject op_aset19(ThreadContext context, IRubyObject key2, IRubyObject value2) {
        return this.getOrCreateRubyHashMap().op_aset19(context, key2, value2);
    }

    private static class RubyHashMap
    extends RubyHash {
        private final MapJavaProxy receiver;

        public RubyHashMap(Ruby runtime, MapJavaProxy receiver2) {
            super(runtime, 0);
            this.receiver = receiver2;
        }

        private void setSize(int size2) {
            this.size = size2;
        }

        private Map mapDelegate() {
            return this.receiver.getMapObject();
        }

        @Override
        public void internalPut(IRubyObject key2, IRubyObject value2, boolean checkForExisting) {
            this.internalPutSmall(key2, value2, checkForExisting);
        }

        @Override
        protected final void internalPutSmall(IRubyObject key2, IRubyObject value2, boolean checkForExisting) {
            Map map = this.mapDelegate();
            map.put(key2.toJava(Object.class), value2.toJava(Object.class));
            this.size = map.size();
        }

        @Override
        protected final void op_asetForString(Ruby runtime, RubyString key2, IRubyObject value2) {
            Map map = this.mapDelegate();
            map.put(key2.decodeString(), value2.toJava(Object.class));
            this.size = map.size();
        }

        @Override
        protected final void op_asetSmallForString(Ruby runtime, RubyString key2, IRubyObject value2) {
            this.op_asetForString(runtime, key2, value2);
        }

        @Override
        public IRubyObject internalGet(IRubyObject key2) {
            Object result2 = this.mapDelegate().get(key2.toJava(Object.class));
            if (result2 == null) {
                return null;
            }
            return JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), result2);
        }

        @Override
        public RubyHash.RubyHashEntry internalGetEntry(IRubyObject key2) {
            Object convertedKey;
            Map map = this.mapDelegate();
            Object value2 = map.get(convertedKey = key2.toJava(Object.class));
            if (value2 != null) {
                return new RubyHash.RubyHashEntry(key2.hashCode(), key2, JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), value2), null, null);
            }
            return NO_ENTRY;
        }

        @Override
        public RubyHash.RubyHashEntry internalDelete(IRubyObject key2) {
            Object convertedKey;
            Map map = this.mapDelegate();
            Object value2 = map.get(convertedKey = key2.toJava(Object.class));
            if (value2 != null) {
                map.remove(convertedKey);
                this.size = map.size();
                return new RubyHash.RubyHashEntry(key2.hashCode(), key2, JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), value2), null, null);
            }
            return NO_ENTRY;
        }

        @Override
        public RubyHash.RubyHashEntry internalDeleteEntry(RubyHash.RubyHashEntry entry) {
            Object convertedKey;
            Map map = this.mapDelegate();
            if (map.containsKey(convertedKey = ((IRubyObject)entry.getKey()).toJava(Object.class))) {
                map.remove(convertedKey);
                this.size = map.size();
                return entry;
            }
            return NO_ENTRY;
        }

        @Override
        public void visitAll(RubyHash.Visitor visitor) {
            Map.Entry[] entries2;
            Ruby runtime = this.getRuntime();
            Map map = this.mapDelegate();
            for (Map.Entry entry : entries2 = map.entrySet().toArray(new Map.Entry[map.size()])) {
                IRubyObject key2 = JavaUtil.convertJavaToUsableRubyObject(runtime, entry.getKey());
                IRubyObject value2 = JavaUtil.convertJavaToUsableRubyObject(runtime, entry.getValue());
                visitor.visit(key2, value2);
            }
        }

        @Override
        public RubyBoolean has_key_p(IRubyObject key2) {
            Object convertedKey = key2.toJava(Object.class);
            return this.getRuntime().newBoolean(this.mapDelegate().containsKey(convertedKey));
        }

        @Override
        public RubyHash rehash() {
            return this;
        }

        @Override
        public RubyHash rb_clear() {
            this.mapDelegate().clear();
            this.size = 0;
            return this;
        }

        @Override
        public IRubyObject shift(ThreadContext context) {
            throw this.getRuntime().newNotImplementedError("Java Maps do not preserve insertion order and do not support shift");
        }

        @Override
        public RubyHash to_hash() {
            Ruby runtime = this.getRuntime();
            RubyHash hash2 = new RubyHash(runtime);
            Set entries2 = this.mapDelegate().entrySet();
            for (Map.Entry entry : entries2) {
                IRubyObject key2 = JavaUtil.convertJavaToUsableRubyObject(runtime, entry.getKey());
                IRubyObject value2 = JavaUtil.convertJavaToUsableRubyObject(runtime, entry.getValue());
                hash2.fastASetCheckString(runtime, key2, value2);
            }
            return hash2;
        }
    }
}

