/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.nodes;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ReplaceObserver;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.instrument.Probe;
import com.oracle.truffle.api.instrument.ProbeException;
import com.oracle.truffle.api.instrument.ProbeFailure;
import com.oracle.truffle.api.instrument.ProbeNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.NodeClass;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.NodeInterface;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.NodeVisitor;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.JSONHelper;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;

public abstract class Node
implements NodeInterface,
Cloneable {
    private final NodeClass nodeClass;
    @CompilerDirectives.CompilationFinal
    private Node parent;
    @CompilerDirectives.CompilationFinal
    private SourceSection sourceSection;
    private static final Object GIL = new Object();
    private static final ThreadLocal<Integer> IN_ATOMIC_BLOCK = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };

    protected Node() {
        this(null);
    }

    protected Node(SourceSection sourceSection) {
        CompilerAsserts.neverPartOfCompilation();
        this.sourceSection = sourceSection;
        this.nodeClass = NodeClass.get(this.getClass());
        if (TruffleOptions.TraceASTJSON) {
            JSONHelper.dumpNewNode(this);
        }
    }

    public final void assignSourceSection(SourceSection section) {
        if (this.sourceSection != null && this.getSourceSection() != section) {
            throw new IllegalStateException("Source section is already assigned. Old: " + this.getSourceSection() + ", new: " + section);
        }
        this.sourceSection = section;
    }

    NodeClass getNodeClass() {
        return this.nodeClass;
    }

    public NodeCost getCost() {
        NodeInfo info = this.getClass().getAnnotation(NodeInfo.class);
        if (info != null) {
            return info.cost();
        }
        return NodeCost.MONOMORPHIC;
    }

    public final void clearSourceSection() {
        this.sourceSection = null;
    }

    public final SourceSection getSourceSection() {
        return this.sourceSection;
    }

    @ExplodeLoop
    public final SourceSection getEncapsulatingSourceSection() {
        Node current = this;
        while (current != null) {
            if (current.sourceSection != null) {
                return current.sourceSection;
            }
            current = current.parent;
        }
        return null;
    }

    protected final <T extends Node> T[] insert(T[] newChildren) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        assert (newChildren != null);
        T[] TArray = newChildren;
        int n = newChildren.length;
        int n2 = 0;
        while (n2 < n) {
            T newChild = TArray[n2];
            this.adoptHelper((Node)newChild);
            ++n2;
        }
        return newChildren;
    }

    protected final <T extends Node> T insert(T newChild) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        assert (newChild != null);
        this.adoptHelper(newChild);
        return newChild;
    }

    public final void adoptChildren() {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.adoptHelper();
    }

    private void adoptHelper(Node newChild) {
        assert (newChild != null);
        if (newChild == this) {
            throw new IllegalStateException("The parent of a node can never be the node itself.");
        }
        newChild.parent = this;
        if (TruffleOptions.TraceASTJSON) {
            JSONHelper.dumpNewChild(this, newChild);
        }
        newChild.adoptHelper();
    }

    private void adoptHelper() {
        Iterable<Node> children = this.getChildren();
        for (Node child : children) {
            if (child == null || child.getParent() == this) continue;
            this.adoptHelper(child);
        }
    }

    private void adoptUnadoptedHelper(Node newChild) {
        assert (newChild != null);
        if (newChild == this) {
            throw new IllegalStateException("The parent of a node can never be the node itself.");
        }
        newChild.parent = this;
        newChild.adoptUnadoptedHelper();
    }

    private void adoptUnadoptedHelper() {
        Iterable<Node> children = this.getChildren();
        for (Node child : children) {
            if (child == null || child.getParent() != null) continue;
            this.adoptUnadoptedHelper(child);
        }
    }

    public Map<String, Object> getDebugProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        return properties;
    }

    public final Node getParent() {
        return this.parent;
    }

    public final <T extends Node> T replace(final T newNode, final CharSequence reason) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.atomic(new Runnable(){

            @Override
            public void run() {
                Node.this.replaceHelper(newNode, reason);
            }
        });
        return newNode;
    }

    public final <T extends Node> T replace(T newNode) {
        return this.replace(newNode, "");
    }

    final void replaceHelper(Node newNode, CharSequence reason) {
        CompilerAsserts.neverPartOfCompilation();
        assert (Node.inAtomicBlock());
        if (this.getParent() == null) {
            throw new IllegalStateException("This node cannot be replaced, because it does not yet have a parent.");
        }
        if (this.sourceSection != null && newNode.getSourceSection() == null) {
            newNode.assignSourceSection(this.sourceSection);
        }
        newNode.parent = this.parent;
        if (NodeUtil.replaceChild(this.parent, this, newNode)) {
            this.parent.adoptHelper(newNode);
        } else {
            this.parent.adoptUnadoptedHelper(newNode);
        }
        this.reportReplace(this, newNode, reason);
        this.onReplace(newNode, reason);
    }

    public final boolean isSafelyReplaceableBy(Node newNode) {
        return NodeUtil.isReplacementSafe(this.getParent(), this, newNode);
    }

    private void reportReplace(Node oldNode, Node newNode, CharSequence reason) {
        Node node = this;
        while (node != null) {
            RootCallTarget target;
            if (node instanceof ReplaceObserver) {
                ((ReplaceObserver)((Object)node)).nodeReplaced(oldNode, newNode, reason);
            } else if (node instanceof RootNode && (target = ((RootNode)node).getCallTarget()) instanceof ReplaceObserver) {
                ((ReplaceObserver)((Object)target)).nodeReplaced(oldNode, newNode, reason);
            }
            node = node.getParent();
        }
        if (TruffleOptions.TraceRewrites) {
            NodeUtil.traceRewrite(this, newNode, reason);
        }
        if (TruffleOptions.TraceASTJSON) {
            JSONHelper.dumpReplaceChild(this, newNode, reason);
        }
    }

    protected void onReplace(Node newNode, CharSequence reason) {
    }

    public final void accept(NodeVisitor nodeVisitor) {
        if (nodeVisitor.visit(this)) {
            NodeUtil.forEachChildRecursive(this, nodeVisitor);
        }
    }

    public final Iterable<Node> getChildren() {
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return Node.this.nodeClass.makeIterator(Node.this);
            }
        };
    }

    public Node copy() {
        try {
            return (Node)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Node deepCopy() {
        return NodeUtil.deepCopyImpl(this);
    }

    @Deprecated
    protected final Object clone() throws CloneNotSupportedException {
        throw new IllegalStateException("This method should never be called, use the copy method instead!");
    }

    public final RootNode getRootNode() {
        Node rootNode = this;
        while (rootNode.getParent() != null) {
            assert (!(rootNode instanceof RootNode)) : "root node must not have a parent";
            rootNode = rootNode.getParent();
        }
        if (rootNode instanceof RootNode) {
            return (RootNode)rootNode;
        }
        return null;
    }

    public boolean isInstrumentable() {
        return false;
    }

    public ProbeNode.WrapperNode createWrapperNode() {
        return null;
    }

    public final Probe probe() {
        if (this instanceof ProbeNode.WrapperNode) {
            throw new ProbeException(ProbeFailure.Reason.WRAPPER_NODE, null, this, null);
        }
        if (this.parent == null) {
            throw new ProbeException(ProbeFailure.Reason.NO_PARENT, null, this, null);
        }
        if (this.parent instanceof ProbeNode.WrapperNode) {
            return ((ProbeNode.WrapperNode)((Object)this.parent)).getProbe();
        }
        if (!this.isInstrumentable()) {
            throw new ProbeException(ProbeFailure.Reason.NOT_INSTRUMENTABLE, this.parent, this, null);
        }
        ProbeNode.WrapperNode wrapper = this.createWrapperNode();
        if (wrapper == null || !(wrapper instanceof Node)) {
            throw new ProbeException(ProbeFailure.Reason.NO_WRAPPER, this.parent, this, wrapper);
        }
        Node wrapperNode = (Node)((Object)wrapper);
        if (!this.isSafelyReplaceableBy(wrapperNode)) {
            throw new ProbeException(ProbeFailure.Reason.WRAPPER_TYPE, this.parent, this, wrapper);
        }
        Probe probe = ProbeNode.insertProbe(wrapper);
        this.replace(wrapperNode);
        return probe;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        Map<String, Object> properties = this.getDebugProperties();
        boolean hasProperties = false;
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            sb.append(hasProperties ? "," : "<");
            hasProperties = true;
            sb.append(entry.getKey()).append("=").append(entry.getValue());
        }
        if (hasProperties) {
            sb.append(">");
        }
        sb.append("@").append(Integer.toHexString(this.hashCode()));
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void atomic(Runnable closure) {
        RootNode rootNode = this.getRootNode();
        Object object = rootNode != null ? rootNode : GIL;
        synchronized (object) {
            assert (Node.enterAtomic());
            try {
                closure.run();
            }
            finally {
                assert (Node.exitAtomic());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final <T> T atomic(Callable<T> closure) {
        try {
            RootNode rootNode = this.getRootNode();
            Object object = rootNode != null ? rootNode : GIL;
            synchronized (object) {
                assert (Node.enterAtomic());
                T t = closure.call();
                return t;
                finally {
                    assert (Node.exitAtomic());
                }
            }
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getDescription() {
        NodeInfo info = this.getClass().getAnnotation(NodeInfo.class);
        if (info != null) {
            return info.description();
        }
        return "";
    }

    public String getLanguage() {
        NodeInfo info = this.getClass().getAnnotation(NodeInfo.class);
        if (info != null && info.language() != null && info.language().length() > 0) {
            return info.language();
        }
        if (this.parent != null) {
            return this.parent.getLanguage();
        }
        return "";
    }

    private static boolean inAtomicBlock() {
        return IN_ATOMIC_BLOCK.get() > 0;
    }

    private static boolean enterAtomic() {
        IN_ATOMIC_BLOCK.set(IN_ATOMIC_BLOCK.get() + 1);
        return true;
    }

    private static boolean exitAtomic() {
        IN_ATOMIC_BLOCK.set(IN_ATOMIC_BLOCK.get() - 1);
        return true;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Child {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Children {
    }
}

