/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.nodes.serial;

import java.nio.ByteBuffer;

public class VariableLengthIntBuffer {
    public static final int NULL = -1;
    private ByteBuffer buffer;

    public VariableLengthIntBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public VariableLengthIntBuffer(byte[] array) {
        this.buffer = ByteBuffer.wrap(array);
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public byte[] getBytes() {
        int pos = this.buffer.position();
        byte[] bytes = new byte[this.buffer.position()];
        this.buffer.rewind();
        this.buffer.get(bytes);
        this.buffer.position(pos);
        return bytes;
    }

    public int get() {
        byte peekByte = this.buffer.get(this.buffer.position());
        if ((peekByte & 0x80) == 0) {
            return this.buffer.get();
        }
        if (peekByte == -1) {
            this.buffer.get();
            return -1;
        }
        int result = this.buffer.getInt() & Integer.MAX_VALUE;
        assert ((result & 0x40000000) == 0);
        return result;
    }

    public void put(int i) {
        this.ensureCapacity();
        if (i == -1) {
            this.buffer.put((byte)-1);
        } else if ((i & 0xFFFFFF80) == 0) {
            this.buffer.put((byte)i);
        } else if ((i & 0xC0000000) == 0) {
            this.buffer.putInt(i | Integer.MIN_VALUE);
        } else {
            throw new IllegalArgumentException("Integer out of encodeable " + i);
        }
    }

    private void ensureCapacity() {
        if (this.buffer.position() + 4 > this.buffer.capacity()) {
            ByteBuffer newBuffer = ByteBuffer.allocate(this.buffer.capacity() * 2);
            int pos = this.buffer.position();
            this.buffer.rewind();
            newBuffer.put(this.buffer);
            newBuffer.position(pos);
            this.buffer = newBuffer;
        }
    }

    public boolean hasRemaining() {
        return this.buffer.hasRemaining();
    }
}

