/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.interop;

import com.oracle.truffle.api.CompilerDirectives;

public final class ForeignAccessArguments {
    public static final Object[] EMPTY_ARGUMENTS_ARRAY = new Object[0];
    public static final int RECEIVER_INDEX = 0;
    public static final int RUNTIME_ARGUMENT_COUNT = 1;

    public static Object[] create(Object receiver) {
        return new Object[]{receiver};
    }

    public static Object[] create(Object receiver, Object[] arguments) {
        Object[] objectArguments = new Object[1 + arguments.length];
        objectArguments[0] = receiver;
        ForeignAccessArguments.arraycopy(arguments, 0, objectArguments, 1, arguments.length);
        return objectArguments;
    }

    public static Object getArgument(Object[] arguments, int index) {
        return arguments[1 + index];
    }

    public static Object getReceiver(Object[] arguments) {
        return arguments[0];
    }

    public static Object[] extractUserArguments(Object[] arguments) {
        return ForeignAccessArguments.copyOfRange(arguments, 1, arguments.length);
    }

    public static int getUserArgumentCount(Object[] arguments) {
        return arguments.length - 1;
    }

    private static Object[] copyOfRange(Object[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            CompilerDirectives.transferToInterpreter();
            throw new IllegalArgumentException(String.valueOf(from) + " > " + to);
        }
        Object[] copy = new Object[newLength];
        ForeignAccessArguments.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    private static void arraycopy(Object[] src, int srcPos, Object[] dest, int destPos, int length) {
        int i = 0;
        while (i < length) {
            dest[destPos + i] = src[srcPos + i];
            ++i;
        }
    }
}

