/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayDupNode;
import org.jruby.truffle.nodes.core.array.ArrayGuards;
import org.jruby.truffle.runtime.RubyContext;

@GeneratedBy(value=ArrayDupNode.class)
public final class ArrayDupNodeGen
extends ArrayDupNode
implements SpecializedNode {
    @Node.Child
    private RubyNode array_;
    @Node.Child
    private BaseNode_ specialization_;

    private ArrayDupNodeGen(RubyContext context, SourceSection sourceSection, RubyNode array) {
        super(context, sourceSection);
        this.array_ = array;
        this.specialization_ = UninitializedNode_.create(this);
    }

    @Override
    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public DynamicObject executeDup(VirtualFrame frameValue, DynamicObject arrayValue) {
        return this.specialization_.executeDynamicObject1(frameValue, arrayValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    @Override
    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    @Override
    public Node deepCopy() {
        return SpecializationNode.updateRoot(super.deepCopy());
    }

    public static ArrayDupNode create(RubyContext context, SourceSection sourceSection, RubyNode array) {
        return new ArrayDupNodeGen(context, sourceSection, array);
    }

    @GeneratedBy(methodName="dupObject(DynamicObject)", value=ArrayDupNode.class)
    private static final class DupObjectNode_
    extends BaseNode_ {
        DupObjectNode_(ArrayDupNodeGen root) {
            super(root, 5);
        }

        @Override
        public DynamicObject executeDynamicObject1(VirtualFrame frameValue, DynamicObject arrayValue) {
            if (RubyGuards.isRubyArray(arrayValue) && ArrayGuards.isObjectArray(arrayValue)) {
                return this.root.dupObject(arrayValue);
            }
            return this.getNext().executeDynamicObject1(frameValue, arrayValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arrayValue) {
            DynamicObject arrayValue_;
            if (arrayValue instanceof DynamicObject && RubyGuards.isRubyArray(arrayValue_ = (DynamicObject)arrayValue) && ArrayGuards.isObjectArray(arrayValue_)) {
                return this.root.dupObject(arrayValue_);
            }
            return this.getNext().executeDynamicObject_(frameValue, arrayValue);
        }

        static BaseNode_ create(ArrayDupNodeGen root) {
            return new DupObjectNode_(root);
        }
    }

    @GeneratedBy(methodName="dupFloat(DynamicObject)", value=ArrayDupNode.class)
    private static final class DupFloatNode_
    extends BaseNode_ {
        DupFloatNode_(ArrayDupNodeGen root) {
            super(root, 4);
        }

        @Override
        public DynamicObject executeDynamicObject1(VirtualFrame frameValue, DynamicObject arrayValue) {
            if (RubyGuards.isRubyArray(arrayValue) && ArrayGuards.isDoubleArray(arrayValue)) {
                return this.root.dupFloat(arrayValue);
            }
            return this.getNext().executeDynamicObject1(frameValue, arrayValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arrayValue) {
            DynamicObject arrayValue_;
            if (arrayValue instanceof DynamicObject && RubyGuards.isRubyArray(arrayValue_ = (DynamicObject)arrayValue) && ArrayGuards.isDoubleArray(arrayValue_)) {
                return this.root.dupFloat(arrayValue_);
            }
            return this.getNext().executeDynamicObject_(frameValue, arrayValue);
        }

        static BaseNode_ create(ArrayDupNodeGen root) {
            return new DupFloatNode_(root);
        }
    }

    @GeneratedBy(methodName="dupLongFixnum(DynamicObject)", value=ArrayDupNode.class)
    private static final class DupLongFixnumNode_
    extends BaseNode_ {
        DupLongFixnumNode_(ArrayDupNodeGen root) {
            super(root, 3);
        }

        @Override
        public DynamicObject executeDynamicObject1(VirtualFrame frameValue, DynamicObject arrayValue) {
            if (RubyGuards.isRubyArray(arrayValue) && ArrayGuards.isLongArray(arrayValue)) {
                return this.root.dupLongFixnum(arrayValue);
            }
            return this.getNext().executeDynamicObject1(frameValue, arrayValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arrayValue) {
            DynamicObject arrayValue_;
            if (arrayValue instanceof DynamicObject && RubyGuards.isRubyArray(arrayValue_ = (DynamicObject)arrayValue) && ArrayGuards.isLongArray(arrayValue_)) {
                return this.root.dupLongFixnum(arrayValue_);
            }
            return this.getNext().executeDynamicObject_(frameValue, arrayValue);
        }

        static BaseNode_ create(ArrayDupNodeGen root) {
            return new DupLongFixnumNode_(root);
        }
    }

    @GeneratedBy(methodName="dupIntegerFixnum(DynamicObject)", value=ArrayDupNode.class)
    private static final class DupIntegerFixnumNode_
    extends BaseNode_ {
        DupIntegerFixnumNode_(ArrayDupNodeGen root) {
            super(root, 2);
        }

        @Override
        public DynamicObject executeDynamicObject1(VirtualFrame frameValue, DynamicObject arrayValue) {
            if (RubyGuards.isRubyArray(arrayValue) && ArrayGuards.isIntArray(arrayValue)) {
                return this.root.dupIntegerFixnum(arrayValue);
            }
            return this.getNext().executeDynamicObject1(frameValue, arrayValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arrayValue) {
            DynamicObject arrayValue_;
            if (arrayValue instanceof DynamicObject && RubyGuards.isRubyArray(arrayValue_ = (DynamicObject)arrayValue) && ArrayGuards.isIntArray(arrayValue_)) {
                return this.root.dupIntegerFixnum(arrayValue_);
            }
            return this.getNext().executeDynamicObject_(frameValue, arrayValue);
        }

        static BaseNode_ create(ArrayDupNodeGen root) {
            return new DupIntegerFixnumNode_(root);
        }
    }

    @GeneratedBy(methodName="dupNull(DynamicObject)", value=ArrayDupNode.class)
    private static final class DupNullNode_
    extends BaseNode_ {
        DupNullNode_(ArrayDupNodeGen root) {
            super(root, 1);
        }

        @Override
        public DynamicObject executeDynamicObject1(VirtualFrame frameValue, DynamicObject arrayValue) {
            if (RubyGuards.isRubyArray(arrayValue) && ArrayGuards.isNullArray(arrayValue)) {
                return this.root.dupNull(arrayValue);
            }
            return this.getNext().executeDynamicObject1(frameValue, arrayValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arrayValue) {
            DynamicObject arrayValue_;
            if (arrayValue instanceof DynamicObject && RubyGuards.isRubyArray(arrayValue_ = (DynamicObject)arrayValue) && ArrayGuards.isNullArray(arrayValue_)) {
                return this.root.dupNull(arrayValue_);
            }
            return this.getNext().executeDynamicObject_(frameValue, arrayValue);
        }

        static BaseNode_ create(ArrayDupNodeGen root) {
            return new DupNullNode_(root);
        }
    }

    @GeneratedBy(value=ArrayDupNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(ArrayDupNodeGen root) {
            super(root, 0);
        }

        @Override
        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arrayValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arrayValue));
        }

        @Override
        public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arrayValue) {
            return this.getNext().executeDynamicObject_(frameValue, arrayValue);
        }

        static BaseNode_ create(ArrayDupNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=ArrayDupNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(ArrayDupNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arrayValue) {
            return (DynamicObject)this.uninitialized((Frame)frameValue, arrayValue);
        }

        static BaseNode_ create(ArrayDupNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=ArrayDupNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        protected final ArrayDupNodeGen root;

        BaseNode_(ArrayDupNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        @Override
        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.array_};
        }

        @Override
        public final Object acceptAndExecute(Frame frameValue, Object arrayValue) {
            return this.executeDynamicObject_((VirtualFrame)frameValue, arrayValue);
        }

        public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2);

        public DynamicObject executeDynamicObject1(VirtualFrame frameValue, DynamicObject arrayValue) {
            return this.executeDynamicObject_(frameValue, arrayValue);
        }

        public Object execute(VirtualFrame frameValue) {
            Object arrayValue_ = this.root.array_.execute(frameValue);
            return this.executeDynamicObject_(frameValue, arrayValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        @Override
        protected final SpecializationNode createNext(Frame frameValue, Object arrayValue) {
            if (arrayValue instanceof DynamicObject) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isNullArray(arrayValue_)) {
                    return DupNullNode_.create(this.root);
                }
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isIntArray(arrayValue_)) {
                    return DupIntegerFixnumNode_.create(this.root);
                }
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isLongArray(arrayValue_)) {
                    return DupLongFixnumNode_.create(this.root);
                }
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isDoubleArray(arrayValue_)) {
                    return DupFloatNode_.create(this.root);
                }
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isObjectArray(arrayValue_)) {
                    return DupObjectNode_.create(this.root);
                }
            }
            return null;
        }

        @Override
        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }
    }
}

