/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.fixnum;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;

public abstract class FixnumLiteralNode {

    @NodeInfo(cost=NodeCost.NONE)
    public static class LongFixnumLiteralNode
    extends RubyNode {
        private final long value;

        public LongFixnumLiteralNode(RubyContext context, SourceSection sourceSection, long value) {
            super(context, sourceSection);
            this.value = value;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return this.executeLong(frame);
        }

        @Override
        public long executeLong(VirtualFrame frame) {
            return this.value;
        }

        public long getValue() {
            return this.value;
        }
    }

    @NodeInfo(cost=NodeCost.NONE)
    public static class IntegerFixnumLiteralNode
    extends RubyNode {
        private final int value;

        public IntegerFixnumLiteralNode(RubyContext context, SourceSection sourceSection, int value) {
            super(context, sourceSection);
            this.value = value;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return this.executeInteger(frame);
        }

        @Override
        public int executeInteger(VirtualFrame frame) {
            return this.value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

