/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ExactMath;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.jruby.Ruby;
import org.jruby.RubyTime;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.core.TimeNodes;
import org.jruby.truffle.nodes.objects.AllocateObjectNode;
import org.jruby.truffle.nodes.objects.AllocateObjectNodeGen;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.nodes.time.ReadTimeZoneNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.util.RubyDateFormatter;

public abstract class TimePrimitiveNodes {

    @RubiniusPrimitive(name="time_utc_offset")
    public static abstract class TimeUTCOffsetPrimitiveNode
    extends RubiniusPrimitiveNode {
        public TimeUTCOffsetPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object timeUTCOffset(DynamicObject time) {
            Object offset = Layouts.TIME.getOffset(time);
            if (offset != this.nil()) {
                return offset;
            }
            return TimeNodes.getDateTime(time).getZone().getOffset(TimeNodes.getDateTime(time).getMillis()) / 1000;
        }
    }

    @RubiniusPrimitive(name="time_env_zone")
    public static abstract class TimeEnvZonePrimitiveNode
    extends RubiniusPrimitiveNode {
        public TimeEnvZonePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object timeEnvZone(DynamicObject time) {
            DateTime dt = Layouts.TIME.getDateTime(time);
            String timezone = dt.getZone().getShortName(dt.getMillis());
            return this.createString(StringOperations.encodeByteList(timezone, (Encoding)UTF8Encoding.INSTANCE));
        }
    }

    @RubiniusPrimitive(name="time_set_nseconds", lowerFixnumParameters={0})
    public static abstract class TimeSetNSecondsPrimitiveNode
    extends RubiniusPrimitiveNode {
        public TimeSetNSecondsPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public long timeSetNSeconds(DynamicObject time, int nanoseconds) {
            Layouts.TIME.setDateTime(time, TimeNodes.getDateTime(time).withMillisOfSecond(nanoseconds / 1000000));
            return nanoseconds;
        }
    }

    @RubiniusPrimitive(name="time_nseconds")
    public static abstract class TimeNSecondsPrimitiveNode
    extends RubiniusPrimitiveNode {
        public TimeNSecondsPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public long timeNSeconds(DynamicObject time) {
            return (long)TimeNodes.getDateTime(time).getMillisOfSecond() * 1000000L;
        }
    }

    @RubiniusPrimitive(name="time_s_from_array", needsSelf=true, lowerFixnumParameters={0, 1, 2, 3, 4, 5, 6, 7})
    public static abstract class TimeSFromArrayPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        ReadTimeZoneNode readTimeZoneNode;
        @Node.Child
        AllocateObjectNode allocateObjectNode;

        public TimeSFromArrayPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.readTimeZoneNode = new ReadTimeZoneNode(context, sourceSection);
            this.allocateObjectNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization
        public DynamicObject timeSFromArray(VirtualFrame frame, DynamicObject timeClass, int sec, int min, int hour, int mday, int month, int year, int nsec, int isdst, boolean fromutc, Object utcoffset) {
            return this.buildTime(frame, timeClass, sec, min, hour, mday, month, year, nsec, isdst, fromutc, utcoffset);
        }

        @Specialization(guards={"!isInteger(sec) || !isInteger(nsec)"})
        public DynamicObject timeSFromArrayFallback(VirtualFrame frame, DynamicObject timeClass, Object sec, int min, int hour, int mday, int month, int year, Object nsec, int isdst, boolean fromutc, Object utcoffset) {
            return null;
        }

        private DynamicObject buildTime(VirtualFrame frame, DynamicObject timeClass, int sec, int min, int hour, int mday, int month, int year, int nsec, int isdst, boolean fromutc, Object utcoffset) {
            DateTimeZone zone;
            CompilerDirectives.transferToInterpreter();
            if (sec < 0 || sec > 59 || min < 0 || min > 59 || hour < 0 || hour > 23 || mday < 1 || mday > 31 || month < 1 || month > 12) {
                throw new RaiseException(this.getContext().getCoreLibrary().argumentErrorOutOfRange(this));
            }
            if (fromutc) {
                zone = DateTimeZone.UTC;
            } else if (utcoffset == this.nil()) {
                String tz = this.readTimeZoneNode.execute(frame).toString();
                zone = RubyTime.getTimeZoneFromTZString((Ruby)this.getContext().getRuntime(), (String)tz);
            } else if (utcoffset instanceof Integer) {
                zone = DateTimeZone.forOffsetMillis((int)((Integer)utcoffset * 1000));
            } else if (utcoffset instanceof Long) {
                zone = DateTimeZone.forOffsetMillis((int)((int)((Long)utcoffset).longValue() * 1000));
            } else if (utcoffset instanceof DynamicObject) {
                int millis = TimeSFromArrayPrimitiveNode.cast(this.ruby(frame, "(offset * 1000).to_i", "offset", utcoffset));
                zone = DateTimeZone.forOffsetMillis((int)millis);
            } else {
                throw new UnsupportedOperationException(String.format("%s %s %s %s", isdst, fromutc, utcoffset, utcoffset.getClass()));
            }
            if (isdst == -1) {
                DateTime dateTime = new DateTime(year, month, mday, hour, min, sec, nsec / 1000000, zone);
                return this.allocateObjectNode.allocate(timeClass, dateTime, utcoffset);
            }
            throw new UnsupportedOperationException(String.format("%s %s %s %s", isdst, fromutc, utcoffset, utcoffset.getClass()));
        }

        private static int cast(Object value) {
            if (value instanceof Integer) {
                return (Integer)value;
            }
            if (value instanceof Long) {
                return (int)((Long)value).longValue();
            }
            throw new UnsupportedOperationException("Can't cast " + value.getClass());
        }
    }

    @RubiniusPrimitive(name="time_strftime")
    public static abstract class TimeStrftimePrimitiveNode
    extends RubiniusPrimitiveNode {
        public TimeStrftimePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(format)"})
        public DynamicObject timeStrftime(DynamicObject time, DynamicObject format) {
            RubyDateFormatter rdf = this.getContext().getRuntime().getCurrentContext().getRubyDateFormatter();
            return this.createString(rdf.formatToByteList(rdf.compilePattern(StringOperations.getByteList(format), false), TimeNodes.getDateTime(time), 0L, null));
        }
    }

    @RubiniusPrimitive(name="time_decompose")
    public static abstract class TimeDecomposePrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private ReadTimeZoneNode readTimeZoneNode;

        public TimeDecomposePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.readTimeZoneNode = new ReadTimeZoneNode(context, sourceSection);
        }

        @Specialization
        public DynamicObject timeDecompose(VirtualFrame frame, DynamicObject time) {
            CompilerDirectives.transferToInterpreter();
            DateTime dateTime = TimeNodes.getDateTime(time);
            int sec = dateTime.getSecondOfMinute();
            int min = dateTime.getMinuteOfHour();
            int hour = dateTime.getHourOfDay();
            int day = dateTime.getDayOfMonth();
            int month = dateTime.getMonthOfYear();
            int year = dateTime.getYear();
            int wday = dateTime.getDayOfWeek();
            if (wday == 7) {
                wday = 0;
            }
            int yday = dateTime.getDayOfYear();
            boolean isdst = false;
            String envTimeZoneString = this.readTimeZoneNode.execute(frame).toString();
            String zoneString = RubyTime.zoneHelper((String)envTimeZoneString, (DateTime)dateTime, (boolean)false);
            DynamicObject zone = zoneString.matches(".*-\\d+") ? this.nil() : this.createString(StringOperations.encodeByteList(zoneString, (Encoding)UTF8Encoding.INSTANCE));
            Object[] decomposed = new Object[]{sec, min, hour, day, month, year, wday, yday, false, zone};
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), decomposed, decomposed.length);
        }
    }

    @RubiniusPrimitive(name="time_useconds")
    public static abstract class TimeUSecondsPrimitiveNode
    extends RubiniusPrimitiveNode {
        public TimeUSecondsPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public long timeUSeconds(DynamicObject time) {
            return (long)TimeNodes.getDateTime(time).getMillisOfSecond() * 1000L;
        }
    }

    @RubiniusPrimitive(name="time_seconds")
    public static abstract class TimeSecondsPrimitiveNode
    extends RubiniusPrimitiveNode {
        public TimeSecondsPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public long timeSeconds(DynamicObject time) {
            return TimeNodes.getDateTime(time).getMillis() / 1000L;
        }
    }

    @RubiniusPrimitive(name="time_s_specific", needsSelf=false, lowerFixnumParameters={1})
    public static abstract class TimeSSpecificPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private ReadTimeZoneNode readTimeZoneNode;

        public TimeSSpecificPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.readTimeZoneNode = new ReadTimeZoneNode(context, sourceSection);
        }

        @Specialization(guards={"isUTC", "isNil(offset)"})
        public DynamicObject timeSSpecificUTC(long seconds, int nanoseconds, boolean isUTC, Object offset) {
            long milliseconds = this.getMillis(seconds, nanoseconds);
            return Layouts.TIME.createTime(this.getContext().getCoreLibrary().getTimeFactory(), this.time(milliseconds), this.nil());
        }

        @Specialization(guards={"!isUTC", "isNil(offset)"})
        public DynamicObject timeSSpecific(VirtualFrame frame, long seconds, int nanoseconds, boolean isUTC, Object offset) {
            long milliseconds = this.getMillis(seconds, nanoseconds);
            return Layouts.TIME.createTime(this.getContext().getCoreLibrary().getTimeFactory(), this.localtime(milliseconds, (DynamicObject)this.readTimeZoneNode.execute(frame)), offset);
        }

        private long getMillis(long seconds, int nanoseconds) {
            try {
                return ExactMath.addExact(ExactMath.multiplyExact(seconds, 1000L), (long)(nanoseconds / 1000000));
            }
            catch (ArithmeticException e) {
                CompilerDirectives.transferToInterpreter();
                String message = String.format("UNIX epoch + %d seconds out of range for Time (Joda-Time limitation)", seconds);
                throw new RaiseException(this.getContext().getCoreLibrary().rangeError(message, (Node)this));
            }
        }

        @CompilerDirectives.TruffleBoundary
        private DateTime time(long milliseconds) {
            return new DateTime(milliseconds, DateTimeZone.UTC);
        }

        @CompilerDirectives.TruffleBoundary
        private DateTime localtime(long milliseconds, DynamicObject timeZone) {
            assert (RubyGuards.isRubyString(timeZone));
            return new DateTime(milliseconds, RubyTime.getTimeZoneFromTZString((Ruby)this.getContext().getRuntime(), (String)timeZone.toString()));
        }
    }

    @RubiniusPrimitive(name="time_s_dup", needsSelf=false)
    public static abstract class TimeSDupPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode;

        public TimeSDupPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateObjectNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization
        public DynamicObject timeSDup(DynamicObject other) {
            return this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(other), TimeNodes.getDateTime(other), Layouts.TIME.getOffset(other));
        }
    }

    @RubiniusPrimitive(name="time_s_now")
    public static abstract class TimeSNowPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode;
        @Node.Child
        private ReadTimeZoneNode readTimeZoneNode;

        public TimeSNowPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateObjectNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
            this.readTimeZoneNode = new ReadTimeZoneNode(context, sourceSection);
        }

        @Specialization
        public DynamicObject timeSNow(VirtualFrame frame, DynamicObject timeClass) {
            return this.allocateObjectNode.allocate(timeClass, this.now((DynamicObject)this.readTimeZoneNode.execute(frame)), this.nil());
        }

        @CompilerDirectives.TruffleBoundary
        private DateTime now(DynamicObject timeZone) {
            assert (RubyGuards.isRubyString(timeZone));
            return DateTime.now((DateTimeZone)RubyTime.getTimeZoneFromTZString((Ruby)this.getContext().getRuntime(), (String)timeZone.toString()));
        }
    }
}

