/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.array;

import java.util.Arrays;
import org.jruby.truffle.runtime.array.ArrayMirror;
import org.jruby.truffle.runtime.array.ArrayUtils;
import org.jruby.truffle.runtime.array.BasicArrayMirror;

class IntegerArrayMirror
extends BasicArrayMirror {
    private final int[] array;

    public IntegerArrayMirror(int[] array) {
        this.array = array;
    }

    @Override
    public int getLength() {
        return this.array.length;
    }

    @Override
    public Object get(int index) {
        return this.array[index];
    }

    @Override
    public void set(int index, Object value) {
        this.array[index] = (Integer)value;
    }

    @Override
    public ArrayMirror copyArrayAndMirror(int newLength) {
        return new IntegerArrayMirror(Arrays.copyOf(this.array, newLength));
    }

    @Override
    public void copyTo(ArrayMirror destination, int sourceStart, int destinationStart, int count) {
        System.arraycopy(this.array, sourceStart, destination.getArray(), destinationStart, count);
    }

    @Override
    public Object[] getBoxedCopy(int newLength) {
        return ArrayUtils.box(this.array, newLength);
    }

    @Override
    public void copyTo(Object[] destination, int sourceStart, int destinationStart, int count) {
        for (int n = 0; n < count; ++n) {
            destination[destinationStart + n] = this.array[sourceStart + n];
        }
    }

    @Override
    public Object getArray() {
        return this.array;
    }
}

