/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.backtrace;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.NullSourceSection;
import com.oracle.truffle.api.source.SourceSection;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyCallStack;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.backtrace.Activation;
import org.jruby.truffle.runtime.backtrace.Backtrace;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.layouts.Layouts;

public class BacktraceFormatter {
    private final RubyContext context;
    private final EnumSet<FormattingFlags> flags;

    public static BacktraceFormatter createDefaultFormatter(RubyContext context) {
        EnumSet<FormattingFlags> flags = EnumSet.noneOf(FormattingFlags.class);
        if (!context.getOptions().BACKTRACES_HIDE_CORE_FILES) {
            flags.add(FormattingFlags.INCLUDE_CORE_FILES);
        }
        return new BacktraceFormatter(context, flags);
    }

    public static List<String> rubyBacktrace(RubyContext context) {
        return BacktraceFormatter.createDefaultFormatter(context).formatBacktrace(null, RubyCallStack.getBacktrace(null));
    }

    public static String printableRubyBacktrace(RubyContext context) {
        StringBuilder builder = new StringBuilder();
        for (String line : BacktraceFormatter.rubyBacktrace(context)) {
            builder.append("\n");
            builder.append(line);
        }
        return builder.toString().substring(1);
    }

    public BacktraceFormatter(RubyContext context, EnumSet<FormattingFlags> flags) {
        this.context = context;
        this.flags = flags;
    }

    @CompilerDirectives.TruffleBoundary
    public void printBacktrace(DynamicObject exception, Backtrace backtrace) {
        this.printBacktrace(exception, backtrace, new PrintWriter(System.err, true));
    }

    @CompilerDirectives.TruffleBoundary
    public void printBacktrace(DynamicObject exception, Backtrace backtrace, PrintWriter writer) {
        for (String line : this.formatBacktrace(exception, backtrace)) {
            writer.println(line);
        }
    }

    public List<String> formatBacktrace(DynamicObject exception, Backtrace backtrace) {
        try {
            if (backtrace == null) {
                backtrace = RubyCallStack.getBacktrace(null);
            }
            List<Activation> activations = backtrace.getActivations();
            ArrayList<String> lines = new ArrayList<String>();
            lines.add(this.formatInLine(activations, exception));
            for (int n = 1; n < activations.size(); ++n) {
                lines.add(this.formatFromLine(activations, n));
            }
            return lines;
        }
        catch (Exception e) {
            return Arrays.asList(String.format("(exception while constructing backtrace: %s %s)", e.getMessage(), e.getStackTrace()[0].toString()));
        }
    }

    private String formatInLine(List<Activation> activations, DynamicObject exception) {
        String reportedName;
        SourceSection reportedSourceSection;
        StringBuilder builder = new StringBuilder();
        Activation activation = activations.get(0);
        SourceSection sourceSection = activation.getCallNode().getEncapsulatingSourceSection();
        if (this.isCore(sourceSection) && !this.flags.contains((Object)FormattingFlags.INCLUDE_CORE_FILES)) {
            reportedSourceSection = this.nextUserSourceSection(activations, 1);
            reportedName = RubyArguments.getMethod(activation.getMaterializedFrame().getArguments()).getName();
        } else {
            reportedSourceSection = sourceSection;
            reportedName = reportedSourceSection.getIdentifier();
        }
        if (reportedSourceSection == null || reportedSourceSection.getSource() == null) {
            builder.append("???");
        } else {
            builder.append(reportedSourceSection.getSource().getName());
            builder.append(":");
            builder.append(reportedSourceSection.getStartLine());
            builder.append(":in `");
            builder.append(reportedName);
            builder.append("'");
        }
        if (exception != null) {
            String message;
            try {
                Object messageObject = this.context.send(exception, "message", null, new Object[0]);
                message = RubyGuards.isRubyString(messageObject) ? messageObject.toString() : Layouts.EXCEPTION.getMessage(exception).toString();
            }
            catch (RaiseException e) {
                message = Layouts.EXCEPTION.getMessage(exception).toString();
            }
            builder.append(": ");
            builder.append(message);
            builder.append(" (");
            builder.append(Layouts.MODULE.getFields(Layouts.BASIC_OBJECT.getLogicalClass(exception)).getName());
            builder.append(")");
        }
        return builder.toString();
    }

    private String formatFromLine(List<Activation> activations, int n) {
        String formattedLine = this.formatLine(activations, n);
        if (this.flags.contains((Object)FormattingFlags.OMIT_FROM_PREFIX)) {
            return formattedLine;
        }
        return "\tfrom " + formattedLine;
    }

    public String formatLine(List<Activation> activations, int n) {
        String reportedName;
        SourceSection reportedSourceSection;
        Activation activation = activations.get(n);
        SourceSection sourceSection = activation.getCallNode().getEncapsulatingSourceSection();
        if (this.isCore(sourceSection) && !this.flags.contains((Object)FormattingFlags.INCLUDE_CORE_FILES)) {
            reportedSourceSection = this.nextUserSourceSection(activations, n);
            try {
                reportedName = RubyArguments.getMethod(activation.getMaterializedFrame().getArguments()).getName();
            }
            catch (Exception e) {
                reportedName = "???";
            }
        } else {
            reportedSourceSection = sourceSection;
            reportedName = sourceSection.getIdentifier();
        }
        StringBuilder builder = new StringBuilder();
        if (reportedSourceSection instanceof NullSourceSection) {
            builder.append(reportedSourceSection.getShortDescription());
        } else if (reportedSourceSection == null) {
            builder.append("???");
        } else {
            builder.append(reportedSourceSection.getSource().getName());
            builder.append(":");
            builder.append(reportedSourceSection.getStartLine());
        }
        builder.append(":in `");
        builder.append(reportedName);
        builder.append("'");
        return builder.toString();
    }

    private SourceSection nextUserSourceSection(List<Activation> activations, int n) {
        while (n < activations.size()) {
            SourceSection sourceSection = activations.get(n).getCallNode().getEncapsulatingSourceSection();
            if (!this.isCore(sourceSection)) {
                return sourceSection;
            }
            ++n;
        }
        return null;
    }

    private boolean isCore(SourceSection sourceSection) {
        return sourceSection instanceof NullSourceSection || sourceSection.getSource().getPath().startsWith("truffle:");
    }

    public static enum FormattingFlags {
        OMIT_FROM_PREFIX,
        INCLUDE_CORE_FILES;

    }
}

