/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.layouts.rubinius;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import org.jruby.truffle.om.dsl.api.UnexpectedLayoutRefusalException;
import org.jruby.truffle.runtime.layouts.BasicObjectLayoutImpl;
import org.jruby.truffle.runtime.layouts.rubinius.RandomizerLayout;
import org.jruby.util.Random;

public class RandomizerLayoutImpl
extends BasicObjectLayoutImpl
implements RandomizerLayout {
    public static final RandomizerLayout INSTANCE = new RandomizerLayoutImpl();
    protected static final Shape.Allocator RANDOMIZER_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey RANDOM_IDENTIFIER = new HiddenKey("random");
    protected static final Property RANDOM_PROPERTY = Property.create(RANDOM_IDENTIFIER, RANDOMIZER_ALLOCATOR.locationForType(Random.class, EnumSet.of(LocationModifier.NonNull)), 0);

    protected RandomizerLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createRandomizerShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape(new RandomizerType(logicalClass, metaClass)).addProperty(RANDOM_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createRandomizer(DynamicObjectFactory factory, Random random) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant(factory);
        assert (this.createsRandomizer(factory));
        assert (factory.getShape().hasProperty(RANDOM_IDENTIFIER));
        assert (random != null);
        return factory.newInstance(random);
    }

    private boolean isRandomizer(DynamicObject object) {
        return this.isRandomizer(object.getShape().getObjectType());
    }

    private boolean isRandomizer(ObjectType objectType) {
        return objectType instanceof RandomizerType;
    }

    private boolean createsRandomizer(DynamicObjectFactory factory) {
        return this.isRandomizer(factory.getShape().getObjectType());
    }

    @Override
    public Random getRandom(DynamicObject object) {
        assert (this.isRandomizer(object));
        assert (object.getShape().hasProperty(RANDOM_IDENTIFIER));
        return (Random)RANDOM_PROPERTY.get(object, true);
    }

    @Override
    public void setRandom(DynamicObject object, Random value) {
        assert (this.isRandomizer(object));
        assert (object.getShape().hasProperty(RANDOM_IDENTIFIER));
        assert (value != null);
        try {
            RANDOM_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    protected static class RandomizerType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public RandomizerType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public RandomizerType setLogicalClass(DynamicObject logicalClass) {
            return new RandomizerType(logicalClass, this.metaClass);
        }

        @Override
        public RandomizerType setMetaClass(DynamicObject metaClass) {
            return new RandomizerType(this.logicalClass, metaClass);
        }
    }
}

