/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.jna;

import com.sun.jna.FastMemory;
import com.sun.jna.Function;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import de.intarsys.nativec.api.ICallback;
import de.intarsys.nativec.api.INativeCallback;
import de.intarsys.nativec.api.INativeFunction;
import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.api.INativeInterface;
import de.intarsys.nativec.api.INativeLibrary;
import de.intarsys.nativec.jna.JnaNativeCallbackAlt;
import de.intarsys.nativec.jna.JnaNativeCallbackStd;
import de.intarsys.nativec.jna.JnaNativeFunction;
import de.intarsys.nativec.jna.JnaNativeHandle;
import de.intarsys.nativec.jna.JnaNativeLibrary;
import java.util.ArrayList;
import java.util.List;

public class JnaNativeInterface
implements INativeInterface {
    private List<String> searchPaths = new ArrayList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        ClassLoader classLoader;
        ClassLoader classLoader2 = classLoader = JnaNativeInterface.class.getClassLoader();
        synchronized (classLoader2) {
            try {
                Class.forName("com.sun.jna.Native", true, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    @Override
    public void addSearchPath(String string) {
        if (this.searchPaths.contains(string)) {
            return;
        }
        this.searchPaths.add(string);
    }

    @Override
    public INativeHandle allocate(int n) {
        return new JnaNativeHandle(new FastMemory(n));
    }

    @Override
    public INativeCallback createCallback(ICallback iCallback) {
        if (iCallback == null) {
            return null;
        }
        if (iCallback.getCallingConvention() == ICallback.CallingConventionStdcall) {
            return new JnaNativeCallbackAlt(iCallback);
        }
        if (iCallback.getCallingConvention() == ICallback.CallingConventionCdecl) {
            return new JnaNativeCallbackStd(iCallback);
        }
        throw new IllegalArgumentException("illegal calling convention");
    }

    @Override
    public INativeFunction createFunction(long l) {
        Pointer pointer = new Pointer(l);
        Function function = Function.getFunction((Pointer)pointer);
        return new JnaNativeFunction(function);
    }

    @Override
    public INativeHandle createHandle(long l) {
        return new JnaNativeHandle(l);
    }

    @Override
    public INativeLibrary createLibrary(String string) {
        return new JnaNativeLibrary(this, string);
    }

    protected List<String> getSearchPaths() {
        return this.searchPaths;
    }

    @Override
    public int longSize() {
        return Native.LONG_SIZE;
    }

    @Override
    public int pointerSize() {
        return Native.POINTER_SIZE;
    }

    @Override
    public int wideCharSize() {
        return 2;
    }
}

