/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.commons.business.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.apache.commons.lang.StringUtils;
import org.pdfsam.guiclient.commons.components.JPdfSelectionTable;
import org.pdfsam.guiclient.commons.models.AbstractPdfSelectionTableModel;
import org.pdfsam.guiclient.commons.panels.JPdfSelectionPanel;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.dto.PdfSelectionTableItem;
import org.pdfsam.i18n.GettextResource;

public class SetOutputPathSelectionTableAction
extends AbstractAction {
    private static final long serialVersionUID = -7102238226761449078L;
    private final JPdfSelectionPanel selectionPanel;
    private final JTextField destinationField;
    private final String defaultOutputFileName;

    public SetOutputPathSelectionTableAction(JPdfSelectionPanel selectionPanel, JTextField destinationField, String defaultOutputFileName) {
        super(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Set destination"));
        this.setEnabled(true);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, 512));
        this.putValue("ShortDescription", GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Set the destination path"));
        this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/images/set_outfile.png")));
        this.selectionPanel = selectionPanel;
        this.destinationField = destinationField;
        this.defaultOutputFileName = defaultOutputFileName;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PdfSelectionTableItem item;
        JPdfSelectionTable mainTable = this.selectionPanel.getMainTable();
        if (mainTable.getSelectedRowCount() == 1 && (item = ((AbstractPdfSelectionTableModel)mainTable.getModel()).getRow(mainTable.getSelectedRow())) != null) {
            String defaultOutputPath = item.getInputFile().getParent();
            if (!defaultOutputPath.endsWith(File.separator)) {
                defaultOutputPath = defaultOutputPath + File.separator;
            }
            if (!StringUtils.isEmpty((String)this.defaultOutputFileName)) {
                defaultOutputPath = defaultOutputPath + this.defaultOutputFileName;
            }
            this.destinationField.setText(defaultOutputPath);
        }
    }
}

