/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.viewcontroller.ContentManager;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LocatedTransferHandler
extends TransferHandler {
    private JComponent currentDestination;
    private DropTargetAdapter destinationDropTargetListener;
    private Point dropLocation;

    @Override
    public final boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        boolean bl = this.canImportFlavor(dataFlavorArray);
        if (bl && this.currentDestination != jComponent) {
            if (this.currentDestination != null) {
                this.currentDestination.getDropTarget().removeDropTargetListener(this.destinationDropTargetListener);
            }
            try {
                this.destinationDropTargetListener = new DropTargetAdapter(){
                    private boolean acceptedDragAction;

                    public void drop(DropTargetDropEvent dropTargetDropEvent) {
                        this.removeDropTargetListener();
                    }

                    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
                        LocatedTransferHandler.this.dropLocation = dropTargetDragEvent.getLocation();
                        SwingUtilities.convertPointToScreen(LocatedTransferHandler.this.dropLocation, dropTargetDragEvent.getDropTargetContext().getComponent());
                        Component component = dropTargetDragEvent.getDropTargetContext().getComponent();
                        if (component instanceof JComponent && this.acceptDropAction(dropTargetDragEvent.getSourceActions(), dropTargetDragEvent.getDropAction())) {
                            this.acceptedDragAction = true;
                            LocatedTransferHandler.this.dragEntered((JComponent)component, dropTargetDragEvent.getTransferable(), dropTargetDragEvent.getDropAction());
                        }
                    }

                    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
                        LocatedTransferHandler.this.dropLocation = dropTargetDragEvent.getLocation();
                        SwingUtilities.convertPointToScreen(LocatedTransferHandler.this.dropLocation, dropTargetDragEvent.getDropTargetContext().getComponent());
                        Component component = dropTargetDragEvent.getDropTargetContext().getComponent();
                        if (component instanceof JComponent) {
                            if (this.acceptDropAction(dropTargetDragEvent.getSourceActions(), dropTargetDragEvent.getDropAction()) ^ this.acceptedDragAction) {
                                boolean bl = this.acceptedDragAction = !this.acceptedDragAction;
                                if (this.acceptedDragAction) {
                                    LocatedTransferHandler.this.dragEntered((JComponent)component, dropTargetDragEvent.getTransferable(), dropTargetDragEvent.getDropAction());
                                } else {
                                    LocatedTransferHandler.this.dragExited((JComponent)component);
                                }
                            }
                            if (this.acceptedDragAction) {
                                LocatedTransferHandler.this.dragMoved((JComponent)component, dropTargetDragEvent.getTransferable(), dropTargetDragEvent.getDropAction());
                            }
                        }
                    }

                    public void dragExit(DropTargetEvent dropTargetEvent) {
                        this.removeDropTargetListener();
                        Component component = dropTargetEvent.getDropTargetContext().getComponent();
                        if (component instanceof JComponent) {
                            LocatedTransferHandler.this.dragExited((JComponent)component);
                        }
                    }

                    private boolean acceptDropAction(int n, int n2) {
                        return n2 != 0 && (n & n2) == n2;
                    }

                    private void removeDropTargetListener() {
                        LocatedTransferHandler.this.currentDestination.getDropTarget().removeDropTargetListener(LocatedTransferHandler.this.destinationDropTargetListener);
                        LocatedTransferHandler.this.destinationDropTargetListener = null;
                        LocatedTransferHandler.this.currentDestination = null;
                        this.acceptedDragAction = false;
                        LocatedTransferHandler.this.dropLocation = null;
                    }
                };
                jComponent.getDropTarget().addDropTargetListener(this.destinationDropTargetListener);
                this.currentDestination = jComponent;
            }
            catch (TooManyListenersException tooManyListenersException) {
                throw new RuntimeException("Swing doesn't support multicast on DropTarget anymore!");
            }
        }
        return bl;
    }

    protected void dragEntered(JComponent jComponent, Transferable transferable, int n) {
    }

    protected void dragMoved(JComponent jComponent, Transferable transferable, int n) {
    }

    protected void dragExited(JComponent jComponent) {
    }

    protected abstract boolean canImportFlavor(DataFlavor[] var1);

    protected Point getDropLocation() {
        if (this.dropLocation != null) {
            return new Point(this.dropLocation);
        }
        throw new IllegalStateException("Operation isn't a drag and drop");
    }

    protected boolean isDrop() {
        return this.dropLocation != null;
    }

    protected List<String> getModelContents(List<File> list, ContentManager contentManager) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (File file : list) {
            String string = file.getAbsolutePath();
            if (!contentManager.isAcceptable(string, ContentManager.ContentType.MODEL)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }
}

