/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.facet.common;

import com.baselet.control.StringStyle;
import com.baselet.control.basics.XValues;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.control.enums.AlignVertical;
import com.baselet.control.enums.ElementStyle;
import com.baselet.control.enums.Priority;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.TextSplitter;
import com.baselet.element.facet.Facet;
import com.baselet.element.facet.PropertiesParserState;
import com.baselet.gui.AutocompletionText;
import java.util.Collections;
import java.util.List;

public class TextPrintFacet
extends Facet {
    public static final TextPrintFacet INSTANCE = new TextPrintFacet();

    private TextPrintFacet() {
    }

    @Override
    public boolean checkStart(String line, PropertiesParserState state) {
        return true;
    }

    @Override
    public void handleLine(String line, PropertiesParserState state) {
        DrawHandler drawer = state.getDrawer();
        drawer.setLayer(DrawHandler.Layer.Foreground);
        TextPrintFacet.setupAtFirstLine(line, drawer, state);
        if (state.getElementStyle() == ElementStyle.WORDWRAP && !line.trim().isEmpty()) {
            TextPrintFacet.printLineWithWordWrap(line, drawer, state);
        } else {
            TextPrintFacet.printLine(StringStyle.analyzeFormatLabels(StringStyle.replaceNotEscaped(line)), drawer, state);
        }
        drawer.setLayer(DrawHandler.Layer.Background);
    }

    private static void printLineWithWordWrap(String line, DrawHandler drawer, PropertiesParserState state) {
        double spaceForText = state.getXLimitsForArea(state.getTextPrintPosition(), drawer.textHeightMax(), false).getSpace() - drawer.getDistanceBorderToText() * 2.0;
        StringStyle[] wrappedLine = TextSplitter.splitStringAlgorithm(line, spaceForText, drawer, false);
        int lineIndex = 0;
        while (state.getTextPrintPosition() < (double)state.getGridElementSize().height && lineIndex < wrappedLine.length) {
            double currentSpaceForText = state.getXLimitsForArea(state.getTextPrintPosition(), drawer.textHeightMax(), false).getSpace() - drawer.getDistanceBorderToText() * 2.0;
            if (currentSpaceForText != spaceForText) {
                line = line.substring(line.indexOf(wrappedLine[lineIndex - 1].getStringWithoutMarkup()) + wrappedLine[lineIndex - 1].getStringWithoutMarkup().length()).trim();
                wrappedLine = TextSplitter.splitStringAlgorithm(line, spaceForText, drawer, false);
                lineIndex = 0;
            }
            TextPrintFacet.printLine(wrappedLine[lineIndex++], drawer, state);
        }
    }

    private static void printLine(StringStyle line, DrawHandler drawer, PropertiesParserState state) {
        XValues xLimitsForText = state.getXLimitsForArea(state.getTextPrintPosition(), drawer.textHeightMax(), false);
        Double spaceNotUsedForText = (double)state.getGridElementSize().width - xLimitsForText.getSpace();
        if (!spaceNotUsedForText.equals(Double.NaN)) {
            state.updateMinimumWidth(spaceNotUsedForText + drawer.textWidth(line));
        }
        AlignHorizontal hAlign = state.getAlignment().getHorizontal();
        drawer.print(line, TextPrintFacet.calcHorizontalTextBoundaries(xLimitsForText, drawer.getDistanceBorderToText(), hAlign), state.getTextPrintPosition(), hAlign);
        state.increaseTextPrintPosition(drawer.textHeightMaxWithSpace());
    }

    private static void setupAtFirstLine(String line, DrawHandler drawer, PropertiesParserState state) {
        boolean isFirstPrintedLine = state.getFacetResponse(TextPrintFacet.class, true);
        if (isFirstPrintedLine) {
            state.getBuffer().setTopMin(TextPrintFacet.calcStartPointFromVAlign(drawer, state));
            state.getBuffer().setTopMin(TextPrintFacet.calcTopDisplacementToFitLine(line, state, drawer));
            state.setFacetResponse(TextPrintFacet.class, false);
        }
    }

    private static double calcStartPointFromVAlign(DrawHandler drawer, PropertiesParserState state) {
        double returnVal = drawer.textHeightMax();
        returnVal = state.getElementStyle() == ElementStyle.AUTORESIZE ? (returnVal += 2.0 * drawer.getDistanceBorderToText() + state.getBuffer().getTop()) : (state.getAlignment().getVertical() == AlignVertical.TOP ? (returnVal += drawer.getDistanceBorderToText() + state.getBuffer().getTop()) : (state.getAlignment().getVertical() == AlignVertical.CENTER ? (returnVal += ((double)state.getGridElementSize().height - state.getTotalTextBlockHeight()) / 2.0 + state.getBuffer().getTop() / 2.0) : (returnVal += (double)state.getGridElementSize().height - state.getTotalTextBlockHeight() - drawer.textHeightMax() / 4.0)));
        return returnVal;
    }

    private static double calcTopDisplacementToFitLine(String firstLine, PropertiesParserState state, DrawHandler drawer) {
        boolean wordwrap;
        double displacement = state.getTextPrintPosition();
        boolean bl = wordwrap = state.getElementStyle() == ElementStyle.WORDWRAP;
        if (!wordwrap) {
            int BUFFER = 2;
            double textHeight = drawer.textHeightMax();
            double addedSpacePerIteration = textHeight / 2.0;
            double availableWidthSpace = state.getXLimitsForArea(displacement, textHeight, true).getSpace() - (double)BUFFER;
            int maxLoops = 1000;
            for (double accumulator = displacement; accumulator < (double)state.getGridElementSize().height && !TextSplitter.checkifStringFitsNoWordwrap(firstLine, availableWidthSpace, drawer); accumulator += addedSpacePerIteration) {
                if (maxLoops-- < 0) {
                    throw new RuntimeException("Endless loop during calculation of top displacement");
                }
                double previousWidthSpace = availableWidthSpace;
                availableWidthSpace = state.getXLimitsForArea(accumulator, textHeight, true).getSpace() - (double)BUFFER;
                if (!(availableWidthSpace > previousWidthSpace)) continue;
                displacement = accumulator;
            }
        }
        return displacement;
    }

    private static double calcHorizontalTextBoundaries(XValues xLimitsForText, double distanceBorderToText, AlignHorizontal hAlign) {
        double x = hAlign == AlignHorizontal.LEFT ? xLimitsForText.getLeft() + distanceBorderToText : (hAlign == AlignHorizontal.CENTER ? xLimitsForText.getSpace() / 2.0 + xLimitsForText.getLeft() : xLimitsForText.getRight() - distanceBorderToText);
        return x;
    }

    @Override
    public List<AutocompletionText> getAutocompletionStrings() {
        return Collections.emptyList();
    }

    @Override
    public Priority getPriority() {
        return Priority.LOWEST;
    }

    @Override
    public void parsingFinished(PropertiesParserState state, List<String> handledLines) {
        if (state.getElementStyle() == ElementStyle.AUTORESIZE) {
            double heightDiff = -state.getDrawer().textHeightMax();
            state.increaseTextPrintPosition(heightDiff += state.getDrawer().textHeightMax() / 2.0);
            double hSpaceLeftAndRight = state.getDrawer().getDistanceBorderToText() * 2.0;
            state.updateMinimumWidth(state.getCalculatedElementWidth() + hSpaceLeftAndRight);
        }
    }
}

