/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl.packrect;

public class Rect {
    private int x;
    private int y;
    private int w;
    private int h;

    public Rect() {
        this(0, 0, 0, 0);
    }

    public Rect(int n, int n2, int n3, int n4) {
        this.setPosition(n, n2);
        this.setSize(n3, n4);
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public int w() {
        return this.w;
    }

    public int h() {
        return this.h;
    }

    public void setPosition(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative x");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Negative y");
        }
        this.x = n;
        this.y = n2;
    }

    public void setSize(int n, int n2) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("Negative width");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Negative height");
        }
        this.w = n;
        this.h = n2;
    }

    public int maxX() {
        if (this.w() < 1) {
            return -1;
        }
        return this.x() + this.w() - 1;
    }

    public int maxY() {
        if (this.h() < 1) {
            return -1;
        }
        return this.y() + this.h() - 1;
    }

    public boolean canContain(Rect rect) {
        return this.w() >= rect.w() && this.h() >= rect.h();
    }

    public String toString() {
        return "[Rect x: " + this.x() + " y: " + this.y() + " w: " + this.w() + " h: " + this.h() + "]";
    }
}

