/*
 * Decompiled with CFR 0.152.
 */
package test;

import org.json.JSONObject;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.owasp.jbrofuzz.db.CouchDBHandler;
import org.owasp.jbrofuzz.db.CouchDBMapper;
import org.owasp.jbrofuzz.fuzz.MessageContainer;
import test.TestUtils;

public class CouchDBHandlerTest {
    private CouchDBHandler dbHandler = new CouchDBHandler();
    private String protocol = "http";
    private String host = "192.168.56.102";
    private int port = 5984;
    private long connectionId = 12L;
    private long sessionId = 12L;
    private String os = "windoof";
    private String jVersion = "1.6";
    private String timeStamp = "now";
    private String dbName = "testdb";
    private String documentId = "test1";

    @Before
    public void setUp() {
        this.dbHandler = new CouchDBHandler();
        this.dbHandler.setProtocol(this.protocol);
        this.dbHandler.setHost(this.host);
        this.dbHandler.setPort(this.port);
        this.dbHandler.createDB(this.dbName);
    }

    @Test
    public void simpleReadWriteTst() {
        MessageContainer session = null;
        MessageContainer connection = null;
        MessageContainer response = null;
        MessageContainer message = null;
        connection = TestUtils.fillConnection(connection, this.connectionId, this.sessionId);
        response = TestUtils.fillResponse(response, this.connectionId);
        message = TestUtils.fillMessage(message, this.connectionId);
        CouchDBMapper couchMapper = new CouchDBMapper();
        String doc = this.dbHandler.getDocument(this.dbName, this.documentId);
        JSONObject readDoc = new JSONObject();
        try {
            readDoc = new JSONObject(doc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        MessageContainer readSession = null;
        TestUtils.compareSessionDTOs(session, readSession);
    }

    @After
    public void cleanUp() {
        this.dbHandler.removeDB("testdb");
    }
}

