/*
 * Decompiled with CFR 0.152.
 */
package ch.csnc.extension.httpclient;

import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509KeyManager;

public class AliasKeyManager
implements X509KeyManager {
    private KeyStore _ks;
    private String _alias;
    private String _keyPassword;

    public AliasKeyManager(KeyStore keyStore, String string, String string2) {
        this._ks = keyStore;
        this._alias = string;
        this._keyPassword = string2;
    }

    @Override
    public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
        return this._alias;
    }

    @Override
    public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
        return this._alias;
    }

    @Override
    public X509Certificate[] getCertificateChain(String string) {
        try {
            Certificate[] certificateArray = this._ks.getCertificateChain(string);
            if (certificateArray == null) {
                return null;
            }
            X509Certificate[] x509CertificateArray = new X509Certificate[certificateArray.length];
            for (int i = 0; i < certificateArray.length; ++i) {
                x509CertificateArray[i] = (X509Certificate)certificateArray[i];
            }
            return x509CertificateArray;
        }
        catch (KeyStoreException keyStoreException) {
            keyStoreException.printStackTrace();
            return null;
        }
    }

    @Override
    public String[] getClientAliases(String string, Principal[] principalArray) {
        return new String[]{this._alias};
    }

    @Override
    public PrivateKey getPrivateKey(String string) {
        try {
            return (PrivateKey)this._ks.getKey(string, this._keyPassword.toCharArray());
        }
        catch (KeyStoreException keyStoreException) {
            keyStoreException.printStackTrace();
            return null;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            return null;
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            unrecoverableKeyException.printStackTrace();
            return null;
        }
    }

    @Override
    public String[] getServerAliases(String string, Principal[] principalArray) {
        return new String[]{this._alias};
    }
}

