/*
 * Decompiled with CFR 0.152.
 */
package ch.csnc.extension.httpclient;

import ch.csnc.extension.httpclient.SSLContextManager;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SSLContextManagerUnitTest {
    private SSLContextManager sslContextManager;

    @Before
    public void setUp() throws Exception {
        this.sslContextManager = new SSLContextManager();
    }

    @Test
    public void shouldReturnAvailabilityOfPKCS11Provider() {
        boolean bl = true;
        try {
            Class.forName("sun.security.pkcs11.SunPKCS11");
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                Class.forName("com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl");
            }
            catch (ClassNotFoundException classNotFoundException2) {
                bl = false;
            }
        }
        boolean bl2 = this.sslContextManager.isProviderAvailable("PKCS11");
        Assert.assertThat((Object)bl2, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)bl)));
    }

    @Test
    public void shouldReturnAvailabilityOfMsksProvider() {
        boolean bl = true;
        try {
            Class.forName("se.assembla.jce.provider.ms.MSProvider");
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
        }
        boolean bl2 = this.sslContextManager.isProviderAvailable("msks");
        Assert.assertThat((Object)bl2, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)bl)));
    }

    @Test
    public void shouldAlwaysReturnFalseForOtherThanPKCS11AndMsksProvider() {
        boolean bl = this.sslContextManager.isProviderAvailable("thisProviderDoesNotExist");
        Assert.assertThat((Object)bl, (Matcher)Matchers.is((Object)false));
    }
}

