/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.clientapi.core;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.zaproxy.clientapi.core.Alert;

public class AlertsFile {
    public static void saveAlertsToFile(List<Alert> list, List<Alert> list2, List<Alert> list3, File file) throws JDOMException, IOException {
        Element element;
        Element element2 = new Element("alerts");
        Document document = new Document(element2);
        document.setRootElement(element2);
        if (list2.size() > 0) {
            element = new Element("alertsFound");
            element.setAttribute("alertsFound", Integer.toString(list2.size()));
            for (Alert alert : list2) {
                AlertsFile.createAlertXMLElements(element, alert);
            }
            document.getRootElement().addContent((Content)element);
        }
        if (list.size() > 0) {
            element = new Element("alertsNotFound");
            element.setAttribute("alertsNotFound", Integer.toString(list.size()));
            for (Alert alert : list) {
                AlertsFile.createAlertXMLElements(element, alert);
            }
            document.getRootElement().addContent((Content)element);
        }
        if (list3.size() > 0) {
            element = new Element("ignoredAlertsFound");
            element.setAttribute("ignoredAlertsFound", Integer.toString(list3.size()));
            for (Alert alert : list3) {
                AlertsFile.createAlertXMLElements(element, alert);
            }
            document.getRootElement().addContent((Content)element);
        }
        AlertsFile.writeAlertsToFile(file, document);
    }

    private static void writeAlertsToFile(File file, Document document) {
        XMLOutputter xMLOutputter = new XMLOutputter();
        xMLOutputter.setFormat(Format.getPrettyFormat());
        try {
            xMLOutputter.output(document, (Writer)new FileWriter(file));
            System.out.println("alert xml report saved to: " + file.getAbsolutePath());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static void createAlertXMLElements(Element element, Alert alert) {
        Element element2 = new Element("alert");
        if (alert.getAlert() != null) {
            element2.setAttribute("alert", alert.getAlert());
        }
        if (alert.getRisk() != null) {
            element2.setAttribute("risk", alert.getRisk().name());
        }
        if (alert.getUrl() != null) {
            element2.setAttribute("confidence", alert.getConfidence().name());
        }
        if (alert.getUrl() != null) {
            element2.setAttribute("url", alert.getUrl());
        }
        if (alert.getParam() != null) {
            element2.setAttribute("param", alert.getParam());
        }
        if (alert.getOther() != null) {
            element2.setAttribute("other", alert.getOther());
        }
        if (alert.getAttack() != null) {
            element2.setAttribute("attack", alert.getAttack());
        }
        if (alert.getDescription() != null) {
            element2.setAttribute("description", alert.getDescription());
        }
        if (alert.getSolution() != null) {
            element2.setAttribute("solution", alert.getSolution());
        }
        if (alert.getReference() != null) {
            element2.setAttribute("reference", alert.getReference());
        }
        element.addContent((Content)element2);
    }

    public static List<Alert> getAlertsFromFile(File file, String string) throws JDOMException, IOException {
        ArrayList<Alert> arrayList = new ArrayList<Alert>();
        SAXBuilder sAXBuilder = new SAXBuilder();
        Document document = sAXBuilder.build(file);
        List list = document.getRootElement().getChildren(string);
        for (Element element : list) {
            Alert alert = new Alert(element.getAttributeValue("alert"), element.getAttributeValue("url"), element.getAttributeValue("risk"), element.getAttributeValue("confidence"), element.getAttributeValue("param"), element.getAttributeValue("other"));
            arrayList.add(alert);
        }
        return arrayList;
    }
}

