/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.clientapi.core;

import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Node;
import org.zaproxy.clientapi.core.ApiResponse;
import org.zaproxy.clientapi.core.ApiResponseElement;
import org.zaproxy.clientapi.core.ApiResponseFactory;
import org.zaproxy.clientapi.core.ClientApiException;

public class ApiResponseSet
extends ApiResponse {
    private String[] attributes = null;
    private Map<String, String> values = null;

    public ApiResponseSet(String string, String[] stringArray) {
        super(string);
        this.attributes = stringArray;
    }

    public ApiResponseSet(String string, Map<String, String> map) {
        super(string);
        this.values = map;
    }

    public ApiResponseSet(Node node) throws ClientApiException {
        super(node.getNodeName());
        this.values = new HashMap<String, String>();
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            ApiResponseElement apiResponseElement = (ApiResponseElement)ApiResponseFactory.getResponse(node2);
            this.values.put(apiResponseElement.getName(), apiResponseElement.getValue());
        }
    }

    public String[] getAttributes() {
        return this.attributes;
    }

    public String getAttribute(String string) {
        return this.values.get(string);
    }

    @Override
    public String toString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("\t");
        }
        stringBuilder.append("ApiResponseSet ");
        stringBuilder.append(this.getName());
        stringBuilder.append(" : [\n");
        for (Map.Entry<String, String> entry : this.values.entrySet()) {
            for (int i = 0; i < n + 1; ++i) {
                stringBuilder.append("\t");
            }
            stringBuilder.append(entry.getKey());
            stringBuilder.append(" = ");
            stringBuilder.append(entry.getValue());
            stringBuilder.append("\n");
        }
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("\t");
        }
        stringBuilder.append("]\n");
        return stringBuilder.toString();
    }
}

