/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.db.sql;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.parosproxy.paros.db.DatabaseServer;
import org.zaproxy.zap.db.sql.DbSQL;
import org.zaproxy.zap.db.sql.SqlDatabaseServer;

public class HsqldbDatabaseServer
extends SqlDatabaseServer
implements DatabaseServer {
    public static final int DEFAULT_SERVER_PORT = 9001;
    private static final Logger logger = Logger.getLogger(HsqldbDatabaseServer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HsqldbDatabaseServer(String string) throws ClassNotFoundException, Exception {
        super(string);
        string = string.replaceAll("\\\\", "/");
        boolean bl = false;
        File file = new File(string + ".properties");
        if (file.exists()) {
            Properties properties = new Properties();
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
            }
            finally {
                block12: {
                    try {
                        if (fileInputStream != null) {
                            ((InputStream)fileInputStream).close();
                        }
                    }
                    catch (IOException iOException) {
                        if (!logger.isDebugEnabled()) break block12;
                        logger.debug((Object)iOException.getMessage(), (Throwable)iOException);
                    }
                }
            }
            String string2 = (String)properties.get("version");
            if (string2.charAt(0) < '2') {
                bl = true;
            }
        }
        this.setDbUrl("jdbc:hsqldb:file:" + string);
        this.setDbUser(DbSQL.getSingleton().getDbUser());
        this.setDbPassword(DbSQL.getSingleton().getDbPassword());
        if (bl) {
            this.shutdown(true);
        }
    }

    @Override
    void shutdown(boolean bl) throws SQLException {
        super.shutdown(bl);
        Connection connection = this.getNewConnection();
        CallableStatement callableStatement = null;
        callableStatement = bl ? connection.prepareCall("SHUTDOWN COMPACT") : connection.prepareCall("SHUTDOWN");
        callableStatement.execute();
        callableStatement.close();
        connection.close();
    }
}

