/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ascan;

import java.util.Date;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.HostProcess;
import org.parosproxy.paros.core.scanner.Plugin;

public class ScanProgressItem {
    public static final int STATUS_PENDING = 1;
    public static final int STATUS_RUNNING = 2;
    public static final int STATUS_COMPLETED = 3;
    private HostProcess hProcess;
    private Plugin plugin;
    private int status;

    public ScanProgressItem(HostProcess hostProcess, Plugin plugin, int n) {
        this.hProcess = hostProcess;
        this.plugin = plugin;
        this.status = n;
    }

    public String getNameLabel() {
        return this.plugin.getName();
    }

    public String getAttackStrenghtLabel() {
        return Constant.messages.getString("ascan.policy.level." + this.plugin.getAttackStrength().name().toLowerCase());
    }

    public String getStatusLabel() {
        switch (this.status) {
            case 3: {
                return Constant.messages.getString("ascan.progress.label.completed");
            }
            case 2: {
                return Constant.messages.getString("ascan.progress.label.running");
            }
            case 1: {
                return Constant.messages.getString("ascan.progress.label.pending");
            }
        }
        return "";
    }

    public long getElapsedTime() {
        if (this.status == 1 || this.plugin.getTimeStarted() == null) {
            return -1L;
        }
        Date date = this.plugin.getTimeFinished() == null ? new Date() : this.plugin.getTimeFinished();
        return date.getTime() - this.plugin.getTimeStarted().getTime();
    }

    public int getProgressPercentage() {
        if (this.isRunning()) {
            return this.hProcess.getTestCurrentCount(this.plugin) * 100 / this.hProcess.getTestTotalCount();
        }
        if (this.isCompleted()) {
            return 100;
        }
        return 0;
    }

    public boolean isRunning() {
        return this.status == 2;
    }

    public boolean isCompleted() {
        return this.status == 3;
    }

    public boolean isSkipped() {
        return this.hProcess.isSkipped(this.plugin);
    }

    public void skip() {
        if (this.isRunning()) {
            this.hProcess.pluginSkipped(this.plugin);
        }
    }

    protected Plugin getPlugin() {
        return this.plugin;
    }

    public int getReqCount() {
        return this.hProcess.getPluginRequestCount(this.plugin.getId());
    }
}

