/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.history;

import java.util.List;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.SiteMap;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.alert.ExtensionAlert;
import org.zaproxy.zap.view.messagecontainer.http.HttpMessageContainer;
import org.zaproxy.zap.view.popup.PopupMenuItemHttpMessageContainer;
import org.zaproxy.zap.view.popup.PopupMenuItemSiteNodeContainer;

public class PopupMenuPurgeSites
extends PopupMenuItemSiteNodeContainer {
    private static final long serialVersionUID = 4827464631678110752L;
    private static final Logger logger = Logger.getLogger(PopupMenuPurgeSites.class);

    public PopupMenuPurgeSites() {
        super(Constant.messages.getString("sites.purge.popup"), true);
    }

    @Override
    public boolean isEnableForInvoker(PopupMenuItemHttpMessageContainer.Invoker invoker, HttpMessageContainer httpMessageContainer) {
        return invoker == PopupMenuItemHttpMessageContainer.Invoker.SITES_PANEL;
    }

    @Override
    public boolean isButtonEnabledForSiteNode(SiteNode siteNode) {
        return !siteNode.isRoot() || siteNode.getChildCount() != 0;
    }

    @Override
    public void performHistoryReferenceActions(List<HistoryReference> list) {
        int n;
        if (list.size() > 0 && (n = View.getSingleton().showConfirmDialog(Constant.messages.getString("sites.purge.warning"))) != 0) {
            return;
        }
        super.performHistoryReferenceActions(list);
    }

    @Override
    public void performAction(SiteNode siteNode) {
        PopupMenuPurgeSites.purge(Model.getSingleton().getSession().getSiteTree(), siteNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void purge(SiteMap siteMap, SiteNode siteNode) {
        SiteNode siteNode2 = null;
        SiteMap siteMap2 = siteMap;
        synchronized (siteMap2) {
            while (siteNode.getChildCount() > 0) {
                try {
                    siteNode2 = (SiteNode)siteNode.getChildAt(0);
                    PopupMenuPurgeSites.purge(siteMap, siteNode2);
                }
                catch (Exception exception) {
                    logger.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
            if (siteNode.isRoot()) {
                return;
            }
            ExtensionHistory extensionHistory = (ExtensionHistory)Control.getSingleton().getExtensionLoader().getExtension("ExtensionHistory");
            extensionHistory.removeFromHistoryList(siteNode.getHistoryReference());
            extensionHistory.clearLogPanelDisplayQueue();
            ExtensionAlert extensionAlert = (ExtensionAlert)Control.getSingleton().getExtensionLoader().getExtension("ExtensionAlert");
            if (siteNode.getHistoryReference() != null) {
                PopupMenuPurgeSites.deleteAlertsFromExtensionAlert(extensionAlert, siteNode.getHistoryReference());
                siteNode.getHistoryReference().delete();
                siteMap.removeHistoryReference(siteNode.getHistoryReference().getHistoryId());
            }
            while (siteNode.getPastHistoryReference().size() > 0) {
                HistoryReference historyReference = siteNode.getPastHistoryReference().get(0);
                PopupMenuPurgeSites.deleteAlertsFromExtensionAlert(extensionAlert, historyReference);
                extensionHistory.removeFromHistoryList(historyReference);
                extensionHistory.clearLogPanelDisplayQueue();
                extensionHistory.delete(historyReference);
                siteNode.getPastHistoryReference().remove(0);
                siteMap.removeHistoryReference(historyReference.getHistoryId());
            }
            siteMap.removeNodeFromParent(siteNode);
        }
    }

    private static void deleteAlertsFromExtensionAlert(ExtensionAlert extensionAlert, HistoryReference historyReference) {
        if (extensionAlert == null) {
            return;
        }
        extensionAlert.deleteHistoryReferenceAlerts(historyReference);
    }

    @Override
    public boolean isSafe() {
        return true;
    }
}

