/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteNode;
import org.zaproxy.zap.extension.alert.AlertNode;
import org.zaproxy.zap.view.HistoryReferenceTable;
import org.zaproxy.zap.view.table.HistoryReferencesTable;

@Deprecated
public abstract class PopupMenuHistoryReference
extends ExtensionPopupMenuItem {
    private static final long serialVersionUID = 1L;
    private JTree treeInvoker = null;
    private HistoryReferencesTable hrefsTableInvoker = null;
    private HistoryReferenceTable hrefTableInvoker = null;
    private Invoker lastInvoker = null;
    private boolean multiSelect = false;
    private static final Logger log = Logger.getLogger(PopupMenuHistoryReference.class);

    public PopupMenuHistoryReference(String string) {
        this(string, false);
    }

    public PopupMenuHistoryReference(String string, boolean bl) {
        super(string);
        this.setText(string);
        this.multiSelect = bl;
        this.initialize();
    }

    protected Invoker getLastInvoker() {
        return this.lastInvoker;
    }

    protected void initialize() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                log.debug((Object)("actionPerformed " + PopupMenuHistoryReference.this.lastInvoker.name() + " " + actionEvent.getActionCommand()));
                try {
                    if (PopupMenuHistoryReference.this.multiSelect) {
                        PopupMenuHistoryReference.this.performActions(PopupMenuHistoryReference.this.getSelectedHistoryReferences());
                    } else {
                        HistoryReference historyReference = PopupMenuHistoryReference.this.getSelectedHistoryReference();
                        if (historyReference != null) {
                            try {
                                PopupMenuHistoryReference.this.performAction(historyReference);
                            }
                            catch (Exception exception) {
                                log.error((Object)exception.getMessage(), (Throwable)exception);
                            }
                        } else {
                            log.error((Object)("PopupMenuHistoryReference invoker " + (Object)((Object)PopupMenuHistoryReference.this.lastInvoker) + " failed to get history ref"));
                        }
                    }
                }
                catch (Exception exception) {
                    log.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
        });
    }

    private HistoryReference getSelectedHistoryReference() {
        Object var1_1 = null;
        HistoryReference historyReference = null;
        try {
            switch (this.lastInvoker) {
                case sites: {
                    SiteNode siteNode = (SiteNode)this.treeInvoker.getLastSelectedPathComponent();
                    historyReference = siteNode.getHistoryReference();
                    break;
                }
                case ascan: 
                case history: 
                case bruteforce: 
                case search: 
                case fuzz: {
                    historyReference = this.hrefsTableInvoker.getSelectedHistoryReference();
                    break;
                }
                case alerts: {
                    AlertNode alertNode = (AlertNode)this.treeInvoker.getLastSelectedPathComponent();
                    if (alertNode.getUserObject() == null) break;
                    Alert alert = alertNode.getUserObject();
                    historyReference = alert.getHistoryRef();
                    break;
                }
                case hreftable: {
                    historyReference = this.hrefTableInvoker.getSelectedValue();
                }
            }
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
        }
        return historyReference;
    }

    private List<HistoryReference> getSelectedHistoryReferences() {
        List<HistoryReference> list = new ArrayList<HistoryReference>();
        TreePath[] treePathArray = null;
        Object var3_3 = null;
        Object var4_4 = null;
        try {
            switch (this.lastInvoker) {
                case sites: {
                    treePathArray = this.treeInvoker.getSelectionPaths();
                    if (treePathArray == null) break;
                    for (TreePath treePath : treePathArray) {
                        SiteNode siteNode = (SiteNode)treePath.getLastPathComponent();
                        list.add(siteNode.getHistoryReference());
                    }
                    break;
                }
                case ascan: 
                case history: 
                case bruteforce: 
                case search: 
                case fuzz: {
                    list = this.hrefsTableInvoker.getSelectedHistoryReferences();
                    break;
                }
                case alerts: {
                    AlertNode alertNode = (AlertNode)this.treeInvoker.getLastSelectedPathComponent();
                    if (alertNode.getUserObject() == null) break;
                    Alert alert = alertNode.getUserObject();
                    list.add(alert.getHistoryRef());
                    break;
                }
                case hreftable: {
                    list = this.hrefTableInvoker.getSelectedValues();
                }
            }
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
        }
        return list;
    }

    @Override
    public boolean isEnableForComponent(Component component) {
        Object object;
        boolean bl = false;
        if (component.getName() == null) {
            return false;
        }
        if (component.getName().equals("History Table")) {
            this.lastInvoker = Invoker.history;
            this.hrefsTableInvoker = (HistoryReferencesTable)((Object)component);
            this.setEnabled(this.isEnabledForHistoryReferences(this.getSelectedHistoryReferences()));
            bl = true;
        } else if (component instanceof JTree && component.getName().equals("treeSite")) {
            this.lastInvoker = Invoker.sites;
            this.treeInvoker = (JTree)component;
            this.setEnabled(this.isEnabledForHistoryReferences(this.getSelectedHistoryReferences()));
            bl = true;
        } else if (component.getName().equals("treeAlert")) {
            this.lastInvoker = Invoker.alerts;
            this.treeInvoker = (JTree)component;
            JTree jTree = (JTree)component;
            if (jTree.getLastSelectedPathComponent() != null) {
                if (jTree.getSelectionCount() > 1) {
                    this.setEnabled(false);
                } else {
                    object = (DefaultMutableTreeNode)jTree.getLastSelectedPathComponent();
                    if (!((DefaultMutableTreeNode)object).isRoot() && ((DefaultMutableTreeNode)object).getUserObject() != null) {
                        this.setEnabled(this.isEnabledForHistoryReference(this.getSelectedHistoryReferences().get(0)));
                    } else {
                        this.setEnabled(false);
                    }
                }
            }
            bl = true;
        } else if (component.getName().equals("SearchHttpMessageContainer")) {
            this.lastInvoker = Invoker.search;
            this.hrefsTableInvoker = (HistoryReferencesTable)((Object)component);
            this.setEnabled(this.isEnabledForHistoryReferences(this.getSelectedHistoryReferences()));
            bl = true;
        } else if (component.getName().equals("ActiveScanMessageContainer")) {
            this.lastInvoker = Invoker.ascan;
            this.hrefsTableInvoker = (HistoryReferencesTable)((Object)component);
            this.setEnabled(this.isEnabledForHistoryReferences(this.getSelectedHistoryReferences()));
            bl = true;
        } else if (component.getName().equals("HttpFuzzerResultsContentPanel")) {
            this.lastInvoker = Invoker.fuzz;
            this.hrefsTableInvoker = (HistoryReferencesTable)((Object)component);
            this.setEnabled(this.isEnabledForHistoryReferences(this.getSelectedHistoryReferences()));
            bl = true;
        } else if (component.getName().equals("ForcedBrowseMessageContainer")) {
            this.lastInvoker = Invoker.bruteforce;
            this.hrefsTableInvoker = (HistoryReferencesTable)((Object)component);
            this.setEnabled(this.isEnabledForHistoryReferences(this.getSelectedHistoryReferences()));
            bl = true;
        } else if (component instanceof HistoryReferenceTable) {
            this.lastInvoker = Invoker.hreftable;
            this.hrefTableInvoker = (HistoryReferenceTable)component;
            this.setEnabled(this.isEnabledForHistoryReferences(this.getSelectedHistoryReferences()));
            bl = true;
        }
        if (bl) {
            if (this.isEnabled() && !this.isSafe() && Control.getSingleton().getMode().equals((Object)Control.Mode.protect)) {
                boolean bl2 = true;
                object = Model.getSingleton().getSession();
                for (HistoryReference historyReference : this.getSelectedHistoryReferences()) {
                    if (((Session)object).isInScope(historyReference)) continue;
                    bl2 = false;
                    break;
                }
                if (!bl2) {
                    this.setEnabled(false);
                }
            }
            return this.isEnableForInvoker(this.lastInvoker);
        }
        return false;
    }

    public boolean isEnabledForHistoryReferences(List<HistoryReference> list) {
        if (list.size() == 0) {
            return false;
        }
        if (list.size() > 1 && !this.multiSelect) {
            return false;
        }
        for (HistoryReference historyReference : list) {
            if (this.isEnabledForHistoryReference(historyReference)) continue;
            return false;
        }
        return true;
    }

    public boolean isEnabledForHistoryReference(HistoryReference historyReference) {
        return historyReference != null && historyReference.getHistoryType() != 0;
    }

    public void performActions(List<HistoryReference> list) throws Exception {
        for (HistoryReference historyReference : list) {
            this.performAction(historyReference);
        }
    }

    public abstract void performAction(HistoryReference var1) throws Exception;

    public abstract boolean isEnableForInvoker(Invoker var1);

    public static enum Invoker {
        sites,
        history,
        alerts,
        ascan,
        search,
        fuzz,
        bruteforce,
        hreftable;

    }
}

