/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec;

import java.io.IOException;
import java.math.BigInteger;
import java.security.spec.ECField;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import sun.security.util.DerOutputStream;
import sun.security.util.ObjectIdentifier;

public final class NamedCurve
extends ECParameterSpec {
    private final String name;
    private final ObjectIdentifier oid;
    private final byte[] encoded;
    private static final Map<String, NamedCurve> oidMap = new LinkedHashMap<String, NamedCurve>();
    private static final Map<String, NamedCurve> nameMap = new HashMap<String, NamedCurve>();
    private static final Map<Integer, NamedCurve> lengthMap = new HashMap<Integer, NamedCurve>();
    private static Pattern SPLIT_PATTERN = Pattern.compile(",|\\[|\\]");
    private static final int P = 1;
    private static final int B = 2;
    private static final int PD = 5;
    private static final int BD = 6;

    private NamedCurve(String name, ObjectIdentifier oid, EllipticCurve curve, ECPoint g, BigInteger n, int h) throws IOException {
        super(curve, g, n, h);
        this.name = name;
        this.oid = oid;
        DerOutputStream out = new DerOutputStream();
        out.putOID(oid);
        this.encoded = out.toByteArray();
    }

    public static ECParameterSpec getECParameterSpec(String name) {
        NamedCurve spec = oidMap.get(name);
        return spec != null ? spec : nameMap.get(name);
    }

    static ECParameterSpec getECParameterSpec(ObjectIdentifier oid) {
        return NamedCurve.getECParameterSpec(oid.toString());
    }

    public static ECParameterSpec getECParameterSpec(int length) {
        return lengthMap.get(length);
    }

    public static Collection<? extends ECParameterSpec> knownECParameterSpecs() {
        return Collections.unmodifiableCollection(oidMap.values());
    }

    byte[] getEncoded() {
        return (byte[])this.encoded.clone();
    }

    ObjectIdentifier getObjectIdentifier() {
        return this.oid;
    }

    public String toString() {
        return this.name + " (" + this.oid + ")";
    }

    private static BigInteger bi(String s) {
        return new BigInteger(s, 16);
    }

    private static void add(String name, String soid, int type, String sfield, String a, String b, String x, String y, String n, int h) {
        ECField field;
        BigInteger p = NamedCurve.bi(sfield);
        if (type == 1 || type == 5) {
            field = new ECFieldFp(p);
        } else if (type == 2 || type == 6) {
            field = new ECFieldF2m(p.bitLength() - 1, p);
        } else {
            throw new RuntimeException("Invalid type: " + type);
        }
        EllipticCurve curve = new EllipticCurve(field, NamedCurve.bi(a), NamedCurve.bi(b));
        ECPoint g = new ECPoint(NamedCurve.bi(x), NamedCurve.bi(y));
        try {
            String[] commonNames;
            ObjectIdentifier oid = new ObjectIdentifier(soid);
            NamedCurve params = new NamedCurve(name, oid, curve, g, NamedCurve.bi(n), h);
            if (oidMap.put(soid, params) != null) {
                throw new RuntimeException("Duplication oid: " + soid);
            }
            for (String commonName : commonNames = SPLIT_PATTERN.split(name)) {
                if (nameMap.put(commonName.trim(), params) == null) continue;
                throw new RuntimeException("Duplication name: " + commonName);
            }
            int len = field.getFieldSize();
            if (type == 5 || type == 6 || lengthMap.get(len) == null) {
                lengthMap.put(len, params);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Internal error", e);
        }
    }

    static {
        NamedCurve.add("secp256r1 [NIST P-256, X9.62 prime256v1]", "1.2.840.10045.3.1.7", 5, "FFFFFFFF00000001000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF", "FFFFFFFF00000001000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFC", "5AC635D8AA3A93E7B3EBBD55769886BC651D06B0CC53B0F63BCE3C3E27D2604B", "6B17D1F2E12C4247F8BCE6E563A440F277037D812DEB33A0F4A13945D898C296", "4FE342E2FE1A7F9B8EE7EB4A7C0F9E162BCE33576B315ECECBB6406837BF51F5", "FFFFFFFF00000000FFFFFFFFFFFFFFFFBCE6FAADA7179E84F3B9CAC2FC632551", 1);
        NamedCurve.add("secp384r1 [NIST P-384]", "1.3.132.0.34", 5, "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFF0000000000000000FFFFFFFF", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFF0000000000000000FFFFFFFC", "B3312FA7E23EE7E4988E056BE3F82D19181D9C6EFE8141120314088F5013875AC656398D8A2ED19D2A85C8EDD3EC2AEF", "AA87CA22BE8B05378EB1C71EF320AD746E1D3B628BA79B9859F741E082542A385502F25DBF55296C3A545E3872760AB7", "3617DE4A96262C6F5D9E98BF9292DC29F8F41DBD289A147CE9DA3113B5F0B8C00A60B1CE1D7E819D7A431D7C90EA0E5F", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC7634D81F4372DDF581A0DB248B0A77AECEC196ACCC52973", 1);
        NamedCurve.add("secp521r1 [NIST P-521]", "1.3.132.0.35", 5, "01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC", "0051953EB9618E1C9A1F929A21A0B68540EEA2DA725B99B315F3B8B489918EF109E156193951EC7E937B1652C0BD3BB1BF073573DF883D2C34F1EF451FD46B503F00", "00C6858E06B70404E9CD9E3ECB662395B4429C648139053FB521F828AF606B4D3DBAA14B5E77EFE75928FE1DC127A2FFA8DE3348B3C1856A429BF97E7E31C2E5BD66", "011839296A789A3BC0045C8A5FB42C7D1BD998F54449579B446817AFBD17273E662C97EE72995EF42640C550B9013FAD0761353C7086A272C24088BE94769FD16650", "01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFA51868783BF2F966B7FCC0148F709A5D03BB5C9B8899C47AEBB6FB71E91386409", 1);
        SPLIT_PATTERN = null;
    }
}

