/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.termvectors;

import com.carrotsearch.hppc.IntArrayList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.single.shard.SingleShardRequest;
import org.elasticsearch.action.termvectors.MultiTermVectorsRequest;
import org.elasticsearch.action.termvectors.TermVectorsRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class MultiTermVectorsShardRequest
extends SingleShardRequest<MultiTermVectorsShardRequest> {
    private int shardId;
    private String preference;
    IntArrayList locations;
    List<TermVectorsRequest> requests;

    MultiTermVectorsShardRequest() {
    }

    MultiTermVectorsShardRequest(MultiTermVectorsRequest request, String index, int shardId) {
        super(request, index);
        this.shardId = shardId;
        this.locations = new IntArrayList();
        this.requests = new ArrayList<TermVectorsRequest>();
    }

    @Override
    public ActionRequestValidationException validate() {
        return super.validateNonNullIndex();
    }

    public int shardId() {
        return this.shardId;
    }

    public MultiTermVectorsShardRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    public String preference() {
        return this.preference;
    }

    public void add(int location, TermVectorsRequest request) {
        this.locations.add(location);
        this.requests.add(request);
    }

    @Override
    public String[] indices() {
        String[] indices = new String[this.requests.size()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = this.requests.get(i).index();
        }
        return indices;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        this.locations = new IntArrayList(size);
        this.requests = new ArrayList<TermVectorsRequest>(size);
        for (int i = 0; i < size; ++i) {
            this.locations.add(in.readVInt());
            this.requests.add(TermVectorsRequest.readTermVectorsRequest(in));
        }
        this.preference = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.locations.size());
        for (int i = 0; i < this.locations.size(); ++i) {
            out.writeVInt(this.locations.get(i));
            this.requests.get(i).writeTo(out);
        }
        out.writeOptionalString(this.preference);
    }
}

