/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import com.carrotsearch.hppc.ObjectHashSet;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.DelegatingAnalyzerWrapper;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.TermsQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ReleasableLock;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.DocumentMapperForType;
import org.elasticsearch.index.mapper.DocumentMapperParser;
import org.elasticsearch.index.mapper.DocumentTypeListener;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldTypeLookup;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperUtils;
import org.elasticsearch.index.mapper.MergeResult;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.object.ObjectMapper;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.similarity.SimilarityLookupService;
import org.elasticsearch.indices.InvalidTypeNameException;
import org.elasticsearch.indices.TypeMissingException;
import org.elasticsearch.indices.mapper.MapperRegistry;
import org.elasticsearch.script.ScriptService;

public class MapperService
extends AbstractIndexComponent
implements Closeable {
    public static final String DEFAULT_MAPPING = "_default_";
    private static ObjectHashSet<String> META_FIELDS = ObjectHashSet.from((Object[])new String[]{"_uid", "_id", "_type", "_all", "_parent", "_routing", "_index", "_size", "_timestamp", "_ttl"});
    private static final Function<MappedFieldType, Analyzer> INDEX_ANALYZER_EXTRACTOR = new Function<MappedFieldType, Analyzer>(){

        public Analyzer apply(MappedFieldType fieldType) {
            return fieldType.indexAnalyzer();
        }
    };
    private static final Function<MappedFieldType, Analyzer> SEARCH_ANALYZER_EXTRACTOR = new Function<MappedFieldType, Analyzer>(){

        public Analyzer apply(MappedFieldType fieldType) {
            return fieldType.searchAnalyzer();
        }
    };
    private static final Function<MappedFieldType, Analyzer> SEARCH_QUOTE_ANALYZER_EXTRACTOR = new Function<MappedFieldType, Analyzer>(){

        public Analyzer apply(MappedFieldType fieldType) {
            return fieldType.searchQuoteAnalyzer();
        }
    };
    private final Settings indexSettings;
    private final AnalysisService analysisService;
    private final boolean dynamic;
    private volatile String defaultMappingSource;
    private volatile String defaultPercolatorMappingSource;
    private volatile Map<String, DocumentMapper> mappers = ImmutableMap.of();
    final ReentrantReadWriteLock mappingLock = new ReentrantReadWriteLock();
    private final ReleasableLock mappingWriteLock = new ReleasableLock(this.mappingLock.writeLock());
    private volatile FieldTypeLookup fieldTypes;
    private volatile ImmutableOpenMap<String, ObjectMapper> fullPathObjectMappers = ImmutableOpenMap.of();
    private boolean hasNested = false;
    private final DocumentMapperParser documentParser;
    private final MapperAnalyzerWrapper indexAnalyzer;
    private final MapperAnalyzerWrapper searchAnalyzer;
    private final MapperAnalyzerWrapper searchQuoteAnalyzer;
    private final List<DocumentTypeListener> typeListeners = new CopyOnWriteArrayList<DocumentTypeListener>();
    private volatile ImmutableMap<String, MappedFieldType> unmappedFieldTypes = ImmutableMap.of();
    private volatile ImmutableSet<String> parentTypes = ImmutableSet.of();
    final MapperRegistry mapperRegistry;
    private static final Predicate<DocumentMapper> NOT_A_DEFAULT_DOC_MAPPER = new Predicate<DocumentMapper>(){

        public boolean apply(DocumentMapper input) {
            return !MapperService.DEFAULT_MAPPING.equals(input.type());
        }
    };

    @Inject
    public MapperService(Index index, IndexSettingsService indexSettingsService, AnalysisService analysisService, SimilarityLookupService similarityLookupService, ScriptService scriptService, MapperRegistry mapperRegistry) {
        this(index, indexSettingsService.getSettings(), analysisService, similarityLookupService, scriptService, mapperRegistry);
    }

    public MapperService(Index index, Settings indexSettings, AnalysisService analysisService, SimilarityLookupService similarityLookupService, ScriptService scriptService, MapperRegistry mapperRegistry) {
        super(index, indexSettings);
        this.indexSettings = indexSettings;
        this.analysisService = analysisService;
        this.mapperRegistry = mapperRegistry;
        this.fieldTypes = new FieldTypeLookup();
        this.documentParser = new DocumentMapperParser(indexSettings, this, analysisService, similarityLookupService, scriptService, mapperRegistry);
        this.indexAnalyzer = new MapperAnalyzerWrapper((Analyzer)analysisService.defaultIndexAnalyzer(), INDEX_ANALYZER_EXTRACTOR);
        this.searchAnalyzer = new MapperAnalyzerWrapper((Analyzer)analysisService.defaultSearchAnalyzer(), SEARCH_ANALYZER_EXTRACTOR);
        this.searchQuoteAnalyzer = new MapperAnalyzerWrapper((Analyzer)analysisService.defaultSearchQuoteAnalyzer(), SEARCH_QUOTE_ANALYZER_EXTRACTOR);
        this.dynamic = indexSettings.getAsBoolean("index.mapper.dynamic", (Boolean)true);
        this.defaultPercolatorMappingSource = "{\n\"_default_\":{\n\"properties\" : {\n\"query\" : {\n\"type\" : \"object\",\n\"enabled\" : false\n}\n}\n}\n}";
        this.defaultMappingSource = index.getName().equals(".scripts") ? "{\"_default_\": {\"properties\": {\"script\": { \"enabled\": false },\"template\": { \"enabled\": false }}}}" : "{\"_default_\":{}}";
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("using dynamic[{}], default mapping source[{}], default percolator mapping source[{}]", this.dynamic, this.defaultMappingSource, this.defaultPercolatorMappingSource);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("using dynamic[{}]", this.dynamic);
        }
    }

    @Override
    public void close() {
        for (DocumentMapper documentMapper : this.mappers.values()) {
            documentMapper.close();
        }
    }

    public boolean hasNested() {
        return this.hasNested;
    }

    public Iterable<DocumentMapper> docMappers(final boolean includingDefaultMapping) {
        return new Iterable<DocumentMapper>(){

            @Override
            public Iterator<DocumentMapper> iterator() {
                UnmodifiableIterator iterator = includingDefaultMapping ? MapperService.this.mappers.values().iterator() : Iterators.filter(MapperService.this.mappers.values().iterator(), (Predicate)NOT_A_DEFAULT_DOC_MAPPER);
                return Iterators.unmodifiableIterator((Iterator)iterator);
            }
        };
    }

    public AnalysisService analysisService() {
        return this.analysisService;
    }

    public DocumentMapperParser documentMapperParser() {
        return this.documentParser;
    }

    public void addTypeListener(DocumentTypeListener listener) {
        this.typeListeners.add(listener);
    }

    public void removeTypeListener(DocumentTypeListener listener) {
        this.typeListeners.remove(listener);
    }

    public DocumentMapper merge(String type, CompressedXContent mappingSource, boolean applyDefault, boolean updateAllTypes) {
        if (DEFAULT_MAPPING.equals(type)) {
            DocumentMapper mapper = this.documentParser.parseCompressed(type, mappingSource);
            try (ReleasableLock lock = this.mappingWriteLock.acquire();){
                this.mappers = MapBuilder.newMapBuilder(this.mappers).put(type, mapper).map();
            }
            try {
                this.defaultMappingSource = mappingSource.string();
            }
            catch (IOException e) {
                throw new ElasticsearchGenerationException("failed to un-compress", e);
            }
            return mapper;
        }
        return this.merge(this.parse(type, mappingSource, applyDefault), updateAllTypes);
    }

    private DocumentMapper merge(DocumentMapper mapper, boolean updateAllTypes) {
        try (ReleasableLock lock = this.mappingWriteLock.acquire();){
            DocumentMapper oldMapper;
            if (mapper.type().length() == 0) {
                throw new InvalidTypeNameException("mapping type name is empty");
            }
            if (Version.indexCreated(this.indexSettings).onOrAfter(Version.V_2_0_0_beta1) && mapper.type().length() > 255) {
                throw new InvalidTypeNameException("mapping type name [" + mapper.type() + "] is too long; limit is length 255 but was [" + mapper.type().length() + "]");
            }
            if (mapper.type().charAt(0) == '_') {
                throw new InvalidTypeNameException("mapping type name [" + mapper.type() + "] can't start with '_'");
            }
            if (mapper.type().contains("#")) {
                throw new InvalidTypeNameException("mapping type name [" + mapper.type() + "] should not include '#' in it");
            }
            if (mapper.type().contains(",")) {
                throw new InvalidTypeNameException("mapping type name [" + mapper.type() + "] should not include ',' in it");
            }
            if (Version.indexCreated(this.indexSettings).onOrAfter(Version.V_2_0_0_beta1) && mapper.type().equals(mapper.parentFieldMapper().type())) {
                throw new IllegalArgumentException("The [_parent.type] option can't point to the same type");
            }
            if (this.typeNameStartsWithIllegalDot(mapper)) {
                if (Version.indexCreated(this.indexSettings).onOrAfter(Version.V_2_0_0_beta1)) {
                    throw new IllegalArgumentException("mapping type name [" + mapper.type() + "] must not start with a '.'");
                }
                this.logger.warn("Type [{}] starts with a '.', it is recommended not to start a type name with a '.'", mapper.type());
            }
            if ((oldMapper = this.mappers.get(mapper.type())) != null) {
                MergeResult result = oldMapper.merge(mapper.mapping(), false, updateAllTypes);
                if (result.hasConflicts() && this.logger.isDebugEnabled()) {
                    this.logger.debug("merging mapping for type [{}] resulted in conflicts: [{}]", mapper.type(), Arrays.toString(result.buildConflicts()));
                }
                DocumentMapper documentMapper = oldMapper;
                return documentMapper;
            }
            ArrayList<ObjectMapper> newObjectMappers = new ArrayList<ObjectMapper>();
            ArrayList<FieldMapper> newFieldMappers = new ArrayList<FieldMapper>();
            for (MetadataFieldMapper metadataMapper : mapper.mapping().metadataMappers) {
                newFieldMappers.add(metadataMapper);
            }
            MapperUtils.collect(mapper.mapping().root, newObjectMappers, newFieldMappers);
            this.checkNewMappersCompatibility(newObjectMappers, newFieldMappers, updateAllTypes);
            this.addMappers(newObjectMappers, newFieldMappers);
            for (DocumentTypeListener typeListener : this.typeListeners) {
                typeListener.beforeCreate(mapper);
            }
            this.mappers = MapBuilder.newMapBuilder(this.mappers).put(mapper.type(), mapper).map();
            if (mapper.parentFieldMapper().active()) {
                ImmutableSet.Builder parentTypesCopy = ImmutableSet.builder();
                parentTypesCopy.addAll(this.parentTypes);
                parentTypesCopy.add((Object)mapper.parentFieldMapper().type());
                this.parentTypes = parentTypesCopy.build();
            }
            assert (this.assertSerialization(mapper));
            DocumentMapper documentMapper = mapper;
            return documentMapper;
        }
    }

    private boolean typeNameStartsWithIllegalDot(DocumentMapper mapper) {
        return mapper.type().startsWith(".") && !".percolator".equals(mapper.type());
    }

    private boolean assertSerialization(DocumentMapper mapper) {
        CompressedXContent mappingSource = mapper.mappingSource();
        DocumentMapper newMapper = this.parse(mapper.type(), mappingSource, false);
        if (!newMapper.mappingSource().equals(mappingSource)) {
            throw new IllegalStateException("DocumentMapper serialization result is different from source. \n--> Source [" + mappingSource + "]\n--> Result [" + newMapper.mappingSource() + "]");
        }
        return true;
    }

    protected void checkNewMappersCompatibility(Collection<ObjectMapper> newObjectMappers, Collection<FieldMapper> newFieldMappers, boolean updateAllTypes) {
        assert (this.mappingLock.isWriteLockedByCurrentThread());
        for (ObjectMapper newObjectMapper : newObjectMappers) {
            ObjectMapper existingObjectMapper = this.fullPathObjectMappers.get(newObjectMapper.fullPath());
            if (existingObjectMapper == null) continue;
            MergeResult result = new MergeResult(true, updateAllTypes);
            existingObjectMapper.merge(newObjectMapper, result);
            if (!result.hasConflicts()) continue;
            throw new IllegalArgumentException("Mapper for [" + newObjectMapper.fullPath() + "] conflicts with existing mapping in other types" + Arrays.toString(result.buildConflicts()));
        }
        this.fieldTypes.checkCompatibility(newFieldMappers, updateAllTypes);
    }

    protected void addMappers(Collection<ObjectMapper> objectMappers, Collection<FieldMapper> fieldMappers) {
        assert (this.mappingLock.isWriteLockedByCurrentThread());
        ImmutableOpenMap.Builder<String, ObjectMapper> fullPathObjectMappers = ImmutableOpenMap.builder(this.fullPathObjectMappers);
        for (ObjectMapper objectMapper : objectMappers) {
            fullPathObjectMappers.put(objectMapper.fullPath(), objectMapper);
            if (!objectMapper.nested().isNested()) continue;
            this.hasNested = true;
        }
        this.fullPathObjectMappers = fullPathObjectMappers.build();
        this.fieldTypes = this.fieldTypes.copyAndAddAll(fieldMappers);
    }

    public DocumentMapper parse(String mappingType, CompressedXContent mappingSource, boolean applyDefault) throws MapperParsingException {
        String defaultMappingSource = ".percolator".equals(mappingType) ? this.defaultPercolatorMappingSource : this.defaultMappingSource;
        return this.documentParser.parseCompressed(mappingType, mappingSource, applyDefault ? defaultMappingSource : null);
    }

    public boolean hasMapping(String mappingType) {
        return this.mappers.containsKey(mappingType);
    }

    public Collection<String> types() {
        return this.mappers.keySet();
    }

    public DocumentMapper documentMapper(String type) {
        return this.mappers.get(type);
    }

    public DocumentMapperForType documentMapperWithAutoCreate(String type) {
        DocumentMapper mapper = this.mappers.get(type);
        if (mapper != null) {
            return new DocumentMapperForType(mapper, null);
        }
        if (!this.dynamic) {
            throw new TypeMissingException(this.index, type, "trying to auto create mapping, but dynamic mapping is disabled");
        }
        mapper = this.parse(type, null, true);
        return new DocumentMapperForType(mapper, mapper.mapping());
    }

    @Nullable
    public Query searchFilter(String ... types) {
        boolean filterPercolateType = this.hasMapping(".percolator");
        if (types != null && filterPercolateType) {
            for (String type : types) {
                if (!".percolator".equals(type)) continue;
                filterPercolateType = false;
                break;
            }
        }
        Query percolatorType = null;
        if (filterPercolateType) {
            percolatorType = this.documentMapper(".percolator").typeFilter();
        }
        if (types == null || types.length == 0) {
            if (this.hasNested && filterPercolateType) {
                BooleanQuery.Builder bq = new BooleanQuery.Builder();
                bq.add(percolatorType, BooleanClause.Occur.MUST_NOT);
                bq.add((Query)Queries.newNonNestedFilter(), BooleanClause.Occur.MUST);
                return new ConstantScoreQuery((Query)bq.build());
            }
            if (this.hasNested) {
                return Queries.newNonNestedFilter();
            }
            if (filterPercolateType) {
                return new ConstantScoreQuery(Queries.not(percolatorType));
            }
            return null;
        }
        if (types.length == 1) {
            Query filter;
            DocumentMapper docMapper = this.documentMapper(types[0]);
            Object object = filter = docMapper != null ? docMapper.typeFilter() : new TermQuery(new Term("_type", types[0]));
            if (filterPercolateType) {
                BooleanQuery.Builder bq = new BooleanQuery.Builder();
                bq.add(percolatorType, BooleanClause.Occur.MUST_NOT);
                bq.add(filter, BooleanClause.Occur.MUST);
                return new ConstantScoreQuery((Query)bq.build());
            }
            return filter;
        }
        boolean useTermsFilter = true;
        for (String type : types) {
            DocumentMapper docMapper = this.documentMapper(type);
            if (docMapper == null) {
                useTermsFilter = false;
                break;
            }
            if (docMapper.typeMapper().fieldType().indexOptions() != IndexOptions.NONE) continue;
            useTermsFilter = false;
            break;
        }
        if (useTermsFilter) {
            BytesRef[] typesBytes = new BytesRef[types.length];
            for (int i = 0; i < typesBytes.length; ++i) {
                typesBytes[i] = new BytesRef((CharSequence)types[i]);
            }
            TermsQuery termsFilter = new TermsQuery("_type", typesBytes);
            if (filterPercolateType) {
                BooleanQuery.Builder bq = new BooleanQuery.Builder();
                bq.add(percolatorType, BooleanClause.Occur.MUST_NOT);
                bq.add((Query)termsFilter, BooleanClause.Occur.MUST);
                return new ConstantScoreQuery((Query)bq.build());
            }
            return termsFilter;
        }
        BooleanQuery.Builder bool = new BooleanQuery.Builder();
        for (String type : types) {
            DocumentMapper docMapper = this.documentMapper(type);
            if (docMapper == null) {
                bool.add((Query)new TermQuery(new Term("_type", type)), BooleanClause.Occur.SHOULD);
                continue;
            }
            bool.add(docMapper.typeFilter(), BooleanClause.Occur.SHOULD);
        }
        if (filterPercolateType) {
            bool.add(percolatorType, BooleanClause.Occur.MUST_NOT);
        }
        if (this.hasNested) {
            bool.add((Query)Queries.newNonNestedFilter(), BooleanClause.Occur.MUST);
        }
        return new ConstantScoreQuery((Query)bool.build());
    }

    public MappedFieldType indexName(String indexName) {
        return this.fieldTypes.getByIndexName(indexName);
    }

    public MappedFieldType fullName(String fullName) {
        return this.fieldTypes.get(fullName);
    }

    public Collection<String> simpleMatchToIndexNames(String pattern) {
        if (!Regex.isSimpleMatchPattern(pattern)) {
            return Collections.singletonList(pattern);
        }
        return this.fieldTypes.simpleMatchToIndexNames(pattern);
    }

    public Collection<String> simpleMatchToIndexNames(String pattern, @Nullable String[] types) {
        return this.simpleMatchToIndexNames(pattern);
    }

    public ObjectMapper getObjectMapper(String name, @Nullable String[] types) {
        return this.fullPathObjectMappers.get(name);
    }

    public MappedFieldType smartNameFieldType(String smartName) {
        MappedFieldType fieldType = this.fullName(smartName);
        if (fieldType != null) {
            return fieldType;
        }
        return this.indexName(smartName);
    }

    public MappedFieldType smartNameFieldType(String smartName, @Nullable String[] types) {
        return this.smartNameFieldType(smartName);
    }

    public MappedFieldType unmappedFieldType(String type) {
        ImmutableMap<String, MappedFieldType> unmappedFieldMappers = this.unmappedFieldTypes;
        MappedFieldType fieldType = (MappedFieldType)((Object)unmappedFieldMappers.get((Object)type));
        if (fieldType == null) {
            Mapper.TypeParser.ParserContext parserContext = this.documentMapperParser().parserContext(type);
            Mapper.TypeParser typeParser = parserContext.typeParser(type);
            if (typeParser == null) {
                throw new IllegalArgumentException("No mapper found for type [" + type + "]");
            }
            Mapper.Builder<?, ?> builder = typeParser.parse("__anonymous_" + type, (Map<String, Object>)ImmutableMap.of(), parserContext);
            Mapper.BuilderContext builderContext = new Mapper.BuilderContext(this.indexSettings, new ContentPath(1));
            fieldType = ((FieldMapper)builder.build(builderContext)).fieldType();
            this.unmappedFieldTypes = ImmutableMap.builder().putAll(unmappedFieldMappers).put((Object)type, (Object)fieldType).build();
        }
        return fieldType;
    }

    public Analyzer indexAnalyzer() {
        return this.indexAnalyzer;
    }

    public Analyzer searchAnalyzer() {
        return this.searchAnalyzer;
    }

    public Analyzer searchQuoteAnalyzer() {
        return this.searchQuoteAnalyzer;
    }

    public ObjectMapper resolveClosestNestedObjectMapper(String fieldName) {
        int indexOf = fieldName.lastIndexOf(46);
        if (indexOf == -1) {
            return null;
        }
        do {
            String objectPath;
            ObjectMapper objectMapper;
            if ((objectMapper = this.fullPathObjectMappers.get(objectPath = fieldName.substring(0, indexOf))) == null) {
                indexOf = objectPath.lastIndexOf(46);
                continue;
            }
            if (objectMapper.nested().isNested()) {
                return objectMapper;
            }
            indexOf = objectPath.lastIndexOf(46);
        } while (indexOf != -1);
        return null;
    }

    public ImmutableSet<String> getParentTypes() {
        return this.parentTypes;
    }

    public static boolean isMetadataField(String fieldName) {
        return META_FIELDS.contains((Object)fieldName);
    }

    public static String[] getAllMetaFields() {
        return (String[])META_FIELDS.toArray(String.class);
    }

    final class MapperAnalyzerWrapper
    extends DelegatingAnalyzerWrapper {
        private final Analyzer defaultAnalyzer;
        private final Function<MappedFieldType, Analyzer> extractAnalyzer;

        MapperAnalyzerWrapper(Analyzer defaultAnalyzer, Function<MappedFieldType, Analyzer> extractAnalyzer) {
            super(Analyzer.PER_FIELD_REUSE_STRATEGY);
            this.defaultAnalyzer = defaultAnalyzer;
            this.extractAnalyzer = extractAnalyzer;
        }

        protected Analyzer getWrappedAnalyzer(String fieldName) {
            Analyzer analyzer;
            MappedFieldType fieldType = MapperService.this.smartNameFieldType(fieldName);
            if (fieldType != null && (analyzer = (Analyzer)this.extractAnalyzer.apply((Object)fieldType)) != null) {
                return analyzer;
            }
            return this.defaultAnalyzer;
        }
    }
}

