/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.count;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.count.CountRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.QuerySourceBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestBuilderListener;

public class RestCountAction
extends BaseRestHandler {
    @Inject
    public RestCountAction(Settings settings, RestController controller, Client client) {
        super(settings, controller, client);
        controller.registerHandler(RestRequest.Method.POST, "/_count", this);
        controller.registerHandler(RestRequest.Method.GET, "/_count", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_count", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_count", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_count", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_count", this);
    }

    @Override
    public void handleRequest(final RestRequest request, RestChannel channel, Client client) {
        CountRequest countRequest = new CountRequest(Strings.splitStringByCommaToArray(request.param("index")));
        countRequest.indicesOptions(IndicesOptions.fromRequest(request, countRequest.indicesOptions()));
        if (RestActions.hasBodyContent(request)) {
            countRequest.source(RestActions.getRestContent(request));
        } else {
            QuerySourceBuilder querySourceBuilder = RestActions.parseQuerySource(request);
            if (querySourceBuilder != null) {
                countRequest.source(querySourceBuilder);
            }
        }
        countRequest.routing(request.param("routing"));
        countRequest.minScore(request.paramAsFloat("min_score", -1.0f));
        countRequest.types(Strings.splitStringByCommaToArray(request.param("type")));
        countRequest.preference(request.param("preference"));
        final int terminateAfter = request.paramAsInt("terminate_after", 0);
        if (terminateAfter < 0) {
            throw new IllegalArgumentException("terminateAfter must be > 0");
        }
        if (terminateAfter > 0) {
            countRequest.terminateAfter(terminateAfter);
        }
        client.search(countRequest.toSearchRequest(), (ActionListener<SearchResponse>)new RestBuilderListener<SearchResponse>(channel){

            @Override
            public RestResponse buildResponse(SearchResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                if (terminateAfter != 0) {
                    builder.field("terminated_early", (Object)response.isTerminatedEarly());
                }
                builder.field("count", response.getHits().totalHits());
                RestActions.buildBroadcastShardsHeader(builder, request, response.getTotalShards(), response.getSuccessfulShards(), response.getFailedShards(), response.getShardFailures());
                builder.endObject();
                return new BytesRestResponse(response.status(), builder);
            }
        });
    }
}

