/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.util.Comparator;
import java.util.List;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalHistogram;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalOrder;

public interface Histogram
extends MultiBucketsAggregation {
    public List<? extends Bucket> getBuckets();

    public static abstract class Order
    implements ToXContent {
        public static final Order KEY_ASC = new InternalOrder(1, "_key", true, new Comparator<InternalHistogram.Bucket>(){

            @Override
            public int compare(InternalHistogram.Bucket b1, InternalHistogram.Bucket b2) {
                return Long.compare(b1.key, b2.key);
            }
        });
        public static final Order KEY_DESC = new InternalOrder(2, "_key", false, new Comparator<InternalHistogram.Bucket>(){

            @Override
            public int compare(InternalHistogram.Bucket b1, InternalHistogram.Bucket b2) {
                return -Long.compare(b1.key, b2.key);
            }
        });
        public static final Order COUNT_ASC = new InternalOrder(3, "_count", true, new Comparator<InternalHistogram.Bucket>(){

            @Override
            public int compare(InternalHistogram.Bucket b1, InternalHistogram.Bucket b2) {
                int cmp = Long.compare(b1.getDocCount(), b2.getDocCount());
                if (cmp == 0) {
                    cmp = Long.compare(b1.key, b2.key);
                }
                return cmp;
            }
        });
        public static final Order COUNT_DESC = new InternalOrder(4, "_count", false, new Comparator<InternalHistogram.Bucket>(){

            @Override
            public int compare(InternalHistogram.Bucket b1, InternalHistogram.Bucket b2) {
                int cmp = -Long.compare(b1.getDocCount(), b2.getDocCount());
                if (cmp == 0) {
                    cmp = Long.compare(b1.key, b2.key);
                }
                return cmp;
            }
        });

        public static Order aggregation(String path, boolean asc) {
            return new InternalOrder.Aggregation(path, asc);
        }

        public static Order aggregation(String aggregationName, String valueName, boolean asc) {
            return new InternalOrder.Aggregation(aggregationName + "." + valueName, asc);
        }

        abstract Comparator<InternalHistogram.Bucket> comparator();
    }

    public static interface Bucket
    extends MultiBucketsAggregation.Bucket {
    }
}

