/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal.protocol;

import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.UUID;
import org.gradle.internal.serialize.ObjectReader;
import org.gradle.internal.serialize.ObjectWriter;
import org.gradle.messaging.remote.Address;
import org.gradle.messaging.remote.internal.MessageOriginator;
import org.gradle.messaging.remote.internal.MessageSerializer;
import org.gradle.messaging.remote.internal.inet.InetEndpoint;
import org.gradle.messaging.remote.internal.inet.MultiChoiceAddress;
import org.gradle.messaging.remote.internal.protocol.ChannelAvailable;
import org.gradle.messaging.remote.internal.protocol.ChannelUnavailable;
import org.gradle.messaging.remote.internal.protocol.DiscoveryMessage;
import org.gradle.messaging.remote.internal.protocol.LookupRequest;
import org.gradle.messaging.remote.internal.protocol.UnknownMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoveryProtocolSerializer
implements MessageSerializer<DiscoveryMessage> {
    public static final byte PROTOCOL_VERSION = 2;
    public static final byte LOOKUP_REQUEST = 1;
    public static final byte CHANNEL_AVAILABLE = 2;
    public static final byte CHANNEL_UNAVAILABLE = 3;

    @Override
    public ObjectReader<DiscoveryMessage> newReader(InputStream inputStream, Address localAddress, Address remoteAddress) {
        return new MessageReader(inputStream, (InetEndpoint)remoteAddress);
    }

    @Override
    public ObjectWriter<DiscoveryMessage> newWriter(OutputStream outputStream) {
        return new MessageWriter(outputStream);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MessageWriter
    implements ObjectWriter<DiscoveryMessage> {
        private final Output output;

        public MessageWriter(OutputStream outputStream) {
            this.output = new Output(outputStream);
        }

        @Override
        public void write(DiscoveryMessage message) throws Exception {
            this.output.writeByte((byte)2);
            if (message instanceof LookupRequest) {
                this.writeLookupRequest((LookupRequest)message);
            } else if (message instanceof ChannelAvailable) {
                this.writeChannelAvailable((ChannelAvailable)message);
            } else if (message instanceof ChannelUnavailable) {
                this.writeChannelUnavailable((ChannelUnavailable)message);
            } else {
                throw new UnsupportedOperationException();
            }
            this.output.flush();
        }

        private void writeChannelUnavailable(ChannelUnavailable channelUnavailable) throws IOException {
            this.output.writeByte((byte)3);
            this.writeMessageOriginator(channelUnavailable.getOriginator());
            this.output.writeString(channelUnavailable.getGroup());
            this.output.writeString(channelUnavailable.getChannel());
            this.writeAddress((MultiChoiceAddress)channelUnavailable.getAddress());
        }

        private void writeChannelAvailable(ChannelAvailable channelAvailable) throws IOException {
            this.output.writeByte((byte)2);
            this.writeMessageOriginator(channelAvailable.getOriginator());
            this.output.writeString(channelAvailable.getGroup());
            this.output.writeString(channelAvailable.getChannel());
            this.writeAddress((MultiChoiceAddress)channelAvailable.getAddress());
        }

        private void writeLookupRequest(LookupRequest request) throws IOException {
            this.output.writeByte((byte)1);
            this.writeMessageOriginator(request.getOriginator());
            this.output.writeString(request.getGroup());
            this.output.writeString(request.getChannel());
        }

        private void writeMessageOriginator(MessageOriginator messageOriginator) throws IOException {
            this.writeUUID(messageOriginator.getId());
            this.output.writeString(messageOriginator.getName());
        }

        private void writeAddress(MultiChoiceAddress address) throws IOException {
            this.writeUUID(address.getCanonicalAddress());
            this.output.writeInt(address.getPort(), true);
            this.output.writeInt(address.getCandidates().size(), true);
            for (InetAddress inetAddress : address.getCandidates()) {
                byte[] binAddress = inetAddress.getAddress();
                this.output.writeInt(binAddress.length, true);
                this.output.write(binAddress);
            }
        }

        private void writeUUID(Object id) throws IOException {
            UUID uuid = (UUID)id;
            this.output.writeLong(uuid.getMostSignificantBits());
            this.output.writeLong(uuid.getLeastSignificantBits());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MessageReader
    implements ObjectReader<DiscoveryMessage> {
        private final Input input;
        private final InetEndpoint remoteAddress;

        public MessageReader(InputStream inputStream, InetEndpoint remoteAddress) {
            this.input = new Input(inputStream);
            this.remoteAddress = remoteAddress;
        }

        @Override
        public DiscoveryMessage read() throws Exception {
            byte protocolVersion = this.input.readByte();
            if (protocolVersion != 2) {
                return new UnknownMessage(String.format("unknown protocol version %s", protocolVersion));
            }
            byte messageType = this.input.readByte();
            switch (messageType) {
                case 1: {
                    return this.readLookupRequest();
                }
                case 2: {
                    return this.readChannelAvailable();
                }
                case 3: {
                    return this.readChannelUnavailable();
                }
            }
            return new UnknownMessage(String.format("unknown message type %s", messageType));
        }

        private DiscoveryMessage readChannelUnavailable() throws IOException {
            MessageOriginator originator = this.readMessageOriginator();
            String group = this.input.readString();
            String channel = this.input.readString();
            MultiChoiceAddress address = this.readAddress();
            return new ChannelUnavailable(originator, group, channel, address);
        }

        private DiscoveryMessage readChannelAvailable() throws IOException {
            MessageOriginator originator = this.readMessageOriginator();
            String group = this.input.readString();
            String channel = this.input.readString();
            MultiChoiceAddress address = this.readAddress();
            address = address.addAddresses(this.remoteAddress.getCandidates());
            return new ChannelAvailable(originator, group, channel, address);
        }

        private DiscoveryMessage readLookupRequest() throws IOException {
            MessageOriginator originator = this.readMessageOriginator();
            String group = this.input.readString();
            String channel = this.input.readString();
            return new LookupRequest(originator, group, channel);
        }

        private MessageOriginator readMessageOriginator() throws IOException {
            UUID uuid = this.readUUID();
            String name = this.input.readString();
            return new MessageOriginator(uuid, name);
        }

        private MultiChoiceAddress readAddress() throws IOException {
            UUID uuid = this.readUUID();
            int port = this.input.readInt(true);
            int addressCount = this.input.readInt(true);
            ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
            for (int i = 0; i < addressCount; ++i) {
                int length = this.input.readInt(true);
                byte[] binAddress = this.input.readBytes(length);
                InetAddress inetAddress = InetAddress.getByAddress(binAddress);
                addresses.add(inetAddress);
            }
            return new MultiChoiceAddress(uuid, port, addresses);
        }

        private UUID readUUID() throws IOException {
            long mostSigUuidBits = this.input.readLong();
            long leastSigUuidBits = this.input.readLong();
            return new UUID(mostSigUuidBits, leastSigUuidBits);
        }
    }
}

