/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental;

import java.io.File;
import java.io.Serializable;

public class ResolvedInclude
implements Serializable {
    private final String include;
    private final File dependencyFile;

    public ResolvedInclude(String include, File dependencyFile) {
        this.include = include;
        this.dependencyFile = dependencyFile;
    }

    public boolean isUnknown() {
        return this.dependencyFile == null;
    }

    public boolean isMaybeMacro() {
        return this.isUnknown() && ResolvedInclude.isMacro(this.include);
    }

    private static boolean isMacro(String token) {
        if (token.isEmpty() || !Character.isJavaIdentifierStart(token.charAt(0))) {
            return false;
        }
        if (token.length() > 1) {
            for (char c : token.substring(1).toCharArray()) {
                if (Character.isJavaIdentifierPart(c)) continue;
                return false;
            }
        }
        return true;
    }

    public String getInclude() {
        return this.include;
    }

    public File getFile() {
        return this.dependencyFile;
    }

    public String toString() {
        return String.format("Resolved include '%s'", this.include);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResolvedInclude)) {
            return false;
        }
        ResolvedInclude that = (ResolvedInclude)o;
        return this.include.equals(that.include) && (this.dependencyFile == null ? that.dependencyFile == null : this.dependencyFile.equals(that.dependencyFile));
    }

    public int hashCode() {
        return this.include.hashCode();
    }
}

