/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.buildcomparison.outcome.internal.tooling;

import java.net.URI;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.internal.artifacts.publish.ArchivePublishArtifact;
import org.gradle.api.plugins.buildcomparison.outcome.internal.FileOutcomeIdentifier;
import org.gradle.api.plugins.buildcomparison.outcome.internal.tooling.DefaultGradleFileBuildOutcome;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Tar;
import org.gradle.api.tasks.bundling.War;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.jvm.tasks.Jar;
import org.gradle.plugins.ear.Ear;
import org.gradle.tooling.model.internal.outcomes.GradleFileBuildOutcome;

public class PublishArtifactToFileBuildOutcomeTransformer {
    public GradleFileBuildOutcome transform(PublishArtifact artifact, Project project) {
        String id = this.getId(artifact, project);
        String taskPath = this.getTaskPath(artifact);
        String description = this.getDescription(artifact);
        String typeIdentifier = this.getTypeIdentifier(artifact);
        return new DefaultGradleFileBuildOutcome(id, description, taskPath, artifact.getFile(), typeIdentifier);
    }

    private String getId(PublishArtifact artifact, Project project) {
        URI artifactUri = artifact.getFile().toURI();
        URI projectDirUri = project.getProjectDir().toURI();
        URI relativeUri = projectDirUri.relativize(artifactUri);
        return relativeUri.getPath();
    }

    private String getDescription(PublishArtifact artifact) {
        return "Publish artifact '".concat(artifact.toString()).concat("'");
    }

    private String getTypeIdentifier(PublishArtifact artifact) {
        if (artifact instanceof ArchivePublishArtifact) {
            ArchivePublishArtifact publishArtifact = (ArchivePublishArtifact)artifact;
            AbstractArchiveTask task = publishArtifact.getArchiveTask();
            if (task instanceof War) {
                return FileOutcomeIdentifier.WAR_ARTIFACT.getTypeIdentifier();
            }
            if (task instanceof Ear) {
                return FileOutcomeIdentifier.EAR_ARTIFACT.getTypeIdentifier();
            }
            if (task instanceof Jar) {
                return FileOutcomeIdentifier.JAR_ARTIFACT.getTypeIdentifier();
            }
            if (task instanceof Zip) {
                return FileOutcomeIdentifier.ZIP_ARTIFACT.getTypeIdentifier();
            }
            if (task instanceof Tar) {
                return FileOutcomeIdentifier.TAR_ARTIFACT.getTypeIdentifier();
            }
            return FileOutcomeIdentifier.ARCHIVE_ARTIFACT.getTypeIdentifier();
        }
        return FileOutcomeIdentifier.UNKNOWN_ARTIFACT.getTypeIdentifier();
    }

    private String getTaskPath(PublishArtifact artifact) {
        if (artifact instanceof ArchivePublishArtifact) {
            return ((ArchivePublishArtifact)artifact).getArchiveTask().getPath();
        }
        String taskPath = null;
        Set tasks = artifact.getBuildDependencies().getDependencies(null);
        if (!tasks.isEmpty()) {
            taskPath = ((Task)tasks.iterator().next()).getPath();
        }
        return taskPath;
    }
}

