/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.gradleplugin.userinterface.swing.common;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import org.gradle.api.UncheckedIOException;
import org.gradle.gradleplugin.foundation.settings.SettingsNode;

public class PreferencesAssistant {
    private static final String WINDOW_X = "window_x";
    private static final String WINDOW_Y = "window_y";
    private static final String WINDOW_WIDTH = "window_width";
    private static final String WINDOW_HEIGHT = "window_height";
    private static final String EXTENDED_STATE = "extended-state";
    private static final String DIVIDER_LOCATION = "divider_location";
    private static final String DIRECTORY_NAME = "directory_name";

    public static SettingsNode saveSettings(SettingsNode settingsNode, Window window, String id, Class windowClass) {
        Point p = window.getLocation();
        Dimension size = window.getSize();
        SettingsNode childNode = settingsNode.addChildIfNotPresent(PreferencesAssistant.getPrefix(windowClass, id));
        childNode.setValueOfChildAsInt(WINDOW_X, p.x);
        childNode.setValueOfChildAsInt(WINDOW_Y, p.y);
        childNode.setValueOfChildAsInt(WINDOW_WIDTH, size.width);
        childNode.setValueOfChildAsInt(WINDOW_HEIGHT, size.height);
        return childNode;
    }

    public static void saveSettings(SettingsNode settingsNode, JFrame frame, String id, Class windowClass) {
        if (frame.getExtendedState() == 1) {
            return;
        }
        SettingsNode childNode = PreferencesAssistant.saveSettings(settingsNode, (Window)frame, id, windowClass);
        if (frame.getExtendedState() != 1) {
            childNode.setValueOfChildAsInt(EXTENDED_STATE, frame.getExtendedState());
        }
    }

    public static SettingsNode restoreSettings(SettingsNode settingsNode, Window window, String id, Class windowClass) {
        SettingsNode childNode = settingsNode.getChildNode(PreferencesAssistant.getPrefix(windowClass, id));
        if (childNode == null) {
            return null;
        }
        int x = childNode.getValueOfChildAsInt(WINDOW_X, window.getLocation().x);
        int y = childNode.getValueOfChildAsInt(WINDOW_Y, window.getLocation().y);
        int width = childNode.getValueOfChildAsInt(WINDOW_WIDTH, window.getSize().width);
        int height = childNode.getValueOfChildAsInt(WINDOW_HEIGHT, window.getSize().height);
        window.setLocation(x, y);
        window.setSize(width, height);
        return childNode;
    }

    public static void restoreSettings(SettingsNode settingsNode, JFrame frame, String id, Class windowClass) {
        SettingsNode childNode = PreferencesAssistant.restoreSettings(settingsNode, (Window)frame, id, windowClass);
        if (childNode == null) {
            return;
        }
        int extendedState = childNode.getValueOfChildAsInt(EXTENDED_STATE, frame.getExtendedState());
        if (extendedState != 1) {
            frame.setExtendedState(extendedState);
        }
    }

    public static void saveSettings(SettingsNode settingsNode, JSplitPane splitter, String id, Class splitterClass) {
        SettingsNode childNode = settingsNode.addChildIfNotPresent(PreferencesAssistant.getPrefix(splitterClass, id));
        childNode.setValueOfChildAsInt(DIVIDER_LOCATION, splitter.getDividerLocation());
    }

    public static void restoreSettings(SettingsNode settingsNode, JSplitPane splitter, String id, Class splitterClass) {
        SettingsNode childNode = settingsNode.getChildNode(PreferencesAssistant.getPrefix(splitterClass, id));
        if (childNode == null) {
            return;
        }
        int location = childNode.getValueOfChildAsInt(DIVIDER_LOCATION, splitter.getDividerLocation());
        splitter.setDividerLocation(location);
    }

    private static String getPrefix(Class aClass, String id) {
        return aClass.getSimpleName() + '_' + id;
    }

    public static void saveSettings(SettingsNode settingsNode, JFileChooser fileChooser, String id, Class fileChooserClass, boolean saveCurrentDirectoryVsSelectedFilesParent) {
        String save;
        SettingsNode childNode = settingsNode.addChildIfNotPresent(PreferencesAssistant.getPrefix(fileChooserClass, id));
        try {
            save = saveCurrentDirectoryVsSelectedFilesParent ? fileChooser.getCurrentDirectory().getCanonicalPath() : fileChooser.getSelectedFile().getCanonicalPath();
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
        if (save != null) {
            childNode.setValueOfChild(DIRECTORY_NAME, save);
        }
    }

    public static void restoreSettings(SettingsNode settingsNode, JFileChooser fileChooser, String id, Class fileChooserClass) {
        SettingsNode childNode = settingsNode.getChildNode(PreferencesAssistant.getPrefix(fileChooserClass, id));
        if (childNode == null) {
            return;
        }
        String lastDirectory = childNode.getValueOfChild(DIRECTORY_NAME, null);
        if (lastDirectory != null) {
            fileChooser.setCurrentDirectory(new File(lastDirectory));
        }
    }
}

