/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.im.InputMethodRequests;
import java.text.BreakIterator;
import java.text.CharacterIterator;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TooManyListenersException;
import javax.annotation.Nonnull;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.LayerUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.IPropertyManager;
import org.gjt.sp.jedit.JEditActionContext;
import org.gjt.sp.jedit.JEditActionSet;
import org.gjt.sp.jedit.JEditBeanShellAction;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.input.AbstractInputHandler;
import org.gjt.sp.jedit.input.DefaultInputHandlerProvider;
import org.gjt.sp.jedit.input.InputHandlerProvider;
import org.gjt.sp.jedit.input.TextAreaInputHandler;
import org.gjt.sp.jedit.syntax.Chunk;
import org.gjt.sp.jedit.syntax.DefaultTokenHandler;
import org.gjt.sp.jedit.syntax.Token;
import org.gjt.sp.jedit.textarea.ChunkCache;
import org.gjt.sp.jedit.textarea.DisplayManager;
import org.gjt.sp.jedit.textarea.ElasticTabstopsTabExpander;
import org.gjt.sp.jedit.textarea.FoldPainter;
import org.gjt.sp.jedit.textarea.Gutter;
import org.gjt.sp.jedit.textarea.InputMethodSupport;
import org.gjt.sp.jedit.textarea.MouseActions;
import org.gjt.sp.jedit.textarea.ScrollLayout;
import org.gjt.sp.jedit.textarea.ScrollListener;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.textarea.SelectionManager;
import org.gjt.sp.jedit.textarea.StatusListener;
import org.gjt.sp.jedit.textarea.StructureMatcher;
import org.gjt.sp.jedit.textarea.TextAreaBorder;
import org.gjt.sp.jedit.textarea.TextAreaDropHandler;
import org.gjt.sp.jedit.textarea.TextAreaException;
import org.gjt.sp.jedit.textarea.TextAreaMouseHandler;
import org.gjt.sp.jedit.textarea.TextAreaPainter;
import org.gjt.sp.jedit.textarea.TriangleFoldPainter;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.ThreadUtilities;

public abstract class TextArea
extends JPanel {
    public static final int NO_SCROLL = 0;
    public static final int NORMAL_SCROLL = 1;
    public static final int ELECTRIC_SCROLL = 2;
    static TextArea focusedComponent;
    MouseInputAdapter mouseHandler;
    final ChunkCache chunkCache;
    DisplayManager displayManager;
    final SelectionManager selectionManager;
    private JEditActionContext<JEditBeanShellAction, JEditActionSet<JEditBeanShellAction>> actionContext;
    boolean bufferChanging;
    int maxHorizontalScrollWidth;
    String wrap;
    boolean hardWrap;
    boolean softWrap;
    boolean wrapToWidth;
    int maxLineLen;
    int wrapMargin;
    float tabSize;
    int charWidth;
    boolean scrollBarsInitialized;
    final Point offsetXY;
    boolean lastLinePartial;
    boolean blink;
    private static final Timer caretTimer;
    private static final Timer structureTimer;
    protected JPopupMenu popup;
    private boolean popupEnabled;
    private final Gutter gutter;
    protected final TextAreaPainter painter;
    private final EventListenerList listenerList;
    private final MutableCaretEvent caretEvent;
    private boolean caretBlinks;
    private final ElasticTabstopsTabExpander elasticTabstopsExpander = new ElasticTabstopsTabExpander(this);
    protected InputHandlerProvider inputHandlerProvider;
    private InputMethodSupport inputMethodSupport;
    private int physLastLine;
    private int screenLastLine;
    private int visibleLines;
    private int electricScroll;
    private int horizontalOffset;
    private boolean quickCopy;
    private final Box verticalBox;
    private final JScrollBar vertical;
    private final JScrollBar horizontal;
    protected JEditBuffer buffer;
    protected int caret;
    protected int caretLine;
    private int caretScreenLine;
    private final List<StructureMatcher> structureMatchers;
    private StructureMatcher.Match match;
    private int magicCaret;
    protected boolean multi;
    private boolean overwrite;
    private boolean rectangularSelectionMode;
    private boolean dndEnabled;
    private boolean queuedCaretUpdate;
    private int queuedScrollMode;
    private boolean queuedFireCaretEvent;
    private int oldCaretLine;
    private boolean joinNonWordChars;
    private boolean ctrlForRectangularSelection;

    protected TextArea(IPropertyManager iPropertyManager, InputHandlerProvider inputHandlerProvider) {
        this.inputHandlerProvider = inputHandlerProvider;
        this.enableEvents(12L);
        this.selectionManager = new SelectionManager(this);
        this.chunkCache = new ChunkCache(this);
        this.painter = new TextAreaPainter(this);
        this.gutter = new Gutter(this);
        this.gutter.setMouseActionsProvider(new MouseActions(iPropertyManager, "gutter"));
        this.listenerList = new EventListenerList();
        this.caretEvent = new MutableCaretEvent();
        this.blink = true;
        this.offsetXY = new Point();
        this.structureMatchers = new LinkedList<StructureMatcher>();
        this.structureMatchers.add(new StructureMatcher.BracketMatcher());
        this.setLayout(new ScrollLayout());
        this.add("center", this.painter);
        this.add("left", this.gutter);
        RequestFocusLayerUI requestFocusLayerUI = new RequestFocusLayerUI();
        this.verticalBox = new Box(0);
        this.vertical = new JScrollBar(1);
        this.verticalBox.add(new JLayer<JComponent>(this.vertical, requestFocusLayerUI));
        this.vertical.setRequestFocusEnabled(false);
        this.add("right", this.verticalBox);
        this.horizontal = new JScrollBar(0);
        this.add("bottom", new JLayer<JComponent>(this.horizontal, requestFocusLayerUI));
        this.horizontal.setRequestFocusEnabled(false);
        this.horizontal.setValues(0, 0, 0, 0);
        if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
            this.setBorder(new TextAreaBorder());
            this.vertical.putClientProperty("JScrollBar.isFreeStanding", Boolean.FALSE);
            this.horizontal.putClientProperty("JScrollBar.isFreeStanding", Boolean.FALSE);
        }
        this.vertical.addAdjustmentListener(new AdjustHandler());
        this.horizontal.addAdjustmentListener(new AdjustHandler());
        this.addFocusListener(new FocusHandler());
        this.addMouseWheelListener(new MouseWheelHandler());
        focusedComponent = this;
    }

    public FoldPainter getFoldPainter() {
        return new TriangleFoldPainter();
    }

    public void initInputHandler() {
        this.actionContext = new JEditActionContext<JEditBeanShellAction, JEditActionSet<JEditBeanShellAction>>(){

            @Override
            public void invokeAction(EventObject eventObject, JEditBeanShellAction jEditBeanShellAction) {
                jEditBeanShellAction.invoke(TextArea.this);
            }
        };
        this.setMouseHandler(new TextAreaMouseHandler(this));
        this.inputHandlerProvider = new DefaultInputHandlerProvider(new TextAreaInputHandler(this){

            @Override
            protected JEditBeanShellAction getAction(String string) {
                return (JEditBeanShellAction)TextArea.this.actionContext.getAction(string);
            }
        });
    }

    public JEditActionContext<JEditBeanShellAction, JEditActionSet<JEditBeanShellAction>> getActionContext() {
        return this.actionContext;
    }

    public void setMouseHandler(MouseInputAdapter mouseInputAdapter) {
        this.mouseHandler = mouseInputAdapter;
        this.painter.addMouseListener(this.mouseHandler);
        this.painter.addMouseMotionListener(this.mouseHandler);
    }

    @Override
    public void setTransferHandler(TransferHandler transferHandler) {
        super.setTransferHandler(transferHandler);
        try {
            this.getDropTarget().addDropTargetListener(new TextAreaDropHandler(this));
        }
        catch (TooManyListenersException tooManyListenersException) {
            Log.log(9, this, tooManyListenersException);
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = super.toString();
        int n = string.length() - 1;
        stringBuilder.append(string);
        stringBuilder.setLength(n);
        stringBuilder.append(",caret=").append(this.caret);
        stringBuilder.append(",caretLine=").append(this.caretLine);
        stringBuilder.append(",caretScreenLine=").append(this.caretScreenLine);
        stringBuilder.append(",electricScroll=").append(this.electricScroll);
        stringBuilder.append(",horizontalOffset=").append(this.horizontalOffset);
        stringBuilder.append(",magicCaret=").append(this.magicCaret);
        stringBuilder.append(",offsetXY=").append(this.offsetXY.toString());
        stringBuilder.append(",oldCaretLine=").append(this.oldCaretLine);
        stringBuilder.append(",screenLastLine=").append(this.screenLastLine);
        stringBuilder.append(",visibleLines=").append(this.visibleLines);
        stringBuilder.append(",firstPhysicalLine=").append(this.getFirstPhysicalLine());
        stringBuilder.append(",physLastLine=").append(this.physLastLine).append("]");
        return stringBuilder.toString();
    }

    public void dispose() {
        DisplayManager.textAreaDisposed(this);
        this.gutter.dispose();
    }

    public AbstractInputHandler getInputHandler() {
        return this.inputHandlerProvider.getInputHandler();
    }

    public final TextAreaPainter getPainter() {
        return this.painter;
    }

    public final Gutter getGutter() {
        return this.gutter;
    }

    public DisplayManager getDisplayManager() {
        return this.displayManager;
    }

    public final boolean isCaretBlinkEnabled() {
        return this.caretBlinks;
    }

    public void setCaretBlinkEnabled(boolean bl) {
        this.caretBlinks = bl;
        if (!bl) {
            this.blink = false;
        }
        if (this.buffer != null) {
            this.invalidateLine(this.caretLine);
        }
    }

    public final int getElectricScroll() {
        return this.electricScroll;
    }

    public final void setElectricScroll(int n) {
        this.electricScroll = n;
    }

    public final boolean isQuickCopyEnabled() {
        return this.quickCopy;
    }

    public final void setQuickCopyEnabled(boolean bl) {
        this.quickCopy = bl;
    }

    public final JEditBuffer getBuffer() {
        return this.buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBuffer(JEditBuffer jEditBuffer) {
        if (this.buffer == jEditBuffer) {
            return;
        }
        try {
            this.bufferChanging = true;
            boolean bl = false;
            if (this.buffer != null) {
                if (!this.buffer.isLoading()) {
                    this.selectNone();
                }
                this.caretScreenLine = 0;
                this.caret = 0;
                this.caretLine = 0;
                this.match = null;
                bl = this.buffer.insideCompoundEdit();
                if (bl) {
                    this.buffer.endCompoundEdit();
                }
            }
            this.buffer = jEditBuffer;
            if (bl) {
                this.buffer.beginCompoundEdit();
            }
            this.chunkCache.setBuffer(jEditBuffer);
            this.gutter.setBuffer(jEditBuffer);
            this.propertiesChanged();
            if (this.displayManager != null) {
                this.displayManager.release();
            }
            this.displayManager = DisplayManager.getDisplayManager(jEditBuffer, this);
            this.displayManager.init();
            if (jEditBuffer.isLoading()) {
                this.updateScrollBar();
            }
            this.repaint();
            this.fireScrollEvent(true);
        }
        finally {
            this.bufferChanging = false;
        }
    }

    public final boolean isEditable() {
        return this.buffer.isEditable();
    }

    public boolean isDragEnabled() {
        return this.dndEnabled;
    }

    public void setDragEnabled(boolean bl) {
        this.dndEnabled = bl;
    }

    public boolean getJoinNonWordChars() {
        return this.joinNonWordChars;
    }

    public void setJoinNonWordChars(boolean bl) {
        this.joinNonWordChars = bl;
    }

    public boolean isCtrlForRectangularSelection() {
        return this.ctrlForRectangularSelection;
    }

    public void setCtrlForRectangularSelection(boolean bl) {
        this.ctrlForRectangularSelection = bl;
    }

    public final int getFirstLine() {
        return this.displayManager.firstLine.getScrollLine() + this.displayManager.firstLine.getSkew();
    }

    public void setFirstLine(int n) {
        int n2 = this.displayManager.getScrollLineCount() - this.visibleLines + (this.lastLinePartial ? 1 : 0);
        if (n > n2) {
            n = n2;
        }
        if (n < 0) {
            n = 0;
        }
        int n3 = this.getFirstLine();
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "setFirstLine() from " + n3 + " to " + n);
        }
        if (n == n3) {
            return;
        }
        this.displayManager.setFirstLine(n3, n);
        this.repaint();
        this.fireScrollEvent(true);
    }

    public final int getFirstPhysicalLine() {
        return this.displayManager.firstLine.getPhysicalLine();
    }

    public void setFirstPhysicalLine(int n) {
        this.setFirstPhysicalLine(n, 0);
    }

    public void setFirstPhysicalLine(int n, int n2) {
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "setFirstPhysicalLine(" + n + ',' + n2 + ')');
        }
        int n3 = n - this.displayManager.firstLine.getPhysicalLine();
        this.displayManager.setFirstPhysicalLine(n3, n2);
        this.repaint();
        this.fireScrollEvent(true);
    }

    public final int getLastPhysicalLine() {
        return this.physLastLine;
    }

    public int getLastScreenLine() {
        return this.screenLastLine;
    }

    public final int getVisibleLines() {
        return this.visibleLines;
    }

    public final int getHorizontalOffset() {
        return this.horizontalOffset;
    }

    public void setHorizontalOffset(int n) {
        if (n > 0) {
            n = 0;
        }
        if (n == this.horizontalOffset) {
            return;
        }
        this.horizontalOffset = n;
        this.painter.repaint();
        this.fireScrollEvent(false);
    }

    public void scrollUpLine() {
        this.setFirstLine(this.getFirstLine() - 1);
    }

    public void scrollUpPage() {
        this.setFirstLine(this.getFirstLine() - this.getVisibleLines() + (this.lastLinePartial ? 1 : 0));
    }

    public void scrollDownLine() {
        this.setFirstLine(this.getFirstLine() + 1);
    }

    public void scrollDownPage() {
        this.setFirstLine(this.getFirstLine() + this.getVisibleLines() - (this.lastLinePartial ? 1 : 0));
    }

    public void scrollToCaret(boolean bl) {
        this.scrollTo(this.caretLine, this.caret - this.buffer.getLineStartOffset(this.caretLine), bl);
    }

    public void scrollTo(int n, boolean bl) {
        int n2 = this.buffer.getLineOfOffset(n);
        this.scrollTo(n2, n - this.buffer.getLineStartOffset(n2), bl);
    }

    public void scrollTo(int n, int n2, boolean bl) {
        Object object;
        int n3;
        if (this.buffer.isLoading()) {
            return;
        }
        if (Debug.SCROLL_TO_DEBUG) {
            Log.log(1, this, "scrollTo(), lineCount=" + this.getLineCount());
        }
        if (this.visibleLines <= 1) {
            if (Debug.SCROLL_TO_DEBUG) {
                Log.log(1, this, "visibleLines <= 0");
            }
            ChunkCache.LineInfo[] lineInfoArray = this.chunkCache.getLineInfosForPhysicalLine(n);
            int n4 = ChunkCache.getSubregionOfOffset(n2, lineInfoArray);
            this.setFirstPhysicalLine(n, n4);
            return;
        }
        int n5 = this.buffer.getLineLength(n);
        if (n2 > n5) {
            n3 = this.charWidth * (n2 - n5);
            n2 = n5;
        } else {
            n3 = 0;
        }
        int n6 = bl && this.visibleLines - 1 > this.electricScroll << 1 ? this.electricScroll : 0;
        int n7 = this.chunkCache.getScreenLineOfOffset(n, n2);
        int n8 = this.getVisibleLines();
        if (n7 == -1) {
            if (Debug.SCROLL_TO_DEBUG) {
                Log.log(1, this, "screenLine == -1");
            }
            object = this.chunkCache.getLineInfosForPhysicalLine(n);
            int n9 = ChunkCache.getSubregionOfOffset(n2, object);
            int n10 = this.displayManager.getPrevVisibleLine(this.getFirstPhysicalLine());
            int n11 = this.displayManager.getNextVisibleLine(this.getLastPhysicalLine());
            if (n == this.getFirstPhysicalLine()) {
                if (Debug.SCROLL_TO_DEBUG) {
                    Log.log(1, this, n + " == " + this.getFirstPhysicalLine());
                }
                this.setFirstPhysicalLine(n, n9 - n6);
            } else if (n == n10) {
                if (Debug.SCROLL_TO_DEBUG) {
                    Log.log(1, this, n + " == " + n10);
                }
                this.setFirstPhysicalLine(n10, n9 - n6);
            } else if (n == this.getLastPhysicalLine()) {
                if (Debug.SCROLL_TO_DEBUG) {
                    Log.log(1, this, n + " == " + this.getLastPhysicalLine());
                }
                this.setFirstPhysicalLine(n, n9 + n6 - n8 + (this.lastLinePartial ? 2 : 1));
            } else if (n == n11) {
                if (Debug.SCROLL_TO_DEBUG) {
                    Log.log(1, this, n + " == " + n11);
                }
                this.setFirstPhysicalLine(n11, n9 + n6 - n8 + (this.lastLinePartial ? 2 : 1));
            } else {
                if (Debug.SCROLL_TO_DEBUG) {
                    Log.log(1, this, "neither");
                    Log.log(1, this, "Last physical line is " + this.getLastPhysicalLine());
                }
                this.setFirstPhysicalLine(n, n9 - (n8 >> 1));
                if (Debug.SCROLL_TO_DEBUG) {
                    Log.log(1, this, "Last physical line is " + this.getLastPhysicalLine());
                }
            }
        } else if (n7 < n6) {
            if (Debug.SCROLL_TO_DEBUG) {
                Log.log(1, this, "electric up");
            }
            this.setFirstLine(this.getFirstLine() - n6 + n7);
        } else if (n7 > n8 - n6 - (this.lastLinePartial ? 2 : 1)) {
            if (Debug.SCROLL_TO_DEBUG) {
                Log.log(1, this, "electric down");
            }
            this.setFirstLine(this.getFirstLine() + n6 - n8 + n7 + (this.lastLinePartial ? 2 : 1));
        }
        if (!this.displayManager.isLineVisible(n)) {
            return;
        }
        object = this.offsetToXY(n, n2, this.offsetXY);
        object.x += n3;
        if (object.x < 0) {
            this.setHorizontalOffset(this.horizontalOffset - object.x + this.charWidth + 5);
        } else if (object.x >= this.painter.getWidth() - this.charWidth - 5) {
            this.setHorizontalOffset(this.horizontalOffset + (this.painter.getWidth() - object.x) - this.charWidth - 5);
        }
    }

    public final void addScrollListener(ScrollListener scrollListener) {
        this.listenerList.add(ScrollListener.class, scrollListener);
    }

    public final void removeScrollListener(ScrollListener scrollListener) {
        this.listenerList.remove(ScrollListener.class, scrollListener);
    }

    public int getPhysicalLineOfScreenLine(int n) {
        return this.chunkCache.getLineInfo((int)n).physicalLine;
    }

    public int getScreenLineOfOffset(int n) {
        int n2 = this.buffer.getLineOfOffset(n);
        return this.chunkCache.getScreenLineOfOffset(n2, n -= this.buffer.getLineStartOffset(n2));
    }

    public int getScreenLineStartOffset(int n) {
        ChunkCache.LineInfo lineInfo = this.chunkCache.getLineInfo(n);
        if (lineInfo.physicalLine == -1) {
            return -1;
        }
        return this.buffer.getLineStartOffset(lineInfo.physicalLine) + lineInfo.offset;
    }

    public int getScreenLineEndOffset(int n) {
        ChunkCache.LineInfo lineInfo = this.chunkCache.getLineInfo(n);
        if (lineInfo.physicalLine == -1) {
            return -1;
        }
        return this.buffer.getLineStartOffset(lineInfo.physicalLine) + lineInfo.offset + lineInfo.length;
    }

    public int xyToOffset(int n, int n2) {
        return this.xyToOffset(n, n2, true);
    }

    public int xyToOffset(int n, int n2, boolean bl) {
        int n3 = this.painter.getLineHeight();
        int n4 = n2 / n3;
        if (n4 < 0 || n4 >= this.visibleLines) {
            return -1;
        }
        return this.xToScreenLineOffset(n4, n, bl);
    }

    public int xToScreenLineOffset(int n, int n2, boolean bl) {
        int n3;
        ChunkCache.LineInfo lineInfo = this.chunkCache.getLineInfo(n);
        if (lineInfo.physicalLine == -1) {
            return this.getLineEndOffset(this.displayManager.getLastVisibleLine()) - 1;
        }
        float f = n2 - this.horizontalOffset;
        int n4 = Chunk.xToOffset(lineInfo.chunks, f, false);
        int n5 = this.getLineStartOffset(lineInfo.physicalLine);
        if (n4 == -1 || n4 == lineInfo.offset + lineInfo.length) {
            return n5 + lineInfo.offset + lineInfo.length - 1;
        }
        int n6 = n5 + n4;
        LineCharacterBreaker lineCharacterBreaker = new LineCharacterBreaker(this, n6);
        int n7 = n3 = lineCharacterBreaker.offsetIsBoundary(n6) ? n6 : lineCharacterBreaker.previousOf(n6);
        if (bl) {
            int n8;
            float f2;
            float f3 = Chunk.offsetToX(lineInfo.chunks, n3 - n5);
            return f < (f3 + (f2 = Chunk.offsetToX(lineInfo.chunks, (n8 = lineCharacterBreaker.nextOf(n3)) - n5))) / 2.0f ? n3 : n8;
        }
        return n3;
    }

    public Point offsetToXY(int n) {
        int n2 = this.buffer.getLineOfOffset(n);
        Point point = new Point();
        return this.offsetToXY(n2, n -= this.buffer.getLineStartOffset(n2), point);
    }

    public Point offsetToXY(int n, int n2) {
        return this.offsetToXY(n, n2, new Point());
    }

    public Point offsetToXY(int n, int n2, Point point) {
        if (!this.displayManager.isLineVisible(n)) {
            return null;
        }
        int n3 = this.chunkCache.getScreenLineOfOffset(n, n2);
        if (n3 == -1) {
            return null;
        }
        point.y = n3 * this.painter.getLineHeight();
        ChunkCache.LineInfo lineInfo = this.chunkCache.getLineInfo(n3);
        point.x = (int)((float)this.horizontalOffset + Chunk.offsetToX(lineInfo.chunks, n2));
        return point;
    }

    public void invalidateScreenLineRange(int n, int n2) {
        int n3;
        if (this.buffer.isLoading()) {
            return;
        }
        if (n > n2) {
            n3 = n2;
            n2 = n;
            n = n3;
        }
        if (this.chunkCache.needFullRepaint()) {
            n2 = this.visibleLines;
        }
        n3 = n * this.painter.getLineHeight();
        int n4 = (n2 - n + 1) * this.painter.getLineHeight();
        this.painter.repaint(0, n3, this.painter.getWidth(), n4);
        this.gutter.repaint(0, n3, this.gutter.getWidth(), n4);
    }

    public void invalidateLine(int n) {
        if (!this.isShowing() || this.buffer.isLoading() || n < this.getFirstPhysicalLine() || n > this.physLastLine || !this.displayManager.isLineVisible(n)) {
            return;
        }
        int n2 = -1;
        int n3 = -1;
        for (int i = 0; i < this.visibleLines; ++i) {
            ChunkCache.LineInfo lineInfo = this.chunkCache.getLineInfo(i);
            if ((lineInfo.physicalLine >= n || lineInfo.physicalLine == -1) && n2 == -1) {
                n2 = i;
            }
            if ((lineInfo.physicalLine < n || !lineInfo.lastSubregion) && lineInfo.physicalLine != -1) continue;
            n3 = i;
            break;
        }
        if (this.chunkCache.needFullRepaint() || n3 == -1) {
            n3 = this.visibleLines;
        }
        this.invalidateScreenLineRange(n2, n3);
    }

    public void invalidateLineRange(int n, int n2) {
        int n3;
        if (!this.isShowing() || this.buffer.isLoading()) {
            return;
        }
        if (n2 < n) {
            n3 = n2;
            n2 = n;
            n = n3;
        }
        if (n2 < this.getFirstPhysicalLine() || n > this.getLastPhysicalLine()) {
            return;
        }
        n3 = -1;
        int n4 = -1;
        for (int i = 0; i < this.visibleLines; ++i) {
            ChunkCache.LineInfo lineInfo = this.chunkCache.getLineInfo(i);
            if ((lineInfo.physicalLine >= n || lineInfo.physicalLine == -1) && n3 == -1) {
                n3 = i;
            }
            if ((lineInfo.physicalLine < n2 || !lineInfo.lastSubregion) && lineInfo.physicalLine != -1) continue;
            n4 = i;
            break;
        }
        if (n3 == -1) {
            n3 = 0;
        }
        if (this.chunkCache.needFullRepaint() || n4 == -1) {
            n4 = this.visibleLines;
        }
        this.invalidateScreenLineRange(n3, n4);
    }

    public final int getBufferLength() {
        return this.buffer.getLength();
    }

    public final int getLineCount() {
        return this.buffer.getLineCount();
    }

    public final int getLineOfOffset(int n) {
        return this.buffer.getLineOfOffset(n);
    }

    public int getLineStartOffset(int n) {
        return this.buffer.getLineStartOffset(n);
    }

    public int getLineEndOffset(int n) {
        return this.buffer.getLineEndOffset(n);
    }

    public int getLineLength(int n) {
        return this.buffer.getLineLength(n);
    }

    public final String getText(int n, int n2) {
        return this.buffer.getText(n, n2);
    }

    public final void getText(int n, int n2, Segment segment) {
        this.buffer.getText(n, n2, segment);
    }

    public String getText() {
        return this.buffer.getText(0, this.buffer.getLength());
    }

    public final String getLineText(int n) {
        return this.buffer.getLineText(n);
    }

    public final void getLineText(int n, Segment segment) {
        this.buffer.getLineText(n, segment);
    }

    public String getVisibleLineText(int n) {
        int n2 = -this.getHorizontalOffset();
        ChunkCache.LineInfo lineInfo = this.chunkCache.getLineInfo(n);
        int n3 = this.getLineStartOffset(lineInfo.physicalLine);
        Point point = this.offsetToXY(n3 + lineInfo.offset);
        int n4 = this.xyToOffset(n2 + point.x, point.y);
        int n5 = this.xyToOffset(this.getPainter().getWidth(), point.y);
        return this.buffer.getText(n4, n5 - n4);
    }

    public void getVisibleLineText(int n, Segment segment) {
        int n2 = -this.getHorizontalOffset();
        ChunkCache.LineInfo lineInfo = this.chunkCache.getLineInfo(n);
        int n3 = this.getLineStartOffset(lineInfo.physicalLine);
        Point point = this.offsetToXY(n3 + lineInfo.offset);
        int n4 = this.xyToOffset(n2 + point.x, point.y);
        int n5 = this.xyToOffset(this.getPainter().getWidth(), point.y);
        this.buffer.getText(n4, n5 - n4, segment);
    }

    public CharSequence getVisibleLineSegment(int n) {
        int n2 = -this.getHorizontalOffset();
        ChunkCache.LineInfo lineInfo = this.chunkCache.getLineInfo(n);
        int n3 = this.getLineStartOffset(lineInfo.physicalLine);
        Point point = this.offsetToXY(n3 + lineInfo.offset);
        int n4 = this.xyToOffset(n2 + point.x, point.y);
        int n5 = this.xyToOffset(this.getPainter().getWidth(), point.y);
        return this.buffer.getSegment(n4, n5 - n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String string) {
        try {
            this.buffer.beginCompoundEdit();
            this.buffer.remove(0, this.buffer.getLength());
            this.buffer.insert(0, string);
        }
        finally {
            this.buffer.endCompoundEdit();
        }
    }

    public final void selectAll() {
        int n = this.getFirstLine();
        int n2 = this.getHorizontalOffset();
        this.setSelection(new Selection.Range(0, this.buffer.getLength()));
        this.moveCaretPosition(this.buffer.getLength(), true);
        this.setFirstLine(n);
        this.setHorizontalOffset(n2);
    }

    public void selectLine() {
        int n = this.getCaretLine();
        int n2 = this.getLineStartOffset(n);
        int n3 = this.getLineEndOffset(n) - 1;
        Selection.Range range = new Selection.Range(n2, n3);
        if (this.multi) {
            this.addToSelection(range);
        } else {
            this.setSelection(range);
        }
        this.moveCaretPosition(n3);
    }

    public void selectParagraph() {
        int n;
        int n2 = this.getCaretLine();
        if (this.getLineLength(n2) == 0) {
            this.getToolkit().beep();
            return;
        }
        int n3 = n2;
        for (n = n2; n >= 0 && this.getLineLength(n) != 0; --n) {
        }
        while (n3 < this.getLineCount() && this.getLineLength(n3) != 0) {
            ++n3;
        }
        int n4 = this.getLineStartOffset(n + 1);
        int n5 = this.getLineEndOffset(n3 - 1) - 1;
        Selection.Range range = new Selection.Range(n4, n5);
        if (this.multi) {
            this.addToSelection(range);
        } else {
            this.setSelection(range);
        }
        this.moveCaretPosition(n5);
    }

    public void selectWord() {
        int n = this.getCaretLine();
        int n2 = this.getLineStartOffset(n);
        int n3 = this.getCaretPosition() - n2;
        if (this.getLineLength(n) == 0) {
            return;
        }
        String string = this.getLineText(n);
        String string2 = this.buffer.getStringProperty("noWordSep");
        if (n3 == this.getLineLength(n)) {
            --n3;
        }
        int n4 = TextUtilities.findWordStart(string, n3, string2, true, false, false);
        int n5 = TextUtilities.findWordEnd(string, n3 + 1, string2, true, false, false);
        Selection.Range range = new Selection.Range(n2 + n4, n2 + n5);
        if (this.multi) {
            this.addToSelection(range);
        } else {
            this.setSelection(range);
        }
        this.moveCaretPosition(n2 + n5);
    }

    public Selection selectToMatchingBracket(int n, boolean bl) {
        int n2;
        int n3 = this.buffer.getLineOfOffset(n);
        int n4 = n - this.buffer.getLineStartOffset(n3);
        if (this.getLineLength(n3) != 0 && (n2 = TextUtilities.findMatchingBracket(this.buffer, n3, Math.max(0, n4 - 1))) != -1) {
            Selection.Range range;
            if (n2 < n) {
                if (!bl) {
                    this.moveCaretPosition(n, false);
                }
                range = new Selection.Range(n2, n);
            } else {
                if (!bl) {
                    this.moveCaretPosition(n2 + 1, false);
                }
                range = new Selection.Range(n - 1, n2 + 1);
            }
            if (!this.multi && !bl) {
                this.selectNone();
            }
            this.addToSelection(range);
            return range;
        }
        return null;
    }

    public void selectToMatchingBracket() {
        this.selectToMatchingBracket(this.caret, false);
    }

    public void selectBlock() {
        char c;
        int n;
        int n2;
        Selection selection = this.getSelectionAtOffset(this.caret);
        if (selection == null) {
            n = n2 = this.caret;
        } else {
            n = selection.start;
            n2 = selection.end;
        }
        String string = this.getText(0, this.buffer.getLength());
        if (n == 0) {
            this.getToolkit().beep();
            return;
        }
        String string2 = "([{";
        String string3 = ")]}";
        int n3 = 1;
        char c2 = '\u0000';
        char c3 = '\u0000';
        while (--n >= 0) {
            c = string.charAt(n);
            int n4 = string2.indexOf(c);
            if (n4 != -1) {
                if (--n3 != 0) continue;
                c2 = c;
                c3 = string3.charAt(n4);
                break;
            }
            if (string3.indexOf(c) == -1) continue;
            ++n3;
        }
        n3 = 1;
        if (c2 == '\u0000') {
            this.getToolkit().beep();
            return;
        }
        do {
            if ((c = string.charAt(n2)) == c3) {
                if (--n3 != 0) continue;
                ++n2;
                break;
            }
            if (c != c2) continue;
            ++n3;
        } while (++n2 < this.buffer.getLength());
        selection = new Selection.Range(n, n2);
        if (this.multi) {
            this.addToSelection(selection);
        } else {
            this.setSelection(selection);
        }
        this.moveCaretPosition(n2);
    }

    public boolean lineInStructureScope(int n) {
        if (this.match == null) {
            return false;
        }
        if (this.match.startLine < this.caretLine) {
            return n >= this.match.startLine && n <= this.caretLine;
        }
        return n <= this.match.endLine && n >= this.caretLine;
    }

    public final void invertSelection() {
        this.selectionManager.invertSelection();
    }

    public int getSelectionCount() {
        return this.selectionManager.getSelectionCount();
    }

    @Nonnull
    public Selection[] getSelection() {
        return this.selectionManager.getSelection();
    }

    public Selection getSelection(int n) {
        return this.selectionManager.selection.get(n);
    }

    public Iterator<Selection> getSelectionIterator() {
        return this.selectionManager.selection.iterator();
    }

    public void selectNone() {
        this.invalidateSelectedLines();
        this.setSelection((Selection)null);
    }

    public void setSelection(Selection[] selectionArray) {
        this.invalidateSelectedLines();
        this.selectionManager.setSelection(selectionArray);
        this.finishCaretUpdate(this.caretLine, 0, true);
    }

    public void setSelection(Selection selection) {
        this.invalidateSelectedLines();
        this.selectionManager.setSelection(selection);
        this.finishCaretUpdate(this.caretLine, 0, true);
    }

    public void addToSelection(Selection[] selectionArray) {
        this.invalidateSelectedLines();
        this.selectionManager.addToSelection(selectionArray);
        this.finishCaretUpdate(this.caretLine, 0, true);
    }

    public void addToSelection(Selection selection) {
        this.invalidateSelectedLines();
        this.selectionManager.addToSelection(selection);
        this.finishCaretUpdate(this.caretLine, 0, true);
    }

    public Selection getSelectionAtOffset(int n) {
        return this.selectionManager.getSelectionAtOffset(n);
    }

    public void removeFromSelection(Selection selection) {
        this.invalidateSelectedLines();
        this.selectionManager.removeFromSelection(selection);
        this.finishCaretUpdate(this.caretLine, 0, true);
    }

    public void removeFromSelection(int n) {
        Selection selection = this.getSelectionAtOffset(n);
        if (selection == null) {
            return;
        }
        this.invalidateSelectedLines();
        this.selectionManager.removeFromSelection(selection);
        this.finishCaretUpdate(this.caretLine, 0, true);
    }

    public void resizeSelection(int n, int n2, int n3, boolean bl) {
        Selection selection = this.selectionManager.getSelectionAtOffset(n);
        if (selection != null) {
            this.invalidateLineRange(selection.startLine, selection.endLine);
            this.selectionManager.removeFromSelection(selection);
        }
        this.selectionManager.resizeSelection(n, n2, n3, bl);
        this.fireCaretEvent();
    }

    public void extendSelection(int n, int n2) {
        this.extendSelection(n, n2, 0, 0);
    }

    public void extendSelection(int n, int n2, int n3, int n4) {
        int n5;
        n = this.getCharacterBoundaryAt(n);
        n2 = this.getCharacterBoundaryAt(n2);
        Selection selection = this.getSelectionAtOffset(n);
        if (selection != null) {
            this.invalidateLineRange(selection.startLine, selection.endLine);
            this.selectionManager.removeFromSelection(selection);
            if (n == selection.start) {
                n = n2;
                n2 = selection.end;
            } else if (n == selection.end) {
                n = selection.start;
            }
        }
        if (n2 < n) {
            n5 = n2;
            n2 = n;
            n = n5;
        }
        if (this.rectangularSelectionMode) {
            selection = new Selection.Rect(n, n2);
            ((Selection.Rect)selection).extraStartVirt = n3;
            ((Selection.Rect)selection).extraEndVirt = n4;
        } else {
            selection = new Selection.Range(n, n2);
        }
        this.selectionManager.addToSelection(selection);
        this.fireCaretEvent();
        if (this.rectangularSelectionMode && n4 != 0) {
            n5 = this.getLineOfOffset(n2);
            this.scrollTo(n5, this.getLineLength(n5) + n4, false);
        }
    }

    public String getSelectedText(Selection selection) {
        StringBuilder stringBuilder = new StringBuilder(selection.end - selection.start);
        selection.getText(this.buffer, stringBuilder);
        return stringBuilder.toString();
    }

    public String getSelectedText(String string) {
        Selection[] selectionArray = this.selectionManager.getSelection();
        if (selectionArray.length == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < selectionArray.length; ++i) {
            if (i != 0) {
                stringBuilder.append(string);
            }
            selectionArray[i].getText(this.buffer, stringBuilder);
        }
        return stringBuilder.toString();
    }

    public String getSelectedText() {
        return this.getSelectedText("\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedText(Selection selection, String string) {
        if (!this.isEditable()) {
            throw new InternalError("Text component read only");
        }
        try {
            this.buffer.beginCompoundEdit();
            this.moveCaretPosition(selection.setText(this.buffer, string));
        }
        finally {
            this.buffer.endCompoundEdit();
        }
    }

    public void setSelectedText(String string) {
        int n = this.replaceSelection(string);
        if (n != -1) {
            this.moveCaretPosition(n);
        }
        this.selectNone();
    }

    public void setSelectedText(String string, boolean bl) {
        int n = this.replaceSelection(string);
        if (bl && n != -1) {
            this.moveCaretPosition(n);
        }
        this.selectNone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int replaceSelection(String string) {
        if (!this.isEditable()) {
            throw new RuntimeException("Text component read only");
        }
        int n = -1;
        if (this.getSelectionCount() == 0) {
            this.buffer.insert(this.caret, string);
        } else {
            try {
                Selection[] selectionArray;
                this.buffer.beginCompoundEdit();
                for (Selection selection : selectionArray = this.getSelection()) {
                    n = selection.setText(this.buffer, string);
                }
            }
            finally {
                this.buffer.endCompoundEdit();
            }
        }
        return n;
    }

    public int[] getSelectedLines() {
        if (this.selectionManager.getSelectionCount() == 0) {
            return new int[]{this.caretLine};
        }
        return this.selectionManager.getSelectedLines();
    }

    public boolean caretAutoScroll() {
        return focusedComponent == this;
    }

    public void addStructureMatcher(StructureMatcher structureMatcher) {
        this.structureMatchers.add(structureMatcher);
    }

    public void removeStructureMatcher(StructureMatcher structureMatcher) {
        this.structureMatchers.remove(structureMatcher);
    }

    public StructureMatcher.Match getStructureMatch() {
        return this.match;
    }

    public final void blinkCaret() {
        if (this.caretBlinks) {
            this.blink = !this.blink;
            this.invalidateLine(this.caretLine);
        } else {
            this.blink = true;
        }
    }

    public void centerCaret() {
        int n = this.getScreenLineStartOffset(this.visibleLines >> 1);
        if (n == -1) {
            this.getToolkit().beep();
        } else {
            this.setCaretPosition(n);
        }
    }

    public void scrollAndCenterCaret() {
        if (!this.getDisplayManager().isLineVisible(this.getCaretLine())) {
            this.getDisplayManager().expandFold(this.getCaretLine(), true);
        }
        int n = this.getCaretLine();
        int n2 = this.getPhysicalLineOfScreenLine(this.visibleLines >> 1);
        int n3 = n - n2;
        this.setFirstLine(this.getFirstLine() + n3);
        this.requestFocus();
    }

    public void setCaretPosition(int n) {
        this.selectNone();
        this.moveCaretPosition(n, true);
    }

    public void setCaretPosition(int n, boolean bl) {
        this.selectNone();
        this.moveCaretPosition(n, bl);
    }

    public void moveCaretPosition(int n) {
        this.moveCaretPosition(n, true);
    }

    public void moveCaretPosition(int n, boolean bl) {
        this.moveCaretPosition(n, bl ? 2 : 1);
    }

    public void moveCaretPosition(int n, int n2) {
        if (n < 0 || n > this.buffer.getLength()) {
            throw new IllegalArgumentException("caret out of bounds: " + n);
        }
        int n3 = this.caretLine;
        if (this.caret == n) {
            this.finishCaretUpdate(n3, n2, false);
        } else {
            this.caret = this.getCharacterBoundaryAt(n);
            this.caretLine = this.getLineOfOffset(this.caret);
            this.magicCaret = -1;
            this.finishCaretUpdate(n3, n2, true);
        }
    }

    public int getCaretPosition() {
        return this.caret;
    }

    public int getCaretLine() {
        return this.caretLine;
    }

    public int getMagicCaretPosition() {
        if (this.magicCaret == -1) {
            this.magicCaret = this.chunkCache.subregionOffsetToX(this.caretLine, this.caret - this.getLineStartOffset(this.caretLine));
        }
        return this.magicCaret;
    }

    public void setMagicCaretPosition(int n) {
        this.magicCaret = n;
    }

    public final void addCaretListener(CaretListener caretListener) {
        this.listenerList.add(CaretListener.class, caretListener);
    }

    public final void removeCaretListener(CaretListener caretListener) {
        this.listenerList.remove(CaretListener.class, caretListener);
    }

    public void goToNextBracket(boolean bl) {
        int n = -1;
        if (this.caret != this.buffer.getLength()) {
            String string = this.getText(this.caret, this.buffer.getLength() - this.caret - 1);
            block3: for (int i = 0; i < string.length(); ++i) {
                switch (string.charAt(i)) {
                    case ')': 
                    case ']': 
                    case '}': {
                        n = this.caret + i + 1;
                        break block3;
                    }
                    default: {
                        continue block3;
                    }
                }
            }
        }
        if (n == -1) {
            this.getToolkit().beep();
        } else {
            if (bl) {
                this.extendSelection(this.caret, n);
            } else if (!this.multi) {
                this.selectNone();
            }
            this.moveCaretPosition(n);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void goToNextCharacter(boolean bl) {
        int n;
        int n2;
        int n3;
        block17: {
            block19: {
                Selection selection;
                block18: {
                    selection = this.getSelectionAtOffset(this.caret);
                    if (!bl && selection instanceof Selection.Range) {
                        if (!this.multi) {
                            this.setCaretPosition(selection.end);
                            return;
                        }
                        if (this.caret != selection.end) {
                            this.moveCaretPosition(selection.end);
                            return;
                        }
                    }
                    if (selection instanceof Selection.Rect) {
                        n3 = ((Selection.Rect)selection).extraStartVirt;
                        n2 = ((Selection.Rect)selection).extraEndVirt;
                    } else {
                        n3 = 0;
                        n2 = 0;
                    }
                    n = this.caret;
                    if (this.caret != this.buffer.getLength()) break block18;
                    if (bl && (this.rectangularSelectionMode || selection instanceof Selection.Rect)) {
                        if (selection != null && this.caret == selection.start) {
                            ++n3;
                            break block17;
                        } else {
                            ++n2;
                        }
                        break block17;
                    } else {
                        this.getToolkit().beep();
                        return;
                    }
                }
                if (this.caret != this.getLineEndOffset(this.caretLine) - 1) break block19;
                if (bl && (this.rectangularSelectionMode || selection instanceof Selection.Rect)) {
                    if (selection != null && this.caret == selection.start) {
                        ++n3;
                        break block17;
                    } else {
                        ++n2;
                    }
                    break block17;
                } else {
                    int n4 = this.displayManager.getNextVisibleLine(this.caretLine);
                    if (n4 == -1) {
                        this.getToolkit().beep();
                        return;
                    }
                    n = this.getLineStartOffset(n4);
                }
                break block17;
            }
            n = this.getNextCharacterOffset(this.caret);
        }
        if (bl) {
            this.extendSelection(this.caret, n, n3, n2);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(n);
    }

    public void goToNextLine(boolean bl) {
        Selection selection = this.getSelectionAtOffset(this.caret);
        boolean bl2 = selection == null ? this.rectangularSelectionMode : selection instanceof Selection.Rect;
        int n = this.getMagicCaretPosition();
        int n2 = this.chunkCache.getBelowPosition(this.caretLine, this.caret - this.buffer.getLineStartOffset(this.caretLine), n + 1, bl2 && bl);
        if (n2 == -1) {
            int n3 = this.getLineEndOffset(this.caretLine) - 1;
            if (this.caret == n3) {
                this.getToolkit().beep();
                return;
            }
            n2 = n3;
        }
        this._changeLine(bl, n2);
        this.setMagicCaretPosition(n);
    }

    public void goToNextPage(boolean bl) {
        int n;
        this.scrollToCaret(false);
        int n2 = this.getMagicCaretPosition();
        if (this.caretLine < this.displayManager.getFirstVisibleLine()) {
            this.caretLine = this.displayManager.getNextVisibleLine(this.caretLine);
        }
        if (this.getFirstLine() + this.getVisibleLines() >= this.displayManager.getScrollLineCount()) {
            int n3 = this.displayManager.getLastVisibleLine();
            n = this.getLineEndOffset(n3) - 1;
        } else {
            int n4 = this.getScreenLineOfOffset(this.caret);
            this.scrollDownPage();
            n = this.xToScreenLineOffset(n4, n2, true);
        }
        if (bl) {
            this.extendSelection(this.caret, n);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(n, false);
        this.setMagicCaretPosition(n2);
    }

    public void goToNextParagraph(boolean bl) {
        int n = this.getCaretLine();
        int n2 = this.getBufferLength();
        boolean bl2 = false;
        Segment segment = new Segment();
        block3: for (int i = n + 1; i < this.getLineCount(); ++i) {
            if (!this.displayManager.isLineVisible(i)) continue;
            this.getLineText(i, segment);
            block4: for (int j = 0; j < segment.count; ++j) {
                switch (segment.array[segment.offset + j]) {
                    case '\t': 
                    case ' ': {
                        continue block4;
                    }
                    default: {
                        if (!bl2) continue block3;
                        n2 = this.getLineStartOffset(i);
                        break block3;
                    }
                }
            }
            bl2 = true;
        }
        if (bl) {
            this.extendSelection(this.caret, n2);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(n2);
    }

    public void goToNextWord(boolean bl) {
        this.goToNextWord(bl, false);
    }

    public void goToNextWord(boolean bl, boolean bl2) {
        String string;
        if (this.buffer.isLoading()) {
            return;
        }
        int n = this.getLineStartOffset(this.caretLine);
        int n2 = this.caret - n;
        if (n2 == (string = this.getLineText(this.caretLine)).length()) {
            int n3 = this.displayManager.getNextVisibleLine(this.caretLine);
            if (n3 == -1) {
                this.getToolkit().beep();
                return;
            }
            n2 = this.getLineStartOffset(n3);
        } else {
            String string2 = this.buffer.getStringProperty("noWordSep");
            boolean bl3 = this.buffer.getBooleanProperty("camelCasedWords");
            n2 = TextUtilities.findWordEnd(string, n2 + 1, string2, true, bl3, bl2);
            n2 += n;
        }
        if (bl) {
            this.extendSelection(this.caret, n2);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(n2);
    }

    public void goToPrevBracket(boolean bl) {
        String string = this.getText(0, this.caret);
        int n = -1;
        block3: for (int i = this.getCaretPosition() - 1; i >= 0; --i) {
            switch (string.charAt(i)) {
                case '(': 
                case '[': 
                case '{': {
                    n = i;
                    break block3;
                }
                default: {
                    continue block3;
                }
            }
        }
        if (n == -1) {
            this.getToolkit().beep();
        } else {
            if (bl) {
                this.extendSelection(this.caret, n);
            } else if (!this.multi) {
                this.selectNone();
            }
            this.moveCaretPosition(n);
        }
    }

    public void goToPrevCharacter(boolean bl) {
        Selection selection = this.getSelectionAtOffset(this.caret);
        if (!bl && selection instanceof Selection.Range) {
            if (this.multi) {
                if (this.caret != selection.start) {
                    this.moveCaretPosition(selection.start);
                    return;
                }
            } else {
                this.setCaretPosition(selection.start);
                return;
            }
        }
        if (this.caret == 0) {
            this.getToolkit().beep();
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = this.caret;
        if (bl && this.caret == this.getLineEndOffset(this.caretLine) - 1) {
            if (selection instanceof Selection.Rect) {
                n = ((Selection.Rect)selection).extraStartVirt;
                n2 = ((Selection.Rect)selection).extraEndVirt;
                if (this.caret == selection.start) {
                    if (n == 0) {
                        n3 = this.getPrevCharacterOffset(this.caret);
                    } else {
                        --n;
                    }
                } else if (n2 == 0) {
                    n3 = this.getPrevCharacterOffset(this.caret);
                } else {
                    --n2;
                }
            } else {
                n3 = this.getPrevCharacterOffset(this.caret);
            }
        } else if (this.caret == this.getLineStartOffset(this.caretLine)) {
            int n4 = this.displayManager.getPrevVisibleLine(this.caretLine);
            if (n4 == -1) {
                this.getToolkit().beep();
                return;
            }
            n3 = this.getLineEndOffset(n4) - 1;
        } else {
            n3 = this.getPrevCharacterOffset(this.caret);
        }
        if (bl) {
            this.extendSelection(this.caret, n3, n, n2);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(n3);
    }

    public void goToPrevLine(boolean bl) {
        Selection selection = this.getSelectionAtOffset(this.caret);
        boolean bl2 = selection == null ? this.rectangularSelectionMode : selection instanceof Selection.Rect;
        int n = this.getMagicCaretPosition();
        int n2 = this.chunkCache.getAbovePosition(this.caretLine, this.caret - this.buffer.getLineStartOffset(this.caretLine), n + 1, bl2 && bl);
        if (n2 == -1) {
            int n3 = this.getLineStartOffset(this.caretLine);
            if (this.caret == n3) {
                this.getToolkit().beep();
                return;
            }
            n2 = n3;
        }
        this._changeLine(bl, n2);
        this.setMagicCaretPosition(n);
    }

    public void goToPrevPage(boolean bl) {
        int n;
        this.scrollToCaret(false);
        int n2 = this.getMagicCaretPosition();
        if (this.caretLine < this.displayManager.getFirstVisibleLine()) {
            this.caretLine = this.displayManager.getNextVisibleLine(this.caretLine);
        }
        if (this.getFirstLine() == 0) {
            int n3 = this.displayManager.getFirstVisibleLine();
            n = this.getLineStartOffset(n3);
        } else {
            int n4 = this.getScreenLineOfOffset(this.caret);
            this.scrollUpPage();
            n = this.xToScreenLineOffset(n4, n2, true);
        }
        if (bl) {
            this.extendSelection(this.caret, n);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(n, false);
        this.setMagicCaretPosition(n2);
    }

    public void goToPrevParagraph(boolean bl) {
        int n = this.caretLine;
        int n2 = 0;
        boolean bl2 = false;
        Segment segment = new Segment();
        block3: for (int i = n - 1; i >= 0; --i) {
            if (!this.displayManager.isLineVisible(i)) continue;
            this.getLineText(i, segment);
            block4: for (int j = 0; j < segment.count; ++j) {
                switch (segment.array[segment.offset + j]) {
                    case '\t': 
                    case ' ': {
                        continue block4;
                    }
                    default: {
                        if (!bl2) continue block3;
                        n2 = this.getLineEndOffset(i) - 1;
                        break block3;
                    }
                }
            }
            bl2 = true;
        }
        if (bl) {
            this.extendSelection(this.caret, n2);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(n2);
    }

    public void goToPrevWord(boolean bl) {
        this.goToPrevWord(bl, false);
    }

    public void goToPrevWord(boolean bl, boolean bl2) {
        this.goToPrevWord(bl, bl2, false);
    }

    public void goToPrevWord(boolean bl, boolean bl2, boolean bl3) {
        if (this.buffer.isLoading()) {
            return;
        }
        int n = this.getLineStartOffset(this.caretLine);
        int n2 = this.caret - n;
        String string = this.getLineText(this.caretLine);
        if (n2 == 0) {
            if (n == 0) {
                this.getToolkit().beep();
                return;
            }
            int n3 = this.displayManager.getPrevVisibleLine(this.caretLine);
            if (n3 == -1) {
                this.getToolkit().beep();
                return;
            }
            n2 = this.getLineEndOffset(n3) - 1;
        } else {
            String string2 = this.buffer.getStringProperty("noWordSep");
            boolean bl4 = this.buffer.getBooleanProperty("camelCasedWords");
            n2 = TextUtilities.findWordStart(string, n2 - 1, string2, true, bl4, bl2, bl3);
            n2 += n;
        }
        if (bl) {
            this.extendSelection(this.caret, n2);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(n2);
    }

    public void home(boolean bl) {
        switch (this.getInputHandler().getLastActionCount() % 2) {
            case 1: {
                this.goToStartOfWhiteSpace(bl);
                break;
            }
            default: {
                this.goToStartOfLine(bl);
            }
        }
    }

    public void end(boolean bl) {
        switch (this.getInputHandler().getLastActionCount() % 2) {
            case 1: {
                this.goToEndOfWhiteSpace(bl);
                break;
            }
            default: {
                this.goToEndOfLine(bl);
            }
        }
    }

    public void smartHome(boolean bl) {
        switch (this.getInputHandler().getLastActionCount()) {
            case 1: {
                this.goToStartOfWhiteSpace(bl);
                break;
            }
            case 2: {
                this.goToStartOfLine(bl);
                break;
            }
            default: {
                this.goToFirstVisibleLine(bl);
            }
        }
    }

    public void smartEnd(boolean bl) {
        switch (this.getInputHandler().getLastActionCount()) {
            case 1: {
                int n = this.getCaretPosition();
                this.goToEndOfCode(bl);
                int n2 = this.getCaretPosition();
                if (n2 != n) break;
                this.goToEndOfWhiteSpace(bl);
                break;
            }
            case 2: {
                this.goToEndOfWhiteSpace(bl);
                break;
            }
            case 3: {
                this.goToEndOfLine(bl);
                break;
            }
            default: {
                this.goToLastVisibleLine(bl);
            }
        }
    }

    public void goToStartOfLine(boolean bl) {
        Selection selection = this.getSelectionAtOffset(this.caret);
        int n = bl || selection == null ? this.caretLine : selection.startLine;
        int n2 = this.getLineStartOffset(n);
        if (bl) {
            this.extendSelection(this.caret, n2);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(n2);
    }

    public void goToEndOfLine(boolean bl) {
        Selection selection = this.getSelectionAtOffset(this.caret);
        int n = bl || selection == null ? this.caretLine : selection.endLine;
        int n2 = this.getLineEndOffset(n) - 1;
        if (bl) {
            this.extendSelection(this.caret, n2);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(n2);
    }

    public void goToEndOfCode(boolean bl) {
        int n;
        int n2 = this.getCaretLine();
        DefaultTokenHandler defaultTokenHandler = new DefaultTokenHandler();
        this.buffer.markTokens(n2, defaultTokenHandler);
        Token token = defaultTokenHandler.getTokens();
        char[] cArray = this.getLineText(n2).toCharArray();
        while (true) {
            if (token.id == 1 || token.id == 2 || token.id == 3 || token.id == 4) {
                for (n = token.offset; n < token.offset + token.length; ++n) {
                    cArray[n] = 32;
                }
            }
            if (token.next == null) break;
            token = token.next;
        }
        n = this.getLineLength(n2) - StandardUtilities.getTrailingWhiteSpace(new String(cArray));
        n += this.getLineStartOffset(n2);
        if (bl) {
            this.extendSelection(this.caret, n);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(n);
    }

    public void goToStartOfWhiteSpace(boolean bl) {
        int n;
        int n2;
        if (this.buffer.isLoading()) {
            return;
        }
        Selection selection = this.getSelectionAtOffset(this.caret);
        if (bl || selection == null) {
            n2 = this.caretLine;
            n = this.caret - this.buffer.getLineStartOffset(n2);
        } else {
            n2 = selection.startLine;
            n = selection.start - this.buffer.getLineStartOffset(n2);
        }
        int n3 = this.chunkCache.getSubregionStartOffset(n2, n);
        if (n3 == this.getLineStartOffset(n2)) {
            n3 = StandardUtilities.getLeadingWhiteSpace(this.getLineText(n2));
            if (n3 == this.getLineLength(n2)) {
                n3 = 0;
            }
            n3 += this.getLineStartOffset(n2);
        }
        if (bl) {
            this.extendSelection(this.caret, n3);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(n3);
    }

    public void goToEndOfWhiteSpace(boolean bl) {
        int n;
        int n2;
        if (this.buffer.isLoading()) {
            return;
        }
        Selection selection = this.getSelectionAtOffset(this.caret);
        if (bl || selection == null) {
            n2 = this.caretLine;
            n = this.caret - this.getLineStartOffset(n2);
        } else {
            n2 = selection.endLine;
            n = selection.end - this.getLineStartOffset(n2);
        }
        int n3 = this.chunkCache.getSubregionEndOffset(n2, n);
        if (n3 == this.getLineEndOffset(n2)) {
            n3 = this.getLineLength(n2) - StandardUtilities.getTrailingWhiteSpace(this.getLineText(n2));
            if (n3 == 0) {
                n3 = this.getLineLength(n2);
            }
            n3 += this.getLineStartOffset(n2);
        } else {
            --n3;
        }
        if (bl) {
            this.extendSelection(this.caret, n3);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(n3);
    }

    public void goToFirstVisibleLine(boolean bl) {
        int n = this.getFirstLine() == 0 ? 0 : this.electricScroll;
        int n2 = this.getScreenLineStartOffset(n);
        if (n2 == -1) {
            n2 = this.getLineStartOffset(this.displayManager.getFirstVisibleLine());
        }
        if (bl) {
            this.extendSelection(this.caret, n2);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(n2);
    }

    public void goToLastVisibleLine(boolean bl) {
        int n;
        if (this.getFirstLine() + this.visibleLines >= this.displayManager.getScrollLineCount()) {
            n = this.getLineEndOffset(this.displayManager.getLastVisibleLine()) - 1;
        } else {
            n = this.visibleLines - this.electricScroll - 1;
            if (this.lastLinePartial) {
                --n;
            }
            if (n < 0) {
                n = 0;
            }
            if ((n = this.getScreenLineEndOffset(n) - 1) == -1) {
                n = this.getLineEndOffset(this.displayManager.getLastVisibleLine()) - 1;
            }
        }
        if (bl) {
            this.extendSelection(this.caret, n);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(n);
    }

    public void goToBufferStart(boolean bl) {
        int n = this.buffer.getLineStartOffset(this.displayManager.getFirstVisibleLine());
        if (bl) {
            this.extendSelection(this.caret, n);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(n);
    }

    public void goToBufferEnd(boolean bl) {
        int n = this.buffer.getLineEndOffset(this.displayManager.getLastVisibleLine()) - 1;
        if (bl) {
            this.extendSelection(this.caret, n);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(n);
    }

    public void goToMatchingBracket() {
        int n;
        int n2;
        if (this.getLineLength(this.caretLine) != 0 && (n2 = TextUtilities.findMatchingBracket(this.buffer, this.caretLine, Math.max(0, (n = this.caret - this.getLineStartOffset(this.caretLine)) - 1))) != -1) {
            this.selectNone();
            this.moveCaretPosition(n2 + 1, false);
            return;
        }
        this.getToolkit().beep();
    }

    public void userInput(char c) {
        if (!this.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        this.getPainter().hideCursor();
        switch (c) {
            case '\t': {
                this.userInputTab();
                break;
            }
            case '\b': {
                this.backspace();
                break;
            }
            case '\u007f': {
                this.delete();
                break;
            }
            default: {
                String string = String.valueOf(c);
                if (this.getSelectionCount() == 0) {
                    if (this.doWordWrap(c == ' ')) break;
                    boolean bl = this.buffer.isElectricKey(c, this.caretLine) && "full".equals(this.buffer.getStringProperty("autoIndent")) && this.buffer.getCurrentIndentForLine(this.caretLine, null) == this.buffer.getIdealIndentForLine(this.caretLine);
                    this.insert(string, bl);
                    break;
                }
                this.replaceSelection(string);
            }
        }
    }

    public final boolean isOverwriteEnabled() {
        return this.overwrite;
    }

    public final void setOverwriteEnabled(boolean bl) {
        this.blink = true;
        caretTimer.restart();
        this.overwrite = bl;
        this.invalidateLine(this.caretLine);
        this.fireStatusChanged(0, bl);
    }

    public final void toggleOverwriteEnabled() {
        this.setOverwriteEnabled(!this.overwrite);
    }

    public void backspace() {
        this.delete(false);
    }

    public void backspaceWord() {
        this.backspaceWord(false);
    }

    public void backspaceWord(boolean bl) {
        this.backspaceWord(bl, false);
    }

    public void backspaceWord(boolean bl, boolean bl2) {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        if (this.getSelectionCount() != 0) {
            this.setSelectedText("");
            return;
        }
        int n = this.getLineStartOffset(this.caretLine);
        int n2 = this.caret - n;
        String string = this.getLineText(this.caretLine);
        if (n2 == 0) {
            if (n == 0) {
                this.getToolkit().beep();
                return;
            }
            --n2;
        } else {
            String string2 = this.buffer.getStringProperty("noWordSep");
            boolean bl3 = this.buffer.getBooleanProperty("camelCasedWords");
            n2 = TextUtilities.findWordStart(string, n2 - 1, string2, true, bl3, bl, bl2);
        }
        this.buffer.remove(n2 + n, this.caret - (n2 + n));
    }

    public void delete() {
        this.delete(true);
    }

    public void deleteToEndOfLine() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        this.buffer.remove(this.caret, this.getLineEndOffset(this.caretLine) - this.caret - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteLine() {
        int n;
        int n2;
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        int n3 = this.chunkCache.subregionOffsetToX(this.caretLine, this.caret - this.getLineStartOffset(this.caretLine));
        int[] nArray = this.getSelectedLines();
        try {
            this.buffer.beginCompoundEdit();
            for (n2 = nArray.length - 1; n2 >= 0; --n2) {
                n = this.getLineStartOffset(nArray[n2]);
                int n4 = this.getLineEndOffset(nArray[n2]);
                if (n4 > this.buffer.getLength()) {
                    if (n != 0) {
                        --n;
                    }
                    --n4;
                }
                this.buffer.remove(n, n4 - n);
            }
        }
        finally {
            this.buffer.endCompoundEdit();
        }
        n2 = this.displayManager.getLastVisibleLine();
        if (this.caretLine == n2) {
            n = this.chunkCache.xToSubregionOffset(n2, 0, n3, true);
            this.setCaretPosition(this.buffer.getLineStartOffset(n2) + n);
        } else {
            n = this.chunkCache.xToSubregionOffset(this.caretLine, 0, n3, true);
            this.setCaretPosition(this.getLineStartOffset(this.caretLine) + n);
        }
    }

    public void deleteParagraph() {
        int n;
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        int n2 = 0;
        for (n = this.caretLine - 1; n >= 0; --n) {
            if (!this.lineContainsSpaceAndTabs(n)) continue;
            n2 = this.getLineStartOffset(n);
            break;
        }
        n = this.buffer.getLength();
        for (int i = this.caretLine + 1; i < this.getLineCount(); ++i) {
            if (!this.lineContainsSpaceAndTabs(i)) continue;
            n = this.getLineEndOffset(i) - 1;
            break;
        }
        this.buffer.remove(n2, n - n2);
    }

    public void deleteToStartOfLine() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        this.buffer.remove(this.getLineStartOffset(this.caretLine), this.caret - this.getLineStartOffset(this.caretLine));
    }

    public void deleteWord() {
        this.deleteWord(false);
    }

    public void deleteWord(boolean bl) {
        String string;
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        if (this.getSelectionCount() != 0) {
            this.setSelectedText("");
            return;
        }
        int n = this.getLineStartOffset(this.caretLine);
        int n2 = this.caret - n;
        if (n2 == (string = this.getLineText(this.caretLine)).length()) {
            if (n + n2 == this.buffer.getLength()) {
                this.getToolkit().beep();
                return;
            }
            ++n2;
        } else {
            String string2 = this.buffer.getStringProperty("noWordSep");
            boolean bl2 = this.buffer.getBooleanProperty("camelCasedWords");
            n2 = TextUtilities.findWordEnd(string, n2 + 1, string2, true, bl2, bl);
        }
        this.buffer.remove(this.caret, n2 + n - this.caret);
    }

    public final boolean isMultipleSelectionEnabled() {
        return this.multi;
    }

    public final void toggleMultipleSelectionEnabled() {
        this.setMultipleSelectionEnabled(!this.multi);
    }

    public final void setMultipleSelectionEnabled(boolean bl) {
        this.multi = bl;
        this.fireStatusChanged(1, bl);
        this.painter.repaint();
    }

    public final boolean isRectangularSelectionEnabled() {
        return this.rectangularSelectionMode;
    }

    public final void toggleRectangularSelectionEnabled() {
        this.setRectangularSelectionEnabled(!this.rectangularSelectionMode);
        if (this.getSelectionCount() == 1) {
            Selection selection = this.getSelection(0);
            this.removeFromSelection(selection);
            if (this.rectangularSelectionMode) {
                this.addToSelection(new Selection.Rect(selection.getStart(), selection.getEnd()));
            } else {
                this.addToSelection(new Selection.Range(selection.getStart(), selection.getEnd()));
            }
        }
    }

    public final void setRectangularSelectionEnabled(boolean bl) {
        this.rectangularSelectionMode = bl;
        this.fireStatusChanged(2, bl);
        this.painter.repaint();
    }

    public void goToParentFold() {
        int n;
        int n2 = -1;
        int n3 = this.buffer.getFoldLevel(this.caretLine);
        for (n = this.caretLine - 1; n >= 0; --n) {
            if (this.buffer.getFoldLevel(n) >= n3) continue;
            n2 = n;
            break;
        }
        if (n2 == -1) {
            this.getToolkit().beep();
            return;
        }
        n = this.getMagicCaretPosition();
        int n4 = this.buffer.getLineStartOffset(n2) + this.chunkCache.xToSubregionOffset(n2, 0, n + 1, true);
        if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(n4);
        this.setMagicCaretPosition(n);
    }

    public void goToNextFold(boolean bl) {
        int n;
        int n2 = -1;
        for (n = this.caretLine + 1; n < this.buffer.getLineCount(); ++n) {
            if (!this.buffer.isFoldStart(n) || !this.displayManager.isLineVisible(n)) continue;
            n2 = n;
            break;
        }
        if (n2 == -1) {
            this.getToolkit().beep();
            return;
        }
        n = this.getMagicCaretPosition();
        int n3 = this.buffer.getLineStartOffset(n2) + this.chunkCache.xToSubregionOffset(n2, 0, n + 1, true);
        if (bl) {
            this.extendSelection(this.caret, n3);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(n3);
        this.setMagicCaretPosition(n);
    }

    public void goToPrevFold(boolean bl) {
        int n;
        int n2 = -1;
        for (n = this.caretLine - 1; n >= 0; --n) {
            if (!this.buffer.isFoldStart(n) || !this.displayManager.isLineVisible(n)) continue;
            n2 = n;
            break;
        }
        if (n2 == -1) {
            this.getToolkit().beep();
            return;
        }
        n = this.getMagicCaretPosition();
        int n3 = this.buffer.getLineStartOffset(n2) + this.chunkCache.xToSubregionOffset(n2, 0, n + 1, true);
        if (bl) {
            this.extendSelection(this.caret, n3);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(n3);
        this.setMagicCaretPosition(n);
    }

    public void collapseFold() {
        this.collapseFold(this.caretLine);
    }

    public void collapseFold(int n) {
        this.displayManager.collapseFold(n);
    }

    public void expandFold(boolean bl) {
        int n = this.chunkCache.subregionOffsetToX(this.caretLine, this.caret - this.getLineStartOffset(this.caretLine));
        int n2 = this.displayManager.expandFold(this.caretLine, bl);
        if (!bl && n2 != -1) {
            if (!this.multi) {
                this.selectNone();
            }
            this.moveCaretPosition(this.getLineStartOffset(n2) + this.chunkCache.xToSubregionOffset(n2, 0, n, true));
        }
    }

    public void selectFold() {
        this.selectFold(this.caretLine);
    }

    public void selectFold(int n) {
        int[] nArray = this.buffer.getFoldAtLine(n);
        int n2 = this.getLineEndOffset(nArray[1]) - 1;
        Selection.Range range = new Selection.Range(this.getLineStartOffset(nArray[0]), n2);
        if (this.multi) {
            this.addToSelection(range);
        } else {
            this.setSelection(range);
        }
        this.moveCaretPosition(n2);
    }

    public void narrowToFold() {
        int[] nArray = this.buffer.getFoldAtLine(this.caretLine);
        if (nArray[0] == 0 && nArray[1] == this.buffer.getLineCount() - 1) {
            this.getToolkit().beep();
        } else {
            this.displayManager.narrow(nArray[0], nArray[1]);
        }
    }

    public void narrowToSelection() {
        if (this.getSelectionCount() != 1) {
            this.getToolkit().beep();
            return;
        }
        Selection selection = this.getSelection(0);
        this.displayManager.narrow(selection.getStartLine(), selection.getEndLine());
        this.selectNone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExplicitFold() throws TextAreaException {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        if (!"explicit".equals(this.buffer.getStringProperty("folding"))) {
            throw new TextAreaException("folding-not-explicit");
        }
        try {
            this.buffer.beginCompoundEdit();
            if (this.getSelectionCount() == 0) {
                int n = this.addExplicitFold(this.caret, this.caret, this.caretLine, this.caretLine);
                this.setCaretPosition(this.caret - n);
            } else {
                Selection[] selectionArray = this.getSelection();
                Selection selection = null;
                int n = 0;
                Selection[] selectionArray2 = selectionArray;
                int n2 = selectionArray2.length;
                for (int i = 0; i < n2; ++i) {
                    Selection selection2;
                    selection = selection2 = selectionArray2[i];
                    n = this.addExplicitFold(selection.start, selection.end, selection.startLine, selection.endLine);
                }
                assert (selection != null);
                this.setCaretPosition(selection.start - n, false);
            }
        }
        finally {
            this.buffer.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lineComment() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        String string = this.buffer.getContextSensitiveProperty(this.caret, "lineComment");
        if (string == null || string.length() == 0) {
            this.rangeLineComment();
            return;
        }
        string = string + ' ';
        this.buffer.beginCompoundEdit();
        int[] nArray = this.getSelectedLines();
        try {
            for (int n : nArray) {
                String string2 = this.getLineText(n);
                this.buffer.insert(this.getLineStartOffset(n) + StandardUtilities.getLeadingWhiteSpace(string2), string);
            }
        }
        finally {
            this.buffer.endCompoundEdit();
        }
        this.selectNone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rangeComment() {
        String string = this.buffer.getContextSensitiveProperty(this.caret, "commentStart");
        String string2 = this.buffer.getContextSensitiveProperty(this.caret, "commentEnd");
        if (!this.buffer.isEditable() || string == null || string2 == null || string.length() == 0 || string2.length() == 0) {
            this.getToolkit().beep();
            return;
        }
        string = string + ' ';
        string2 = ' ' + string2;
        try {
            this.buffer.beginCompoundEdit();
            Selection[] selectionArray = this.getSelection();
            if (selectionArray.length == 0) {
                int n = this.caret;
                this.buffer.insert(this.caret, string);
                this.buffer.insert(this.caret, string2);
                this.setCaretPosition(n + string.length());
            }
            for (Selection selection : selectionArray) {
                if (selection instanceof Selection.Range) {
                    this.buffer.insert(selection.start, string);
                    this.buffer.insert(selection.end, string2);
                    continue;
                }
                if (!(selection instanceof Selection.Rect)) continue;
                Selection.Rect rect = (Selection.Rect)selection;
                int n = rect.getStartColumn(this.buffer);
                int n2 = rect.getEndColumn(this.buffer);
                for (int i = selection.startLine; i <= selection.endLine; ++i) {
                    this.buffer.insertAtColumn(i, n2, string2);
                    this.buffer.insertAtColumn(i, n, string);
                }
            }
            this.selectNone();
        }
        finally {
            this.buffer.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void formatParagraph() throws TextAreaException {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        if (this.maxLineLen <= 0) {
            throw new TextAreaException("format-maxlinelen");
        }
        Selection[] selectionArray = this.getSelection();
        if (selectionArray.length != 0) {
            this.buffer.beginCompoundEdit();
            for (Selection selection : selectionArray) {
                this.setSelectedText(selection, TextUtilities.format(this.getSelectedText(selection), this.maxLineLen, this.buffer.getTabSize()));
            }
            this.buffer.endCompoundEdit();
        } else {
            int n;
            int n2 = this.getCaretLine();
            int n3 = 0;
            int n4 = this.buffer.getLength();
            for (n = n2 - 1; n >= 0; --n) {
                if (!this.lineContainsSpaceAndTabs(n)) continue;
                n3 = this.getLineEndOffset(n);
                break;
            }
            for (n = n2 + 1; n < this.getLineCount(); ++n) {
                if (!this.lineContainsSpaceAndTabs(n)) continue;
                n4 = this.getLineStartOffset(n) - 1;
                break;
            }
            try {
                this.buffer.beginCompoundEdit();
                String string = this.buffer.getText(n3, n4 - n3);
                int n5 = this.getCaretPosition() - n3;
                int n6 = TextUtilities.indexIgnoringWhitespace(string, n5);
                this.buffer.remove(n3, n4 - n3);
                string = TextUtilities.format(string, this.maxLineLen, this.buffer.getTabSize());
                this.buffer.insert(n3, string);
                int n7 = n3;
                if (string.length() != 0) {
                    n7 += Math.min(string.length(), TextUtilities.ignoringWhitespaceIndex(string, n6));
                }
                this.moveCaretPosition(n7);
            }
            finally {
                this.buffer.endCompoundEdit();
            }
        }
    }

    public void spacesToTabs() {
        Selection[] selectionArray = this.getSelection();
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        this.buffer.beginCompoundEdit();
        if (selectionArray.length == 0) {
            this.setText(TextUtilities.spacesToTabs(this.getText(), this.buffer.getTabSize()));
        } else {
            for (Selection selection : selectionArray) {
                this.setSelectedText(selection, TextUtilities.spacesToTabs(this.getSelectedText(selection), this.buffer.getTabSize()));
            }
        }
        this.buffer.endCompoundEdit();
    }

    public void tabsToSpaces() {
        Selection[] selectionArray = this.getSelection();
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        this.buffer.beginCompoundEdit();
        if (selectionArray.length == 0) {
            this.setText(TextUtilities.tabsToSpaces(this.getText(), this.buffer.getTabSize()));
        } else {
            for (Selection selection : selectionArray) {
                this.setSelectedText(selection, TextUtilities.tabsToSpaces(this.getSelectedText(selection), this.buffer.getTabSize()));
            }
        }
        this.buffer.endCompoundEdit();
    }

    public void toUpperCase() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        Selection[] selectionArray = this.getSelection();
        int n = -1;
        if (selectionArray.length == 0) {
            n = this.getCaretPosition();
            this.selectWord();
            selectionArray = this.getSelection();
        }
        if (selectionArray.length == 0) {
            if (n != -1) {
                this.setCaretPosition(n);
            }
            this.getToolkit().beep();
            return;
        }
        this.buffer.beginCompoundEdit();
        for (Selection selection : selectionArray) {
            this.setSelectedText(selection, this.getSelectedText(selection).toUpperCase());
        }
        this.buffer.endCompoundEdit();
        if (n != -1) {
            this.setCaretPosition(n);
        }
    }

    public void toLowerCase() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        Selection[] selectionArray = this.getSelection();
        int n = -1;
        if (selectionArray.length == 0) {
            n = this.getCaretPosition();
            this.selectWord();
            selectionArray = this.getSelection();
        }
        if (selectionArray.length == 0) {
            if (n != -1) {
                this.setCaretPosition(n);
            }
            this.getToolkit().beep();
            return;
        }
        this.buffer.beginCompoundEdit();
        for (Selection selection : selectionArray) {
            this.setSelectedText(selection, this.getSelectedText(selection).toLowerCase());
        }
        this.buffer.endCompoundEdit();
        if (n != -1) {
            this.setCaretPosition(n);
        }
    }

    public void removeTrailingWhiteSpace() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
        } else {
            this.buffer.removeTrailingWhiteSpace(this.getSelectedLines());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertEnterAndIndent() {
        if (!this.isEditable()) {
            this.getToolkit().beep();
        } else {
            String string = this.buffer.getStringProperty("autoIndent");
            if ("full".equals(string) && this.buffer.isElectricKey('\n', this.caretLine)) {
                this.buffer.indentLine(this.caretLine, true);
            }
            try {
                this.buffer.beginCompoundEdit();
                this.setSelectedText("\n");
                if ("full".equals(string)) {
                    if (!this.buffer.indentLine(this.caretLine, true)) {
                        if (this.lineContainsSpaceAndTabs(this.caretLine)) {
                            this.goToEndOfLine(false);
                        } else {
                            this.goToStartOfWhiteSpace(false);
                        }
                    }
                } else if ("simple".equals(string)) {
                    this.buffer.simpleIndentLine(this.caretLine);
                }
            }
            finally {
                this.buffer.endCompoundEdit();
            }
        }
    }

    public void insertTabAndIndent() {
        if (!this.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        boolean bl = "full".equals(this.buffer.getStringProperty("autoIndent"));
        if (bl && this.getSelectionCount() == 0) {
            int n;
            CharSequence charSequence = this.buffer.getLineSegment(this.caretLine);
            int n2 = this.buffer.getLineStartOffset(this.caretLine);
            if (this.caret - n2 <= (n = StandardUtilities.getLeadingWhiteSpace(charSequence)) && this.buffer.indentLine(this.caretLine, false)) {
                return;
            }
        }
        this.userInput('\t');
    }

    public void indentSelectedLines() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
        } else {
            this.buffer.indentLines(this.getSelectedLines());
            this.selectNone();
        }
    }

    public void turnOnElasticTabstops() {
        if (this.buffer.isLoading()) {
            return;
        }
        this.buffer.indentUsingElasticTabstops();
        this.buffer.elasticTabstopsOn = true;
    }

    public void shiftIndentLeft() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
        } else {
            this.buffer.shiftIndentLeft(this.getSelectedLines());
        }
    }

    public void shiftIndentRight() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
        } else {
            this.buffer.shiftIndentRight(this.getSelectedLines());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinLines() {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        try {
            this.buffer.beginCompoundEdit();
            boolean bl = false;
            for (Selection selection : this.selectionManager.getSelection()) {
                while (selection.startLine < selection.endLine) {
                    this.joinLineAt(selection.endLine - 1);
                    bl = true;
                }
            }
            if (!bl) {
                int n = this.getLineEndOffset(this.caretLine);
                if (n > this.buffer.getLength()) {
                    this.getToolkit().beep();
                    return;
                }
                this.joinLineAt(this.caretLine);
                if (!this.multi) {
                    this.selectNone();
                }
                this.moveCaretPosition(n - 1);
            }
        }
        finally {
            this.buffer.endCompoundEdit();
        }
    }

    public void addLeftOfScrollBar(Component component) {
        this.verticalBox.add(component, 0);
    }

    public void removeLeftOfScrollBar(Component component) {
        this.verticalBox.remove(component);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        ToolTipManager.sharedInstance().registerComponent(this.painter);
        ToolTipManager.sharedInstance().registerComponent(this.gutter);
        this.recalculateVisibleLines();
        if (!this.buffer.isLoading()) {
            this.recalculateLastPhysicalLine();
        }
        this.propertiesChanged();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        ToolTipManager.sharedInstance().unregisterComponent(this.painter);
        ToolTipManager.sharedInstance().unregisterComponent(this.gutter);
        if (focusedComponent == this) {
            focusedComponent = null;
        }
        caretTimer.stop();
    }

    @Override
    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean getFocusCycleRoot() {
        return true;
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        this.getInputHandler().processKeyEvent(keyEvent, 1, false);
        if (!keyEvent.isConsumed()) {
            super.processKeyEvent(keyEvent);
        }
    }

    public void addTopComponent(Component component) {
        this.add("top", component);
    }

    public void removeTopComponent(Component component) {
        this.remove(component);
    }

    public void addTopLeftComponent(Component component) {
        this.add("topLeft", component);
    }

    public void addTopRightComponent(Component component) {
        this.add("topRight", component);
    }

    public void addBottomLeftComponent(Component component) {
        this.add("bottomLeft", component);
    }

    public void addBottomRightComponent(Component component) {
        this.add("bottomRight", component);
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        if (this.inputMethodSupport == null) {
            this.inputMethodSupport = new InputMethodSupport(this);
            Log.log(1, this, "InputMethodSupport is activated");
        }
        return this.inputMethodSupport;
    }

    public final void addStatusListener(StatusListener statusListener) {
        this.listenerList.add(StatusListener.class, statusListener);
    }

    public final void removeStatusListener(StatusListener statusListener) {
        this.listenerList.remove(StatusListener.class, statusListener);
    }

    public void propertiesChanged() {
        boolean bl;
        if (this.buffer == null) {
            return;
        }
        if (this.buffer.getBooleanProperty("elasticTabstops")) {
            if (!this.buffer.elasticTabstopsOn) {
                this.turnOnElasticTabstops();
            }
            if (this.buffer.getColumnBlock() != null) {
                this.buffer.getColumnBlock().setTabSizeDirtyStatus(true, true);
            }
        } else {
            this.buffer.elasticTabstopsOn = false;
        }
        int n = this.buffer.getTabSize();
        char[] cArray = new char[n];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = 32;
        }
        this.tabSize = this.painter.getStringWidth(new String(cArray));
        String string = " 0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        this.charWidth = (int)Math.round(this.painter.getFont().getStringBounds(string, this.painter.getFontRenderContext()).getWidth() / (double)string.length());
        String string2 = this.wrap;
        this.wrap = this.buffer.getStringProperty("wrap");
        this.hardWrap = "hard".equals(this.wrap);
        String string3 = this.buffer.getStringProperty("largefilemode");
        this.softWrap = "soft".equals(this.wrap) && !"limited".equals(string3) && !"nohighlight".equals(string3);
        boolean bl2 = this.wrapToWidth;
        int n2 = this.wrapMargin;
        this.setMaxLineLength(this.buffer.getIntegerProperty("maxLineLen", 0));
        boolean bl3 = bl = !this.wrap.equals(string2) || bl2 != this.wrapToWidth || n2 != this.wrapMargin;
        if (this.displayManager != null && !this.bufferChanging && !this.buffer.isLoading() && bl) {
            this.displayManager.invalidateScreenLineCounts();
            this.displayManager.notifyScreenLineChanges();
        }
        this.chunkCache.reset();
        this.gutter.repaint();
        this.painter.repaint();
    }

    public void addActionSet(JEditActionSet<JEditBeanShellAction> jEditActionSet) {
        this.actionContext.addActionSet(jEditActionSet);
    }

    @Deprecated
    public final int getMarkPosition() {
        Selection selection = this.getSelectionAtOffset(this.caret);
        if (selection == null) {
            return this.caret;
        }
        if (selection.start == this.caret) {
            return selection.end;
        }
        if (selection.end == this.caret) {
            return selection.start;
        }
        return this.caret;
    }

    public final boolean isCaretVisible() {
        return this.blink && this.hasFocus();
    }

    final boolean isStructureHighlightVisible() {
        return this.match != null && this.hasFocus() && this.displayManager.isLineVisible(this.match.startLine) && this.displayManager.isLineVisible(this.match.endLine);
    }

    void updateMaxHorizontalScrollWidth() {
        int n = this.chunkCache.getMaxHorizontalScrollWidth();
        if (n != this.maxHorizontalScrollWidth) {
            this.maxHorizontalScrollWidth = n;
            this.horizontal.setValues(Math.max(0, Math.min(this.maxHorizontalScrollWidth + this.charWidth - this.painter.getWidth(), -this.horizontalOffset)), this.painter.getWidth(), 0, this.maxHorizontalScrollWidth + this.charWidth);
            this.horizontal.setUnitIncrement(10);
            this.horizontal.setBlockIncrement(this.painter.getWidth());
        } else if (this.horizontal.getValue() != -this.horizontalOffset) {
            this.horizontal.setValue(-this.horizontalOffset);
        }
    }

    void recalculateVisibleLines() {
        if (this.painter == null) {
            return;
        }
        int n = this.painter.getHeight();
        int n2 = this.painter.getLineHeight();
        if (n2 == 0) {
            this.visibleLines = 0;
        } else if (n <= 0) {
            this.visibleLines = 0;
            this.lastLinePartial = false;
        } else {
            this.visibleLines = n / n2;
            boolean bl = this.lastLinePartial = n % n2 != 0;
            if (this.lastLinePartial) {
                ++this.visibleLines;
            }
        }
        this.chunkCache.recalculateVisibleLines();
        if (this.displayManager != null && this.buffer != null && !this.buffer.isLoading()) {
            this.setFirstLine(this.getFirstLine());
        }
        this.updateScrollBar();
    }

    void foldStructureChanged() {
        this.chunkCache.invalidateAll();
        this.recalculateLastPhysicalLine();
        if (!this.displayManager.isLineVisible(this.caretLine)) {
            int n = this.chunkCache.subregionOffsetToX(this.caretLine, this.caret - this.getLineStartOffset(this.caretLine));
            int n2 = this.displayManager.getPrevVisibleLine(this.caretLine);
            if (!this.multi) {
                this.invalidateSelectedLines();
                this.selectionManager.setSelection((Selection)null);
            }
            this.moveCaretPosition(this.buffer.getLineStartOffset(n2) + this.chunkCache.xToSubregionOffset(n2, 0, n, true));
        }
        this.repaint();
    }

    void updateScrollBar() {
        if (this.buffer == null) {
            return;
        }
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "updateScrollBar(), slc=" + this.displayManager.getScrollLineCount());
        }
        if (this.vertical != null && this.visibleLines != 0) {
            if (Debug.SCROLL_DEBUG) {
                Log.log(1, this, "Vertical ok");
            }
            final int n = this.displayManager.getScrollLineCount();
            final int n2 = this.getFirstLine();
            final int n3 = this.visibleLines - (this.lastLinePartial ? 1 : 0);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    TextArea.this.vertical.setValues(n2, n3, 0, n);
                    TextArea.this.vertical.setUnitIncrement(2);
                    TextArea.this.vertical.setBlockIncrement(n3);
                }
            };
            ThreadUtilities.runInDispatchThread(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _finishCaretUpdate() {
        if (!this.queuedCaretUpdate) {
            return;
        }
        try {
            if (this.match != null) {
                if (this.oldCaretLine < this.match.startLine) {
                    this.invalidateLineRange(this.oldCaretLine, this.match.endLine);
                } else {
                    this.invalidateLineRange(this.match.startLine, this.oldCaretLine);
                }
                this.match = null;
            }
            int n = this.chunkCache.getScreenLineOfOffset(this.caretLine, this.caret - this.buffer.getLineStartOffset(this.caretLine));
            if (this.caretScreenLine == -1) {
                this.invalidateScreenLineRange(n, n);
            } else {
                this.invalidateScreenLineRange(this.caretScreenLine, n);
            }
            this.caretScreenLine = n;
            this.invalidateSelectedLines();
            this.blink = true;
            caretTimer.restart();
            if (!this.displayManager.isLineVisible(this.caretLine)) {
                if (this.displayManager.isOutsideNarrowing(this.caretLine)) {
                    int n2 = this.buffer.getIntegerProperty("collapseFolds", 0);
                    if (n2 != 0) {
                        this.displayManager.expandFolds(n2, false);
                        this.displayManager.expandFold(this.caretLine, false);
                        this.foldStructureChanged();
                    } else {
                        this.displayManager.expandAllFolds();
                    }
                } else {
                    this.displayManager.expandFold(this.caretLine, false);
                }
            }
            if (this.queuedScrollMode == 2) {
                this.scrollToCaret(true);
            } else if (this.queuedScrollMode == 1) {
                this.scrollToCaret(false);
            }
            TextArea.updateBracketHighlightWithDelay();
            if (this.queuedFireCaretEvent) {
                this.fireCaretEvent();
            }
        }
        finally {
            this.queuedFireCaretEvent = false;
            this.queuedCaretUpdate = false;
            this.queuedScrollMode = 0;
        }
    }

    void invalidateStructureMatch() {
        if (this.match != null) {
            this.invalidateLineRange(this.match.startLine, this.match.endLine);
        }
    }

    void startDragAndDrop(InputEvent inputEvent, boolean bl) {
        TransferHandler transferHandler = this.getTransferHandler();
        if (transferHandler != null) {
            Log.log(1, this, "Drag and drop callback");
            transferHandler.exportAsDrag(this, inputEvent, bl ? 1 : 2);
        }
    }

    void fireNarrowActive() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; --i) {
            if (objectArray[i] != StatusListener.class) continue;
            try {
                ((StatusListener)objectArray[i + 1]).narrowActive(this);
                continue;
            }
            catch (Throwable throwable) {
                Log.log(9, this, throwable);
            }
        }
    }

    private void _setHorizontalOffset(int n) {
        if (n > 0) {
            n = 0;
        }
        if (n == this.horizontalOffset) {
            return;
        }
        int n2 = Math.min(-(this.maxHorizontalScrollWidth + this.charWidth - this.painter.getWidth()), 0);
        if (n < n2) {
            n = n2;
        }
        this.setHorizontalOffset(n);
    }

    private void invalidateSelectedLines() {
        this.invalidateLine(this.caretLine);
        for (Selection selection : this.selectionManager.selection) {
            this.invalidateLineRange(selection.startLine, selection.endLine);
        }
    }

    private void finishCaretUpdate(int n, int n2, boolean bl) {
        this.queuedFireCaretEvent |= bl;
        this.queuedScrollMode = Math.max(n2, this.queuedScrollMode);
        if (this.queuedCaretUpdate) {
            return;
        }
        this.oldCaretLine = n;
        this.queuedCaretUpdate = true;
        if (!this.buffer.isTransactionInProgress()) {
            this._finishCaretUpdate();
        }
    }

    private void fireCaretEvent() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; --i) {
            if (objectArray[i] != CaretListener.class) continue;
            try {
                ((CaretListener)objectArray[i + 1]).caretUpdate(this.caretEvent);
                continue;
            }
            catch (Throwable throwable) {
                Log.log(9, this, throwable);
            }
        }
    }

    private void fireScrollEvent(boolean bl) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; --i) {
            if (objectArray[i] != ScrollListener.class) continue;
            try {
                if (bl) {
                    ((ScrollListener)objectArray[i + 1]).scrolledVertically(this);
                    continue;
                }
                ((ScrollListener)objectArray[i + 1]).scrolledHorizontally(this);
                continue;
            }
            catch (Throwable throwable) {
                Log.log(9, this, throwable);
            }
        }
    }

    private void fireStatusChanged(int n, boolean bl) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; --i) {
            if (objectArray[i] != StatusListener.class) continue;
            try {
                ((StatusListener)objectArray[i + 1]).statusChanged(this, n, bl);
                continue;
            }
            catch (Throwable throwable) {
                Log.log(9, this, throwable);
            }
        }
    }

    private void fireBracketSelected(int n, String string) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; --i) {
            if (objectArray[i] != StatusListener.class) continue;
            try {
                ((StatusListener)objectArray[i + 1]).bracketSelected(this, n, string);
                continue;
            }
            catch (Throwable throwable) {
                Log.log(9, this, throwable);
            }
        }
    }

    private void _changeLine(boolean bl, int n) {
        if (bl) {
            int n2;
            int n3;
            RectParams rectParams = this.getRectParams(this.caret, n);
            if (rectParams == null) {
                n3 = 0;
                n2 = 0;
            } else {
                n3 = rectParams.extraStartVirt;
                n2 = rectParams.extraEndVirt;
                n = rectParams.newCaret;
            }
            this.extendSelection(this.caret, n, n3, n2);
        } else if (!this.multi) {
            this.selectNone();
        }
        this.moveCaretPosition(n);
    }

    private boolean lineContainsSpaceAndTabs(int n) {
        Segment segment = new Segment();
        this.getLineText(n, segment);
        block3: for (int i = 0; i < segment.count; ++i) {
            switch (segment.array[segment.offset + i]) {
                case '\t': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insert(String string, boolean bl) {
        try {
            int n;
            if (this.overwrite || bl) {
                this.buffer.beginCompoundEdit();
            }
            if (this.overwrite && (n = this.getLineEndOffset(this.caretLine)) - this.caret > 1) {
                this.deleteNextCharacter(this.caret);
            }
            this.buffer.insert(this.caret, string);
            if (bl) {
                this.buffer.indentLine(this.caretLine, true);
            }
        }
        finally {
            if (this.overwrite || bl) {
                this.buffer.endCompoundEdit();
            }
        }
    }

    private void insertTab() {
        int n = this.buffer.getTabSize();
        if (this.buffer.getBooleanProperty("noTabs")) {
            int n2 = this.getLineStartOffset(this.caretLine);
            String string = this.getText(n2, this.caret - n2);
            int n3 = 0;
            block3: for (int i = 0; i < string.length(); ++i) {
                switch (string.charAt(n3)) {
                    case '\t': {
                        n3 = 0;
                        continue block3;
                    }
                    default: {
                        if (++n3 < n) continue block3;
                        n3 = 0;
                    }
                }
            }
            this.replaceSelection(StandardUtilities.createWhiteSpace(n - n3, 0));
        } else {
            this.replaceSelection("\t");
        }
    }

    protected void userInputTab() {
        if (this.getSelectionCount() == 1) {
            Selection selection = this.getSelection(0);
            if (selection instanceof Selection.Rect || selection.startLine == selection.endLine && (selection.start != this.buffer.getLineStartOffset(selection.startLine) || selection.end != this.buffer.getLineEndOffset(selection.startLine) - 1)) {
                this.insertTab();
            } else {
                this.shiftIndentRight();
            }
        } else if (this.getSelectionCount() != 0) {
            this.shiftIndentRight();
        } else {
            this.insertTab();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doWordWrap(boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        if (!this.hardWrap || this.maxLineLen <= 0) {
            return false;
        }
        Segment segment = new Segment();
        this.buffer.getLineText(this.caretLine, segment);
        int n5 = this.getLineStartOffset(this.caretLine);
        int n6 = this.getLineEndOffset(this.caretLine);
        int n7 = n6 - n5 - 1;
        for (n4 = n3 = this.caret - n5; n4 < n7; ++n4) {
            char c = segment.array[segment.offset + n4];
            if (c == ' ' || c == '\t') continue;
            return false;
        }
        n4 = this.buffer.getTabSize();
        String string = this.buffer.getStringProperty("wordBreakChars");
        int n8 = 0;
        int n9 = 0;
        int n10 = -1;
        boolean bl2 = true;
        for (n2 = 0; n2 < n3; ++n2) {
            n = segment.array[segment.offset + n2];
            if (n == 9) {
                n9 += n4 - n9 % n4;
                if (bl2 || n9 > this.maxLineLen) continue;
                n8 = n2;
                n10 = n2;
                bl2 = true;
                continue;
            }
            if (n == 32) {
                if (bl2 || ++n9 > this.maxLineLen + 1) continue;
                n8 = n2;
                n10 = n2;
                bl2 = true;
                continue;
            }
            if (string != null && string.indexOf(n) != -1) {
                if (bl2 || ++n9 > this.maxLineLen) continue;
                n8 = n2;
                n10 = n2;
                bl2 = true;
                continue;
            }
            n8 = n2;
            ++n9;
            bl2 = false;
        }
        if (bl && n9 == this.maxLineLen && n8 == n3 - 1) {
            n = n3;
            n2 = 1;
        } else if (n9 >= this.maxLineLen && n10 != -1) {
            n = n10;
            n2 = 0;
        } else {
            return false;
        }
        String string2 = this.buffer.getStringProperty("autoIndent");
        try {
            this.buffer.beginCompoundEdit();
            this.buffer.insert(n5 + n, "\n");
            if ("full".equals(string2)) {
                this.buffer.indentLine(this.caretLine, true);
            } else if ("simple".equals(string2)) {
                this.buffer.simpleIndentLine(this.caretLine);
            }
        }
        finally {
            this.buffer.endCompoundEdit();
        }
        return n2 != 0;
    }

    private static void updateBracketHighlightWithDelay() {
        structureTimer.stop();
        structureTimer.start();
    }

    private void updateStructureHighlight() {
        if (!this.painter.isStructureHighlightEnabled() && !this.gutter.isStructureHighlightEnabled()) {
            return;
        }
        for (StructureMatcher structureMatcher : this.structureMatchers) {
            this.match = structureMatcher.getMatch(this);
            if (this.match == null) continue;
            break;
        }
        if (this.match != null) {
            if (this.caretLine < this.match.startLine) {
                this.invalidateLineRange(this.caretLine, this.match.endLine);
            } else {
                this.invalidateLineRange(this.match.startLine, this.caretLine);
            }
            if (!this.displayManager.isLineVisible(this.match.startLine) || this.chunkCache.getScreenLineOfOffset(this.match.startLine, this.match.start - this.getLineStartOffset(this.match.startLine)) == -1) {
                this.showStructureStatusMessage(this.match.startLine < this.caretLine);
            }
        }
    }

    private void showStructureStatusMessage(boolean bl) {
        String string = this.buffer.getLineText(this.match.startLine).trim();
        if (bl && this.match.startLine != 0 && string.length() == 1) {
            switch (string.charAt(0)) {
                case '(': 
                case ')': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    string = this.buffer.getLineText(this.match.startLine - 1).trim() + ' ' + string;
                }
            }
        }
        this.fireBracketSelected(this.match.startLine + 1, string.replace('\t', ' '));
    }

    void recalculateLastPhysicalLine() {
        int n = this.screenLastLine;
        for (int i = this.visibleLines - 1; i >= 0; --i) {
            ChunkCache.LineInfo lineInfo = this.chunkCache.getLineInfo(i);
            if (lineInfo.physicalLine == -1) continue;
            this.physLastLine = lineInfo.physicalLine;
            this.screenLastLine = i;
            break;
        }
        this.invalidateScreenLineRange(n, this.screenLastLine);
    }

    private RectParams getRectParams(int n, int n2) {
        int n3;
        Selection selection = this.getSelectionAtOffset(n);
        if (selection instanceof Selection.Rect) {
            n3 = n == selection.end ? this.buffer.getVirtualWidth(selection.endLine, selection.end - this.getLineStartOffset(selection.endLine)) + ((Selection.Rect)selection).extraEndVirt : this.buffer.getVirtualWidth(selection.startLine, selection.start - this.getLineStartOffset(selection.startLine)) + ((Selection.Rect)selection).extraStartVirt;
        } else if (this.rectangularSelectionMode) {
            n3 = this.buffer.getVirtualWidth(this.caretLine, n - this.buffer.getLineStartOffset(this.caretLine));
        } else {
            return null;
        }
        int n4 = this.getLineOfOffset(n2);
        int[] nArray = new int[1];
        int n5 = this.buffer.getOffsetOfVirtualColumn(n4, n3, nArray);
        if (n5 == -1) {
            int n6 = n3 - nArray[0];
            n2 = this.getLineEndOffset(n4) - 1;
            boolean bl = selection == null ? n2 < n : (selection.start == n ? n2 <= selection.end : (selection.end == n ? n2 <= selection.start : false));
            RectParams rectParams = bl ? new RectParams(n6, 0, n2) : new RectParams(0, n6, n2);
            return rectParams;
        }
        return new RectParams(0, 0, this.getLineStartOffset(n4) + n5);
    }

    private void deleteNextCharacter(int n) {
        assert (n < this.buffer.getLength());
        int n2 = this.getNextCharacterOffset(n) - n;
        this.buffer.remove(n, n2);
    }

    private void deletePrevCodePoint(int n) {
        assert (n > 0);
        int n2 = 1;
        if (n >= 2) {
            Segment segment = new Segment();
            this.buffer.getText(n - 1, 1, segment);
            char c = segment.array[segment.offset];
            if (Character.isLowSurrogate(c)) {
                this.buffer.getText(n - 2, 1, segment);
                c = segment.array[segment.offset];
                if (Character.isHighSurrogate(c)) {
                    n2 = 2;
                }
            }
        }
        this.buffer.remove(n - n2, n2);
    }

    private void delete(boolean bl) {
        if (!this.buffer.isEditable()) {
            this.getToolkit().beep();
            return;
        }
        if (this.getSelectionCount() != 0) {
            Selection[] selectionArray;
            for (Selection selection : selectionArray = this.getSelection()) {
                if (selection instanceof Selection.Rect) {
                    Selection.Rect rect = (Selection.Rect)selection;
                    int n = rect.getStartColumn(this.buffer);
                    if (n == rect.getEndColumn(this.buffer)) {
                        if (!bl && n == 0) {
                            this.getToolkit().beep();
                            continue;
                        }
                        this.tallCaretDelete(rect, bl);
                        continue;
                    }
                    this.setSelectedText(selection, null);
                    continue;
                }
                this.setSelectedText(selection, null);
            }
        } else if (bl) {
            if (this.caret == this.buffer.getLength()) {
                this.getToolkit().beep();
                return;
            }
            this.deleteNextCharacter(this.caret);
        } else {
            if (this.caret == 0) {
                this.getToolkit().beep();
                return;
            }
            this.deletePrevCodePoint(this.caret);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tallCaretDelete(Selection.Rect rect, boolean bl) {
        try {
            this.buffer.beginCompoundEdit();
            int[] nArray = new int[1];
            int n = rect.getStartColumn(this.buffer);
            int n2 = rect.startLine;
            int n3 = rect.endLine;
            for (int i = n2; i <= n3; ++i) {
                int n4 = this.buffer.getOffsetOfVirtualColumn(i, n, nArray);
                if (n4 == -1) {
                    if (nArray[0] == n) {
                        n4 = this.getLineLength(i);
                    } else {
                        if (i != n2 || bl) continue;
                        this.shiftTallCaretLeft(rect);
                        continue;
                    }
                }
                n4 += this.buffer.getLineStartOffset(i);
                if (bl) {
                    if (n4 == this.buffer.getLineEndOffset(i) - 1) continue;
                    this.deleteNextCharacter(n4);
                    continue;
                }
                this.deletePrevCodePoint(n4);
            }
        }
        finally {
            this.buffer.endCompoundEdit();
        }
    }

    private void shiftTallCaretLeft(Selection.Rect rect) {
        this.removeFromSelection(rect);
        this.addToSelection(new Selection.Rect(this.buffer, rect.getStartLine(), rect.getStartColumn(this.buffer) - 1, rect.getEndLine(), rect.getEndColumn(this.buffer) - 1));
    }

    private void setMaxLineLength(int n) {
        this.maxLineLen = n;
        if (n <= 0) {
            if (this.softWrap) {
                this.wrapToWidth = true;
                this.wrapMargin = this.painter.getWidth() - this.charWidth * 3;
            } else {
                this.wrapToWidth = false;
                this.wrapMargin = 0;
            }
        } else {
            int n2 = this.charWidth * n;
            if (this.softWrap && this.painter.getWidth() < n2) {
                this.wrapToWidth = true;
                this.wrapMargin = this.painter.getWidth() - this.charWidth * 3;
            } else {
                this.wrapToWidth = false;
                this.wrapMargin = n2;
            }
        }
    }

    protected int addExplicitFold(int n, int n2, int n3, int n4) {
        String string;
        int n5 = n < this.buffer.getLength() ? n + 1 : n;
        int n6 = n2 > 0 ? n2 - 1 : n2;
        String string2 = this.buffer.getContextSensitiveProperty(n5, "lineComment");
        String string3 = this.buffer.getContextSensitiveProperty(n5, "commentStart");
        String string4 = this.buffer.getContextSensitiveProperty(n5, "commentEnd");
        String string5 = this.buffer.getContextSensitiveProperty(n6, "lineComment");
        String string6 = this.buffer.getContextSensitiveProperty(n6, "commentStart");
        String string7 = this.buffer.getContextSensitiveProperty(n6, "commentEnd");
        int n7 = 1;
        if (string2 != null) {
            string = string2 + "{{{ ";
        } else if (string3 != null && string4 != null) {
            string = string3 + "{{{  " + string4;
            n7 = 2 + string4.length();
        } else {
            string = "{{{ ";
        }
        if (string2 != null) {
            if (this.buffer.getLineLength(n3) != n) {
                string = string + '\n';
            }
        } else {
            string = string + "\n";
        }
        String string8 = string5 != null ? string5 + "}}}" : (string6 != null && string7 != null ? string6 + "}}}" + string7 : "}}}");
        String string9 = this.buffer.getLineText(n3);
        String string10 = string9.substring(0, StandardUtilities.getLeadingWhiteSpace(string9));
        n7 += string10.length();
        if (n == n2) {
            n7 += string8.length() + 1;
            int n8 = this.buffer.getLineStartOffset(n3);
            if (n8 + string10.length() != n) {
                ++n7;
            }
        }
        if (string5 != null) {
            if (this.buffer.getLineLength(n4) != n2) {
                string8 = string8 + '\n';
            }
        } else {
            string8 = string8 + "\n";
        }
        if (n2 == this.buffer.getLineStartOffset(n4)) {
            this.buffer.insert(n2, string8);
        } else {
            CharSequence charSequence = this.buffer.getSegment(n2 - 1, 1);
            if (Character.isWhitespace(charSequence.charAt(0))) {
                this.buffer.insert(n2, string8);
            } else {
                this.buffer.insert(n2, ' ' + string8);
            }
        }
        this.buffer.insert(n, string + string10);
        return n7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rangeLineComment() {
        String string = this.buffer.getContextSensitiveProperty(this.caret, "commentStart");
        String string2 = this.buffer.getContextSensitiveProperty(this.caret, "commentEnd");
        if (!this.buffer.isEditable() || string == null || string2 == null || string.length() == 0 || string2.length() == 0) {
            this.getToolkit().beep();
            return;
        }
        string = string + ' ';
        string2 = ' ' + string2;
        try {
            int[] nArray;
            this.buffer.beginCompoundEdit();
            for (int n : nArray = this.getSelectedLines()) {
                String string3 = this.getLineText(n);
                if (string3.trim().length() == 0) continue;
                this.buffer.insert(this.getLineEndOffset(n) - 1, string2);
                this.buffer.insert(this.getLineStartOffset(n) + StandardUtilities.getLeadingWhiteSpace(string3), string);
            }
        }
        finally {
            this.buffer.endCompoundEdit();
        }
    }

    private void joinLineAt(int n) {
        if (n >= this.buffer.getLineCount() - 1) {
            return;
        }
        int n2 = this.getLineEndOffset(n);
        CharSequence charSequence = this.buffer.getLineSegment(n + 1);
        this.buffer.remove(n2 - 1, StandardUtilities.getLeadingWhiteSpace(charSequence) + 1);
        if (charSequence.length() != 0) {
            this.buffer.insert(n2 - 1, " ");
        }
    }

    public boolean isRightClickPopupEnabled() {
        return this.popupEnabled;
    }

    public void setRightClickPopupEnabled(boolean bl) {
        this.popupEnabled = bl;
    }

    public final JPopupMenu getRightClickPopup() {
        return this.popup;
    }

    public final void setRightClickPopup(JPopupMenu jPopupMenu) {
        this.popup = jPopupMenu;
    }

    public void handlePopupTrigger(MouseEvent mouseEvent) {
        this.createPopupMenu(mouseEvent);
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = this.xyToOffset(n, n2, !this.painter.isBlockCaretEnabled() && !this.isOverwriteEnabled());
        if (this.getSelectionCount() == 0 || this.multi) {
            this.moveCaretPosition(n3, false);
        }
        TextArea.showPopupMenu(this.popup, this, n, n2, false);
    }

    public void createPopupMenu(MouseEvent mouseEvent) {
    }

    public void showPopupMenu() {
        Point point;
        if (!this.popup.isVisible() && this.hasFocus() && (point = this.offsetToXY(this.getCaretPosition())) != null) {
            int n = this.getPainter().getLineHeight();
            TextArea.showPopupMenu(this.popup, this.painter, point.x, point.y + n, true);
        }
    }

    public static void showPopupMenu(JPopupMenu jPopupMenu, Component component, int n, int n2, boolean bl) {
        Component component2;
        int n3 = 0;
        int n4 = 0;
        int n5 = bl ? 1 : 0;
        for (component2 = component; !(component2 instanceof Window) && component2 != null; component2 = component2.getParent()) {
            n3 += component2.getX();
            n4 += component2.getY();
        }
        if (component2 != null) {
            Dimension dimension = jPopupMenu.getPreferredSize();
            Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
            n = n + n3 + dimension.width + component2.getX() > rectangle.width && n + n3 + component2.getX() >= dimension.width ? (bl ? (n -= dimension.width + n5) : component2.getWidth() - dimension.width - n3 + n5) : (n += n5);
            n2 = n2 + n4 + dimension.height + component2.getY() > rectangle.height && n2 + n4 + component2.getY() >= dimension.height ? (bl ? component2.getHeight() - dimension.height - n4 + n5 : -dimension.height - 1) : (n2 += n5);
            jPopupMenu.show(component, n, n2);
        } else {
            jPopupMenu.show(component, n + n5, n2 + n5);
        }
    }

    private int getPrevCharacterOffset(int n) {
        return new LineCharacterBreaker(this, n).previousOf(n);
    }

    private int getNextCharacterOffset(int n) {
        return new LineCharacterBreaker(this, n).nextOf(n);
    }

    private int getCharacterBoundaryAt(int n) {
        LineCharacterBreaker lineCharacterBreaker = new LineCharacterBreaker(this, n);
        return lineCharacterBreaker.offsetIsBoundary(n) ? n : lineCharacterBreaker.previousOf(n);
    }

    public TabExpander getTabExpander() {
        if (this.buffer.getBooleanProperty("elasticTabstops")) {
            return this.elasticTabstopsExpander;
        }
        return this.painter;
    }

    static {
        caretTimer = new Timer(500, new CaretBlinker());
        caretTimer.setInitialDelay(500);
        caretTimer.start();
        structureTimer = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (focusedComponent != null) {
                    focusedComponent.updateStructureHighlight();
                }
            }
        });
        structureTimer.setInitialDelay(100);
        structureTimer.setRepeats(false);
    }

    private class RequestFocusLayerUI
    extends LayerUI<JComponent> {
        private RequestFocusLayerUI() {
        }

        @Override
        protected void processMouseEvent(MouseEvent mouseEvent, JLayer<? extends JComponent> jLayer) {
            if (mouseEvent.getID() == 501) {
                TextArea.this.requestFocus();
            }
        }

        @Override
        public void installUI(JComponent jComponent) {
            super.installUI(jComponent);
            ((JLayer)jComponent).setLayerEventMask(16L);
        }

        @Override
        public void uninstallUI(JComponent jComponent) {
            super.uninstallUI(jComponent);
            ((JLayer)jComponent).setLayerEventMask(0L);
        }
    }

    private class MouseWheelHandler
    implements MouseWheelListener {
        private MouseWheelHandler() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (mouseWheelEvent.isAltDown()) {
                boolean bl;
                boolean bl2 = bl = mouseWheelEvent.isShiftDown() || mouseWheelEvent.isControlDown();
                if (mouseWheelEvent.getWheelRotation() < 0) {
                    TextArea.this.goToPrevLine(bl);
                } else {
                    TextArea.this.goToNextLine(bl);
                }
            } else if (mouseWheelEvent.getScrollType() == 1) {
                if (mouseWheelEvent.isShiftDown()) {
                    TextArea.this._setHorizontalOffset(TextArea.this.getHorizontalOffset() + (mouseWheelEvent.getWheelRotation() > 0 ? 1 : -1) * TextArea.this.painter.getWidth());
                } else if (mouseWheelEvent.getWheelRotation() > 0) {
                    TextArea.this.scrollDownPage();
                } else {
                    TextArea.this.scrollUpPage();
                }
            } else if (mouseWheelEvent.isControlDown() && mouseWheelEvent.isShiftDown()) {
                if (mouseWheelEvent.getWheelRotation() > 0) {
                    TextArea.this.scrollDownPage();
                } else {
                    TextArea.this.scrollUpPage();
                }
            } else if (mouseWheelEvent.isControlDown()) {
                TextArea.this.setFirstLine(TextArea.this.getFirstLine() + mouseWheelEvent.getWheelRotation());
            } else if (mouseWheelEvent.getScrollType() == 0) {
                if (mouseWheelEvent.isShiftDown()) {
                    TextArea.this._setHorizontalOffset(TextArea.this.getHorizontalOffset() + -TextArea.this.charWidth * mouseWheelEvent.getUnitsToScroll());
                } else {
                    TextArea.this.setFirstLine(TextArea.this.getFirstLine() + mouseWheelEvent.getUnitsToScroll());
                }
            } else if (mouseWheelEvent.isShiftDown()) {
                TextArea.this._setHorizontalOffset(TextArea.this.getHorizontalOffset() + -TextArea.this.charWidth * mouseWheelEvent.getWheelRotation());
            } else {
                TextArea.this.setFirstLine(TextArea.this.getFirstLine() + 3 * mouseWheelEvent.getWheelRotation());
            }
        }
    }

    private class FocusHandler
    implements FocusListener {
        private FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (TextArea.this.bufferChanging) {
                return;
            }
            if (TextArea.this.match != null) {
                if (TextArea.this.caretLine < ((TextArea)TextArea.this).match.startLine) {
                    TextArea.this.invalidateLineRange(TextArea.this.caretLine, ((TextArea)TextArea.this).match.endLine);
                } else {
                    TextArea.this.invalidateLineRange(((TextArea)TextArea.this).match.startLine, TextArea.this.caretLine);
                }
            } else {
                TextArea.this.invalidateLine(TextArea.this.caretLine);
            }
            focusedComponent = TextArea.this;
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (!TextArea.this.isShowing()) {
                return;
            }
            if (TextArea.this.match != null) {
                if (TextArea.this.caretLine < ((TextArea)TextArea.this).match.startLine) {
                    TextArea.this.invalidateLineRange(TextArea.this.caretLine, ((TextArea)TextArea.this).match.endLine);
                } else {
                    TextArea.this.invalidateLineRange(((TextArea)TextArea.this).match.startLine, TextArea.this.caretLine);
                }
            } else {
                TextArea.this.invalidateLine(TextArea.this.caretLine);
            }
        }
    }

    private class AdjustHandler
    implements AdjustmentListener {
        private AdjustHandler() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            if (!TextArea.this.scrollBarsInitialized) {
                return;
            }
            if (adjustmentEvent.getAdjustable() == TextArea.this.vertical) {
                TextArea.this.setFirstLine(TextArea.this.vertical.getValue());
            } else {
                TextArea.this.setHorizontalOffset(-TextArea.this.horizontal.getValue());
            }
        }
    }

    private class MutableCaretEvent
    extends CaretEvent {
        MutableCaretEvent() {
            super(TextArea.this);
        }

        @Override
        public int getDot() {
            return TextArea.this.getCaretPosition();
        }

        @Override
        public int getMark() {
            return TextArea.this.getMarkPosition();
        }
    }

    private static class CaretBlinker
    implements ActionListener {
        private CaretBlinker() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (focusedComponent != null && focusedComponent.hasFocus()) {
                focusedComponent.blinkCaret();
            }
        }
    }

    private static class LineCharacterBreaker {
        private final BreakIterator charBreaker;
        private final int index0Offset;

        public LineCharacterBreaker(TextArea textArea, int n) {
            int n2 = textArea.getLineOfOffset(n);
            this.charBreaker = BreakIterator.getCharacterInstance();
            this.charBreaker.setText(new CharIterator(textArea.buffer.getLineSegment(n2)));
            this.index0Offset = textArea.getLineStartOffset(n2);
        }

        public boolean offsetIsBoundary(int n) {
            return this.charBreaker.isBoundary(n - this.index0Offset);
        }

        public int nextOf(int n) {
            int n2 = this.charBreaker.following(n - this.index0Offset);
            if (n2 == -1) {
                return n + 1;
            }
            return n2 + this.index0Offset;
        }

        public int previousOf(int n) {
            int n2 = this.charBreaker.preceding(n - this.index0Offset);
            if (n2 == -1) {
                return n - 1;
            }
            return n2 + this.index0Offset;
        }

        private static class CharIterator
        implements CharacterIterator {
            private final CharSequence sequence;
            private int index;

            public CharIterator(CharSequence charSequence) {
                this.sequence = charSequence;
                this.index = 0;
            }

            @Override
            public char first() {
                this.index = 0;
                return this.current();
            }

            @Override
            public char last() {
                int n = this.sequence.length();
                this.index = n > 0 ? n - 1 : n;
                return this.current();
            }

            @Override
            public char current() {
                return this.index < this.sequence.length() ? this.sequence.charAt(this.index) : (char)'\uffff';
            }

            @Override
            public char next() {
                int n = this.sequence.length();
                if (this.index < n) {
                    ++this.index;
                    return this.current();
                }
                return '\uffff';
            }

            @Override
            public char previous() {
                if (this.index > 0) {
                    --this.index;
                    return this.current();
                }
                return '\uffff';
            }

            @Override
            public char setIndex(int n) {
                if (0 <= n && n <= this.sequence.length()) {
                    this.index = n;
                    return this.current();
                }
                throw new IllegalArgumentException();
            }

            @Override
            public int getBeginIndex() {
                return 0;
            }

            @Override
            public int getEndIndex() {
                return this.sequence.length();
            }

            @Override
            public int getIndex() {
                return this.index;
            }

            @Override
            public Object clone() {
                CharIterator charIterator = new CharIterator(this.sequence);
                charIterator.index = this.index;
                return charIterator;
            }
        }
    }

    private static class RectParams {
        final int extraStartVirt;
        final int extraEndVirt;
        final int newCaret;

        RectParams(int n, int n2, int n3) {
            this.extraStartVirt = n;
            this.extraEndVirt = n2;
            this.newCaret = n3;
        }
    }
}

