'''OpenGL extension KHR.debug

This module customises the behaviour of the 
OpenGL.raw.GLES2.KHR.debug to provide a more 
Python-friendly API

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/KHR/debug.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.KHR.debug import *
from OpenGL.raw.GLES2.KHR.debug import _EXTENSION_NAME

def glInitDebugKHR():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glDebugMessageControl.ids size not checked against count
glDebugMessageControl=wrapper.wrapper(glDebugMessageControl).setInputArraySize(
    'ids', None
)
# INPUT glDebugMessageInsert.buf size not checked against 'buf,length'
glDebugMessageInsert=wrapper.wrapper(glDebugMessageInsert).setInputArraySize(
    'buf', None
)
# INPUT glGetDebugMessageLog.lengths size not checked against count
# INPUT glGetDebugMessageLog.ids size not checked against count
# INPUT glGetDebugMessageLog.severities size not checked against count
# INPUT glGetDebugMessageLog.sources size not checked against count
# INPUT glGetDebugMessageLog.messageLog size not checked against bufSize
# INPUT glGetDebugMessageLog.types size not checked against count
glGetDebugMessageLog=wrapper.wrapper(glGetDebugMessageLog).setInputArraySize(
    'lengths', None
).setInputArraySize(
    'ids', None
).setInputArraySize(
    'severities', None
).setInputArraySize(
    'sources', None
).setInputArraySize(
    'messageLog', None
).setInputArraySize(
    'types', None
)
# INPUT glPushDebugGroup.message size not checked against 'message,length'
glPushDebugGroup=wrapper.wrapper(glPushDebugGroup).setInputArraySize(
    'message', None
)
# INPUT glObjectLabel.label size not checked against 'label,length'
glObjectLabel=wrapper.wrapper(glObjectLabel).setInputArraySize(
    'label', None
)
# INPUT glGetObjectLabel.label size not checked against bufSize
glGetObjectLabel=wrapper.wrapper(glGetObjectLabel).setInputArraySize(
    'length', 1
).setInputArraySize(
    'label', None
)
# INPUT glObjectPtrLabel.label size not checked against 'label,length'
glObjectPtrLabel=wrapper.wrapper(glObjectPtrLabel).setInputArraySize(
    'label', None
)
# INPUT glGetObjectPtrLabel.label size not checked against bufSize
glGetObjectPtrLabel=wrapper.wrapper(glGetObjectPtrLabel).setInputArraySize(
    'length', 1
).setInputArraySize(
    'label', None
)
glGetPointerv=wrapper.wrapper(glGetPointerv).setOutput(
    'params',size=(1,),orPassIn=True
)
# INPUT glGetDebugMessageLogKHR.lengths size not checked against count
# INPUT glGetDebugMessageLogKHR.ids size not checked against count
# INPUT glGetDebugMessageLogKHR.severities size not checked against count
# INPUT glGetDebugMessageLogKHR.sources size not checked against count
# INPUT glGetDebugMessageLogKHR.messageLog size not checked against bufSize
# INPUT glGetDebugMessageLogKHR.types size not checked against count
glGetDebugMessageLogKHR=wrapper.wrapper(glGetDebugMessageLogKHR).setInputArraySize(
    'lengths', None
).setInputArraySize(
    'ids', None
).setInputArraySize(
    'severities', None
).setInputArraySize(
    'sources', None
).setInputArraySize(
    'messageLog', None
).setInputArraySize(
    'types', None
)
# INPUT glGetObjectLabelKHR.label size not checked against bufSize
glGetObjectLabelKHR=wrapper.wrapper(glGetObjectLabelKHR).setInputArraySize(
    'label', None
)
# INPUT glGetObjectPtrLabelKHR.label size not checked against bufSize
glGetObjectPtrLabelKHR=wrapper.wrapper(glGetObjectPtrLabelKHR).setInputArraySize(
    'length', 1
).setInputArraySize(
    'label', None
)
### END AUTOGENERATED SECTION